/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

import toxi.math.InterpolateStrategy;
import toxi.math.LinearInterpolation;
import toxi.math.MathUtils;
import toxi.util.datatypes.DoubleRange;

public class ScaleMap {
    protected InterpolateStrategy mapFunction = new LinearInterpolation();
    protected double interval;
    protected double mapRange;
    protected DoubleRange in;
    protected DoubleRange out;

    public ScaleMap(double d2, double d3, double d4, double d5) {
        this.setInputRange(d2, d3);
        this.setOutputRange(d4, d5);
    }

    public double getClippedValueFor(double d2) {
        float f2 = MathUtils.clipNormalized((float)((d2 - this.in.min) / this.interval));
        return (double)this.mapFunction.interpolate(0.0f, (float)this.mapRange, f2) + this.out.min;
    }

    public double getInputMedian() {
        return (this.in.min + this.in.max) * 0.5;
    }

    public DoubleRange getInputRange() {
        return this.in;
    }

    public double getMappedMedian() {
        return this.getMappedValueFor(0.5);
    }

    public double getMappedValueFor(double d2) {
        float f2 = (float)((d2 - this.in.min) / this.interval);
        return (double)this.mapFunction.interpolate(0.0f, (float)this.mapRange, f2) + this.out.min;
    }

    public double getOutputMedian() {
        return (this.out.min + this.out.max) * 0.5;
    }

    public DoubleRange getOutputRange() {
        return this.out;
    }

    public void setInputRange(double d2, double d3) {
        this.in = new DoubleRange(d2, d3);
        this.interval = d3 - d2;
    }

    public void setMapFunction(InterpolateStrategy interpolateStrategy) {
        this.mapFunction = interpolateStrategy;
    }

    public void setOutputRange(double d2, double d3) {
        this.out = new DoubleRange(d2, d3);
        this.mapRange = d3 - d2;
    }
}

