/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

import toxi.math.InterpolateStrategy;

public class SigmoidInterpolation
implements InterpolateStrategy {
    private float sharpness;
    private float sharpPremult;

    public SigmoidInterpolation() {
        this(2.0f);
    }

    public SigmoidInterpolation(float f2) {
        this.setSharpness(f2);
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public float interpolate(float f2, float f3, float f4) {
        f4 = (f4 * 2.0f - 1.0f) * this.sharpPremult;
        f4 = (float)(1.0 / (1.0 + Math.exp(-f4)));
        return f2 + (f3 - f2) * f4;
    }

    private void setSharpness(float f2) {
        this.sharpness = f2;
        this.sharpPremult = 5.0f * f2;
    }
}

