/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

public final class SinCosLUT {
    public static final float DEFAULT_PRECISION = 0.25f;
    private static SinCosLUT DEFAULT_INSTANCE;
    private final float[] sinLUT;
    private final float precision;
    private final int period;
    private final int quadrant;
    private final float deg2rad;
    private final float rad2deg;

    public static final SinCosLUT getDefaultInstance() {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new SinCosLUT();
        }
        return DEFAULT_INSTANCE;
    }

    public SinCosLUT() {
        this(0.25f);
    }

    public SinCosLUT(float f2) {
        this.precision = f2;
        this.period = (int)(360.0f / f2);
        this.quadrant = this.period >> 2;
        this.deg2rad = (float)Math.PI / 180 * f2;
        this.rad2deg = 57.29578f / f2;
        this.sinLUT = new float[this.period];
        for (int i = 0; i < this.period; ++i) {
            this.sinLUT[i] = (float)Math.sin((float)i * this.deg2rad);
        }
    }

    public final float cos(float f2) {
        while (f2 < 0.0f) {
            f2 += (float)Math.PI * 2;
        }
        return this.sinLUT[((int)(f2 * this.rad2deg) + this.quadrant) % this.period];
    }

    public int getPeriod() {
        return this.period;
    }

    public float getPrecision() {
        return this.precision;
    }

    public float[] getSinLUT() {
        return this.sinLUT;
    }

    public final float sin(float f2) {
        while (f2 < 0.0f) {
            f2 += (float)Math.PI * 2;
        }
        return this.sinLUT[(int)(f2 * this.rad2deg) % this.period];
    }
}

