/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

import toxi.math.CircularInterpolation;
import toxi.math.InterpolateStrategy;
import toxi.math.MathUtils;

public class ZoomLensInterpolation
implements InterpolateStrategy {
    protected CircularInterpolation leftImpl = new CircularInterpolation();
    protected CircularInterpolation rightImpl = new CircularInterpolation();
    protected float lensPos;
    protected float lensStrength;
    protected float absStrength;

    public ZoomLensInterpolation() {
        this(0.5f, 1.0f);
    }

    public ZoomLensInterpolation(float f2, float f3) {
        this.lensPos = f2;
        this.lensStrength = f3;
        this.absStrength = MathUtils.abs(f3);
        this.leftImpl.setFlipped(f3 > 0.0f);
        this.rightImpl.setFlipped(f3 < 0.0f);
    }

    public float interpolate(float f2, float f3, float f4) {
        float f5 = f2 + (f3 - f2) * f4;
        f5 = f4 < this.lensPos ? (f5 += (this.leftImpl.interpolate(f2, f2 + (f3 - f2) * this.lensPos, f4 / this.lensPos) - f5) * this.absStrength) : (f5 += (this.rightImpl.interpolate(f2 + (f3 - f2) * this.lensPos, f3, (f4 - this.lensPos) / (1.0f - this.lensPos)) - f5) * this.absStrength);
        return f5;
    }

    public void setLensPos(float f2, float f3) {
        this.lensPos += (MathUtils.clipNormalized(f2) - this.lensPos) * f3;
    }

    public void setLensStrength(float f2, float f3) {
        this.lensStrength += (MathUtils.clip(f2, -1.0f, 1.0f) - this.lensStrength) * f3;
        this.absStrength = MathUtils.abs(this.lensStrength);
        this.leftImpl.setFlipped(this.lensStrength > 0.0f);
        this.rightImpl.setFlipped(this.lensStrength < 0.0f);
    }
}

