/*
 * Decompiled with CFR 0.152.
 */
package toxi.math.waves;

import java.util.Stack;
import toxi.math.waves.WaveState;

public abstract class AbstractWave {
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public float phase;
    public float frequency;
    public float amp;
    public float offset;
    public float value;
    protected float origPhase;
    protected Stack<WaveState> stateStack;

    public static final float hertzToRadians(float f2, float f3) {
        return f2 / f3 * ((float)Math.PI * 2);
    }

    public static final float radiansToHertz(float f2, float f3) {
        return f2 / ((float)Math.PI * 2) * f3;
    }

    public AbstractWave() {
    }

    public AbstractWave(float f2) {
        this(f2, 0.0f, 1.0f, 0.0f);
    }

    public AbstractWave(float f2, float f3) {
        this(f2, f3, 1.0f, 0.0f);
    }

    public AbstractWave(float f2, float f3, float f4, float f5) {
        this.setPhase(f2);
        this.frequency = f3;
        this.amp = f4;
        this.offset = f5;
    }

    public final float cyclePhase() {
        this.phase %= (float)Math.PI * 2;
        if (this.phase < 0.0f) {
            this.phase += (float)Math.PI * 2;
        }
        return this.phase;
    }

    public final float cyclePhase(float f2) {
        this.phase = (this.phase + f2) % ((float)Math.PI * 2);
        if (this.phase < 0.0f) {
            this.phase += (float)Math.PI * 2;
        }
        return this.phase;
    }

    public void pop() {
        if (this.stateStack == null || this.stateStack != null && this.stateStack.empty()) {
            throw new IllegalStateException("no wave states on stack");
        }
        WaveState waveState = this.stateStack.pop();
        this.phase = waveState.phase;
        this.frequency = waveState.frequency;
        this.amp = waveState.amp;
        this.offset = waveState.offset;
    }

    public void push() {
        if (this.stateStack == null) {
            this.stateStack = new Stack();
        }
        this.stateStack.push(new WaveState(this.phase, this.frequency, this.amp, this.offset));
    }

    public void reset() {
        this.phase = this.origPhase;
    }

    public void setPhase(float f2) {
        this.phase = f2;
        this.cyclePhase();
        this.origPhase = f2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" phase: ").append(this.phase);
        stringBuffer.append(" frequency: ").append(this.frequency);
        stringBuffer.append(" amp: ").append(this.amp);
        stringBuffer.append(" offset: ").append(this.offset);
        return stringBuffer.toString();
    }

    public abstract float update();
}

