/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import javax.xml.bind.annotation.XmlAttribute;
import toxi.math.MathUtils;
import toxi.util.datatypes.IntegerRange;

public class BiasedIntegerRange
extends IntegerRange {
    @XmlAttribute
    public int bias;
    @XmlAttribute
    public float standardDeviation;

    public BiasedIntegerRange() {
        this(0, 100, 50, 1.0f);
    }

    public BiasedIntegerRange(int n, int n2, int n3, float f2) {
        super(n, n2);
        this.bias = n3;
        this.standardDeviation = f2 * 0.5f;
    }

    public BiasedIntegerRange copy() {
        BiasedIntegerRange biasedIntegerRange = new BiasedIntegerRange(this.min, this.max, this.bias, this.standardDeviation * 2.0f);
        biasedIntegerRange.currValue = this.currValue;
        return biasedIntegerRange;
    }

    public int getBias() {
        return this.bias;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }

    public int pickRandom() {
        do {
            this.currValue = (int)(this.random.nextGaussian() * (double)this.standardDeviation * (double)(this.max - this.min)) + this.bias;
        } while (this.currValue < this.min || this.currValue >= this.max);
        return this.currValue;
    }

    public void setBias(int n) {
        this.bias = MathUtils.clip(n, this.min, this.max);
    }

    public void setStandardDeviation(float f2) {
        this.standardDeviation = MathUtils.clip(f2, 0.0f, 1.0f) * 0.5f;
    }

    public String toString() {
        return "BiasedIntegerRange: " + this.min + " -> " + this.max + " bias: " + this.bias + " q: " + this.standardDeviation;
    }
}

