/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleRange {
    @XmlAttribute
    public double min;
    @XmlAttribute
    public double max;
    @XmlAttribute(name="default")
    public double currValue;
    protected Random random = new Random();

    public static DoubleRange fromSamples(List<Double> list) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        for (double d4 : list) {
            d2 = MathUtils.min(d2, d4);
            d3 = MathUtils.max(d3, d4);
        }
        return new DoubleRange(d2, d3);
    }

    public DoubleRange() {
        this(0.0, 1.0);
    }

    public DoubleRange(double d2, double d3) {
        this.min = d2;
        this.max = d3;
        this.currValue = d2;
    }

    public double adjustCurrentBy(double d2) {
        return this.setCurrent(this.currValue + d2);
    }

    public DoubleRange copy() {
        DoubleRange doubleRange = new DoubleRange(this.min, this.max);
        doubleRange.currValue = this.currValue;
        doubleRange.random = this.random;
        return doubleRange;
    }

    public double getCurrent() {
        return this.currValue;
    }

    public double getMedian() {
        return (this.min + this.max) * 0.5;
    }

    public boolean isValueInRange(float f2) {
        return (double)f2 >= this.min && (double)f2 <= this.max;
    }

    public double pickRandom() {
        this.currValue = MathUtils.random(this.random, (float)this.min, (float)this.max);
        return this.currValue;
    }

    public DoubleRange seed(long l) {
        this.random.setSeed(l);
        return this;
    }

    public double setCurrent(double d2) {
        this.currValue = MathUtils.clip(d2, this.min, this.max);
        return this.currValue;
    }

    public DoubleRange setRandom(Random random) {
        this.random = random;
        return this;
    }

    public Double[] toArray(double d2) {
        LinkedList<Double> linkedList = new LinkedList<Double>();
        for (double d3 = this.min; d3 < this.max; d3 += d2) {
            linkedList.add(d3);
        }
        return linkedList.toArray(new Double[0]);
    }

    public String toString() {
        return "DoubleRange: " + this.min + " -> " + this.max;
    }
}

