/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatRange {
    @XmlAttribute
    public float min;
    @XmlAttribute
    public float max;
    @XmlAttribute(name="default")
    public float currValue;
    protected Random random = new Random();

    public static FloatRange fromSamples(List<Float> list) {
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        for (float f4 : list) {
            f2 = MathUtils.min(f2, f4);
            f3 = MathUtils.max(f3, f4);
        }
        return new FloatRange(f2, f3);
    }

    public FloatRange() {
        this(0.0f, 1.0f);
    }

    public FloatRange(float f2, float f3) {
        this.min = f2;
        this.max = f3;
        this.currValue = f2;
    }

    public float adjustCurrentBy(float f2) {
        return this.setCurrent(this.currValue + f2);
    }

    public FloatRange copy() {
        FloatRange floatRange = new FloatRange(this.min, this.max);
        floatRange.currValue = this.currValue;
        floatRange.random = this.random;
        return floatRange;
    }

    public float getCurrent() {
        return this.currValue;
    }

    public float getMedian() {
        return (this.min + this.max) * 0.5f;
    }

    public boolean isValueInRange(float f2) {
        return f2 >= this.min && f2 <= this.max;
    }

    public float pickRandom() {
        this.currValue = MathUtils.random(this.random, this.min, this.max);
        return this.currValue;
    }

    public FloatRange seed(long l) {
        this.random.setSeed(l);
        return this;
    }

    public float setCurrent(float f2) {
        this.currValue = MathUtils.clip(f2, this.min, this.max);
        return this.currValue;
    }

    public FloatRange setRandom(Random random) {
        this.random = random;
        return this;
    }

    public Float[] toArray(float f2) {
        LinkedList<Float> linkedList = new LinkedList<Float>();
        for (double d2 = (double)this.min; d2 < (double)this.max; d2 += (double)f2) {
            linkedList.add(Float.valueOf((float)d2));
        }
        return linkedList.toArray(new Float[0]);
    }

    public String toString() {
        return "FloatRange: " + this.min + " -> " + this.max;
    }
}

