/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mod.lucky.drop.DropFull;
import mod.lucky.util.ObfHelper;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class LuckyUtils {
    private static Random random = new Random();
    private static List<String> potionIds;
    private static List<String> spawnEggIds;
    private static List<String> colorNames;

    public static CommandSource makeCommandSource(ServerWorld world, Vec3d pos, final boolean doOutput, String name) {
        ICommandSource source = new ICommandSource(){

            public void func_145747_a(ITextComponent component) {
            }

            public boolean func_195039_a() {
                return doOutput;
            }

            public boolean func_195040_b() {
                return doOutput;
            }

            public boolean func_195041_r_() {
                return doOutput;
            }
        };
        return new CommandSource(source, pos, Vec2f.field_189974_a, world, 2, name, (ITextComponent)new StringTextComponent(name), world.func_73046_m(), null);
    }

    public static CommandSource makeCommandSource(ServerWorld world, Vec3d pos, boolean doOutput) {
        return LuckyUtils.makeCommandSource(world, pos, doOutput, "Lucky Block");
    }

    public static PlayerEntity getNearestPlayer(ServerWorld world, Vec3d pos) {
        try {
            EntitySelector selector = new EntitySelectorParser(new StringReader("@p")).func_201345_m();
            return selector.func_197347_c(LuckyUtils.makeCommandSource(world, pos, false));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static Vec3d toVec3d(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static CompoundNBT getRandomFireworksRocket() {
        Random random = new Random();
        CompoundNBT mainTag = new CompoundNBT();
        CompoundNBT fireworksTag = new CompoundNBT();
        CompoundNBT explosionTag = new CompoundNBT();
        ListNBT explosionList = new ListNBT();
        explosionTag.func_74774_a("Type", (byte)random.nextInt(5));
        explosionTag.func_74757_a("Flicker", random.nextBoolean());
        explosionTag.func_74757_a("Trail", random.nextBoolean());
        int colorAmount = random.nextInt(4) + 1;
        int[] colors = new int[colorAmount];
        for (int a = 0; a < colorAmount; ++a) {
            float[] c = DyeColor.values()[random.nextInt(DyeColor.values().length)].func_193349_f();
            Color color = new Color(c[0], c[1], c[2]);
            colors[a] = color.getRGB();
        }
        explosionTag.func_74783_a("Colors", colors);
        explosionList.add((Object)explosionTag);
        fireworksTag.func_218657_a("Explosions", (INBT)explosionList);
        fireworksTag.func_74774_a("Flight", (byte)(random.nextInt(2) + 1));
        mainTag.func_218657_a("Fireworks", (INBT)fireworksTag);
        return mainTag;
    }

    public static String getRandomPotionId() {
        return potionIds.get(random.nextInt(potionIds.size()));
    }

    public static String getRandomSpawnEggId() {
        return spawnEggIds.get(random.nextInt(spawnEggIds.size()));
    }

    public static String getRandomColor() {
        return colorNames.get(random.nextInt(colorNames.size()));
    }

    @Nullable
    public static Entity getEntity(World world, int id, String name) {
        ResourceLocation rl = new ResourceLocation(name);
        if (ForgeRegistries.ENTITIES.containsKey(rl)) {
            return ((EntityType)ForgeRegistries.ENTITIES.getValue(rl)).func_200721_a(world);
        }
        return null;
    }

    public static int getPlayerDirection(PlayerEntity player, int accuracy) {
        int yaw = (int)player.field_70177_z;
        int angle = 360 / accuracy;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += angle / 2;
        return (yaw %= 360) / angle;
    }

    public static int adjustHeight(World world, int height, int posX, int posY, int posZ) {
        boolean wasHeightAdjusted = false;
        int newPosY = posY;
        int airCount = 0;
        for (int a = posY; a < posY + 16; ++a) {
            BlockPos pos = new BlockPos(posX, a, posZ);
            if (world.func_180495_p(pos).func_200015_d((IBlockReader)world, pos)) {
                airCount = 0;
                newPosY = a + 1;
            } else {
                ++airCount;
            }
            if (airCount != height) continue;
            wasHeightAdjusted = true;
            break;
        }
        if (wasHeightAdjusted) {
            return newPosY;
        }
        return -1;
    }

    public static ListNBT tagListFromStrArray(String[] array) {
        ListNBT nbttagList = new ListNBT();
        for (String element : array) {
            nbttagList.add((Object)ObfHelper.createStringNBT(element));
        }
        return nbttagList;
    }

    public static String[] strArrayFromTagList(ListNBT nbttagList) {
        String[] array = new String[nbttagList == null ? 0 : nbttagList.size()];
        for (int a = 0; a < array.length; ++a) {
            array[a] = nbttagList.func_150307_f(a);
        }
        return array;
    }

    public static ArrayList<DropFull> dropsFromStrArray(String[] array) {
        ArrayList<DropFull> drops = new ArrayList<DropFull>();
        for (String element : array) {
            DropFull dropFull = new DropFull();
            dropFull.readFromString(element);
            drops.add(dropFull);
        }
        return drops;
    }

    static {
        colorNames = Arrays.asList("black", "blue", "brown", "cyan", "gray", "green", "green", "light_blue", "light_gray", "lime", "magenta", "orange", "pink", "purple", "red", "white", "yellow");
        potionIds = ForgeRegistries.POTIONS.getKeys().stream().filter(k -> k.func_110624_b().equals("minecraft") && !k.func_110623_a().equals("empty") && !k.func_110623_a().equals("water") && !k.func_110623_a().equals("mundane") && !k.func_110623_a().equals("thick") && !k.func_110623_a().equals("awkward")).map(k -> k.toString()).collect(Collectors.toList());
        spawnEggIds = ForgeRegistries.ITEMS.getKeys().stream().filter(k -> k.func_110624_b().equals("minecraft") && k.func_110623_a().endsWith("_spawn_egg")).map(k -> k.toString()).collect(Collectors.toList());
    }
}

