/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.PrimitiveConstantExpression;
import com.strobel.expressions.TypedConstantExpression;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;

public class ConstantExpression
extends Expression {
    private final Object _value;

    ConstantExpression(Object value) {
        this._value = value;
    }

    public final Object getValue() {
        return this._value;
    }

    @Override
    public Type<?> getType() {
        if (this._value == null) {
            return Types.Object;
        }
        return Type.getType(this._value);
    }

    @Override
    public ExpressionType getNodeType() {
        return ExpressionType.Constant;
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitConstant(this);
    }

    static ConstantExpression make(Object value, Type type) {
        if (type.isPrimitive()) {
            return new PrimitiveConstantExpression(value);
        }
        if (value == null && type == Types.Object || value != null && Type.of(value.getClass()) == type) {
            return new ConstantExpression(value);
        }
        return new TypedConstantExpression(value, type);
    }
}

