/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.collections.Cache;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.emit.GenericParameterBuilder;
import com.strobel.reflection.emit.TypeBuilder;
import java.util.Arrays;
import javax.lang.model.type.TypeKind;

final class CustomDelegateTypeCache {
    private static final Cache<CacheKey, Type<?>> TypeCache = Cache.createSatelliteCache();

    CustomDelegateTypeCache() {
    }

    static synchronized Type<?> get(Type<?> returnType, TypeList parameterTypes) {
        CacheKey key = new CacheKey(returnType, parameterTypes);
        Type<?> delegateType = TypeCache.get(key);
        if (delegateType == null) {
            delegateType = TypeCache.cache(key, CustomDelegateTypeCache.createDelegateType(returnType, parameterTypes));
        }
        if (!delegateType.isGenericTypeDefinition()) {
            return delegateType;
        }
        TypeList genericParameters = delegateType.getGenericTypeParameters();
        Type[] typeArguments = new Type[genericParameters.size()];
        int t = 0;
        if (!returnType.isPrimitive()) {
            typeArguments[t++] = returnType;
        }
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            Type parameterType = (Type)parameterTypes.get(i);
            if (parameterType.isPrimitive()) continue;
            typeArguments[t++] = parameterType;
        }
        return delegateType.makeGenericType(typeArguments);
    }

    private static Type<?> createDelegateType(Type<?> returnType, TypeList parameterTypes) {
        TypeList genericParameterTypes;
        Type<?> genericReturnType;
        TypeBuilder typeBuilder = new TypeBuilder(CustomDelegateTypeCache.generateName(returnType, parameterTypes), 1537, null, TypeList.empty());
        int t = 0;
        String[] genericParameterNames = returnType.isPrimitive() ? null : new String[]{"T" + t++};
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            Type type = (Type)parameterTypes.get(i);
            if (type.isPrimitive()) continue;
            genericParameterNames = ArrayUtilities.append(genericParameterNames, "T" + t++);
        }
        if (t == 0) {
            genericReturnType = returnType;
            genericParameterTypes = parameterTypes;
        } else {
            GenericParameterBuilder<?>[] genericParameters = typeBuilder.defineGenericParameters(genericParameterNames);
            Type[] genericParameterTypeArray = new Type[parameterTypes.size()];
            t = 0;
            genericReturnType = returnType.isPrimitive() ? returnType : genericParameters[t++];
            int n2 = parameterTypes.size();
            for (int i = 0; i < n2; ++i) {
                Type parameterType = (Type)parameterTypes.get(i);
                genericParameterTypeArray[i] = parameterType.isPrimitive() ? parameterType : genericParameters[t++];
            }
            genericParameterTypes = Type.list(genericParameterTypeArray);
        }
        typeBuilder.defineMethod("invoke", 1025, genericReturnType, genericParameterTypes);
        return typeBuilder.createType();
    }

    private static String generateName(Type<?> returnType, TypeList parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomDelegateTypeCache.class.getPackage().getName());
        sb.append(".GeneratedDelegate");
        sb.append(CustomDelegateTypeCache.getCharacterCode(returnType));
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            sb.append(CustomDelegateTypeCache.getCharacterCode((Type)parameterTypes.get(i)));
        }
        return sb.toString();
    }

    private static char getCharacterCode(Type<?> type) {
        return type.isPrimitive() ? type.getSignature().charAt(0) : (char)'T';
    }

    private static final class CacheKey {
        private final TypeKind[] _types;

        CacheKey(Type<?> returnType, TypeList parameterTypes) {
            VerifyArgument.notNull(returnType, "returnType");
            VerifyArgument.notNull(parameterTypes, "parameterTypes");
            this._types = new TypeKind[parameterTypes.size() + 1];
            this._types[0] = this.coalesceKind(returnType);
            int n = parameterTypes.size();
            for (int i = 0; i < n; ++i) {
                this._types[i + 1] = this.coalesceKind((Type)parameterTypes.get(i));
            }
        }

        private TypeKind coalesceKind(Type<?> type) {
            TypeKind kind = type.getKind();
            return kind.ordinal() <= TypeKind.VOID.ordinal() ? kind : TypeKind.DECLARED;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CacheKey && Arrays.equals((Object[])this._types, (Object[])((CacheKey)o)._types);
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])this._types);
        }
    }
}

