/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.VerifyArgument;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ParameterExpression;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.Type;

final class Error {
    private Error() {
    }

    public static IllegalStateException extensionMustOverride(String memberName) {
        return new IllegalStateException(String.format("Expression extensions must override %s.", memberName));
    }

    public static IllegalStateException reducibleMustOverride(String memberName) {
        return new IllegalStateException(String.format("Reducible expression extensions must override %s.", memberName));
    }

    public static IllegalStateException memberNotField(MemberInfo member) {
        return new IllegalStateException(String.format("Member '%s' must be a field.", member));
    }

    public static IllegalStateException mustBeReducible() {
        return new IllegalStateException("Expression must be reducible to perform this operation.");
    }

    public static IllegalStateException mustReduceToDifferent() {
        return new IllegalStateException("Expression must reducible to a different expression.");
    }

    public static IllegalStateException reducedNotCompatible() {
        return new IllegalStateException("Expression was reduced to an expression of a non-compatible type.");
    }

    public static IllegalStateException argumentTypesMustMatch() {
        return new IllegalStateException("Argument types must match.");
    }

    public static IllegalStateException argumentCannotBeOfTypeVoid() {
        return new IllegalStateException("Argument cannot be of type 'void'.");
    }

    public static IllegalStateException expressionMustBeWriteable(String parameterName) {
        return new IllegalStateException(String.format("Argument '%s' must be writeable.", parameterName));
    }

    public static IllegalStateException expressionMustBeReadable(String parameterName) {
        return new IllegalStateException(String.format("Argument '%s' must be readable.", parameterName));
    }

    public static IllegalStateException mustRewriteChildToSameType(Type before, Type after, String callerName) {
        return new IllegalStateException(String.format("MethodBase '%s' performed an illegal type change from %s to %s.", callerName, before, after));
    }

    public static IllegalStateException mustRewriteWithoutMethod(MethodBase method, String callerName) {
        return new IllegalStateException(String.format("Rewritten expression calls method '%s', but the original node had no method.  If this is is intentional, override '%s' and change it to allow this rewrite.", callerName, method));
    }

    public static <T extends Expression> IllegalStateException mustRewriteToSameNode(String callerName, Class<T> type, String overrideMethodName) {
        return new IllegalStateException(String.format("When called from '%s', rewriting a node of type '%s' must return a non-null value of the same type.  Alternatively, override '%s' and change it to not visit children of this type.", callerName, type.getName(), overrideMethodName));
    }

    public static IllegalStateException unhandledUnary(ExpressionType unaryType) {
        return new IllegalStateException(String.format("Unhandled unary expression type: %s.", new Object[]{unaryType}));
    }

    public static IllegalStateException unhandledBinary(ExpressionType binaryType) {
        return new IllegalStateException(String.format("Unhandled binary expression type: %s.", new Object[]{binaryType}));
    }

    public static IllegalStateException unmodifiableCollection() {
        return new IllegalStateException("Collection cannot be modified.");
    }

    public static IllegalStateException duplicateVariable(ParameterExpression variable) {
        return new IllegalStateException(String.format("Found duplicate variable '%s'.  Each ParameterExpression in the list must be a unique object.", variable.getName()));
    }

    public static IllegalStateException unaryOperatorNotDefined(ExpressionType operator, Type operandType) {
        return new IllegalStateException(String.format("The unary operator '%s' is not defined for type '%s'", new Object[]{operator, operandType}));
    }

    public static IllegalStateException operatorMethodMustNotBeStatic(MethodBase method) {
        return new IllegalStateException(String.format("MethodBase '%s.%s' cannot be used as an operator because it is static.", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException operatorMethodMustNotReturnVoid(MethodBase method) {
        return new IllegalStateException(String.format("MethodBase '%s.%s' cannot be used as an operator because it returns void.", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException operatorMethodParametersMustMatchReturnValue(MethodBase method) {
        return new IllegalStateException(String.format("MethodBase '%s.%s' cannot be used as an operator because its parameters do not match its return value.", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException returnTypeDoesNotMatchOperandType(ExpressionType expressionType, MethodBase method) {
        return new IllegalStateException(String.format("The return type for operator '%s' does not match the declaring type of method '%s.%s'.", new Object[]{expressionType, method.getDeclaringType().getBriefDescription(), method.getName()}));
    }

    public static IllegalStateException returnTypeDoesNotMatchOperandType(MethodBase method) {
        return new IllegalStateException(String.format("The return type of operator method '%s.%s' does not match the method's declaring type.", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException incorrectNumberOfConstructorArguments() {
        return new IllegalStateException("Incorrect number of arguments supplied for constructor call.");
    }

    public static IllegalStateException incorrectNumberOfLambdaArguments() {
        return new IllegalStateException("Incorrect number of arguments supplied for lambda invocation.");
    }

    public static IllegalStateException incorrectNumberOfLambdaDeclarationParameters() {
        return new IllegalStateException("Incorrect number of parameters supplied for lambda declaration.");
    }

    public static IllegalStateException incorrectNumberOfMethodCallArguments(MethodBase method) {
        return new IllegalStateException(String.format("Incorrect number of arguments supplied for call to method '%s.%s'", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException invalidUnboxType() {
        return new IllegalStateException("Can only unbox from a standard boxed type or java.lang.Object to a primitive type.");
    }

    public static IllegalArgumentException unboxNotDefined(Type<?> boxedType, Type<?> unboxedType) {
        return new IllegalArgumentException(String.format("Could not resolve an unboxing method from %s to %s.", boxedType.getName(), unboxedType.getName()));
    }

    public static IllegalStateException invalidBoxType() {
        return new IllegalStateException("Can only unbox from a standard boxed type or java.lang.Object to a primitive type.");
    }

    public static IllegalStateException argumentMustBeArray() {
        return new IllegalStateException("Argument must be an array.");
    }

    public static IllegalStateException argumentMustBeBoolean() {
        return new IllegalStateException("Argument must be a boolean.");
    }

    public static IllegalStateException argumentMustBeInteger() {
        return new IllegalStateException("Argument must be an integer.");
    }

    public static IllegalStateException argumentMustBeIntegral() {
        return new IllegalStateException("Argument must be an integral numeric type.");
    }

    public static IllegalStateException coercionOperatorNotDefined(Type sourceType, Type destinationType) {
        return new IllegalStateException(String.format("No coercion operator is defined between types '%s' and '%s'.", sourceType, destinationType));
    }

    public static IllegalArgumentException argumentMustNotHaveValueType() {
        return new IllegalArgumentException("Argument must not have a primitive type.");
    }

    public static IllegalArgumentException argumentMustBeThrowable() {
        return new IllegalArgumentException("Argument must derive from Throwable.");
    }

    public static IllegalStateException methodBasedOperatorMustHaveValidReturnType(MethodBase method) {
        return new IllegalStateException(String.format("The operator method '%s.%s' must return the same type as its declaring type or a derived type.", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException methodBasedOperatorMustHaveValidReturnType(ExpressionType operator, MethodBase method) {
        return new IllegalStateException(String.format("The operator method '%s.%s' for operator '%s' must return the same type as its declaring type or a derived type.", new Object[]{method.getDeclaringType().getBriefDescription(), method.getName(), operator}));
    }

    public static IllegalStateException expressionTypeNotInvokable(Type type) {
        return new IllegalStateException(String.format("Expression of type '%s' cannot be invoked.  Invokable types must be interfaces with exactly one method.", type));
    }

    public static IllegalStateException binaryOperatorNotDefined(ExpressionType operator, Type leftType, Type rightType) {
        return new IllegalStateException(String.format("The binary operator '%s' is not defined for the types '%s' and '%s'.", new Object[]{operator, leftType, rightType}));
    }

    public static IllegalStateException referenceEqualityNotDefined(Type leftType, Type rightType) {
        return new IllegalStateException(String.format("Reference equality is not defined for the types '%s' and '%s'.", leftType, rightType));
    }

    public static IllegalStateException invalidOperator(ExpressionType operator) {
        return new IllegalStateException(String.format("Invalid operator: %s", new Object[]{operator}));
    }

    public static IllegalStateException targetRequiredForNonStaticMethodCall(MethodBase method) {
        return new IllegalStateException(String.format("An invocation target expression is required for a call to non-static method '%s.%s'.", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException targetRequiredForNonStaticFieldAccess(FieldInfo field) {
        return new IllegalStateException(String.format("An invocation target expression is required for access to non-static field '%s.%s'.", field.getDeclaringType().getBriefDescription(), field.getName()));
    }

    public static IllegalStateException targetInvalidForStaticFieldAccess(FieldInfo field) {
        return new IllegalStateException(String.format("A target expression cannot be used to access static field '%s.%s'.", field.getDeclaringType().getBriefDescription(), field.getName()));
    }

    public static IllegalStateException targetInvalidForStaticMethodCall(MethodBase method) {
        return new IllegalStateException(String.format("An invocation target expression cannot be used to call static method '%s.%s'.", method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException targetAndMethodTypeMismatch(MethodBase method, Type targetType) {
        return new IllegalStateException(String.format("Expression of type '%s' is not a valid invocation target for instance method '%s.%s'.", targetType.getBriefDescription(), method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException expressionTypeDoesNotMatchParameter(Type argType, Type parameterType) {
        return new IllegalStateException(String.format("Expression of type '%s' cannot be used for constructor parameter of type '%s'.", parameterType.getBriefDescription(), argType.getBriefDescription()));
    }

    public static IllegalStateException expressionTypeDoesNotMatchReturn(Type bodyType, Type returnType) {
        return new IllegalStateException(String.format("Expression of type '%s' cannot be used as the body of a lambda with return type '%s'.", bodyType.getBriefDescription(), returnType.getBriefDescription()));
    }

    public static IllegalStateException expressionTypeDoesNotMatchConstructorParameter(Type argType, Type parameterType) {
        return new IllegalStateException(String.format("Expression of type '%s' cannot be used for parameter of type '%s'.", parameterType.getBriefDescription(), argType.getBriefDescription()));
    }

    public static IllegalStateException expressionTypeDoesNotMatchMethodParameter(Type argType, Type parameterType, MethodBase method) {
        return new IllegalStateException(String.format("Expression of type '%s' cannot be used for parameter of type '%s' of method '%s.%s'.", argType.getBriefDescription(), parameterType.getBriefDescription(), method.getDeclaringType().getBriefDescription(), method.getName()));
    }

    public static IllegalStateException expressionTypeDoesNotMatchAssignment(Type leftType, Type rightType) {
        return new IllegalStateException(String.format("Expression of type '%s' cannot be used for assignment to type '%s'.", rightType.getBriefDescription(), leftType.getBriefDescription()));
    }

    public static IllegalStateException methodDoesNotExistOnType(String methodName, Type type) {
        return new IllegalStateException(String.format("No method '%s' exists on type '%s'.", methodName, type.getBriefDescription()));
    }

    public static IllegalStateException fieldDoesNotExistOnType(String fieldName, Type type) {
        return new IllegalStateException(String.format("No field '%s' exists on type '%s'.", fieldName, type.getBriefDescription()));
    }

    public static IllegalStateException genericMethodWithArgsDoesNotExistOnType(String methodName, Type type) {
        return new IllegalStateException(String.format("No generic method '%s' on type '%s' is compatible with the supplied type arguments and arguments.  No type arguments should be provided if the method is non-generic.", methodName, type.getBriefDescription()));
    }

    public static IllegalStateException methodWithArgsDoesNotExistOnType(String methodName, Type type) {
        return new IllegalStateException(String.format("No method '%s' on type '%s' is compatible with the supplied arguments.", methodName, type.getBriefDescription()));
    }

    public static IllegalStateException methodWithMoreThanOneMatch(String methodName, Type type) {
        return new IllegalStateException(String.format("More than one method '%s' on type '%s' is compatible with the supplied arguments.", methodName, type.getBriefDescription()));
    }

    public static IllegalStateException argumentMustBeArrayIndexType() {
        return new IllegalStateException("Expression must be an integer-based array index.");
    }

    public static IllegalStateException conversionIsNotSupportedForArithmeticTypes() {
        return new IllegalStateException("A conversion expression is not supported for arithmetic types.");
    }

    public static IllegalStateException operandTypesDoNotMatchParameters(ExpressionType nodeType, MethodBase method) {
        return new IllegalStateException(String.format("The operands for operator '%s' do not match the parameters of method '%s'.", new Object[]{nodeType, method.getName()}));
    }

    public static IllegalStateException overloadOperatorTypeDoesNotMatchConversionType(ExpressionType nodeType, MethodBase method) {
        return new IllegalStateException(String.format("The return type of overload method for operator '%s' does not match the parameter type of conversion method '%s'.", new Object[]{nodeType, method.getName()}));
    }

    public static IllegalStateException lambdaTypeMustBeSingleMethodInterface() {
        return new IllegalStateException("Lambda type parameter must be an interface type with exactly one method.");
    }

    public static IllegalStateException parameterExpressionNotValidForDelegate(Type parameterType, Type delegateParameterType) {
        return new IllegalStateException(String.format("ParameterExpression of type '%s' cannot be used for delegate parameter of type '%s'.", parameterType.getBriefDescription(), delegateParameterType.getBriefDescription()));
    }

    public static IllegalStateException labelMustBeVoidOrHaveExpression() {
        return new IllegalStateException("Label type must be void if an expression is not supplied.");
    }

    public static IllegalArgumentException expressionTypeDoesNotMatchLabel(Type valueType, Type expectedType) {
        return new IllegalArgumentException(String.format("Expression of type '%s' cannot be used for return type '%s'.", valueType.getBriefDescription(), expectedType.getBriefDescription()));
    }

    public static IllegalArgumentException expressionTypeCannotInitializeArrayType(Type itemType, Type arrayElementType) {
        return new IllegalArgumentException(String.format("An expression of type '%s' cannot be used to initialize an array of type '%s'.", itemType.getBriefDescription(), arrayElementType.getBriefDescription()));
    }

    public static IllegalStateException catchVariableMustBeCompatibleWithCatchType(Type catchType, Type variableType) {
        return new IllegalStateException(String.format("A variable of type '%s' cannot be used with a catch block with filter type '%s'.", variableType.getBriefDescription(), catchType.getBriefDescription()));
    }

    public static IllegalStateException bodyOfCatchMustHaveSameTypeAsBodyOfTry() {
        return new IllegalStateException("Body of catch must have the same type as body of try.");
    }

    public static IllegalStateException tryMustHaveCatchOrFinally() {
        return new IllegalStateException("A try expression must have at least one catch or finally clause.");
    }

    public static IllegalStateException invalidLValue(ExpressionType nodeType) {
        return new IllegalStateException(String.format("Invalid lvalue for assignment: %s.", new Object[]{nodeType}));
    }

    public static IllegalStateException allCaseBodiesMustHaveSameType() {
        return new IllegalStateException("All case bodies and the default body must have the same type.");
    }

    public static IllegalStateException allTestValuesMustHaveTheSameType() {
        return new IllegalStateException("All test values must have the same type.");
    }

    public static IllegalStateException defaultBodyMustBeSupplied() {
        return new IllegalStateException("Default body must be supplied if case bodies are not void.");
    }

    public static IllegalStateException testValueTypeDoesNotMatchComparisonMethodParameter(Type testValueType, Type parameterType) {
        return new IllegalStateException(String.format("Test value of type '%s' cannot be used for the comparison method parameter of type '%s'.", testValueType.getBriefDescription(), parameterType.getBriefDescription()));
    }

    public static IllegalStateException equalityMustReturnBoolean(MethodBase method) {
        return new IllegalStateException(String.format("The user-defined equality method '%s' must return a boolean value.", method.getName()));
    }

    public static IllegalStateException cannotCompileConstant(Object value) {
        VerifyArgument.notNull(value, "value");
        return new IllegalStateException(String.format("Cannot compile complex constant of type %s because no closure is available.", Type.getType(value)));
    }

    public static IllegalStateException undefinedVariable(String name, Type type, String currentLambdaName) {
        return new IllegalStateException(String.format("Undefined variable '%s' of type %s in lambda '%s'.", name, type, currentLambdaName));
    }

    public static IllegalStateException couldNotCreateDelegate(Throwable t) {
        return new IllegalStateException("Could not create delegate.", t);
    }

    public static IllegalStateException labelTargetAlreadyDefined(String name) {
        return new IllegalStateException(String.format("Target already defined for label '%s'.", name));
    }

    public static IllegalStateException ambiguousJump(String name) {
        return new IllegalStateException(String.format("Cannot jump to ambiguous label '%s'.", name));
    }

    public static IllegalStateException nonLocalJumpWithValue(String name) {
        return new IllegalStateException(String.format("Cannot jump to non-local label '%s' with a value. Only jumps to labels defined in outer blocks can pass values.", name));
    }

    public static IllegalStateException controlCannotEnterExpression() {
        return new IllegalStateException("Control cannot enter an expression; only statements can be jumped into.");
    }

    public static IllegalStateException controlCannotEnterTry() {
        return new IllegalStateException("Control cannot enter a try block.");
    }

    public static IllegalStateException labelTargetUndefined(String name) {
        return new IllegalStateException(String.format("Cannot jump to undefined label '%s'.", name));
    }

    public static IllegalArgumentException primitiveCannotBeTypeBinaryOperand() {
        return new IllegalArgumentException("Primitive-typed expressions cannot be used as operands in InstanceOf or TypeEqual expressions.");
    }

    public static IllegalArgumentException primitiveCannotBeTypeBinaryType() {
        return new IllegalArgumentException("The target type of an InstanceOf or TypeEqual expression must be areference type.");
    }

    public static IllegalStateException incorrectNumberOfIndexes() {
        return new IllegalStateException("Incorrect number of indexes.");
    }

    public static IllegalStateException unexpectedCoalesceOperator() {
        return new IllegalStateException("Unexpected coalesce operator.");
    }

    public static IllegalStateException invalidMemberType(MemberType memberType) {
        return new IllegalStateException(String.format("Invalid member type: %s.", new Object[]{memberType}));
    }

    public static IllegalStateException andAlsoCannotProvideMethod() {
        return new IllegalStateException("AndAlso expressions cannot provide a method for evaluation because short circuiting behavior would not be possible.");
    }

    public static IllegalStateException orElseCannotProvideMethod() {
        return new IllegalStateException("OrElse expressions cannot provide a method for evaluation because short circuiting behavior would not be possible.");
    }

    public static IllegalStateException coalesceUsedOnNonNullableType() {
        return new IllegalStateException("Coalesce used with type that cannot be null.");
    }

    public static IllegalStateException extensionNotReduced() {
        return new IllegalStateException("Extension should have been reduced.");
    }

    public static IllegalStateException tryNotAllowedInFilter() {
        return new IllegalStateException("Try expression is not allowed inside a filter body.");
    }

    public static IllegalArgumentException argumentMustBeReferenceType() {
        return new IllegalArgumentException("Argument must be a reference type.");
    }

    public static IllegalArgumentException initializerMustBeAssignableToVariable() {
        return new IllegalArgumentException("Initializer must be assignable to variable.");
    }

    public static IllegalArgumentException testMustBeBooleanExpression() {
        return new IllegalArgumentException("Test must be a boolean expression.");
    }

    public static IllegalArgumentException continueTargetMustBeVoid() {
        return new IllegalArgumentException("Continue label target must be void.");
    }

    public static IllegalStateException cannotAccessThisFromStaticMember() {
        return new IllegalStateException("Cannot access 'this' from s static member.");
    }

    public static IllegalStateException incorrectlyTypedSelfExpression(Type<?> expected, Type<?> actual) {
        return new IllegalStateException(String.format("Incorrectly typed 'this' expression: expected '%s', found '%s'.", expected.getName(), actual.getName()));
    }

    public static IllegalStateException incorrectlyTypedSuperExpression(Type<?> expected, Type<?> actual) {
        return new IllegalStateException(String.format("Incorrectly typed 'super' expression: expected '%s', found '%s'.", expected.getName(), actual.getName()));
    }

    public static IllegalArgumentException twoOrMoreOperandsRequired() {
        return new IllegalArgumentException("At least two operands are required for a binary operation.");
    }

    public static IllegalArgumentException concatRequiresAtLeastTwoOperands() {
        return new IllegalArgumentException("A concat() expression requires at least two operands.");
    }

    public static IllegalArgumentException dynamicMethodCallRequiresTargetOrMethodHandle() {
        return new IllegalArgumentException("Invocation target required for DynamicMethod call.  A target instance must be provided, or the DynamicMethod must be constructed from a MethodHandle.");
    }
}

