/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.IStrongBox;
import com.strobel.expressions.HoistedLocals;
import com.strobel.expressions.IRuntimeVariables;
import com.strobel.util.ContractUtils;

public final class RuntimeOperations {
    private RuntimeOperations() {
        throw ContractUtils.unreachable();
    }

    public static IRuntimeVariables createRuntimeVariables(Object[] data, long[] indexes) {
        return new RuntimeVariableList(data, indexes);
    }

    private static final class RuntimeVariableList
    implements IRuntimeVariables {
        private final Object[] _data;
        private final long[] _indexes;

        RuntimeVariableList(Object[] data, long[] indexes) {
            assert (data != null);
            assert (indexes != null);
            this._data = data;
            this._indexes = indexes;
        }

        @Override
        public int size() {
            return this._indexes.length;
        }

        @Override
        public Object get(int index) {
            return this.getStrongBox(index).get();
        }

        @Override
        public void set(int index, Object value) {
            this.getStrongBox(index).set(value);
        }

        private IStrongBox getStrongBox(int index) {
            long closureKey = this._indexes[index];
            Object[] result = this._data;
            for (int parents = (int)(closureKey >> 32); parents > 0; --parents) {
                result = HoistedLocals.getParent(result);
            }
            return (IStrongBox)result[(int)closureKey];
        }
    }
}

