/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.core.ArrayUtilities;
import com.strobel.reflection.Binder;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.Error;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.Missing;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.util.TypeUtils;
import java.util.Set;

final class DefaultBinder
extends Binder {
    DefaultBinder() {
    }

    @Override
    public MethodBase selectMethod(Set<BindingFlags> bindingFlags, MethodBase[] matches, Type[] types) {
        int i;
        if (ArrayUtilities.isNullOrEmpty(matches)) {
            return null;
        }
        MethodBase[] candidates = (MethodBase[])matches.clone();
        int currentIndex = 0;
        int n = candidates.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Type<?> parameterType;
            int stop;
            boolean isVarArgs;
            MethodBase candidate = candidates[i2];
            ParameterList parameters = candidate.getParameters();
            int parameterCount = parameters.size();
            boolean bl = isVarArgs = candidate.getCallingConvention() == CallingConvention.VarArgs;
            if (parameterCount != types.length && !isVarArgs) continue;
            for (stop = 0; stop < Math.min(parameterCount, types.length) && ((parameterType = ((ParameterInfo)parameters.get(stop)).getParameterType()) == types[stop] || parameterType == Types.Object || parameterType.isAssignableFrom(types[stop]) || isVarArgs && stop == parameterCount - 1 && parameterType.getElementType().isAssignableFrom(types[stop])); ++stop) {
            }
            if (stop != parameterCount && (stop != parameterCount - 1 || !isVarArgs)) continue;
            candidates[currentIndex++] = candidate;
        }
        if (currentIndex == 0) {
            return null;
        }
        if (currentIndex == 1) {
            return candidates[0];
        }
        int currentMin = 0;
        boolean ambiguous = false;
        int[] parameterOrder = new int[types.length];
        int n2 = types.length;
        for (i = 0; i < n2; ++i) {
            parameterOrder[i] = i;
        }
        for (i = 1; i < currentIndex; ++i) {
            Type<?> varArgType2;
            Type<?> varArgType1;
            MethodBase m1 = candidates[currentMin];
            MethodBase m2 = candidates[i];
            if (m1.getCallingConvention() == CallingConvention.VarArgs) {
                TypeList pt1 = m1.getParameters().getParameterTypes();
                varArgType1 = ((Type)pt1.get(pt1.size() - 1)).getElementType();
            } else {
                varArgType1 = null;
            }
            if (m2.getCallingConvention() == CallingConvention.VarArgs) {
                TypeList pt2 = m2.getParameters().getParameterTypes();
                varArgType2 = ((Type)pt2.get(pt2.size() - 1)).getElementType();
            } else {
                varArgType2 = null;
            }
            int newMin = DefaultBinder.findMostSpecificMethod(m1, parameterOrder, varArgType1, candidates[i], parameterOrder, varArgType2, types, null);
            if (newMin == 0) {
                ambiguous = true;
                continue;
            }
            if (newMin != 2) continue;
            ambiguous = false;
            currentMin = i;
        }
        if (ambiguous) {
            throw Error.ambiguousMatch();
        }
        return candidates[currentMin];
    }

    private static int findMostSpecificMethod(MethodBase m1, int[] varArgOrder1, Type varArgArrayType1, MethodBase m2, int[] varArgOrder2, Type varArgArrayType2, Type[] types, Object[] args) {
        int result = DefaultBinder.findMostSpecific(m1.getParameters(), varArgOrder1, varArgArrayType1, m2.getParameters(), varArgOrder2, varArgArrayType2, types, args);
        if (result != 0) {
            return result;
        }
        if (DefaultBinder.compareMethodSignatureAndName(m1, m2)) {
            int hierarchyDepth2;
            int hierarchyDepth1 = DefaultBinder.getHierarchyDepth(m1.getDeclaringType());
            if (hierarchyDepth1 == (hierarchyDepth2 = DefaultBinder.getHierarchyDepth(m2.getDeclaringType()))) {
                return 0;
            }
            if (hierarchyDepth1 < hierarchyDepth2) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static int findMostSpecific(ParameterList p1, int[] varArgOrder1, Type varArgArrayType1, ParameterList p2, int[] varArgOrder2, Type varArgArrayType2, Type[] types, Object[] args) {
        if (varArgArrayType1 != null && varArgArrayType2 == null) {
            return 2;
        }
        if (varArgArrayType2 != null && varArgArrayType1 == null) {
            return 1;
        }
        boolean p1Less = false;
        boolean p2Less = false;
        int n = types.length;
        block5: for (int i = 0; i < n; ++i) {
            Type c2;
            Type c1;
            if (args != null && args[i] == Missing.Value || (c1 = varArgArrayType1 != null && varArgOrder1[i] >= p1.size() - 1 ? varArgArrayType1 : ((ParameterInfo)p1.get(varArgOrder1[i])).getParameterType()) == (c2 = varArgArrayType2 != null && varArgOrder2[i] >= p2.size() - 1 ? varArgArrayType2 : ((ParameterInfo)p2.get(varArgOrder2[i])).getParameterType())) continue;
            switch (DefaultBinder.findMostSpecificType(c1, c2, types[i])) {
                case 0: {
                    return 0;
                }
                case 1: {
                    p1Less = true;
                    continue block5;
                }
                case 2: {
                    p2Less = true;
                }
            }
        }
        if (p1Less == p2Less) {
            if (!p1Less && args != null) {
                if (p1.size() > p2.size()) {
                    return 1;
                }
                if (p2.size() > p1.size()) {
                    return 2;
                }
            }
            return 0;
        }
        return p1Less ? 1 : 2;
    }

    private static int findMostSpecificType(Type c1, Type c2, Type t) {
        boolean c2FromC1;
        if (TypeUtils.areEquivalent(c1, c2)) {
            return 0;
        }
        if (TypeUtils.areEquivalent(c1, t)) {
            return 1;
        }
        if (TypeUtils.areEquivalent(c2, t)) {
            return 2;
        }
        boolean c1FromC2 = c1.isAssignableFrom(c2);
        if (c1FromC2 == (c2FromC1 = c2.isAssignableFrom(c1))) {
            return 0;
        }
        return c1FromC2 ? 2 : 1;
    }
}

