/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.AnnotationSupport;
import com.strobel.reflection.emit.Error;
import java.lang.annotation.Annotation;
import java.util.HashMap;

public final class AnnotationBuilder<A extends Annotation> {
    private final Type<A> _annotationType;
    private final MethodList _attributes;
    private final ReadOnlyList<Object> _values;
    private A _bakedAnnotation;

    private AnnotationBuilder(Type<A> annotationType, MethodList attributes, ReadOnlyList<Object> values) {
        this._annotationType = VerifyArgument.notNull(annotationType, "annotationType");
        this._attributes = VerifyArgument.notNull(attributes, "properties");
        this._values = VerifyArgument.notNull(values, "values");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public A getAnnotation() {
        if (this._bakedAnnotation == null) {
            AnnotationBuilder annotationBuilder = this;
            synchronized (annotationBuilder) {
                if (this._bakedAnnotation == null) {
                    this.bake();
                }
            }
        }
        return this._bakedAnnotation;
    }

    public Type<A> getAnnotationType() {
        return this._annotationType;
    }

    public MethodList getAttributes() {
        return this._attributes;
    }

    public ReadOnlyList<Object> getValues() {
        return this._values;
    }

    public static <A extends Annotation> AnnotationBuilder<A> create(Type<A> annotationType, MethodList properties, ReadOnlyList<Object> values) {
        AnnotationBuilder.checkProperties(VerifyArgument.notNull(annotationType, "annotationType"), properties, values);
        return new AnnotationBuilder<A>(annotationType, properties != null ? properties : MethodList.empty(), values != null ? values : ReadOnlyList.emptyList());
    }

    public static <A extends Annotation> AnnotationBuilder<A> create(Type<A> annotationType) {
        AnnotationBuilder.checkProperties(VerifyArgument.notNull(annotationType, "annotationType"), MethodList.empty(), ReadOnlyList.emptyList());
        return new AnnotationBuilder<A>(annotationType, MethodList.empty(), ReadOnlyList.emptyList());
    }

    public static <A extends Annotation> AnnotationBuilder<A> create(Type<A> annotationType, Object value) {
        VerifyArgument.notNull(annotationType, "annotationType");
        MethodInfo valueProperty = annotationType.getMethod("value", new Type[0]);
        if (valueProperty == null) {
            throw Error.annotationHasNoDefaultAttribute();
        }
        AnnotationBuilder.checkProperties(annotationType, new MethodList(valueProperty), new ReadOnlyList<Object>(value));
        return new AnnotationBuilder<A>(annotationType, new MethodList(valueProperty), new ReadOnlyList<Object>(value));
    }

    private static <A extends Annotation> void checkProperties(Type<A> annotationType, MethodList properties, ReadOnlyList<Object> values) {
        MethodInfo defaultProperty;
        int valueCount;
        if (!Types.Annotation.isAssignableFrom(annotationType)) {
            throw Error.typeNotAnAnnotation(annotationType);
        }
        int propertyCount = properties != null ? VerifyArgument.noNullElements(properties, "properties").size() : 0;
        if (propertyCount != (valueCount = values != null ? VerifyArgument.noNullElements(properties, "values").size() : 0)) {
            throw Error.attributeValueCountMismatch();
        }
        if (valueCount == 0 && (defaultProperty = annotationType.getMethod("value", new Type[0])) != null) {
            throw Error.annotationRequiresValue(annotationType);
        }
        for (int i = 0; i < propertyCount; ++i) {
            Type<?> propertyType = ((MethodInfo)properties.get(i)).getReturnType();
            Object value = values.get(i);
            if (value instanceof AnnotationBuilder) {
                AnnotationBuilder valueAnnotation = (AnnotationBuilder)value;
                if (propertyType.isAssignableFrom(valueAnnotation.getAnnotationType())) continue;
                throw Error.attributeValueIncompatible(propertyType, valueAnnotation.getAnnotationType());
            }
            if (value != null && propertyType.isAssignableFrom(Type.of(value.getClass()))) continue;
            throw Error.attributeValueIncompatible(propertyType, value != null ? Type.of(value.getClass()) : null);
        }
    }

    void bake() {
        if (this._bakedAnnotation != null) {
            return;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>(this._attributes.size());
        int n = this._attributes.size();
        for (int i = 0; i < n; ++i) {
            valueMap.put(((MethodInfo)this._attributes.get(i)).getName(), this._values.get(i));
        }
        A annotation = AnnotationSupport.annotationForMap(this._annotationType.getErasedClass(), valueMap);
        this._bakedAnnotation = annotation;
    }
}

