/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.ReadOnlyList;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.Type;
import com.strobel.reflection.emit.AnnotationBuilder;
import com.strobel.reflection.emit.MethodBuilder;
import java.lang.annotation.Annotation;

public final class ParameterBuilder {
    private final MethodBuilder _declaringMethod;
    private final Type<?> _parameterType;
    private final int _position;
    private ReadOnlyList<AnnotationBuilder<? extends Annotation>> _annotations;
    private String _name;

    ParameterBuilder(MethodBuilder declaringMethod, int position, String name, Type<?> parameterType) {
        this._declaringMethod = VerifyArgument.notNull(declaringMethod, "declaringMethod");
        this._position = position;
        this._name = name != null ? name : "p" + position;
        this._parameterType = VerifyArgument.notNull(parameterType, "parameterType");
        this._annotations = ReadOnlyList.emptyList();
    }

    public void addCustomAnnotation(AnnotationBuilder<? extends Annotation> annotation) {
        VerifyArgument.notNull(annotation, "annotation");
        AnnotationBuilder[] newAnnotations = new AnnotationBuilder[this._annotations.size() + 1];
        this._annotations.toArray((U[])newAnnotations);
        newAnnotations[this._annotations.size()] = annotation;
        this._annotations = new ReadOnlyList<AnnotationBuilder>(newAnnotations);
    }

    public ReadOnlyList<AnnotationBuilder<? extends Annotation>> getCustomAnnotations() {
        return this._annotations;
    }

    public String getName() {
        return this._name;
    }

    public Type<?> getParameterType() {
        return this._parameterType;
    }

    public int getPosition() {
        return this._position;
    }

    void setName(String name) {
        this._name = name != null ? name : "p" + this._position;
    }
}

