/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.reflection.emit.LocalSymInfo;
import com.strobel.reflection.emit.ScopeAction;
import java.util.Arrays;

final class ScopeTree {
    int[] _offsets;
    ScopeAction[] _scopeActions;
    int _count = 0;
    int _openScopeCount = 0;
    LocalSymInfo[] _localSymInfos;
    static final int InitialSize = 16;

    ScopeTree() {
    }

    int getCurrentActiveScopeIndex() {
        int closeCount = 0;
        int i = this._count - 1;
        if (this._count == 0) {
            return -1;
        }
        while (closeCount > 0 || this._scopeActions[i] == ScopeAction.Close) {
            closeCount = this._scopeActions[i] == ScopeAction.Open ? --closeCount : ++closeCount;
            --i;
        }
        return i;
    }

    void addLocalSymInfoToCurrentScope(String name, byte[] signature, int slot, int startOffset, int endOffset) {
        int i = this.getCurrentActiveScopeIndex();
        if (this._localSymInfos[i] == null) {
            this._localSymInfos[i] = new LocalSymInfo();
        }
        this._localSymInfos[i].addLocalSymInfo(name, signature, slot, startOffset, endOffset);
    }

    void addPackageImportToCurrentScope(String packageName) {
        int i = this.getCurrentActiveScopeIndex();
        if (this._localSymInfos[i] == null) {
            this._localSymInfos[i] = new LocalSymInfo();
        }
        this._localSymInfos[i].addPackageImport(packageName);
    }

    void addScopeInfo(ScopeAction action, int offset) {
        if (action == ScopeAction.Close && this._openScopeCount <= 0) {
            throw new IllegalStateException("Tried to close unmatched symbol scope.");
        }
        this.ensureCapacity();
        this._scopeActions[this._count] = action;
        this._offsets[this._count] = offset;
        this._localSymInfos[this._count] = null;
        ++this._count;
        this._openScopeCount = action == ScopeAction.Open ? ++this._openScopeCount : --this._openScopeCount;
    }

    void ensureCapacity() {
        if (this._count == 0) {
            this._offsets = new int[16];
            this._scopeActions = new ScopeAction[16];
            this._localSymInfos = new LocalSymInfo[16];
        } else if (this._count == this._offsets.length) {
            int newSize = this._count * 2;
            this._offsets = Arrays.copyOf(this._offsets, newSize);
            this._scopeActions = Arrays.copyOf(this._scopeActions, newSize);
            this._localSymInfos = Arrays.copyOf(this._localSymInfos, newSize);
        }
    }
}

