var tocStats = "opened";
var flag = true;
var indexFlag = false;
var indexId = GetParam("indexKey");
var linkInfo = "";
var currentPageKey = "";
var mobileFlag = false;


$( window ).resize(function() {
  breadcrumbsShowHide();
});


$(document).ready(function(){
	$("*").attr("title", "");
	checkDevice();
	
	changeContentsLink();	
	
	setCss();
	
	if(mobileFlag){
		buildTocDivMobile();
	}else{
		BuildTocDiv();	
	}
	
	
	BuildToc();
	addMenuButtonListener();
	searchHighlight();
	buildBreadCrumbs();
	breadcrumbsShowHide();
	changeImageCallOutListStyle();
	//showImageName();
	
	olReload();
});

function BuildTocDiv(){
	var menuHtml = "";
	var folderOpen = GetParam("isTocLink");
	var indexButtonHtml = "";
	
	if(indexFlag){
		indexButtonHtml = 
			"	<li onMouseOver=\"this.style.cursor=\'hand\'\" "+
			"		onMouseOut='this.style.cursor=\"default\";'>"+
			"		<a id='indexButton' href='#'><span></span></a>"+
			"	</li>";
	}
	
	if(folderOpen == "closed"){
		menuHtml = "<div id='tocDiv' style='display:none' >";
		tocStats = "closed";
	}else{
		menuHtml = "<div id='tocDiv'>";
		tocStats = "fixed";
	}
	menuHtml +=
	"	<div class='empty'>"+
	"	</div>"+
	"	<div style='overflow-y:auto; overflow-x:hidden; height:90%;' >"+
	"		<span class='tocContent' ></span>"+
	"	</div>"+
	"</div>"+
	"<div class='header'>"+
	"	<div class='headerWrap'>"+
	"		<ul class='headerNav'>"+
	"			<li onMouseOver=\"this.style.cursor=\'hand\'\" "+
	"				onMouseOut='this.style.cursor=\"default\";'>"+
	"				<a id='homeBtn' title='Home' alt='Home' href='../start_here.htm'><span></span></a>"+
	"			</li>"+
	"			<li onMouseOver=\"this.style.cursor=\'hand\'\" "+
	"				onMouseOut='this.style.cursor=\"default\";'>"+
	"				<a id='toggleTocButton' title='Toc' alt='Toc' href='#'><span></span></a>"+
	"			</li>"+	
	indexButtonHtml +	
	"			<li onMouseOver=\"this.style.cursor=\'hand\'\" "+
	"				onMouseOut='this.style.cursor=\"default\";'>"+
	"				<a id='printButton' title='Print' alt='Print' href='#'><span></span></a>"+
	"			</li>"+
	"			<li onMouseOver=\"this.style.cursor=\'hand\'\" "+
	"				onMouseOut='this.style.cursor=\"default\";'>"+
	"				<a id='privlink' title='Previous' alt='Previous' href='pt01.htm' onclick=\"ShiftPage(-1,\'privlink\')\" ><span></span></a>"+
	"			</li>"+
		"		<li onMouseOver=\"this.style.cursor=\'hand\'\" "+
		"			onMouseOut='this.style.cursor=\"default\";'>"+
		"			<a id='nextlink' title='Next' alt='Next' href='pt01.htm' onclick=\"ShiftPage(1,\'nextlink\')\"><span></span></a>"+
		"		</li>"+
		"	</ul>"+
		"	<div class='searchWrap'>"+
		
		"			<div class='search_from_valign'>"+
		"				<input id='searchinputbox' type='text' name='keyword' onkeydown='TextClick(event)' >"+
		"			</div>"+
		"				<a id='searchLink' title='Search' alt='Search' href='searchText_find.html' onclick=\"SetSearch(); return false;\">"+
		"				Search</a>"+
			"</div>	"+			
		"</div>"+		
	"</div>";
	
	
	$("body").append(menuHtml);
	
	if(navigator.userAgent.toLowerCase().indexOf("msie") != -1){		
		$("div#tocDiv").css("overflow-x", "hidden");
	}else{
		$("div#tocDiv").css("overflow-x", "hidden");
	}
	
	if(folderOpen == "closed"){
		$(".contents").css("paddingLeft", "0px");
	}else{
		$(".contents").css("paddingLeft", "270px");
		$("body").css("width", "99.9%");
	}
}

function buildTocDivMobile(){
	var menuHtml = 
		"<div class='tocHeader'></div>" +
		"<div id='tocDiv' style='left: -280px;' >" +
		"		<span class='tocContent' ></span>"+
		"</div>" +		
		"<div class='header'>" +
			"<div id='leftButtonDiv'>" +
				"<a id='tocButton' title='TOC' alt='TOC' href='#'><span> </span></a>" +
				"<a id='tocCloseButton' title='Close' alt='Close' href='#'><span> </span></a>" +
			"</div>" +
			"<div id='rightButtonDiv'>" +
				"<a id='searchCallButton' title='Search' alt='Search' href='#'><span> </span></a>" +
			"</div>" +
			"<div id='searchDiv'>" +				
				"<input id='searchinputbox' type='text' name='keyword' onkeydown='TextClick(event)' >"+
				"<input id='searchButton' type='button' onclick=\"SetSearch();\" />"+				
			"</div>" +
		"</div>";
	
	$("body").append(menuHtml);
}

function ToggleToc(){
	if(tocStats == "closed"){
		$("div#tocDiv").slideDown("fast");
		tocStats="opened";
		$(".contents").animate({
			paddingLeft : "270px"
		}, "fast", "swing");
	}else{
		$("div#tocDiv").slideUp("fast");
		tocStats="closed";
		$(".contents").animate({
			paddingLeft : "0px"
		}, "fast", "swing");
	}
}

function BuildToc(){
	var source = "";
	$(".tocContent").html(source);
	var data = tocData;	
	var fileNameStart = document.URL.lastIndexOf('/') + 1;
	var fileNameStartIe = document.URL.lastIndexOf('\\') + 1;
	if(fileNameStartIe > fileNameStart) {
		 fileNameStart= fileNameStartIe;
	}
	
	var docName = "";
	var docNameNoAnchor = "";
	
	if(document.URL.lastIndexOf('?') > -1){
		docName = document.URL.substring(fileNameStart, document.URL.lastIndexOf('?'));
		if(docName.lastIndexOf("#") != -1){
			docNameNoAnchor = docName.substring(0, docName.lastIndexOf("."));
			docName = docName.substring(0, docName.lastIndexOf(".")) + docName.substring(docName.lastIndexOf("#")+1);
		}else{
			docNameNoAnchor = docName.substring(0, docName.lastIndexOf("."));
			docName = docName.substring(0, docName.lastIndexOf("."));
		}
		
	}else{
		docName = document.URL.substring(fileNameStart);
		if(docName.lastIndexOf("#") != -1){
			
		}
		docNameNoAnchor = docName.substring(0, docName.lastIndexOf("."));
		docName = docName.substring(0, docName.lastIndexOf("."));
	}
	
	
	source += AddToc(data, 0);
	
	$(".tocContent").html(source);
	
	var topTocElement = $(".level0");
	if(topTocElement.length <= 4){
		for(var key in data){
			var pagePath = data[key][1];
			if(pagePath.lastIndexOf("#") != -1){
				pagePath = pagePath.split(".")[0] + pagePath.substring(pagePath.lastIndexOf("#")+1);
			}else{	
				pagePath = pagePath.substring(0, pagePath.lastIndexOf("."));
			}
			if(pagePath == docName){
				topTocMenuShow(data);
				break;	
			}
		}
	}
	
	currentPageKey = getCurrentPageKey(data, docName);
	
	if(currentPageKey == ""){
		currentPageKey = getCurrentPageKey(data, docNameNoAnchor);
	}
	
	currentTocMenuShow(currentPageKey, docName);
	scrollContent();
	scrollToc(docName, docNameNoAnchor);
	flag = true;	
	$("a#indexButton").removeClass("indexOff");
	$("a#indexButton").addClass("indexOn");
}

function getCurrentPageKey(data, docName){
	var returnVal = "";
	for(var key in data){
		if(returnVal != ""){
			break;
		}
		var pagePath = data[key][1];
		if(pagePath.lastIndexOf("#") != -1){
			pagePath = pagePath.split(".")[0] + pagePath.substring(pagePath.lastIndexOf("#")+1);
		}else{	
			pagePath = pagePath.substring(0, pagePath.lastIndexOf("."));
		}
		
		if(pagePath == docName){
			returnVal = key;
		}else{
			if(data[key][2] != "null"){
				returnVal = getCurrentPageKey(data[key][2], docName);
			}			
		}
	}
	return returnVal;
}

function getCurrentPagePath(data, currentKey){
	var returnVal = "";
	for(var key in data){
		if(returnVal != ""){
			break;
		}
		var pagePath = data[key][1];
		if(pagePath.lastIndexOf("#") != -1){
			pagePath = pagePath.split(".")[0] + pagePath.substring(pagePath.lastIndexOf("#")+1);
		}else{	
			pagePath = pagePath.substring(0, pagePath.lastIndexOf("."));
		}
		
		if(key == currentKey){
			returnVal = pagePath;			
		}else{
			if(data[key][2] != "null"){
				returnVal = getCurrentPagePath(data[key][2], currentKey);
			}			
		}
	}
	return returnVal;
}

function currentTocMenuShow(currentPageKey, docName){
	var data = tocData;
	var splitKey = currentPageKey.split("|");	
	if(splitKey.length == 1){
		subMenuShow(currentPageKey, docName);
	}else{
		var key = "";
		for(var i = 0; i < splitKey.length; i ++){			
			key += splitKey[i];						
			var path = getCurrentPagePath(data, key);
			subMenuShow(key, path);
			if(i != splitKey.length-1){
				key += "|";
			}
		}
	}
}

function topTocMenuShow(data){
	var data = tocData;
	for(var key in data){
		var pagePath = data[key][1];
		if(pagePath.lastIndexOf("#") != -1){
			pagePath = pagePath.split(".")[0] + pagePath.substring(pagePath.lastIndexOf("#")+1);
		}else{
			pagePath = pagePath.substring(0, pagePath.lastIndexOf("."));
		}
		subMenuShow(key, pagePath);
	}
}

function scrollToc(docName, docId){	
	if(docName != "searchText_find"){
		$('#tocDiv div').animate({scrollTop: 0}, 0);
		if(document.URL.indexOf("#") != -1){
			if(document.URL.indexOf("?") != -1){
				var anchorId = document.URL.substring(document.URL.lastIndexOf("#")+1, document.URL.lastIndexOf("?"));
				if(anchorId.indexOf("?") != -1){
					anchorId = document.URL.substring(document.URL.lastIndexOf("#")+1);
				}
			}else{
				var anchorId = document.URL.substring(document.URL.lastIndexOf("#")+1);
			}		
			if($("#"+anchorId).length != 0){
				var scrollVal = $("#"+anchorId).offset().top-110;	
				
			}
		}
		var temp = $("div#" + docId + " > a");
		if(temp.length != 0){			
			$("#tocDiv div#" + docId + " > a").addClass('on');
			$('#tocDiv div').animate({scrollTop: $("#tocDiv div#" + docId + " > a").offset().top-scrollVal - 100}, 0);
		}else{
			temp = $("div#" + docName + " > a");
			if(temp.length != 0){				
				$("#tocDiv div#" + docName + " > a").addClass('on');
				$('#tocDiv div').animate({scrollTop: $("#tocDiv div#" + docName + " > a").offset().top-scrollVal - 100}, 0);
			}
		}
	}
}

function scrollContent(){
	if(document.URL.indexOf("#") != -1){
		if(document.URL.indexOf("?") != -1){
			var anchorId = document.URL.substring(document.URL.lastIndexOf("#")+1, document.URL.lastIndexOf("?"));
			if(anchorId.indexOf("?") != -1){
				anchorId = document.URL.substring(document.URL.lastIndexOf("#")+1);
			}
		}else{
			var anchorId = document.URL.substring(document.URL.lastIndexOf("#")+1);
		}		
		if($("#"+anchorId).length != 0){
			var scrollVal = $("#"+anchorId).offset().top-100			
			$('html, body').animate({scrollTop: scrollVal}, 0);
		}
	}
	//if(navigator.userAgent.indexOf("Chrome") != -1){
		if(document.location.hash != ""){
			if(document.location.hash.indexOf("?") == -1){
				document.location.hash = null;
			}
		}
	//}
}

function AddToc(data, level){
	var returnVal = "";	
	for(var key in data){
		var pageTitle = data[key][0];
		var pagePath = data[key][1];
		var lv = "level" + level;	
		var attribute = "";
		var id = pagePath;	
		if(pagePath.lastIndexOf("#") != -1){
			id = pagePath.split(".")[0] + pagePath.substring(pagePath.lastIndexOf("#")+1);
		}else{			
			id = pagePath.split(".")[0];			
		}
		if(level != 0){
			var keyList = key.split("|");
			for(var i = 0; i < keyList.length-1; i ++){
				attribute += keyList[i];
				if(i != keyList.length-2){
					attribute += "|";
				}	
			}			
		}
		
		var picString = "";
		if(data[key][2] != "null"){
			picString = "<div class=openPic onclick=\"subMenuShow('" + key + "', '" + id + "')\" />";
		}else{
			picString = "<div class=topicPic/>";
		}
		
		returnVal += 
			"<div class='" + lv + "' id='" + id + "' parent='"+ attribute + "' >" +
				"<p>" +
					picString +
					"<a href='#' onclick=\"pageMove('" + CombineFileName(pagePath, "?isTocLink=opened") + "'); return false;\" >" + pageTitle + "</a>"+
				"</p>"+				
			"</div>"+
			"<div id='" + id + "_child'></div>";
		
	}
	
	return returnVal;
	
}

function showToc(data, tocKey){
	var returnVal = "";
	var level = tocKey.split("|").length;
	for(var key in data){		
		var pageTitle = data[key][0];
		var pagePath = data[key][1];
		var lv = "level" + level;	
		var attribute = "";
		var id = pagePath;	
		if(pagePath.lastIndexOf("#") != -1){
			id = pagePath.split(".")[0] + pagePath.substring(pagePath.lastIndexOf("#")+1);
		}else{			
			id = pagePath.split(".")[0];			
		}		
		if(level != 0){
			var keyList = key.split("|");
			for(var i = 0; i < keyList.length-1; i ++){
				attribute += keyList[i];				
				if(i != keyList.length-2){
					attribute += "|";
				}
			}	
		}		
		var picString = "";
		if(data[key][2] != "null"){
			picString = "<div class=openPic onclick=\"subMenuShow('" + key + "', '" + id + "')\" />";
		}else{
			picString = "<div class=topicPic/>";
		}
		
		returnVal += 
			"<div class='" + lv + "' id='" + id + "' parent='"+ attribute + "' >" +
				"<p>" +
					picString +
					"<a href='#' onclick=\"pageMove('" + CombineFileName(pagePath, "?isTocLink=opened") + "'); return false;\" >" + pageTitle + "</a>"+
				"</p>"+
			"</div>"+
			"<div id='" + id + "_child'></div>";
	}	
	return returnVal;
}

function subMenuHide(tocKey, Id){
	if(Id != ""){
		var currentPic = $("span.tocContent div#" + Id + " div")[0];		
		if(currentPic.getAttribute("class") == "closePic"){
			currentPic.setAttribute("onclick", "subMenuShow('" + tocKey + "', '" + Id + "')");
			currentPic.setAttribute("class", "openPic");
		}		
		$("#"+Id+"_child").html("");		
	}
}

function subMenuShow(tocKey, id){	
	var currentPic = $("span.tocContent div#" + id + " div.openPic")[0];
	var data = null;
	if(currentPic != undefined){
		currentPic.setAttribute("onclick", "subMenuHide('" + tocKey + "', '" + id + "')");
		currentPic.setAttribute("class", "closePic");	
	}	
	data = getTocObj(tocData, tocKey);
	var subMenu = "";
	if(data != "null"){
		subMenu += showToc(data, tocKey);
	}	
	$("#" + id + "_child").html(subMenu);
}

function getTocObj(data, tocKey){
	var returnVal = null;
	for(var key in data){
		if(returnVal != null){
			break;
		}
		var subObj = data[key][2];
		if(key == tocKey){
			returnVal = subObj;			
		}else{
			returnVal = getTocObj(data[key][2], tocKey);			
		}
	}
	return returnVal;
}

function pageMove(pageUrl){
	var fileNameStart = document.URL.lastIndexOf('/') + 1;
	var fileNameStartIe = document.URL.lastIndexOf('\\') + 1;
	if(fileNameStartIe > fileNameStart) fileNameStart= fileNameStartIe;
	var docName = document.URL.substring(fileNameStart, document.URL.lastIndexOf('?'));	
	if(docName != pageUrl.substring(0, pageUrl.lastIndexOf("?"))){
		if( document.URL.lastIndexOf("/manual/") > -1 || document.URL.lastIndexOf("\\manual\\") > -1){
			if( pageUrl.indexOf("isTocLink") > -1){
				document.location.href = pageUrl;
			}else{
				document.location.href = pageUrl + "?isTocLink=" + tocStats;
				scrollContent();
			}
		} else{
			if( fileNameStartIe > -1 ){
				document.location.href = "manual/" + pageUrl ;// "manual/" + pageUrl + "?isTocLink=" + tocStats;
			} else{
		    document.location.href = "manual\\" + pageUrl ;// "manual/" + pageUrl + "?isTocLink=" + tocStats;
		  }
		}
		//tocStats = "opened";
	}else{
		if(docName.lastIndexOf("#") > -1){
			docName = docName.split(".")[0] + docName.substring(docName.lastIndexOf("#")+1);
		}
		var currentPic = $("span.tocContent div#" + docName + " div")[0];
		if(currentPic != undefined){
			var picName = currentPic.getAttribute("class");
			if(picName == "openPic"){
				subMenuShow(currentPageKey, docName);
			}else if(picName == "closePic"){
				subMenuHide(currentPageKey, docName);
			}
		}
		BuildToc();
		buildBreadCrumbs();
	}
	
}

function PrintFunction(){	
	if( navigator.appName.indexOf("Microsoft") > -1 ){
		document.execCommand('print',false,null);
	}else{
		print();
	}
}



function ShiftPage(change, target){
	var refName = CombineFileName(GetShiftPageName(change), "?isTocLink=" + tocStats);
	pageMove(refName);
	$("a#" + target).attr("href", refName);
	BuildToc();
	buildBreadCrumbs();
	/*
	BuildToc();
	buildBreadCrumbs();
	*/
}

function CombineFileName(filePath, parameter){
	return filePath + parameter;	
}

function GetShiftPageName(change){
	var data = tocData;
	var fileNameStart = document.URL.lastIndexOf('/') + 1;
	var fileNameStartIe = document.URL.lastIndexOf('\\') + 1;	
	if(fileNameStartIe > fileNameStart) fileNameStart= fileNameStartIe;
	if(document.URL.lastIndexOf('?') > -1){
		var docName = document.URL.substring(fileNameStart, document.URL.lastIndexOf('?'));
	}else{
		var docName = document.URL.substring(fileNameStart);
	}
	
	if(docName.lastIndexOf("#") != -1){
		docName = docName.split(".")[0] + docName.substring(docName.lastIndexOf("#")+1);
	}else{
		docName = docName.substring(0, docName.lastIndexOf("."));
	}
	
	//var currentKey = getCurrentPageKey(data, docName);
	
	var splitKey = currentPageKey.split("|");
	var tocTotalLength = getTocTotalLength(data, 0);	
	var index = -1;
	if(splitKey.length == 1){
		index = currentPageKey.split("_")[0];
	}else{
		index = splitKey[splitKey.length-1].split("_")[0];
	}
	
	if(index == 0 && change == -1){
		change = 0;
	}
	if(index == tocTotalLength-1 && change == 1){
		change = 0;
	}
	if(index == ""){
		index = "0";
		change = 0;
	}
	
	index = parseInt(index) + change;
	return getIndexPath(tocData, index);
}

function getIndexPath(data, index){
	var returnVal = "";
	for(var key in data){
		if(returnVal != ""){
			break;
		}
		var splitKey = key.split("|");
		var tempIndex = splitKey[splitKey.length-1].split("_")[0];		
		if(index == tempIndex){
			returnVal = data[key][1];
			break;
		}else{
			if(data[key][2] != "null"){
				returnVal = getIndexPath(data[key][2], index);
			}
		}
	}
	return returnVal;
}

function getTocTotalLength(data, count){	
	for(var key in data){		
		
		if(data[key][2] != "null"){
			count = count + getTocTotalLength(data[key][2], 0);
		}
		count ++;
	}
	return count
}

function TextClick(event){
	var focused = document.activeElement;
	if(focused == document.getElementById("searchinputbox")){
		if(!event){
			event = window.event;
		}
		var eventCode = event.keyCode;
		if(eventCode == 13){
			var result = "./searchText_find.html?keyword="+encodeURIComponent($("input#searchinputbox").val());
			document.location.href = result;
		}
	}
	
}

function SetSearch(){
	document.location.href = GetSearchText();
}

function GetSearchText(){
	var result = "./searchText_find.html?keyword="+encodeURIComponent($("input#searchinputbox").val());
	return result;
}

function GetParam(paramName){
	var returnVal = "";
	if(document.location.href.lastIndexOf("?") > -1) {
		var params = document.location.href.split("?")[1].split("&");		
		for(var param in params){
			param = params[param];
			param = param.split("=");		
			if(param[0] == paramName){
				returnVal = param[1];
				break;
			}
		}
	}
	return returnVal;
}

function arrowMove(direction) {
	var refName = CombineFileName(GetShiftPageName(direction), "?isTocLink=" + tocStats);
	pageMove(refName);
}

document.onkeydown = function(event) {
	var focused = document.activeElement;
	if(focused != document.getElementById("searchinputbox")){
		if(!event){
			event = window.event;
		}
		var eventCode = event.keyCode;
		
		if(eventCode == 37){
			arrowMove(-1);
		}else if(eventCode == 39){
			arrowMove(1);
		}
	}
};

function loadIndexDiv(){
	var indexObj = indexData;
	var htmlText = 
	"	<input id='indexSearchInput' onkeyup='indexSearch();' type='text' />" ;
	//"	<input type='button' value='Search' onclick='indexSearch()' />";
	htmlText += "<div id='index'><ul>" + buildIndex(indexObj) + "</ul></div>";
	$(".tocContent").html(htmlText);
	if(indexId != ""){
		$('#tocDiv div').animate({scrollTop: $("#"+indexId).offset().top - 60}, 0);
		$('#' + indexId).css('font-weight', 'bold');
		
		var contentId = indexId.split("_")[1];
		
		if($("#"+contentId).length != 0){
			var scrollVal = $("#"+contentId).offset().top-120			
			$('html, body').animate({scrollTop: scrollVal}, 0);
		}
	}	
	flag = false;
	//$("a#indexButton span").text("TOC");
	$("a#indexButton").removeClass("indexOn");
	$("a#indexButton").addClass("indexOff");
}

function buildIndex(indexObj){
	var pageObj = tocData;
	var returnVal = "";
	var indexKeyArray = new Array();	
	for(var indexKey in indexObj){		
		indexKeyArray.push(indexKey);
	}
	indexKeyArray.sort(caseInsensitiveSort);	
	for(var i = 0; i < indexKeyArray.length; i ++){
		var indexKey = indexKeyArray[i];
		returnVal += "<li>";
		var indexArray = indexObj[indexKey][0];
		returnVal += indexKey;
		returnVal += "<ul>" + makeList(indexArray, pageObj, indexKey);			
		if(indexObj[indexKey][1] != "null"){
			returnVal += buildIndex(indexObj[indexKey][1]);
		}
		returnVal += "</ul>";		
		returnVal += "</li>";
	}	
	return returnVal;
}

function caseInsensitiveSort(a, b)
{	
	if(a instanceof Array){
		var ret = 0;
	   	a = a[0].key.toLowerCase();b = b[0].key.toLowerCase();
	   	if(a > b)
			ret = 1;
		if(a < b)
			ret = -1;
		return ret;
	}else{		
		var ret = 0;
	   	a = a.toLowerCase();b = b.toLowerCase();
	   	if(a > b)
			ret = 1;
		if(a < b)
			ret = -1;
		return ret;
	}
}

function makeList(indexArray, pageObj, indexKey){
	var returnVal = "";
	indexArray = eliminateDuplicates(indexArray);
	if(indexArray.length == 1){
		var url = indexArray[0];
		for(var pageKey in pageObj){
			var pageDataName = pageObj[pageKey][0];
			var pageDataUrl = pageObj[pageKey][1];
			var subPageObj = pageObj[pageKey][2];
			if(url.indexOf(pageDataUrl) != -1){
				var indexId = "index_" + url.split('#')[1];
				url = url.split('#')[0] + "?nav=index&indexKey=" + indexId;
				returnVal += "<li><a id='" + indexId + "' href='" + url + "'>" + pageDataName + "(" + indexKey + ")</a></li>";
			}else{
				if(subPageObj != "null"){
					returnVal += makeList(indexArray, subPageObj, indexKey);  						
				}	
			}
		}
	}else{
		for(var i = 0; i < indexArray.length; i ++){
			var url = indexArray[i];
			var temp = new Array();
			temp.push(url);
  			for(var pageKey in pageObj){
  				var pageDataName = pageObj[pageKey][0];
  				var pageDataUrl = pageObj[pageKey][1];
  				var subPageObj = pageObj[pageKey][2];
  				if(url.indexOf(pageDataUrl) != -1){
  					returnVal += "<li><a id='" + indexId + "' href='" + url + "'>" + pageDataName + "(" + indexKey + ")</a></li>";
  					break;
  				}
  				if(subPageObj != "null"){
  					returnVal += makeList(temp, subPageObj, indexKey);  					
  				}
  			}
		}
	}	
	return returnVal;
}

function eliminateDuplicates(arr) {
	var len=arr.length;
	var out=[];
	var obj={};	
 	for (var i=0;i<len;i++) {
 		if(obj){
 		}
 		obj[arr[i].split("#")[0]]=arr[i];
 	}
 	for (i in obj) {
 		out.push(obj[i]);
 	}
 	return out;
}

function indexSearch(){
	var indexObj = indexData;
	var keyword = document.getElementById('indexSearchInput').value;
	if(keyword == ""){
		loadIndexDiv();
		document.getElementById('indexSearchInput').focus();	
	}else{
		var indexKeyArray = new Array();
		makeIndexSearchArray(keyword, indexObj, indexKeyArray);
		var htmlText = "";
		htmlText += "<ul>" + makeIndexSearchResult(indexObj, indexKeyArray) + "</ul>";
		$("#index").html(htmlText);	
	}	
}

function makeIndexSearchArray(keyword, indexObj, indexKeyArray){
	for(var indexKey in indexObj){
		if(indexKey.toLowerCase().indexOf(keyword.toLowerCase()) != -1){
			//indexKeyArray.push(new Array(indexKey, indexObj[indexKey][0]));
			var Json = [{"key" : indexKey, "link" : indexObj[indexKey][0]}];
			indexKeyArray.push(Json);
		}
		if(indexObj[indexKey][1] != "null"){
			makeIndexSearchArray(keyword, indexObj[indexKey][1], indexKeyArray);
		}
	}
}

function makeIndexSearchResult(indexObj, indexKeyArray){
	var pageObj = tocData;
	var returnVal = "";	
	indexKeyArray.sort(caseInsensitiveSort);	
	for(var i = 0; i < indexKeyArray.length; i ++){
		var indexKey = indexKeyArray[i][0].key;
		var indexLinkArray = indexKeyArray[i][0].link;
		returnVal += "<li>" + indexKey + "<ul>" + makeList(indexLinkArray, pageObj, indexKey) + "</ul>" + "</li>";
	}	
	return returnVal;
}

function searchHighlight(){
	var searchKeyword = decodeURIComponent(GetParam('keyword'));
	searchKeyword = searchKeyword.toLowerCase();
	if(searchKeyword != ""){
		var keywordWithAnchor = searchKeyword;		
		var keyword = keywordWithAnchor;		
		var keywordArray = keyword.split(" ");	
		for(var k = 0; k < keywordArray.length; k ++){
			var content = $(".contents").html();
			var para = $("p, span, h1, h2, h3, h4, dt");
			var currentKey = keywordArray[k];
			for(var i = 0; i < para.length; i++){
				var tempHTML = para[i].outerHTML;
				var tagData = tempHTML.match(/<.*?>/gi);
				var resultData = "";
				var indexArray = new Array();
				var offset = 0;
				for(var j = 0; j < tagData.length; j++){
					var index = 0;
					var lastIndex = 0;
					if(tagData.length-1 == j){
						resultData += tagData[j];
						break;
					}else{
						index = tempHTML.indexOf(tagData[j],offset)+tagData[j].length;
						resultData += 	tagData[j];
						lastIndex = tempHTML.indexOf(tagData[j+1],index);
						offset = lastIndex;
						var tempData = tempHTML.substring(index,lastIndex);
						if(tempData != ""){
							tempData = htmlDecode(tempData);
						}
						tempData = replaceSearch(tempData, currentKey);
						resultData += tempData;
					}
				}
				content = content.replace(tempHTML, resultData);				
			}
			$(".contents").html(content);
		}		
	}
}

function htmlDecode(input){
  var e = document.createElement('div');
  e.innerHTML = input;
  return e.childNodes[0].nodeValue;
}

function replaceSearch(data, currentKey){
	if(data.indexOf("&nbsp;") > -1){
		data = data.split("&nbsp;").join(" ");
	}
	if(currentKey != ""){
		//currentKey = searchHighlightReservedKey(currentKey);		
		if(currentKey != ""){
			var keyIgnoreCaseIndex = data.toUpperCase().indexOf(currentKey.toUpperCase());
			var tempData = "";
			if(keyIgnoreCaseIndex > - 1){
				var currentKeyword = data.substring(keyIgnoreCaseIndex, currentKey.length + keyIgnoreCaseIndex);
				var currentReplacedData = data.substring(0, currentKey.length + keyIgnoreCaseIndex);
				var nextData = data.substring(currentKey.length + keyIgnoreCaseIndex, data.length);
				currentReplacedData = replaceHighglight(currentReplacedData, currentKeyword);
				nextData = replaceSearch(nextData, currentKey);
				tempData += currentReplacedData;
				tempData += nextData;
				return tempData;
			}else{
				
			}
		}	
	}	
	return data;
}

function searchHighlightReservedKey(keyword){
	if(keyword.indexOf("&") > -1){
		keyword = keyword.split("&").join("&amp;");

	}else if(keyword.indexOf("\"") > -1){
		keyword = keyword.split("\"").join("&quot;");

	}else if(keyword.indexOf("<") > -1){
		keyword = keyword.split("<").join("&lt;");

	}else if(keyword.indexOf(">") > -1){
		keyword = keyword.split(">").join("&gt;");
	}
	return keyword;
}

function replaceHighglight(data, key){
	var startTag = "<span class='highlight'>";
	var endTag = "</span>";
	var tempData = data.replace(key, startTag+key+endTag);
	return tempData;
}

function buildBreadCrumbs(){
	var tocObj = tocData;	
	var fileNameStart = document.URL.lastIndexOf('/') + 1;
	var fileNameStartIe = document.URL.lastIndexOf('\\') + 1;
	if(fileNameStartIe > fileNameStart) fileNameStart= fileNameStartIe;
	var docName = document.URL.substring(fileNameStart, document.URL.lastIndexOf('?'));	
	//getBreadCrumbs(tocObj, docName);	
	$('.breadcrumbs').html(makeBreadCrumbs(currentPageKey, tocObj));
}

function getBreadCrumbs(tocObj, docName){
	for(var key in tocObj){
		var pageUrl = tocObj[key][1];
		var subObj = tocObj[key][2];
		if(pageUrl.indexOf(docName) != -1){
			currentKey = key;
			break;
		}else{
			if(subObj != "null"){
				getBreadCrumbs(subObj, docName);
			}		
		}
	}
}

function makeBreadCrumbs(key, tocObj){
	var splitKey = key.split("|");
	var sumKey = "";
	var returnVal = "";
	for(var i = 0; i < splitKey.length; i ++){
		sumKey += splitKey[i];
		if(sumKey == key){
			returnVal += "<span class='breadcrumb-node'>";
		}else{
			returnVal += "<span class='breadcrumb-link'>";
		}
		returnVal += makeBreadCrumbsLink(tocObj, sumKey);
		returnVal += "</span>";
		sumKey += "|";
	}
	return returnVal;
}

function makeBreadCrumbsLink(tocObj, sumKey){
	var returnVal = "";	
	for(var key in tocObj){
		var breadCrumbsTitle = tocObj[key][0];		
		if(breadCrumbsTitle.length > 20){
			breadCrumbsTitle = breadCrumbsTitle.substring(0, 20) + " ...";
		}		
		if(key == sumKey){
			if(sumKey == currentPageKey){
				returnVal += breadCrumbsTitle;
			}else{
				//?isTocLink=opened
				returnVal += "<a href='#' onclick=\"pageMove('" + tocObj[key][1] + "?isTocLink" + tocStats + "')\">" + breadCrumbsTitle + "</a>";				
			}			
			break;
		}else{
			if(tocObj[key][2] != "null"){
				returnVal += makeBreadCrumbsLink(tocObj[key][2], sumKey);
			}
		}	
	}	
	return returnVal;	
}

function breadcrumbsShowHide(){
	var windowWidth = $(window).width();
  var breadCrumbsWidth = $(".breadcrumbs").width();
  breadCrumbsWidth = breadCrumbsWidth + $(".headerNav").width() + $(".searchWrap").width() + 50;
  if(breadCrumbsWidth > windowWidth){
  	$(".breadcrumbs").hide();
  }else{
  	$(".breadcrumbs").show();
  }
}

function changeImageCallOutListStyle(){
	var allList = $(".contents ol ");
	for(var i = 0; i < allList.length; i ++){		
		var list = $(".contents ol:eq(" + i + ")");
		var listType = list.attr("type");
		if(listType == "1"){
			var listItem = list.children();
			for(var j = 0; j < listItem.length; j ++){
				listItem[j].setAttribute("style", "list-style:decimal");
			}
		}
	}
}

function showImageName(){
	var imgs = $("img");
	for(var i = 0; i < imgs.length; i ++){		
		var img = $("img").eq(i);
		var imgName = img.attr("src");
		imgName = imgName.substring(imgName.lastIndexOf("/")+1);
		img.attr("title", imgName);
		img.parent().append("<p>" + imgName + "</p>");
	}
}

function defineImageWidth(){
	var imgs = $("img");
	
	for(var i = 0; i < imgs.length; i ++){
		
		var img = imgs.eq(i);
		var imgWidth = img.css("width");
		var imgHeight = img.css("height");
		
		if(imgWidth != "0px"){
			
			
			if(!mobileFlag){
				img.css({
					"width": "100%",
					"height": "100%",
					"max-width": imgWidth,
					"max-height": imgHeight
				});
				
				img.parents("td").children(".mediaobject").css({				
					"min-width": imgWidth,
					"min-height": imgHeight
				});
				
				img.parents("td").children().children(".inlinemediaobject").css({				
					"min-width": imgWidth,
					"min-height": imgHeight
				});
			}else{
				
				/*
				imgWidth = (Number(imgWidth.split("px")[0]) - 5) + "px";
				imgHeight = (Number(imgHeight.split("px")[0]) - 5) + "px";
				
				img.parents("td").children(".mediaobject").css({				
					"min-width": imgWidth,
					"min-height": imgHeight
				});
				
				img.parents("td").children().children(".inlinemediaobject").css({				
					"min-width": imgWidth,
					"min-height": imgHeight
				});
				*/
			}
			
			
		}
	}
}

function addMenuButtonListener(){
	$("a#printButton").click(function(event){
		PrintFunction();
		event.preventDefault();
		return false;
	});
	$("a#toggleTocButton").click(function(event){
		ToggleToc();
		event.preventDefault();
		return false;
	});	
	$("a#indexButton").click(function(event){
		if(tocStats == "closed"){
			ToggleToc();
		}
		if(flag){
			loadIndexDiv();
		}else{
			BuildToc();
		}
		event.preventDefault();
		return false;
	});
	
	if(mobileFlag){
		$('#searchCallButton').click(function() {
			$('#searchDiv').slideToggle(0);
			
			if($(this).find('span').attr("class") == "icon-close"){
				$('#tocDiv').css({
        	top: '42px'
        }, 300);
        
        $('.contents').css({
          marginTop: '90px'
        }, 300);
			}else{
				$('#tocDiv').css({
        	top: '84px'
        }, 300);
        
        $('.contents').css({
          marginTop: '132px'
        }, 300);
			}
			
			$(this).find('span').toggleClass('icon-close');
			
			
			
			return false;
		});
		
		$("#tocButton").click(function(){
	        $('#tocDiv').css({
	            left: '0px'
	        }, 300);
	        
	        $('.header').css({
	            left: '260px'
	        }, 300);
	        
	        $('.contents').css({
	            marginLeft: '270px',
	            opacity: "0.5"
	        }, 300);
	        
	        $("#tocButton span").hide();
	        $("#tocCloseButton span").show();
	        $("#tocCloseButton span").css("display",  "block");	
	        
	    });
	    
	    $("#tocCloseButton, .contents").click(function(){
	        $('#tocDiv').css({
	            left: '-280px'
	        }, 300);
	        
	        $('.header').css({
	            left: '0px'
	        }, 300);
	        
	        $('.contents').css({
	            marginLeft: '20px',
	            opacity: "1"
	        }, 300);
	        
	        $("#tocCloseButton span").hide();
	        $("#tocButton span").show();
	        $("#tocButton span").css("display",  "block");
	        
	    });
	}
}

function changeContentsLink(){
	var links = $(".contents a");
	for(var i = 0; i < links.length; i++){			
		var link = links.eq(i);
		var href = link.attr("href");
		if(link.attr("class") != "footnote" && link.attr("class") != "footnoteref" && link.attr("class") != "para"){
			if(link.attr("target") != "_blank"){
				link.attr("href", "#");
				link.attr("onclick", "pageMove('" + href + "'); return false;");
			}		
		}else{
			link.attr("href", "#");
			link.attr("onclick", "scrollFootNote('" + href + "'); return false;");
		}
	}
}

function scrollFootNote(anchorId){
	anchorId = "#" + anchorId.split("#")[1];
	
	anchorId = anchorId.replace(".", "\\.");
	if($(anchorId).length != 0){
		var scrollVal = $(anchorId).offset().top-100			
		$('html, body').animate({scrollTop: scrollVal}, 0);
	}
}

function olReload(){
	setTimeout(function(){
		$("ol").css("counter-reset", "item");		
	}, 100);
	
	setTimeout(function(){
		defineImageWidth();
	}, 500);
	
}

function checkDevice(){
	var ua = navigator.userAgent.toLowerCase();
		
	if(ua.indexOf("android") > -1 || ua.indexOf("mobile") > -1){
		mobileFlag = true;
	}
}

function setCss(){
	
	
	if(mobileFlag){
		$("head").find("link").remove();
		$("head").append('<link rel="stylesheet" type="text/css" href="../../common/css/mobile.css" />');
	}
}