﻿var searchData =
{
	"0_0": [
		"Basic",
		" > ",
		"User’s Guide",
		"This guide provides information concerning the installation, basic operation and troubleshooting on windows.",
		"Advanced",
		"This guide provides information about the installation, advanced configuration, operation and troubleshooting on various OS environments. ",
		"Some features may not be available depending on models or countries.",
		"Table of Contents",
		"Introduction",
		"Key benefits",
		"Features by model",
		"Useful to know",
		"About this user’s guide",
		"Safety information",
		"Machine overview",
		"Control panel overview",
		"Turning on the machine",
		"Installing the driver locally",
		"Reinstalling the driver",
		"Menu Overview and Basic Setup",
		"Menu overview",
		"Machine’s basic settings",
		"Media and tray",
		"Basic printing ",
		"Basic copying",
		"Basic scanning",
		"Using USB memory device",
		"Maintenance",
		"Ordering supplies and accessories",
		"Available supplies",
		"Available maintenance parts",
		"Storing the toner cartridge",
		"Redistributing toner",
		"Replacing the toner cartridge",
		"Replacing the imaging unit",
		"Replacing the waste toner container",
		"Monitoring the supplies life",
		"Setting the toner low alert",
		"Cleaning the machine",
		"Tips for moving & storing your machine",
		"Troubleshooting",
		"Tips for avoiding paper jams",
		"Clearing paper jams",
		"Understanding the status LED",
		"Understanding display messages",
		"Appendix",
		"Specifications",
		"Regulatory information",
		"To create a better environment",
		"Statement"
	],
	"0_0|1_0": [
		"Introduction",
		" > ",
		"Basic",
		"This chapter provides information you need to know before using the machine.",
		"Key benefits",
		"Features by model",
		"Useful to know",
		"About this user’s guide",
		"Safety information",
		"Machine overview",
		"Control panel overview",
		"Turning on the machine",
		"Installing the driver locally",
		"Reinstalling the driver"
	],
	"0_0|1_0|2_0": [
		"Key benefits",
		" > ",
		"Basic",
		"Introduction",
		"Environmentally friendly",
		"To save toner and paper, this machine supports Eco feature (see ",
		"Eco printing",
		").",
		"To save paper, you can print multiple pages on one single sheet of paper (see ",
		"Using advanced print features",
		"To save paper, you can print on both sides of the paper (double-sided printing) (Manual) (see ",
		"To save electricity, this machine automatically conserves electricity by substantially reducing power consumption when not in use.",
		"We recommend using recycled paper for saving energy.",
		"Fast high resolution printing",
		"You can print in a full range of colors using cyan, magenta, yellow, and black.",
		"You can print with a resolution of up to 600 x 600 dpi effective output.",
		"Convenience",
		"Lenovo Easy Printer Manager",
		" and ",
		"Printing Status",
		" is a program that monitors and informs you of the machine’s status and allows you to customize the machine’s settings (see ",
		"Using Lenovo Easy Printer Manager ",
		" or ",
		"Using ",
		"Lenovo Printer Status",
		"Lenovo Easy Document Creator",
		" is an application to help users compile and share large documents or other scanned information digitally. (see ",
		"If you have Internet access, you can get help, support application, machine drivers, manuals, and order information from the Lenovo website(",
		"www.lenovoimage.com",
		"Wide range of functionality and application support",
		"Supports various paper sizes (see ",
		"Print media specifications ",
		"Print watermark: You can customize your documents with words, such as “",
		"CONFIDENTIAL",
		"” (see ",
		"Print posters: The text and pictures of each page of your document are magnified and printed across the multiple sheets of paper and can then be taped together to form a poster (see ",
		"You can print in various operating systems (see ",
		"System requirements",
		"Your machine is equipped with a USB interface and/or a network interface.",
		"Supports various wireless network setting method ",
		"Using the USB cable or a network cable",
		"You can connect and set various wireless network settings using a USB cable or a network cable.",
		"Using the Wi-Fi Direct",
		"You can conveniently print from your mobile device using the Wi-Fi or Wi-Fi Direct feature.",
		"See ",
		"Introducing wireless set up methods",
		"."
	],
	"0_0|1_0|3_1": [
		"Features by model",
		" > ",
		"Basic",
		"Introduction",
		"Some features and optional goods may not be available depending on model or country.",
		"Operating System",
		"CM7110W",
		"CM7120W",
		"Windows",
		"●",
		"Mac",
		"Linux",
		"(",
		": Supported) ",
		"Software",
		"You can install the printer driver and software when you insert the software CD into your CD-ROM drive.",
		"For Windows, select the printer driver and software in the ",
		"Select Software to Install",
		" window.",
		"SPL printer driver",
		"PCL printer driver",
		"PS printer driver",
		"XPS printer driver",
		"Lenovo Easy Printer Manager",
		"Lenovo Easy Document Creator",
		"Lenovo Printer Status",
		"Embedded Web Server",
		"Scan",
		" driver (Twain/WIA)",
		"Variety feature",
		"Features",
		"Hi-Speed USB 2.0",
		"Network Interface Ethernet 10/100 Base TX wired LAN",
		"Network Interface 802.11b/g/n wireless LAN",
		"[a]",
		"Duplex (2-sided) printing",
		" (Manual)",
		"[b]",
		"USB memory interface",
		"Scan to PC",
		"Copy",
		"ID card copying",
		"Reduced or enlarged copying",
		"Collation",
		"2-up/4-up",
		"Adjust background",
		"[a] ",
		"Depending on your country, wireless LAN card may not be available. For some countries, only 802.11 b/g can be applied. Contact your local Lenovo dealer or the retailer where you bought your machine.",
		"[b] ",
		"Windows (SPL printer driver and PCL printer driver) and MAC only"
	],
	"0_0|1_0|4_2": [
		"Useful to know",
		" > ",
		"Basic",
		"Introduction",
		"The machine does not print.",
		"Open the print queue list and remove the document from the list (see ",
		"Canceling a print job",
		").",
		"Remove the driver and install it again (see ",
		"Installing the driver locally",
		"Select your machine as your default machine in your Windows (see ",
		"Setting your machine as a default machine",
		"Where can I purchase accessories or supplies?",
		"Inquire at a ",
		"Lenovo",
		" distributor or your retailer.",
		"Visit ",
		"www.lenovoimage.com",
		". Select your country/region to view product service information.",
		"The status LED flashes or remains constantly on.",
		"Turn the product off and on again.",
		"Check the meanings of LED indications in this manual and troubleshoot accordingly (see ",
		"Understanding the status LED",
		"A paper jam has occurred.",
		"Open and close the cover (see ",
		"Front view",
		"Check the instructions on removing jammed paper in this manual and troubleshoot accordingly (see ",
		"Clearing paper jams",
		"Printouts are blurry.",
		"The toner level might be low or uneven. Shake the toner cartridge (see ",
		"Redistributing toner",
		"Try a different print resolution setting (see ",
		"Opening printing preferences",
		"Replace the toner cartridge (see ",
		"Replacing the toner cartridge",
		"Where can I download the machine’s driver?",
		"You can get help, support application, machine drivers, manuals, and order information from the Lenovo website."
	],
	"0_0|1_0|5_3": [
		"About this user’s guide",
		" > ",
		"Basic",
		"Introduction",
		"This user's guide provides information for your basic understanding of the machine as well as detailed steps to explain machine usage.",
		"Do not discard this manual, and keep it for future reference.",
		"Read the safety information before using the machine.",
		"If you have a problem using the machine, refer to the troubleshooting chapter.",
		"Terms used in this user’s guide are explained in the glossary chapter.",
		"All illustrations in this user’s guide may differ from your machine depending on its options or model you purchased.",
		"The screenshots in this administrator’s guide may differ from your machine depending on the machine’s firmware/driver version.",
		"The procedures in this user’s guide are mainly based on Windows 7.",
		"Conventions",
		"Some terms in this guide are used interchangeably, as below:",
		"Document is synonymous with original.",
		"Paper is synonymous with media, or print media.",
		"Machine refers to printer or MFP.",
		"General icons",
		"Icon",
		"Text",
		"Description",
		"Warning",
		"Used to alert users to the possibility of personal injury.",
		"Caution",
		"Gives users information to protect the machine from possible mechanical damage or malfunction.",
		"Note",
		"Provides additional information or detailed specification of the machine function and feature."
	],
	"0_0|1_0|6_4": [
		"Safety information",
		" > ",
		"Basic",
		"Introduction",
		"These warnings and precautions are included to prevent injury to you and others, and to prevent any potential damage to your machine. Be sure to read and understand all of these instructions before using the machine. After reading this section, keep it in a safe place for future reference.",
		"Important safety symbols",
		"Explanation of all icons and signs used in this chapter",
		"Warning",
		"Hazards or unsafe practices that may result in severe personal injury or death.",
		"Caution",
		"Hazards or unsafe practices that may result in minor personal injury or property damage.",
		"Do not attempt.\t\t\t",
		"Operating environment",
		" Warning",
		"Do not use if the power cord is damaged or if the electrical outlet is not grounded.",
		"This could result in electric shock or fire. ",
		"Do not place anything on top of the machine (water, small metal or heavy objects, candles, lit cigarettes, etc.).",
		"If the machine gets overheated, it releases smoke, makes strange noises, or generates an odd odor, immediately turn off the power switch and unplug the machine.",
		"The user should be able to access the power outlet in case of emergencies that might require the user to pull the plug out.",
		"Do not bend, or place heavy objects on the power cord. ",
		"Stepping on or allowing the power cord to be crushed by a heavy object could result in electric shock or fire. ",
		"Do not remove the plug by pulling on the cord; do not handle the plug with wet hands. ",
		" Caution",
		"During an electrical storm or for a period of non-operation, remove the power plug from the electrical outlet. ",
		"Be careful, the paper output area is hot. ",
		"Burns could occur. ",
		"If the machine has been dropped, or if the cabinet appears damaged, unplug the machine from all interface connections and request assistance from qualified service personnel.",
		"Otherwise, this could result in electric shock or fire.",
		"If the machine does not operate properly after these instructions have been followed, unplug the machine from all interface connections and request assistance from qualified service personnel.",
		"If the plug does not easily enter the electrical outlet, do not attempt to force it in. ",
		"Call an electrician to change the electrical outlet, or this could result in electric shock.",
		"Do not allow pets to chew on the AC power, telephone or PC interface cords.",
		"This could result in electric shock or fire and/or injury to your pet. ",
		"Operating method",
		"\tDo not forcefully pull the paper out during printing. ",
		"It can cause damage to the machine.",
		"Be careful not to put your hand between the machine and paper tray.",
		"You may get injured.",
		"Be care when replacing paper or removing jammed paper. ",
		"New paper has sharp edges and can cause painful cuts.",
		"When printing large quantities, the bottom part of the paper output area may get hot. Do not allow children to touch. ",
		"Burns can occur.",
		"When removing jammed paper, do not use tweezers or sharp metal objects. ",
		"It can damage the machine.",
		"Do not allow too many papers to stack up in the paper output tray.",
		"It can damage the machine. ",
		"Do not block or push objects into the ventilation opening.",
		"This could result in elevated component temperatures which can cause damage or fire.",
		"Use of controls or adjustments or performance of procedures other than those specified herein may result in hazardous radiation exposure.",
		"This machine's power reception device is the power cord. ",
		"To switch off the power supply, remove the power cord from the electrical outlet. ",
		"Installation / Moving",
		"Do not place the machine in an area with dust, humidity, or water leaks. ",
		"Place the machine in the environment where it meets the operating temperature and humidity specification.",
		"Do not use the machine when it is below freezing temperature or has recently been moved from a location below freezing temperature. Doing so may damage the machine. Only operate the machine when the internal temperature of the machine is within the operating temperature and humidity specifications.",
		"Otherwise, quality problems can occur and cause damage to the machine. ",
		"See ",
		"General specifications",
		".",
		"Before moving the machine, turn the power off and disconnect all cords. The information below are only suggestions based on the units weight.If you have a medical condition that prevents you from lifting, do not lift the machine. Ask for help, and always use the appropriate amount of people to lift the device safely.",
		"Then lift the machine:",
		" If the machine weighs under 20 kg (44.09 lbs), lift with 1 person.",
		" If the machine weighs 20 kg (44.09 lbs) - 40kg (88.18 lbs), lift with 2 people.",
		" If the machine weighs more than 40 kg (88.18 lbs), lift with 4 or more people.",
		"The machine could fall, causing injury or machine damage.",
		"Choose a flat surface with enough space for ventilation to place the machine. Also consider the space required to open the cover and trays. ",
		"The place should be well-ventilated and be far from direct light, heat, and humidity. ",
		"When using the machine for a long period of time or printing a large number of pages in a non-ventilated space, it could pollute the air and be harmful to your health. Place the machine in a well-ventilated space or open a window to circulate the air periodically.",
		"Do not place the machine on an unstable surface.",
		"Use only No.26 AWG",
		"[a]",
		" or larger, telephone line cord, if necessary.",
		"Otherwise, it can cause damage to the machine.",
		"Make sure you plug the power cord into a grounded electrical outlet.",
		"Otherwise, this could result in electric shock or fire.\t",
		"Use the power cord supplied with your machine for safe operation. If you are using a cord which is longer than 2 meters (6 feet) with a 110V machine, then the gauge should be 16 AWG or larger.",
		"Otherwise, it can cause damage to the machine, and could result in electric shock or fire.",
		"Do not put a cover over the machine or place it in an airtight location, such as a closet.",
		"If the machine is not well-ventilated, this could result in fire.",
		"Do not overload wall outlets and extension cords.",
		"This can diminish performance, and could result in electric shock or fire.",
		"The machine should be connected tothe power level which is specified on the label.",
		"If you are unsure and want to check the power level you are using, contact the electrical utility company.",
		"[a] ",
		"AWG: American Wire Gauge",
		"Maintenance / Checking",
		"\tUnplug this product from the wall outlet before cleaning the inside of the machine. Do not clean the machine with benzene, paint thinner or alcohol; do not spray water directly into the machine. ",
		"\tWhen you are working inside the machine replacing supplies or cleaning the inside, do not operate the machine.",
		"You could get injured.",
		"\tKeep cleaning supplies away from children. ",
		"Children could get hurt.",
		"Do not disassemble, repair or rebuild the machine by yourself. ",
		"It can damage the machine. Call a certified technician when the machine needs repairing.",
		"To clean and operate the machine, strictly follow the user's guide provided with the machine.",
		"Otherwise, you could damage the machine.",
		"Keep the power cable and the contact surface of the plug clean from dust or water.",
		"Otherwise, this could result in electric shock or fire. ",
		"Do not remove any covers or guards that are fastened with screws. ",
		"Fuser units should only be repaired by a certified service technician. Repair by non-certified technicians could result in fire or electric shock.",
		"The machine should only be repaired by a Lenovo service technician.\t",
		"Supply usage",
		"\tDo not disassemble the toner cartridge.",
		"Toner dust can be dangerous if inhaled or ingested.",
		"Do not burn any of the supplies such as toner cartridge or fuser unit.",
		"This could cause an explosion or uncontrollable fire.",
		"\tWhen storing supplies such as toner cartridges, keep them away from children.",
		"For supplies that contain toner dust (toner cartridge, waste toner bottle, imaging unit, etc.) follow the instructions below.",
		"When disposing of the supplies, follow the instructions for disposal. Refer to the reseller for disposal instructions.",
		"Do not wash the supplies.",
		"For a waste toner bottle, do not reuse it after emptying the bottle.",
		"If you do not follow the instructions above, it may cause machine malfunction and environmental pollution. The warranty does not cover damages caused by a user's carelessness.",
		"Using recycled supplies, such as toner, can cause damage to the machine.",
		"In case of damage due to the use of recycled supplies, a service fee will be charged.",
		"When toner gets on your clothing, do not use hot water to wash it.",
		"Hot water sets toner into fabric. Use cold water.",
		"When changing the toner cartridge or removing jammed paper, be careful not to let toner dust touch your body or clothes."
	],
	"0_0|1_0|7_5": [
		"Machine overview",
		" > ",
		"Basic",
		"Introduction",
		"Components",
		"The actual component may differ from the illustration below. Some components may change depending on the configuration.",
		"Power cord",
		"Quick installation guide",
		"Software CD",
		"[a]",
		"Misc. accessories",
		"[b]",
		"[a] ",
		"The software CD contains the print drivers, user’s guide, and software applications.",
		"[b] ",
		"Miscellaneous accessories included with your machine may vary by country of purchase and specific model.",
		"Front view",
		"This illustration may differ from your machine depending on your model. There are various types of machine.",
		"Some features and optional goods may not be available depending on model or country (see ",
		"Features by model",
		").",
		"1",
		"Scanner lid",
		"7",
		"Toner cartridges",
		"2",
		"Front handle",
		"8",
		"Waste toner container",
		"3",
		"Tray",
		"9",
		"Imaging unit",
		"4",
		"Front door",
		"10",
		"Scanner glass",
		"5",
		"Output support",
		"11",
		"USB memory port",
		"6",
		"Control panel",
		"Rear view",
		"Rear cover",
		"Power receptacle",
		"USB port",
		"Network port"
	],
	"0_0|1_0|8_6": [
		"Control panel overview",
		" > ",
		"Basic",
		"Introduction",
		"This control panel may differ from your machine depending on its model. There are various types of control panels.",
		"Some features and optional goods may not be available depending on model or country (see ",
		"Features by model",
		").",
		"1",
		"WPS",
		"Configures the wireless network connection easily without a computer (see ",
		"Using the WPS Settings menu ",
		"2",
		"Scan to",
		"Switches between scan and copy mode. The ",
		" LED turns on scan mode and turns off on copy mode.",
		"3",
		"Display screen",
		"Shows the current status and displays prompts during an operation.",
		"4",
		"Arrows",
		"Scrolls through the options available in the selected menu and increases or decreases values. ",
		"5",
		"Menu",
		"Opens Menu mode and scrolls through the available menus (see ",
		"Menu overview",
		"6",
		"OK",
		"Confirms the selection on the screen. ",
		"7",
		"Stop/Clear",
		"Stops an operations at any time.",
		"8",
		"Power",
		"Turns the power on or off, or wakes up the machine from the power save mode. If you need to turn the machine off, press this button for more than three seconds when the machine is in ready mode.",
		"9",
		"Start",
		"Starts a job (Black / Color).",
		"10",
		"Back",
		"Sends you back to the upper menu level.",
		"11",
		"Status",
		"/",
		"Wireless",
		"LED",
		"Indicates the status of your machine (see ",
		"Understanding the status LED",
		"). ",
		"12",
		"ID Copy",
		"Allows you to copy both sides of an ID card like a driver’s license on a single side of paper. ",
		"13",
		"Direct USB",
		"Allows you to directly print files stored on a USB memory device when it is inserted into the USB port on the front of your machine. "
	],
	"0_0|1_0|9_7": [
		"Turning on the machine",
		" > ",
		"Basic",
		"Introduction",
		"Keep in mind that you should use the power cord supplied with the machine. Otherwise, it can cause damage or fire to the machine.",
		"Connect the machine to the electricity supply first.",
		"Turn the switch on if the machine has a power switch.",
		"Illustrations on this user’s guide may differ from your machine depending on its options or models. Check your machine type (see ",
		"Front view",
		").",
		"Press ",
		" (",
		"Power",
		") button on the control panel.",
		" If you want to turn the power off, press and hold ",
		") button for about 3 seconds."
	],
	"0_0|1_0|10_8": [
		"Installing the driver locally",
		" > ",
		"Basic",
		"Introduction",
		"A locally connected machine is a machine directly attached to your computer using a USB cable. If your machine is attached to a network, skip the following steps below and go on to installing a network connected machine’s driver (see ",
		"Installing driver over the network",
		").",
		"If you are a Mac or Linux operating systems user, refer to the ",
		"Installation for Mac",
		" or ",
		"Installation for Linux",
		". ",
		"The installation window in this ",
		"User’s Guide",
		" may differ depending on the machine and interface in use.",
		"Only use a USB cable no longer than 3 meters (118 inches).",
		"Windows",
		"Make sure that the machine is connected to your computer and powered on.",
		"Insert the supplied software CD into your CD-ROM drive.",
		"If the installation window does not appear, click ",
		"Start",
		"All programs",
		"Accessories",
		"Run",
		".",
		" X:\\",
		"Setup.exe",
		" replacing “X” with the letter, which represents your CD-ROM drive and click ",
		"OK",
		"For Windows 8,",
		"If the installation window does not appear, from ",
		"Charms",
		", select ",
		"Search",
		"Apps ",
		"and search for ",
		". Type in X:\\Setup.exe, replacing “X” with the letter that represents your CD-ROM drive and click ",
		"If “",
		"Tap to choose what happens with this disc",
		".” pop-up window appears, click the window and select ",
		"Run Setup.exe",
		"For Windows 10 / Windows Server 2016",
		"If the installation window does not appear, from task bar, type in X:\\",
		" in ",
		" input area, replacing “X” with the letter that represents your CD-ROM drive and press the Enter key.",
		"Review and accept the installation agreements in the installation window. Then, click ",
		"Next",
		"Select you want type on the ",
		"Printer Setup Type",
		" screen. Then, click ",
		"Follow the instructions in the installation window.",
		"From the Windows 8 ",
		" Screen",
		"The V4 driver is automatically downloaded from the Windows Update if your computer is connected to the Internet. If not, you can manually download the V4 driver from Lenovo website, ",
		"www.lenovoimage.com",
		"If you install the driver using the supplied software CD, V4 driver is not installed. If you want to use the V4 driver in the ",
		"Desktop",
		" screen, you can download from the Lenovo website, ",
		"If you want to install Lenovo’s printer management tools, you need to install them using the supplied software CD.",
		"Make sure that your computer is connected to the Internet and powered on.",
		"Make sure that the machine is powered on.",
		"Connect the computer and the machine with a USB cable.",
		"The driver is automatically installed from the ",
		"Windows Update",
		". \t"
	],
	"0_0|1_0|11_9": [
		"Reinstalling the driver",
		" > ",
		"Basic",
		"Introduction",
		"If the printer driver does not work properly, follow the steps below to reinstall the driver.",
		"Windows",
		"Make sure that the machine is connected to your computer and powered on.",
		"From the ",
		"Start",
		" menu, select ",
		"Programs",
		" or ",
		"All Programs",
		"Lenovo Printers",
		"Uninstall Lenovo Printer Software",
		".",
		"For Windows 8,",
		"From Charms, select ",
		"Search",
		"Apps",
		". ",
		"Search and click ",
		"Control Panel",
		"Click ",
		"Programs and Features",
		"Right-click the driver you want to uninstall and select ",
		"Uninstall",
		"For Windows 10 / Windows Server 2016",
		"From task bar, type in ",
		" in ",
		" input area. Press the Enter key.",
		"OR",
		" (",
		") icon, select ",
		"All apps",
		" > type in ",
		"Follow the instructions in the installation window.",
		"Insert the software CD into your CD-ROM drive and install the driver again (see ",
		"Installing the driver locally",
		").",
		"From the Windows 8 ",
		" Screen",
		"Click on the ",
		"Uninstall Lenovo Printer Software ",
		"tile in the ",
		" screen.",
		"Follow the instructions in the window.",
		"If you cannot find a Lenovo Printer Software tile, unintstall from the desktop screen mode. ",
		"If you want to uninstall Lenovo’s printer management tools, from the ",
		" screen, right-click the app > ",
		" > right-click the program you want to delete > ",
		" and follow the instruction in the window. "
	],
	"0_0|12_1": [
		"Menu Overview and Basic Setup",
		" > ",
		"Basic",
		"This chapter provides information about the overall menu structure and the basic setup options.",
		"Menu overview",
		"Machine’s basic settings",
		"Media and tray",
		"Basic printing ",
		"Basic copying",
		"Basic scanning",
		"Using USB memory device"
	],
	"0_0|12_1|13_0": [
		"Menu overview",
		" > ",
		"Basic",
		"Menu Overview and Basic Setup",
		"The control panel provides access to various menus to set up the machine or use the machine’s functions.",
		"An asterisk (*) appears next to the currently selected menu.",
		"Some menus may not appear on the display depending on options or models. If so, it is not applicable to your machine.",
		"Some menu names may differ from your machine depending on its options or the models.",
		"The menus are described in the Advanced Guide (see ",
		"Useful Setting Menus",
		").",
		"Accessing the menu",
		"Select the Copy or Scan button on the control panel depending on the feature to be used.",
		"Select ",
		" (",
		"Menu",
		") until the menu you want appears on the bottom line of the display and press ",
		"OK",
		".",
		"Press the left/right arrows until the needed menu item appears and press ",
		"If the setting item has sub menus, repeat step 3.",
		"Press ",
		" to save the selection.",
		"(",
		"Stop/Clear",
		") to return to the ready mode.",
		"Copy Feature",
		"(see ",
		"Copy",
		")",
		"Copy Setup",
		"Scan Feature",
		"Scan",
		"Scan Setup",
		"Original Size",
		"Reduce/Enlarge",
		"Darkness",
		"Normal",
		"Dark+1",
		"- ",
		"Dark+5",
		"Light+5",
		"Light+1",
		"Original Type",
		"Text",
		"Text/Photo",
		"Photo",
		"Magazine",
		"Collation",
		"Layout",
		"2-Up",
		"4-Up",
		"ID Copy",
		"Adjust Bkgd.",
		"Off",
		"Auto",
		"Enhance Lev.1",
		"Enhance Lev.2",
		"Erase Lev.1",
		"Erase Lev.4",
		"Change Default",
		"Copies",
		"USB Feature",
		"Resolution",
		"Color Mode",
		"File Format",
		"USB Default",
		"Print Setup",
		"Print",
		"System Setup",
		"System setup",
		"Orientation",
		"Portrait",
		"Landscape",
		"[1 - 999]",
		"Standard",
		"High Resol.",
		"Clear Text",
		"Minimum",
		"Medium",
		"Maximum",
		"Edge Enhance",
		"Trapping",
		"Screen",
		"Enhanced",
		"Detailed",
		"Auto CR",
		"SkipBlankPages",
		"Emulation",
		"Emulation Type",
		"Setup",
		"Machine Setup",
		"Language",
		"Power Save",
		"Auto Power Off ",
		"Wakeup Event ",
		"System Timeout",
		"Job Timeout",
		"Altitude Adj.",
		"Humidity",
		"Auto Continue",
		"Paper Substit.",
		"Eco Settings",
		"Paper Setup",
		"Paper Size",
		"Paper Type",
		"Margin",
		"Report",
		"Configuration",
		"Demo Page",
		"Network Info.",
		"Supplies Info.",
		"Usage Counter",
		"PCL Font",
		"PS Font",
		"Maintenance",
		"CLR Empty Msg",
		"[a]",
		"Supplies Life",
		"Image Mgr.",
		"TonerLow Alert",
		"ImgU.Low Alert",
		"Serial Number",
		"[a] ",
		"This option only appears when small amount of toner is left in the cartridge.",
		"Network",
		"Network setup",
		"TCP/IP (IPv4)",
		"DHCP",
		"BOOTP",
		"Static",
		"TCP/IP (IPv6)",
		"IPv6 Protocol",
		"DHCPv6 Config",
		"Ethernet",
		"Ethernet Port",
		"Ethernet Speed",
		"Wi-Fi",
		"Protocol Mgr. ",
		"Network Conf. ",
		"Clear Settings"
	],
	"0_0|12_1|14_1": [
		"Machine’s basic settings",
		" > ",
		"Basic",
		"Menu Overview and Basic Setup",
		"You change the machine’s setting set in the machine from ",
		"Lenovo Easy Printer Manager",
		" or ",
		"Embedded Web Server",
		".",
		"If your machine is connected to the local, you can set the machine’s setting from ",
		"Advanced Setting",
		"Device Settings",
		" (see ",
		"Using Lenovo Easy Printer Manager ",
		").",
		"If your machine is connected to the network, you can set themachine’s setting from ",
		"Settings",
		" tab > ",
		"Machine Settings",
		"Using ",
		"After installation is complete, you may want to set the machine's default settings. ",
		"To change the machine’s default settings, follow these steps:",
		"It may be necessary to press ",
		"OK",
		" to navigate to lower-level menus for some models.",
		"Select ",
		"(",
		"Menu",
		") button on the control panel.",
		"Press ",
		"System Setup",
		"Machine Setup",
		"Select the option you want, then press ",
		"Language",
		": ",
		"change the language that is displayed on the control panel.",
		"Power Save",
		"When you are not using the machine for a while, use this feature to save power.",
		"When you press the ",
		"Power",
		" button, start printing is received, the product will wake up from the power saving mode.",
		") > ",
		"Wakeup Event",
		"On",
		" on the control panel. When you press any button except ",
		" button, the machine wake up from the power save mode.",
		"Altitude Adj.",
		"Print quality is affected by atmospheric pressure, which atmospheric pressure is determined by the height of the machine above sea level. Before you set the altitude value, determine the altitude where you are (see ",
		"Altitude adjustment",
		"OK ",
		"to save the selection.",
		"Stop/Clear",
		") to return to ready mode."
	],
	"0_0|12_1|15_2": [
		"Media and tray",
		" > ",
		"Basic",
		"Menu Overview and Basic Setup",
		"This chapter provides information on how to load print media into your machine.",
		"Selecting print media",
		"Always use print media that meet the guidelines for use with your machine. ",
		"Guidelines for select the print media",
		"Print media that does not meet the guidelines outlined in this user’s guide may cause the following problems:",
		"Poor print quality",
		"Increased paper jams",
		"Premature wear on the machine.",
		"Properties, such as weight, composition, grain, and moisture content, are important factors that affect the machine’s performance and the output quality. When you choose print materials, consider the following:",
		"The type, size, and weight of the print media for your machine are described in print media specifications (see ",
		"Print media specifications ",
		").",
		"Desired outcome: The print media you choose should be appropriate for your project.",
		"Brightness: Some print media are whiter than others and produce sharper, more vibrant images.",
		"Surface smoothness: The smoothness of the print media affects how crisp the printing looks on the paper.",
		"Some print media may meet all of the guidelines in this user’s guide and still not produce satisfactory results. This may be the result of the sheets characteristics, improper handling, unacceptable temperature and humidity levels, or other variables over which cannot be controlled.",
		"Before purchasing large quantities of print media, ensure that it meets the requirements specified in this user’s guide. ",
		"Using print media that does not meet these specifications may cause problems or require repairs. Such repairs are not covered by ",
		"Lenovo",
		"’s warranty or service agreements.",
		"The amount of paper put into the tray may differ according to media type used (see ",
		"Make sure not to use the inkjet photo paper with this machine. It could cause damage to the machine. ",
		"Using flammable print media can cause a fire.",
		"Use designated print media (see ",
		"The use of flammable media or foreign materials left in the printer may lead to overheating of the unit and, in rare cases may cause a fire.",
		"Tray overview",
		"To change the size, you need to adjust the paper guides.",
		"Paper cover",
		"Guide lock",
		"Paper length guide",
		"Paper width guide",
		"If you do not adjust the guide, it may cause paper registration, image skew, or jamming of the paper.",
		"Loading paper in the tray",
		"Illustrations on this user’s guide may differ from your machine depending on its options or models. Check your machine type (see ",
		"Front view",
		"Pull out the paper tray (see ",
		"Open the paper cover.",
		"Squeeze and the paper width guide and paper length lever to locate them in the correct paper size slot marked at the bottom of the tray to adjust to the size.",
		"Flex or fan the edge of the paper stack to separate the pages before loading papers.",
		"Place the paper with the side you want to print facing up.",
		"For paper smaller than A4-sized, press and unlatch the guide lock in the tray, push the tray in manually. Then adjust the paper length guide and paper width guide.",
		"For paper longer than Legal-sized, press and unlatch the guide lock in the tray, pull the tray out manually. Then adjust the paper length guide and paper width guide.",
		"Do not push the paper width guide too far causing the media to buckle.",
		"Do not use a paper with a leading-edge curl, it may cause a paper jam or the paper can be wrinkled.",
		"If you do not adjust the paper width guide, it may cause paper jams.",
		"Squeeze the paper width guide and slide it to the edge of the paper stack without causing it to buckle.",
		"Close the paper cover.",
		"Insert the paper tray.",
		"When you print a document, set the paper type and size for the tray (see ",
		"Setting the paper size and type",
		"The tray is preset to Letter or A4 size, depending on your country. To change the size to A4 or Letter, you must adjust the lever and paper width guide properly.",
		"Pull the tray out of the machine. Open the paper cover and remove paper from the tray if necessary.",
		"If you want to change the size to Letter, hold the lever at the back of the tray, and rotate the lever clockwise. You can see the lever when you move the paper length guide to the legal-sized paper (LGL).",
		"Squeeze the paper width guide and slide it to the edge of the lever.",
		"If you want to change the size to A4, first move the paper width guide to left and rotate the lever counterclockwise. If you force the lever, it could damage the tray.",
		"Printing on special media",
		"When using special media, we recommend you feed one sheet at a time (see ",
		"The table below shows the special media usable in tray. ",
		"The paper setting in the machine and driver should match to print without a paper mismatch error. ",
		"You change the paper setting set in the machine from ",
		"Lenovo Easy Printer Manager",
		" program or ",
		"Embedded Web Server",
		".",
		"If your machine is connected to the local, you can set the machine’s setting from ",
		"Advanced Setting",
		"Device Settings",
		" (see ",
		"Using Lenovo Easy Printer Manager ",
		"If your machine is connected to the network, you can set the machine’s setting from ",
		"Settings",
		" tab > ",
		"Machine Settings",
		"Using ",
		"You can set it using ",
		"System Setup",
		"Paper Setup",
		" > select you want ",
		"Paper Size",
		" or ",
		"Paper Type",
		" button on the control panel. ",
		"To see paper weights for each sheet, refer to ",
		"Types",
		"Tray",
		"[a]",
		"Plain",
		"●",
		"Thick",
		"Thin",
		"Bond",
		"Color",
		"CardStock",
		"Labels",
		"Preprinted",
		"Cotton",
		"Recycled",
		"Archive",
		"Glossy Photo",
		"Matte Photo",
		"[a] ",
		"The paper types available manual feeding in tray.",
		"(",
		": Supported) ",
		"To avoid damaging the machine, use only labels designed for use in laser printers.",
		"When selecting labels, consider the following factors:",
		"Adhesives: ",
		"Should be stable at your machine’s fusing temperature about 170°C (338°F).",
		"Arrangement: ",
		"Only use labels with no exposed backing between them. Labels can peel off sheets that have spaces between the labels, causing serious jams.",
		"Curl: ",
		"Must lie flat with no more than 13 mm of curl in any direction.",
		"Condition: ",
		"Do not use labels with wrinkles, bubbles, or other indications of separation.",
		"Make sure that there is no exposed adhesive material between labels. Exposed areas can cause labels to peel off during printing, which can cause paper jams. Exposed adhesive can also cause damage to machine components.",
		"Do not run a sheet of labels through the machine more than once. The adhesive backing is designed for only a single pass through the machine.",
		"Do not use labels that are separating from the backing sheet or are wrinkled, bubbled, or otherwise damaged.",
		"Card stock/ Custom-sized paper",
		"In the software application, set the margins to at least 6.4 mm (0.25 inches) away from the edges of the material.",
		"Preprinted paper",
		"When loading preprinted paper, the printed side should be facing up with an uncurled edge at the front. If you experience problems with paper feeding, turn the paper around. Note that print quality is not guaranteed.",
		"Must be printed with heat-resistant ink that will not melt, vaporize, or release hazardous emissions when subjected to the machine’s fusing temperature for 0.1 second (about 170°C (338°F)).",
		"Preprinted paper ink must be non-flammable and should not adversely affect machine rollers.",
		"Before you load preprinted paper, verify that the ink on the paper is dry. During the fusing process, wet ink can come off preprinted paper, reducing print quality.",
		"After loading paper in the paper tray, set the paper size and type using the control panel buttons. ",
		"Select ",
		"Menu",
		") button on the control panel.",
		"Press ",
		"Select the tray and the option you want.",
		"OK",
		" to save the selection.",
		"Stop/Clear",
		") to return to ready mode.",
		"If you want to use special-sized paper such as billing paper, select the ",
		"Paper",
		"Size",
		"Edit...",
		" and set ",
		"Custom Paper Size Settings",
		" in the ",
		"Printing Preferences",
		"Opening printing preferences",
		"Using the output support",
		"The surface of the output tray may become hot if you print a large number of pages at once. Make sure that you do not touch the surface, and do not allow children near it.",
		"The printed pages stack on the output support, and the output support will help the printed pages to align. The printer sends output to the output tray by default.",
		"Preparing originals ",
		"Do not load paper smaller than 142 x 148 mm (5.6 x 5.8 inches) or larger than 216 x 356 mm (8.5 x 14 inches).",
		"Make sure any glue, ink, or correction fluid on the paper is completely dry before loading.",
		"Do not load booklets, pamphlets, transparencies, or documents with other unusual characteristics.",
		"Loading originals",
		"You can use the scanner glass to load an original for copying and scanning.",
		"On the scanner glass",
		"Using the scanner glass, you can copy or scan originals. You can get the best scan quality, especially for colored or gray-scaled images.",
		"Lift and open the scanner lid.",
		"Place the original face down on the scanner glass.",
		"Close the scanner lid.",
		"Leaving the scanner lid open while copying may affect copy quality and toner consumption.",
		"Dust on the scanner glass may cause black spots on the printout. Always keep it clean (see ",
		"Cleaning the machine",
		"If you are copying a page from a book or magazine, lift the scanner lid until its hinges are caught by the stopper and then close the lid. If the book or magazine is thicker than 30 mm, start copying with the scanner lid open.",
		"Be careful not to break the scanner glass. You may get hurt.",
		"Do not put hands while closing the scanner lid. The scanner lid may fall on your hands and get hurt.",
		"Do not look into the light from inside of the scanner while copying or scanning. It is harmful to eyes."
	],
	"0_0|12_1|16_3": [
		"Basic printing",
		" > ",
		"Basic",
		"Menu Overview and Basic Setup",
		"Basic printing ",
		"For special printing features, refer to the Advanced Guide (see ",
		"Using advanced print features",
		").",
		"Printing",
		" Mac printing (see ",
		"Mac printing",
		" Linux printing (see ",
		"Linux printing",
		"The following ",
		"Printing Preferences",
		" window is for Notepad in Windows 7. Your ",
		" window may differ, depending on your operating system or the application you are using.",
		"Open the document you want to print.",
		"Select ",
		"Print",
		" from the ",
		"File",
		" menu.",
		"Select your machine from the ",
		"Select Printer",
		" list.",
		"The basic print settings including the number of copies and print range are selected within the ",
		" window. ",
		"To take advantage of the advanced printing features, click ",
		"Properties",
		" or ",
		"Preferences",
		" window\t (see ",
		"Opening printing preferences",
		"To start the print job, click ",
		"OK",
		" in the ",
		" window.",
		"Canceling a print job",
		"If the print job is waiting in the print queue or print spooler, cancel the job as follows:",
		"You can access this window by simply double-clicking the machine icon (",
		") in the Windows task bar. ",
		"You can also cancel the current job by pressing ",
		"(",
		"Stop/Clear",
		") on the control panel.",
		"The ",
		" window that appears in this user’s guide may differ depending on the machine in use. ",
		"When you select an option in ",
		", you may see a warning mark ",
		". An ",
		" mark means you can select that certain option but it is not recommended, and an ",
		" mark means you cannot select that option due to the machine’s setting or environment.",
		" from the file menu. The ",
		" window appears. ",
		". ",
		"Click ",
		"The screenshot may differ depending on model.",
		"You can check the machine’s current status pressing the ",
		"Printer Status",
		" button (see ",
		"Using ",
		"Lenovo Printer Status",
		"Using a favorite setting",
		"Favorites",
		" option, which is visible on each preferences tab except for the ",
		"Lenovo",
		" tab, allows you to save the current preferences for future use.",
		"To save a ",
		" item, follow these steps:",
		"Change the settings as needed on each tab. ",
		"Enter a name for the item in the ",
		" input box.",
		"Save",
		"Enter name and description, and then select the desired icon.",
		". When you save ",
		", all current driver settings are saved.",
		"To use a saved setting, select it in the ",
		" tab. The machine is now set to print according to the settings you have selected. To delete saved settings, select it in the ",
		" tab and click ",
		"Delete",
		"Using help",
		"Click the option you want to know on the ",
		" window and press ",
		"F1",
		" on your keyboard.",
		"Eco printing",
		"Eco",
		" function cuts toner consumption and paper usage. The ",
		" function allows you to save print resources and lead you to eco-friendly printing.",
		"Setting Eco mode on the control panel",
		"Menu",
		") > ",
		"System Setup",
		"Machine Setup",
		"Eco Settings",
		" on the control panel.",
		"Select the option you want and press ",
		".",
		"Default Mode",
		": ",
		"Select this to turn on or off the eco mode.",
		"If you set the eco mode on with a password from the ",
		"Embedded Web Server",
		" (",
		"Settings",
		" tab > ",
		"Machine Settings",
		"System",
		") or ",
		"Lenovo Easy Printer Manager",
		"Advanced Setting",
		"Device Settings",
		"), the ",
		"On force",
		" message appears. You have to enter the password to change the eco mode status.",
		"Select Temp.",
		"Follow the settings from Embedded Web Server or ",
		". Before you select this item, you must set the eco function in ",
		"). ",
		"Press ",
		" to save the selection.",
		"Setting eco mode on the driver",
		"Open the Eco tab to set Eco mode. When you see the eco image (",
		"), that means the eco mode is currently enabled."
	],
	"0_0|12_1|17_4": [
		"Basic copying",
		" > ",
		"Basic",
		"Menu Overview and Basic Setup",
		"For special printing features, refer to the ",
		"Advanced Guide",
		" (see ",
		"Copy",
		").",
		"Basic copy",
		"Make sure that the ",
		"Scan to",
		" button’s LED is off.",
		"Select ",
		"(",
		"Menu",
		") > ",
		"Copy Feature",
		" on the control panel.",
		"Place a single document face down on the document glass (see ",
		"Loading originals",
		"If you want to customize the copy settings including ",
		"Reduce/Enlarge",
		", ",
		"Darkness",
		"Original Type",
		" and more by using the control panel buttons (see ",
		"Changing the settings for each copy",
		"). ",
		"Enter the number of copies using the arrow or number keypad, if necessary.",
		"Press ",
		"Start",
		"If you need to cancel the copying job during the operation, press ",
		"Stop/Clear",
		") and the copying will stop.",
		"Your machine provides default settings for copying so that you can quickly and easily make a copy. ",
		"If you press the",
		") button twice while setting the copy options, all of the options you have set for the current copy job will be canceled and returned to their default status. Or, they will automatically return to their default status after the machine completes the copy in progress.",
		"Accessing menus may differ from model to model (see ",
		"Accessing the menu",
		"It may be necessary to press ",
		"OK",
		" to navigate to lower-level menus for some models.",
		"If you have an original containing faint marking and dark images, you can adjust the brightness to make a copy that is easier to read.",
		"Select the option you want and press ",
		".",
		"For example, the ",
		"Light+5",
		" being the lightest, and the ",
		"Dark+5",
		" being the darkest.",
		") to return to ready mode.",
		"Original ",
		"The original setting is used to improve the copy quality by selecting the document for the current copy job.",
		"Text",
		": Use for originals containing mostly text.",
		"Text/Photo",
		": Use for originals with mixed text and photographs.",
		"If texts in the printout is blurry, select ",
		" to get the clear texts.",
		"Photo",
		": Use when the originals are photographs.",
		"Magazine",
		": Use when the originals are magazine.",
		"Reduced or enlarged copy",
		"You can reduce or enlarge the size of a copied image from 25% to 400% from the scanner glass.",
		"This feature may not be available depending on model or optional goods (see ",
		"Variety feature",
		"If the machine set to Eco mode, reduce and enlarge features are not available.",
		"To select from the predefined copy sizes",
		"To scale the copy by directly entering the scale rate",
		"Custom",
		"Enter the copy size you want using the numeric keypad.",
		" to save the selection.",
		"When you make a reduced copy, black lines may appear at the bottom of your copy.",
		"ID card copying",
		"Your machine can print 2-sided originals on one sheet.",
		"The machine prints one side of the original on the upper half of the paper and the other side on the lower half without reducing the size of the original. This feature is helpful for copying a small-sized item such as business card.",
		"The original must be placed on the scanner glass to use this feature.",
		"If the machine set to Eco mode, this feature is not available.",
		"Depending on the model, the operating procedure may differ.",
		"ID Copy",
		"Place the front side of an original facing down on the scanner glass where arrows indicate as shown. Then, close the scanner lid.",
		"Place Front Side",
		"and Press [Start]",
		" appears on the display.",
		" (",
		"Your machine begins scanning the front side and shows ",
		"Place Back Side",
		"Turn the original over and place it on the scanner glass where arrows indicate as shown. Then, close the scanner lid.",
		") button.",
		"If you do not press the ",
		") button, only the front side will be copied.",
		"If the original is larger than the printable area, some portions may not be printed."
	],
	"0_0|12_1|18_5": [
		"Basic scanning",
		" > ",
		"Basic",
		"Menu Overview and Basic Setup",
		"For special scanning features, refer to the ",
		"Advanced Guide",
		" (see ",
		"Scan features",
		").",
		"Basic Scanning",
		"This is the normal and usual procedure for scanning originals.",
		"This is a basic scanning method for USB-connected machine.",
		"It may be necessary to press ",
		"OK",
		" to navigate to lower-level menus for some models.",
		"If you want to scan using the network, refer to the Advanced Guide (see ",
		"Scanning from network connected machine",
		"). ",
		"Place a single document face down on the document glass (see ",
		"Loading originals",
		"Press ",
		"Scan to",
		"Scan to PC",
		"Local PC",
		" on the control panel.",
		"If you see ",
		"Not Available",
		" message, check the port connection, or select ",
		"Enable Scan from Device Panel",
		" in ",
		"Lenovo Easy Printer Manager",
		"Advanced Setting",
		"Scan to PC Settings",
		".",
		"Select the scan destination you want and press ",
		"Default setting is ",
		"My Documents",
		"You can create and save the frequently used settings as a profile list. Also you can add and delete the profile and save each profile to a different path.",
		"To change the ",
		"Select the option you want and press ",
		"Scanning begins.",
		"Scanned image is saved in computer’s ",
		"C:\\",
		"Users",
		"\\users name\\",
		". The saved folder may differ, depending on your operating system or the application you are using."
	],
	"0_0|12_1|19_6": [
		"Using USB memory device",
		" > ",
		"Basic",
		"Menu Overview and Basic Setup",
		"This chapter explains how to use a USB memory device with your machine.",
		"About USB memory",
		"USB memory devices are available with a variety of memory capacities to give you more room for storing documents, presentations, downloaded music and videos, high resolution photographs or whatever other files you want to store or move.",
		"You can do the following tasks on your machine by using a USB memory device.",
		"Scan documents and save them on a USB memory device",
		"Print data stored on a USB memory device",
		"Restore backup files to the machine’s memory",
		"Format the USB memory device",
		"Check the available memory space",
		"Plugging in a USB memory device",
		"Lift the scanner lid slightly and insert your USB memory device into the USB memory port. Close the scanner lid again before using the device.",
		"The USB memory port on the front of your machine is designed for USB V1.1 and USB V2.0 memory devices. Your machine supports USB memory devices with FAT16/FAT32 and a sector size of 512 bytes.",
		"Check your USB memory device’s file system from your dealer.",
		"You must use only an authorized USB memory device with an A plug connector.",
		"Use only a metal-shielded USB memory device.",
		"Only use a USB memory device that has obtained compatibility certification; otherwise, the machine might not recognize it.",
		"Do not remove the USB memory device while the machine is in operation or writing to or reading from USB memory. The machine warranty does not cover damage caused by user’s misuse. ",
		"If your USB memory device has certain features such as security settings and password settings, your machine may not automatically detect it. For details about these features, see the user’s guide of the USB memory device.",
		"Printing from a USB memory device",
		"You can directly print files stored on a USB memory device.",
		"File is supported by Direct Print option.",
		"PRN: ",
		"Only files created by provided driver with your machine are compatible. ",
		"If you print PRN files created from other machine, the printout would be different.",
		"TIFF: ",
		"TIFF 6.0 Baseline",
		"JPEG: ",
		"JPEG Baseline",
		"PDF: ",
		"PDF 1.7 or lower version",
		"To print a document from a USB memory device",
		"Insert a USB memory device into the USB memory port on your machine, and then press ",
		"Direct USB",
		".",
		"Select ",
		"USB Print",
		"Select the folder or file you want and press ",
		"OK",
		"If you see [+] or [D] in the front of a folder name, there are one or more files or folders in the selected folder.",
		"Select the number of copies to be printed or enter the number.",
		"Press ",
		", ",
		"Start ",
		"or ",
		"Print",
		" to start printing the selected file. ",
		"After printing the file, the display asks if you want to print another job.",
		"OK ",
		"when ",
		"Yes ",
		"appears to print another job, and repeat from step 2. ",
		"Otherwise, press the left/right arrow to select ",
		"No ",
		"and press ",
		"(",
		"Stop/Clear",
		") to return to ready mode.",
		"Scanning to a USB memory device",
		"Accessing menus may differ from model to model (see ",
		"Accessing the menu",
		")",
		"It may be necessary to press ",
		" to navigate to lower-level menus for some models.",
		"You can scan a document and save the scanned image onto a USB memory device.",
		"Scanning",
		"Insert a USB memory device into the USB memory port on your machine.",
		"Place a single document face down on the document glass (see ",
		"Loading originals",
		").",
		"(scan) > ",
		"Scan To USB",
		" on the control panel.",
		"The machine begins scanning.",
		"To scan multiple pages, select ",
		"Yes",
		" while ",
		"Another Page?",
		"/",
		"No",
		" appears. After scanning is complete, you can remove the USB memory device from the machine.",
		"Customizing Scan to USB ",
		"You can specify image size, file format, or color mode for each scanning to USB job.",
		"Menu",
		") > ",
		"Scan Feature",
		"USB Feature",
		"Select the setting option you want appears.",
		"Original Size",
		": ",
		"Sets the image size.",
		"Original Type",
		"Sets the original document’s.",
		"Resolution",
		"Sets the image resolution.",
		"Color Mode",
		"Sets the color mode. If you select ",
		"Mono",
		" in this option, you cannot select JPEG in ",
		"File Format",
		"Sets the file format in which the image is to be saved. If you select ",
		"JPEG",
		" in this option, you cannot select ",
		" in ",
		"Darkness",
		"Sets the brightness level to scan an original.",
		"Select the desired status you want and press ",
		"Repeat steps 2 and 3 to set other setting options.",
		"You can change the default scan settings. Refer to the ",
		"Advanced",
		" Guide.",
		"Managing USB memory",
		"You can delete image files stored on a USB memory device one by one or all at once by reformatting the device.",
		"After deleting files or reformatting a USB memory device, files cannot be restored. Therefore, confirm that you no longer need the data before deleting it.",
		"Deleting an image file",
		"File Manage ",
		"> ",
		"Delete ",
		"Select the file you want to delete and press ",
		"Formatting a USB memory device",
		"Format ",
		"Viewing the USB memory status",
		"You can check the amount of memory space available for scanning and saving documents.",
		"Check Space",
		"The available memory space appears on the display."
	],
	"0_0|20_2": [
		"Maintenance",
		" > ",
		"Basic",
		"This chapter provides information about purchasing supplies, accessories and maintenance parts available for your machine.",
		"Ordering supplies and accessories",
		"Available supplies",
		"Available maintenance parts",
		"Storing the toner cartridge",
		"Redistributing toner",
		"Replacing the toner cartridge",
		"Replacing the imaging unit",
		"Replacing the waste toner container",
		"Monitoring the supplies life",
		"Setting the toner low alert",
		"Cleaning the machine",
		"Tips for moving & storing your machine"
	],
	"0_0|20_2|21_0": [
		"Ordering supplies and accessories",
		" > ",
		"Basic",
		"Maintenance",
		"Available accessories may differ from country to country. Contact your sales representatives to obtain the list of available supplies, and maintenance parts.",
		"To order ",
		"Lenovo",
		"-authorized supplies, accessories, and maintenance parts, contact your local ",
		" dealer or the retailer where you purchased your machine. You can also visit ",
		"www.lenovoimage.com",
		", and then select your country/region to obtain the contact information for service."
	],
	"0_0|20_2|22_1": [
		"Available supplies",
		" > ",
		"Basic",
		"Maintenance",
		"When supplies reach the end of their life spans, you can order the followings of supplies for your machine:",
		"Type",
		"Average yield",
		"[a]",
		"Part name",
		"Toner cartridge",
		"Average continuous black cartridge yield: Approx. 1,500 standard pages (Black)",
		"Average continuous color cartridge yield: Approx. 1,000 standard pages (Yellow/Magenta/Cyan)",
		"LT1821K: Black",
		"LT1821C: Cyan",
		"LT1821M: Magenta",
		"LT1821Y: Yellow",
		"Imaging unit",
		"Approx. 16,000 images",
		"[b]",
		"LD181",
		"Waste toner container",
		"Approx. 7,000 images",
		"WTB181",
		"[a] ",
		"Declared yield value in accordance with ISO/IEC 19798. The number of pages may be affected by operating environment, printing interval, graphics, media type and media size.",
		"[b] ",
		"Image counts based on one color on each page. If you print documents in full color (Cyan, Magenta, Yellow, Black), the life of this item will be reduced by 25%.",
		"Depending on the options, percentage of image area and job mode used, the toner cartridge’s lifespan may differ.",
		"When purchasing new toner cartridges or other supplies, these must be purchased in the same country as the machine you are using. Otherwise, new toner cartridges or other supplies will be incompatible with your machine due to different configurations of toner cartridges and other supplies according to the specific country conditions.",
		"The toner cartridge included in the printer/all-in-one product you purchased is not available for sale and is not guaranteed to be compatible with any other printer.",
		"Lenovo",
		" does not recommend using non-genuine ",
		" toner cartridge such as refilled or remanufactured toner. ",
		" cannot guarantee non-genuine ",
		" toner cartridge's quality. Service or repair required as a result of using non-genuine ",
		" toner cartridges will not be covered under the machine’s warranty."
	],
	"0_0|20_2|23_2": [
		"Available maintenance parts",
		" > ",
		"Basic",
		"Maintenance",
		"You need to replace the maintenance parts at specific intervals to keep the machine in the best condition and avoid print quality and paper feeding problems resulting from the worn-out parts. Maintenance parts are mostly rollers, belts and pads. However, the replacement period and parts may differ depending on the model. Replacing maintenance parts can be performed only by an authorized service provider, dealer, or the retailer where you bought the machine. To purchase maintenance parts, contact the retailer where you bought the machine. The replacement period for the maintenance parts is informed by the \"Lenovo Printer Status\" program. Or on the UI (User Interface) if your machine supports a display screen. The replacement period varies based on the operating system used, computing performance, application software, connecting method, paper type, paper size, and job complexity."
	],
	"0_0|20_2|24_3": [
		"Storing the toner cartridge",
		" > ",
		"Basic",
		"Maintenance",
		"Toner cartridges contain components that are sensitive to light, temperature and humidity. Lenovo suggests users follow these recommendations to ensure optimal performance, highest quality, and longest life from your new Lenovo toner cartridge.",
		"Store this cartridge in the same environment in which the printer will be used. This should be in controlled temperature and humidity conditions. The toner cartridge should remain in its original and unopened package until installation – if original packaging is not available, cover the top opening of the cartridge with paper and store in a dark cabinet.",
		"Opening the cartridge package prior to use dramatically shortens its useful shelf and operating life. Do not store on the floor. If the toner cartridge is removed from the printer, follow the instructions below to store the toner cartridge properly.",
		"Store the cartridge inside the protective bag from the original package. ",
		"Store lying flat (not standing on end) with the same side facing up as if it were installed in the machine.",
		"Do not store consumables in any of the following conditions:",
		"Temperature greater than 40°C (104°F).",
		"Humidity range less than 20% or greater than 80%.",
		"An environment with extreme changes in humidity or temperature.",
		"Direct sunlight or room light.",
		"Dusty places.",
		"A car for a long period of time.",
		"An environment where corrosive gases are present.",
		"An environment with salty air.",
		"Handling instructions",
		"Do not expose the cartridge to unnecessary vibrations or shock.",
		"Toner cartridge usage",
		"Lenovo does not recommend or approve the use of non-Lenovo brand toner cartridges in your printer including generic, store brand, refilled, or remanufactured toner cartridges.",
		"Lenovo’s printer warranty does not cover damage to the machine caused by the use of a refilled, remanufactured, or non-Lenovo brand toner cartridges.",
		"Estimated cartridge life",
		"Estimated cartridge life (the life of the toner cartridge yield) depends on the amount of toner that print jobs require. The actual print yield may vary depending on the print density of the pages you print on, operating environment, percentage of image area, printing interval, media type and/or media size. For example, if you print a lot of graphics, the consumption of the toner is higher and you may need to change the cartridge more often."
	],
	"0_0|20_2|25_4": [
		"Redistributing toner",
		" > ",
		"Basic",
		"Maintenance",
		"When the toner cartridge is near the end of its life:",
		"White streaks or light printing occurs and/or density varies from side to side. ",
		"The ",
		"Status",
		" LED blinks orange. The toner-related message saying that the toner is low may appear on the display. ",
		"The computer’s ",
		"Lenovo Printing Status",
		" program window appears on the computer telling you which color cartridge is low on toner (see ",
		"Using ",
		"Lenovo Printer Status",
		").",
		"If this happens, you can temporarily improve print quality by redistributing the remaining toner in the cartridge. In some cases, white streaks or light printing will still occur even after you have redistributed the toner.",
		"Illustrations on this user’s guide may differ from your machine depending on its options or models. Check your machine type (see ",
		"Front view",
		"Do not use sharp objects such as a knife or scissors to open the toner cartridge package. They might scratch the drum of the cartridge.",
		"If toner gets on your clothing, wipe it off with a dry cloth and wash clothing in cold water. Hot water sets toner into fabric.",
		"Printing even after the toner empty status can cause serious damage to your machine."
	],
	"0_0|20_2|26_5": [
		"Replacing the toner cartridge",
		" > ",
		"Basic",
		"Maintenance",
		"When a toner cartridge has reached the end of life, the ",
		"Printing Status",
		" window appears on the computer, indicating the toner cartridge needs to be placed.",
		"Shake the toner cartridge thoroughly, it will increase the initial print quality.",
		"Illustrations on this user’s guide may differ from your machine depending on its options or models. Check your machine type (see ",
		"Front view",
		").",
		"Do not use sharp objects such as a knife or scissors to open the toner cartridge package. They might scratch the drum of the cartridge.",
		"If toner gets on your clothing, wipe it off with a dry cloth and wash clothing in cold water. Hot water sets toner into fabric.",
		"Printing even after the toner empty status can cause serious damage to your machine."
	],
	"0_0|20_2|27_6": [
		"Replacing the imaging unit",
		" > ",
		"Basic",
		"Maintenance",
		"When the life span of the imaging unit has expired, the ",
		"Printing Status",
		" window appears on the computer, indicating the imaging unit needs to be placed. Otherwise, your machine stops printing.",
		"Don’t use sharp objects such as a knife or scissors to open the imaging unit package. You could damage the surface of the imaging unit.",
		"Be careful not to scratch the surface of the imaging unit.",
		"To prevent damage, do not expose the imaging unit to light for more than a few minutes. Cover it with a piece of paper to protect it if necessary.",
		"Before closing the front cover, make sure all toner cartridges are installed properly."
	],
	"0_0|20_2|28_7": [
		"Replacing the waste toner container",
		" > ",
		"Basic",
		"Maintenance",
		"When the life span of the waste toner container has expired, waste toner container-related message appears on the screen display of the control panel, indicating the waste toner container needs to be replaced. Check the waste toner container for your machine (see ",
		"Available supplies",
		"). For information about installing the waste toner container, refer to the waste toner container installation guide included on the package.",
		"Toner particles can be released inside the machine but it does not mean the machine is damaged. Contact a service representative when print quality problems occur.",
		"When you pull out the waste toner container out of the machine, move the container carefully not to drop it from your hands.",
		"Make sure that you lay the waste toner container on a flat surface so that the toner does not spill.",
		"Do not tilt or turn over the container."
	],
	"0_0|20_2|29_8": [
		"Monitoring the supplies life",
		" > ",
		"Basic",
		"Maintenance",
		"If you experience frequent paper jams or printing problems, check the number of pages the machine has printed or scanned. Replace the corresponding parts, if necessary.",
		"It may be necessary to press ",
		"OK",
		" to navigate to lower-level menus for some models.",
		"Select ",
		"(",
		"Menu",
		") > ",
		"System Setup",
		"Supplies Life",
		" on the control panel.",
		"Select the option you want and press ",
		".",
		"Press ",
		"Stop/Clear",
		") to return to ready mode."
	],
	"0_0|20_2|30_9": [
		"Setting the toner low alert",
		" > ",
		"Basic",
		"Maintenance",
		"If the amount of toner in the cartridge is low, a message or LED informing the user to change the toner cartridge appears. You can set the option for whether or not this message or LED appears.",
		"You change the machine’s setting set in the machine from ",
		"Lenovo Easy Printer Manager",
		" or ",
		"Embedded Web Server",
		".",
		"If your machine is connected to the local, you can set the machine’s setting from ",
		"Advanced Setting",
		"Device Settings",
		" (see ",
		"Using Lenovo Easy Printer Manager ",
		").",
		"If your machine is connected to the network, you can set themachine’s setting from ",
		"Settings",
		" tab > ",
		"Machine Settings",
		"Using ",
		"It may be necessary to press ",
		"OK",
		" to navigate to lower-level menus for some models.",
		"Select ",
		"(",
		"Menu",
		") > ",
		"System Setup",
		"TonerLow Alert",
		" on the control panel.",
		"Select the option you want.",
		"Press ",
		" to save the selection."
	],
	"0_0|20_2|31_10": [
		"Cleaning the machine",
		" > ",
		"Basic",
		"Maintenance",
		"If printing quality problems occur or if you use your machine in a dusty environment, you need to clean your machine regularly to keep it in the best printing condition and use your machine longer.",
		"Cleaning the cabinet of the machine with cleaning materials containing large amounts of alcohol, solvents, or other strong substances can discolor or distort the cabinet. ",
		"If your machine or the surrounding area is contaminated with toner, we recommend you use a cloth or tissue dampened with water to clean it. If you use a vacuum cleaner, toner blows in the air and might be harmful to you.",
		"Cleaning the outside",
		"Clean the machine cabinet with a soft, lint-free cloth. Dampen the cloth slightly with water, but be careful not to let any water drip onto or into the machine.",
		"Cleaning the inside",
		"During the printing process, paper, toner, and dust particles can accumulate inside the machine. This buildup can cause print quality problems, such as toner specks or smearing. Cleaning the inside of the machine clears and reduces these problems.",
		"To prevent damage to the imaging unit, do not expose it to light for more than a few minutes. Cover it with a piece of paper, if necessary. ",
		"Do not touch the green area of the imaging unit. Use the handle on the imaging unit to avoid touching this area. ",
		"Use a dry lint free cloth when cleaning the inside of the machine, be careful not to damage the transfer roller or any other inside parts. Do not use solvents such as benzene or thinner. Printing quality problems can occur and cause damage to the machine.",
		"Use a dry lint-free cloth to clean the machine.",
		"Turn the machine off and unplug the power cord. Wait for the machine to cool down. If your machine has a power switch, turn the power switch off before cleaning the machine.",
		"Illustrations on this user’s guide may differ from your machine depending on its options or models. Check your machine type (see ",
		"Front view",
		").",
		"Cleaning the scan unit",
		"Keeping the scan unit clean helps ensure the best possible copies. We suggest that you clean the scan lid at the start of each day and during the day as needed.",
		"Slightly dampen a soft, lint-free cloth or paper towel with water.",
		"Lift and open the scanner lid.",
		"Wipe the surface of the scanner until it is clean and dry.",
		"White sheet",
		"Scanner glass",
		"Scanner lid",
		"Close the scanner lid."
	],
	"0_0|20_2|32_11": [
		"Tips for moving & storing your machine",
		" > ",
		"Basic",
		"Maintenance",
		"When moving the machine, do not tilt or turn it upside down. Otherwise, the inside of the machine may be contaminated by toner, which can cause damage to the machine or reduce print quality.",
		"When moving the machine, make sure at least two people are holding the machine securely. "
	],
	"0_0|33_3": [
		"Troubleshooting",
		" > ",
		"Basic",
		"This chapter gives helpful information for what to do if you encounter an error.",
		"Tips for avoiding paper jams",
		"Clearing paper jams",
		"Understanding the status LED",
		"Understanding display messages",
		"This chapter gives helpful information for what to do if you encounter an error. If your machine has a display screen, check the message on the display screen first to solve the error.If you cannot find a solution to your problem in this chapter, refer to the ",
		" chapter in the ",
		"Advanced Guide",
		" (see ",
		").If you cannot find a solution in the ",
		"User's Guide",
		" or the problem persists, call for service. "
	],
	"0_0|33_3|34_0": [
		"Tips for avoiding paper jams",
		" > ",
		"Basic",
		"Troubleshooting",
		"By selecting the correct medias, most paper jams can be avoided. To avoid paper jams, refer to the following guidelines:",
		"Ensure that the adjustable guides are positioned correctly (see ",
		"Tray overview",
		").",
		"Do not remove paper from the tray while your machine is printing.",
		"Flex, fan, and straighten paper before loading. ",
		"Do not use creased, damp, or highly curled paper.",
		"Do not mix papers in a tray.",
		"Use only recommended print media (see ",
		"Print media specifications ",
		"Perforated or embossed paper does not separate easily. Flex the sheets back and forth to loosen them, and fan them. ",
		"Feed single paper from tray if there are multi-feeds or paper jams.",
		"Grain refers to the alignment of the paper fibers in a sheet of paper. Grain long paper is recommended.",
		"Do not use rough-edged paper."
	],
	"0_0|33_3|35_1": [
		"Clearing paper jams",
		" > ",
		"Basic",
		"Troubleshooting",
		"To avoid tearing the document, remove the jammed document slowly and carefully.",
		"To prevent document jams, use the scanner glass for thick, thin or mixed paper- originals.",
		"In tray",
		"Illustrations on this user’s guide may differ from your machine depending on its options or models. Check your machine type (see ",
		"Front view",
		").",
		"Inside the machine",
		"The fuser area is hot. Take care when removing paper from the machine.",
		"In exit area"
	],
	"0_0|33_3|36_2": [
		"Understanding the status LED",
		" > ",
		"Basic",
		"Troubleshooting",
		"The color of the LED indicates the machine's current status.",
		"Some LEDs may not be available depending on model or country (see ",
		"Control panel overview",
		").",
		"To resolve the error, look at the error message and its instructions from the troubleshooting part (see ",
		"Understanding display messages",
		"You also can resolve the error with the guideline from the computer’s ",
		"Lenovo Printing Status",
		" window (see ",
		"Using ",
		"Lenovo Printer Status",
		"If the problem persists, call a service representative.",
		"LED",
		"Status",
		"Description",
		"Off",
		"The machine is off-line.",
		"Blue",
		"Blinking",
		"When the backlight blinks, the machine is receiving or printing data.",
		"On",
		"The machine is on-line and can be used.",
		"Orange",
		"A minor error has occurred and the machine is waiting for the error to be cleared. Check the display message. When the problem is cleared, the machine resumes.",
		"Small amount of toner is left in the cartridge. The estimated cartridge life",
		"[a]",
		" of toner is close. Prepare a new cartridge for replacement. You may temporarily increase the printing quality by redistributing the toner (see ",
		"Redistributing toner",
		"[b]",
		"A toner cartridge has almost reached its estimated cartridge life",
		". It is recommended to replace the toner cartridge (see ",
		"Replacing the toner cartridge",
		"The cover is opened. Close the cover.",
		"There is no paper in the tray when receiving or printing data. Load paper in the tray. ",
		"The machine has stopped due to a major error. Check the display message (see ",
		"). ",
		"A paper jam has occurred (see ",
		"Clearing paper jams",
		"Wireless",
		"The machine is connecting to a wireless network.",
		"The machine is connected to a wireless network (see ",
		"Wireless network setup",
		"The machine is disconnected from a wireless network.",
		"Power/Wake Up",
		" (",
		")",
		"The machine is in power save mode.",
		"The machine is in ready mode or machine’s power is off.",
		"Scan to",
		"Scan mode is on. ",
		"Switches between scan and copy mode. The ",
		" LED turns on scan mode and turns off on copy mode.",
		"Scan mode is off and copy mode is on.",
		"[a] ",
		"Estimated cartridge life means the expected or estimated toner cartridge life, which indicates the average capacity of print-outs and is designed pursuant to ISO/IEC 19798. The number of pages may be affected by operating environment, percentage of image area, printing interval, graphics, media and media size. Some amount of toner may remain in the cartridge even when orange LED is on and the printer stops printing.",
		"[b] "
	],
	"0_0|33_3|37_3": [
		"Understanding display messages",
		" > ",
		"Basic",
		"Troubleshooting",
		"Messages appear on the control panel display to indicate the machine’s status or errors. Refer to the tables below to understand the messages’ and their meaning, and correct the problem, if necessary.",
		"This function is not supported for the devices which has a control panel display. You can resolve the error with the guideline from the computer’s ",
		"Printing Status",
		" window (see ",
		"Using ",
		"Lenovo Printer Status",
		").",
		"If a message is not in the table, reboot the power and try the printing job again. If the problem persists, call a service representative.",
		"When you call for service, provide the service representative with the contents of display message.",
		"Some messages may not appear on the display depending on the options or models.",
		"[error number] indicates the error number. ",
		"[tray type] indicates the tray number. ",
		"[media type] indicates the media type.",
		"[media size] indicates the media size.",
		"[color] indicates the color of toner.",
		"Paper Jam-related messages",
		"Message",
		"Meaning",
		"Suggested solutions",
		"Paper Jam",
		"inside machine",
		"Paper has jammed inside the machine.",
		"Clear the jam (see ",
		"Inside the machine",
		"in tray",
		"Paper has jammed in the paper tray.",
		"Clearing paper jams",
		"in exit area",
		"Paper has jammed in the exit area.",
		"In exit area",
		"Paper Empty",
		"There is no paper in tray.",
		"Load paper in tray (see ",
		"Loading paper in the tray",
		"Toner-related messages",
		"Install Toner",
		"A toner cartridge is not installed.",
		"Install a toner cartridge.",
		"Not Compatible",
		"[color]",
		"toner",
		"The toner cartridge is not suitable for your machine. ",
		"Install the corresponding toner cartridge with a Lenovo-genuine cartridge.",
		"Prepare",
		"Toner",
		"Small amount of toner is left in the indicated cartridge. The estimated cartridge life of toner is close.",
		"Prepare a new cartridge for a replacement. You may temporarily increase the printing quality by redistributing the toner (see ",
		"Redistributing toner",
		"Replace Toner",
		"The indicated toner cartridge has almost reached its estimated cartridge life. ",
		"[a]",
		"You can choose ",
		"Stop",
		" or ",
		"Continue",
		" as shown on the control panel. If you select ",
		", the printer stops printing and you cannot print any more without changing the cartridge. If you select ",
		", the printer keeps printing but the printing quality cannot be guaranteed. Besides, it can cause serious damage to your machine.",
		"Replace the toner cartridge for the best print quality when this message appears. Using a cartridge beyond this stage can result in printing quality issues (see ",
		"Replacing the toner cartridge",
		"The indicated toner cartridge has reached its estimated cartridge life.",
		" The machine might stop printing.",
		"Replace the toner cartridge (see ",
		"[a] ",
		"Estimated cartridge life means the expected or estimated toner cartridge life, which indicates the average capacity of print-outs and is designed pursuant to ISO/IEC 19798 (see ",
		"Available supplies",
		"). The number of pages may be affected by operating environment, percentage of image area, printing interval, media, percentage of image area, and media size. Some amount of toner may remain in the cartridge even when replace new cartridge appears and the machine stops printing.",
		"Lenovo",
		" does not recommend using a non-genuine ",
		" toner cartridge such as refilled or remanufactured. ",
		" cannot guarantee a non-genuine Lenovo toner cartridge's quality. Service or repair required as a result of using non-genuine ",
		" toner cartridges will not be covered under the machine warranty.",
		"Tray-related messages",
		"Tray ",
		"Paper Mismatch",
		"The paper size specified in the printer properties does not match the paper you are loading.",
		"Load the correct paper in the tray.",
		"Network-related messages",
		"Fail connection",
		"to WPS",
		"The machine failed to connect via WPS.",
		"Check the WPS settings (see ",
		"Using the WPS Settings menu ",
		"Install",
		"wireless NIC",
		"There is a problem on the network interface.",
		"Turn the power switch off and on. If the problem persists, call for service.",
		"Network Problem: ",
		"IP Conflict",
		"The network IP address you have set is being used by someone else. ",
		"Check the IP address and reset it if necessary (see ",
		"Printing a network configuration report",
		"Not found",
		"Wireless network",
		"The machine cannot find the wireless network.",
		"Check the status of the wireless router or access point, including its configuration and power connections, as well as any devices that may affect wireless communication. If the problem persists, please call for service.",
		"Not Correct",
		"Wireless setting",
		"The wireless network options are configured incorrectly for the security method.",
		"The password entered in the wireless security options is incorrect.",
		"The machine does not support the security method used by the access point or wireless router.",
		"The access point or wireless router has malfunctioned.",
		"Reconfigure the wireless options in the machine, SWS, access point, or wireless router. The WPA2-PSK/AES security method is recommended. If the problem persists, please call for service.",
		"Not connect",
		"Wireless AP",
		"The machine failed to connect to the wireless AP(access point or wireless router).",
		"Check the status of the access point, including its configuration and power connections, as well as any devices that may affect wireless communication. If the problem persists, please call for service.",
		"Wi-Fi Direct",
		"is not ready",
		"The machine failed to initialize the Wi-Fi Direct connection.",
		"Reboot the machine to initialize the wireless settings. If the problem persists, please call for service.",
		"is not connect",
		"The machine failed to connect via Wi-Fi Direct.",
		"Turn the Wi-Fi Direct feature off and then back on or reboot the machine or mobile device. If the problem persists, please call for service.",
		"Misc. messages\t",
		"Door Open",
		"Close it",
		"The cover is not securely latched.",
		"Close the cover until it locks into place. ",
		"Door of scanner",
		"is open",
		"The cover of scanner is not securely latched.",
		"Error",
		": [error number]",
		"Call for Service",
		"There is a problem in the system.",
		"Reboot the power. If the problem persists, please call for service.",
		"Door open/close",
		"The imaging unit is installed improperly, or the cover is not securely latched.",
		"Reinstall the imaging unit to confirm it is seated properly. Close the cover until it locks into place.",
		"Turn off then on",
		"The machine unit cannot be controlled.",
		"Reboot the power and try the printing job again. If the problem persists, please call for service. ",
		"ID Control Fail",
		"Check CTD Sensor",
		" There is a problem in the CTD sensor.",
		"Output bin Full",
		"Remove paper",
		"The output tray is full. Or the sensor is not facing down.",
		"Remove papers from the output tray, the machine resumes printing. Or make sure the sensor is facing down. If the problem persists, call for service.",
		"Fuser Soon",
		"The life of the fuser unit will be expired soon.",
		"Prepare the fuser unit with a new one. Contact the service representatives.",
		"Prepare new",
		"Imaging unit",
		"The life of the imaging unit will be expired soon.",
		"Replace the imaging unit with a new one. Contact the service representatives.",
		"Transfer belt",
		"The life of the transfer belt will expired soon.",
		"Replace the transfer belt with a new one. Contact the service representatives.",
		"transfer roller",
		"Replace new",
		"Fuser unit",
		"The life of the fuser unit will be expired.",
		"Replace the fuser unit with a new one. Contact the service representatives.",
		"Replace with",
		"new imaging unit",
		"The life of the imaging unit will be expired.",
		"The life of the transfer belt has expired.",
		"Replace/Install",
		"Waste Toner Tank",
		"The life span of the waste toner container has expired and the printer will stop printing until a new waste toner container is placed into the printer.",
		"Replace a waste toner container with a Lenovo-genuine waste toner container.",
		"Scanner Locked",
		"The scanner is locked.",
		"Transfer Belt",
		"The transfer belt cannot be controlled.",
		"Reboot the power and try the printing job again. If the problem persists, please call for service."
	],
	"0_0|38_4": [
		"Appendix",
		" > ",
		"Basic",
		"This chapter provides product specifications and information concerning applicable regulations.",
		"Specifications",
		"Regulatory information",
		"To create a better environment",
		"Statement"
	],
	"0_0|38_4|39_0": [
		"Specifications",
		" > ",
		"Basic",
		"Appendix",
		"General specifications",
		"These specifications are subject to change without notice. To see additional specifications and information about changes to the specifications, please visit ",
		"www.lenovoimage.com",
		".",
		"Items",
		"Description",
		"Dimension",
		"[a]",
		"Width x Length x Height",
		"406 x 362 x 288.6 mm (16 x 14.3 x 11.4 inches) ",
		"Weight",
		"Machine with consumables",
		"12.89 Kg (28.42 lbs)",
		"Noise Level",
		"[b]",
		"[c]",
		"Ready mode",
		"Background noise level",
		"Print mode",
		"Color printing",
		"Less than 46 dB (A)",
		"Black and white printing",
		"Less than 48 dB (A)",
		"Copy mode",
		"Scanner glass",
		"Less than 52 dB (A)",
		"Scan mode",
		"Less than 51 dB (A)",
		"Temperature",
		"Operation",
		"10 to 30°C (50 to 86°F)",
		"Storage (packed)",
		"-20 to 40°C (-4 to 104°F)",
		"Humidity",
		"20 to 80% RH",
		"10 to 90% RH",
		"Power rating",
		"[d]",
		"110 volt models",
		"AC 110 - 127 V",
		"220 volt models",
		"AC 220 - 240 V",
		"Power consumption ",
		"[e]",
		"Average operating mode",
		"Less than 290 W",
		"Less than 60 W",
		"Power save mode ",
		"Less than 1.5 W",
		"Power off mode ",
		"[f]",
		"Less than 0.45 W",
		"Network Standby Mode (All Port Activation)",
		"Less than 1.30 W",
		"Wireless",
		"[g]",
		"Module",
		"SPW-B43143S",
		"[a] ",
		"Dimensions and weight are measured without other accessories.",
		"[b] ",
		"Sound Pressure Level, ISO 7779. Configuration tested: basic machine installation, A4 paper, simplex printing.",
		"[c] ",
		"China only: If the equipment's noise is louder than 63 db (A), the equipment should be placed in region of relatively independent advice.",
		"[d] ",
		"See the rating label on the machine for the correct voltage (V), frequency (hertz) and of current (A) for your machine.",
		"[e] ",
		"The power consumption may be affected by the machine’s status, setting conditions, operating environment, and measuring equipment and method the country uses.",
		"[f] ",
		"Power consumption can be completely avoided only when the power cable is not connected.",
		"[g] ",
		"Wireless models only (see ",
		"Features by model",
		").",
		"Print media specifications ",
		"Type",
		"Size",
		"Dimensions",
		"Print media weight/Capacity",
		"Tray",
		"Plain paper",
		"Letter",
		"216 x 279 mm (8.5 x 11 inches)",
		"60 to 85 g/m",
		"2",
		" (16 to 23 lbs bond) ",
		"150 sheets of 75 g/m",
		" (20 lbs bond)",
		"Maximum stack height : 15.5mm (0.6 inches)",
		"Legal",
		"216 x 356 mm (8.5 x 14 inches)",
		"US Folio",
		"216 x 330 mm (8.5 x 13 inches)",
		"A4",
		"210 x 297 mm (8.27 x 11.69 inches)",
		"Oficio",
		"216 x 343 mm (8.5 x 13.5 inches)",
		"JIS B5",
		"182 x 257 mm (7.17 x 10.12 inches)",
		"ISO B5",
		"176 x 250 mm (6.93 x 9.84 inches) ",
		"Executive",
		"184 x 267 mm (7.25 x 10.5 inches)",
		"A5",
		"148 x 210 mm (5.83 x 8.27 inches)",
		"A6",
		"105 x 148 mm (4.13 x 5.83 inches)",
		"Thick paper",
		"Refer to the Plain paper section ",
		"86 to 120 g/m",
		" (23 to 32lbs bond)",
		"5 sheets",
		"Thin paper",
		"60 to 70 g/m",
		" (16 to 19 lbs bond)",
		"150 sheets of 60 g/m",
		" (16 lbs bond)",
		"Cotton",
		"75 to 90 g/m",
		" (20 to 24 lbs bond)",
		"Colored, ",
		"Pre-printed, ",
		"60 to 85 g/m",
		" (16 to 24 lbs bond)",
		"Recycled",
		"Labels",
		"Letter, Legal, Oficio, US Folio, A4, JIS B5, ISO B5, Executive, A5",
		"Refer to the Plain paper section",
		"120 to 150 g/m",
		" (32 to 40 lbs bond)",
		"5 sheets ",
		"Card stock",
		"Letter, Legal, Oficio, US Folio, A4, JIS B5, ISO B5, Executive, A5,",
		"Postcard 4x6",
		"121 to 163 g/m",
		" (32 to 43 lbs bond)",
		"Bond paper",
		"105 to 120 g/m",
		" (28 to 32 lbs bond)",
		"10 sheets",
		"Archive",
		"70 to 90 g/m",
		" (18.6 to 24 lbs bond)",
		"100 sheets",
		"Glossy Photo, ",
		"Matte Photo",
		"Letter, A4,",
		"111 to 220 g/m",
		" (30 to 58 lbs bond)",
		"1 sheets",
		"Minimum size (custom)",
		"105 x 148.5 mm (4.13 x 5.85 inches)",
		"60 to 120 g/m",
		" (16 to 32 lbs bond)",
		"Maximum size (custom)",
		"Maximum capacity may differ depending on media weight, thickness, and environmental conditions. ",
		"The smoothness of the labels used in this machine is 100 to 250 (sheffield). This means the numeric level of smoothness.",
		"If media weight is over 120 g/m",
		" (32 lbs bond), load a paper into the tray one by one.",
		"System requirements",
		"Microsoft",
		"® Windows",
		"®",
		"Operating system",
		"Requirement (recommended)",
		"CPU",
		"RAM",
		"free HDD space",
		"Windows",
		"® XP Service Pack 3",
		"Intel",
		"® Pentium",
		"® III 1 GHz (Pentium IV 2 GHz)",
		"512 MB (1 GB)",
		"1.5 GB",
		"Windows Server",
		"® 2003",
		"® 2008",
		"® IV 1 GHz (Pentium IV 2 GHz)",
		"512 MB (2 GB)",
		"10 GB",
		"Windows Vista",
		"® IV 3 GHz",
		"15 GB",
		"® 7",
		"® IV 1 GHz 32-bit or 64-bit processor or higher",
		"1 GB (2 GB)",
		"16 GB",
		"Support for DirectX",
		"® 9 graphics with 128 MB memory (to enable the Aero theme).",
		"DVD-R/W Drive",
		"® 2008 R2",
		"® IV 1 GHz (x86) or 1.4 GHz (x64) processors (2 GHz or faster)",
		"® 8",
		"® 8.1",
		"® 10",
		"® 2016",
		"2 GB (2 GB)",
		"20 GB",
		"® 2012",
		"® 2012 R2",
		"® IV 1.4 GHz (x64) processors (2 GHz or faster)",
		"32 GB",
		"Internet Explorer 6.0 or higher is the minimum requirement for all Windows operating systems.",
		"Users who have administrator rights can install the software.",
		"Windows Terminal Services",
		" is compatible with your machine.",
		"Mac",
		"Requirements (Recommended)",
		"Free HDD space",
		"Mac OS X 10.9 - 10.13",
		"® processors",
		"2 GB",
		"4 GB",
		"Linux",
		"Requirements",
		"Red Hat Enterprise Linux 5, 6, 7",
		"Fedora 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26",
		"OpenSUSE 11.2, 11.4, 12.1, 121.2, 12.3, 13.1, 13.2, 42.1",
		"Ubuntu 11.10, 12.04, 12.10, 13.04, 13.10, 14.04, 14.10, 15.04, 15.10, 16.04, 16.10, 17.04 ",
		"SUSE Linux Enterprise Desktop 10, 11, 12",
		"Debian 6, 7, 8, 9",
		"Mint 15, 16, 17, 18 ",
		"Pentium IV 2.4 GHz (Intel Core™ 2)"
	],
	"0_0|38_4|40_1": [
		"Regulatory information",
		" > ",
		"Basic",
		"Appendix",
		"This machine is designed for a normal work environment and certified with several regulatory statements.",
		"Laser safety statement",
		"The printer is certified in the U.S. to conform to the requirements of DHHS 21 CFR, chapter 1 Subchapter J for Class I(1) laser products, and elsewhere is certified as a Class I laser product conforming to the requirements of IEC/EN 60825-1:2014.",
		"Class I laser products are not considered to be hazardous. The laser system and printer are designed so there is never any human access to laser radiation above a Class I level during normal operation, user maintenance or prescribed service condition.",
		"Warning ",
		"Never operate or service the printer with the protective cover removed from laser/scanner assembly. The reflected beam, although invisible, can damage your eyes.",
		"When using this product, these basic safety precautions should always be followed to reduce risk of fire, electric shock, and injury to persons:",
		"Below the warning label of Laser is attached on LSU cover.",
		"For 110 volt models , “",
		"This product complies with 21 CFR Chapter 1, subchapter J.",
		"” is written on the label of rear cover. And for 220 volt models, below image is applied on the label of rear cover.",
		"Ozone safety",
		"This product’s ozone emission rate is under 0.1 ppm. Because ozone is heavier than air, keep the product in a place with good ventilation.",
		"Recycling",
		"Recycle or dispose of the packaging material for this product in an environmentally responsible manner.",
		"China only"
	],
	"0_0|38_4|41_2": [
		"To create a better environment",
		" > ",
		"Basic",
		"Appendix",
		"Please cooperate Firstly, thank you very much indeed for using our ",
		"Lenovo",
		" products! ",
		"Lenovo ",
		"focuses on the earth environment concerned. And make a basic policy which is to concern about the earth environment, including any workflow from product development to discard. The local citizen should be responsible for local society and its environment during these environment protection activities. Therefore, we hope you'll take part in this environment plan, and pay attention to environment protection points as below while discarding used consumables.",
		"Please deliver the used package materials to relevant waste disposal office for recycle.",
		"When you discard used consumables, please follow and carry on relevant local regulations properly. If you have questions, call your local sales dealer.",
		"When the machine need replacing parts for the maintenance and repair, please discard used circuit boards, used electrical parts and products as disposed electrical materials.",
		"The power consumption is 0 W after you turn off the machine and unplug it from the AC outlet.",
		"Some parts in the machine can be used on the same series model machines which produced by the same factory.",
		"If you want to replace the parts, please contact your local ",
		"repair station.",
		"China environmental labelling notice",
		"Machines with an LwAd > 63.0 dB(A) are recommended to be set up in separate rooms due to their noise emissions.",
		"The machine can use recycled paper.",
		"Ensure that during use the machine is used in a well ventilated area.",
		"will accept machines and consumables for recycling. For details of the return scheme please refer to the webpage.  ",
		"http://support1.lenovo.com.cn/lenovo/wsi/activity/551.htm"
	],
	"0_0|38_4|42_3": [
		"Statement",
		" > ",
		"Basic",
		"Appendix",
		"Welcome to ",
		"Lenovo",
		" products.",
		"Please read carefully all the materials accompanying the machine before installing and using this product for the first time. It will help you make better use of the product. If you fail to operate the product in accordance with the instructions and requirements provided in this manual or mishandle the product due to misunderstanding or other causes, Lenovo Image(Tianjin) Limited shall not be responsible for any losses arising our thereof, except for the loss resulting from improper installation or caused during the process of operation by professional maintenance personnel from ",
		". Lenovo Image(Tianjin) Limited has conducted a strict and careful collation of the manual. However, we cannot guarantee that the manual is completely free of any error or omission.Lenovo Image(Tianjin) Limited is committed to continuously improve product usage and service quality. Accordingly, it reserves the right to make changes to any product or software program described in the manual and information contained herein without prior notice. The manual is intended to help you use ",
		" products in a correct way, which does not represent any description of software or hardware configuration for the product. In relation to product configuration, please refer to relevant contact (if any) and packing list or consult with the distributor who delivered the product to you. Pictures contained in the manual are for reference only. In case of inconsistency between particular pictures and actual display of the product, please follow the actual display of the product. ©2018 Lenovo Image(Tianjin) Technology Co., Ltd.  All right reserved. This manual is protected by copyright laws and regulations. Without prior written authorization from Lenovo Image(Tianjin) Limited, you shall not reproduce or copy the manual in any way, or transmit the manual via any wireline or wireless network in any form, or translate the manual into any language.",
		" Lenovo",
		", ",
		" 联想 , 联想 , and other ",
		" markings or identification are either trademarks or registered trademarks in Chinese Mainland and/or other countries/territories of Lenovo Image(Tianjin) Limited or its affiliates. Other names and products mentioned herein may be the registered trademarks or trademarks of ",
		" or other companies. If you find any inconsistency between product reality and this manual during the operational process or would like to obtain the latest information or have any problems or suggestions, please contact or log onto: Technical consulting: 400-810-1234, If there is no 400 service please dial 010-58511600. Lenovo website: ",
		"http://www.lenovoimage.com ",
		" Image(Tianjin) Technology Co., Ltd.  All right reserved.",
		"Address: No.6 Chuang Ye Road Shangdi Information Industy Base",
		"Haidian District, Beijing, China",
		"Post Code:100085",
		"Website:",
		"www.lenovoimage.com",
		"Version: 1.00 ",
		"Copyright© 2018 Lenovo Image(Tianjin) Technology Co., Ltd.  All right reserved.",
		"Refer to the '",
		"LICENSE.txt",
		"' file in the provided CD-ROM for the open source license information. "
	],
	"43_1": [
		"Advanced",
		" > ",
		"User’s Guide",
		"This guide provides information about installation, advanced configuration, operation and troubleshooting on various OS environments. ",
		"Some features may not be available depending on models or countries.",
		"Basic",
		"This guide provides information concerning installation, basic operation and troubleshooting on windows.",
		"Table of Contents",
		"Software Installation",
		"Installation for Mac",
		"Reinstallation for Mac",
		"Installation for Linux",
		"Reinstallation for Linux",
		"Using a Network-Connected Machine",
		"Useful network programs",
		"Wired network setup",
		"Installing driver over the network",
		"Wireless network setup",
		"Useful Setting Menus",
		"Before you begin reading a chapter",
		"Print",
		"Copy",
		"Scan",
		"System setup",
		"Network setup",
		"Special Features",
		"Altitude adjustment",
		"Printing features",
		"Scan features",
		"Useful Management Tools",
		"Accessing management tools",
		"Using ",
		"Embedded Web Server",
		"Using Lenovo Easy Printer Manager ",
		"Lenovo Easy Document Creator",
		"Lenovo Printer Status",
		"Troubleshooting",
		"Paper feeding problems",
		"Power and cable connecting problems",
		"Printing problems",
		"Printing quality problems",
		"Copying problems",
		"Scanning problems",
		"Operating system problems"
	],
	"43_1|44_0": [
		"Software Installation",
		" > ",
		"Advanced",
		"This chapter provides instructions for installing essential and helpful software for use in an environment where the machine is connected via a cable. A locally connected machine is a machine directly attached to your computer using a USB cable. If your machine is attached to a network, skip the following steps below and go on to installing a network connected machine’s driver (see ",
		"Installing driver over the network",
		").",
		"Installation for Mac",
		"Reinstallation for Mac",
		"Installation for Linux",
		"Reinstallation for Linux",
		"If you are a Windows OS user, refer to the Basic Guide for installing the machine’s driver (see ",
		"Installing the driver locally",
		"Only use a USB cable no longer then 3 meter (118 inches)."
	],
	"43_1|44_0|45_0": [
		"Installation for Mac",
		" > ",
		"Advanced",
		"Software Installation",
		"You need to download Mac software packages from the ",
		"Lenovo",
		" website to install the printer software (",
		"www.lenovoimage.com",
		").",
		"Make sure that the machine is connected to your computer and powered on.",
		"Download the software that you from the ",
		" website then unpack (",
		"Turn on the machine.",
		"Double-click the unpacked folder.",
		"Select the setup file you want to install the software.",
		"Makes software setup files in unpacked folder. The software setup file format is ",
		".pkg",
		".",
		"For example:",
		"Printer Driver.pkg",
		", ",
		"Printer Manager.pkg",
		"Follow the instructions in the installation window."
	],
	"43_1|44_0|46_1": [
		"Reinstallation for Mac",
		" > ",
		"Advanced",
		"Software Installation",
		"If the printer driver does not work properly, uninstall the driver and reinstall it.",
		"Open the ",
		"Applications",
		" folder > ",
		"Lenovo",
		"Printer Software Uninstaller",
		".",
		"To uninstall printer software, click ",
		"Continue",
		"Check the program you want to delete and click ",
		"Uninstall",
		"Enter the password and click ",
		"OK",
		"After the uninstallation is finished, click ",
		"Close",
		"If a machine has already been added, delete it from the ",
		"Print Setup Utility",
		" or ",
		"Print & Fax"
	],
	"43_1|44_0|47_2": [
		"Installation for Linux",
		" > ",
		"Advanced",
		"Software Installation",
		"You need to download Linux software packages from the ",
		"Lenovo",
		" website to install the printer software (",
		"www.lenovoimage.com",
		").",
		"Installing the Unified Linux Driver",
		"You must log in as a super user (root) to install the machine software. If you are not a super user, ask your system administrator.",
		"Make sure that the machine is connected to your computer and powered on.",
		"Copy ",
		"Unified Linux Driver",
		" package to your system.",
		" Open Terminal program and go to the folder that you copied the package to.",
		"Extract the package.",
		"Move to ",
		"uld",
		" folder.",
		"Execute \"./",
		"install.sh",
		"\" command (If you're not logged in as root, execute the command with \"",
		"sudo",
		"\" as \"",
		"sudo ./install.sh",
		"\")",
		" Proceed with installation.",
		"When installation finished, launch printing utility(Go to ",
		"System",
		"Administration",
		"Printing",
		" or execute \"",
		"system-config-printer",
		"\" command in Terminal program).",
		"Click ",
		"Add",
		" button.",
		"Select your printer.",
		"Forward",
		" button and add it to your system."
	],
	"43_1|44_0|48_3": [
		"Reinstallation for Linux",
		" > ",
		"Advanced",
		"Software Installation",
		"If the printer driver does not work properly, uninstall the driver and reinstall it.",
		" Open ",
		"Terminal",
		" program.",
		"Move to ",
		"uld",
		" folder extracted from ",
		"Unified Linux Driver",
		" package.",
		"Execute \"./",
		"uninstall.sh",
		"\" command (If you're not logged in as root, execute the command with \"",
		"sudo",
		"\" as \"",
		"sudo ./uninstall.sh",
		"\")",
		"Proceed with uninstallation."
	],
	"43_1|49_1": [
		"Using a Network-Connected Machine",
		" > ",
		"Advanced",
		"This chapter gives you step-by-step instructions for setting up a network connected machine and software.",
		"Useful network programs",
		"Wired network setup",
		"Installing driver over the network",
		"Wireless network setup",
		"Supported optional devices and features may differ according to your model (see ",
		"Features by model",
		")."
	],
	"43_1|49_1|50_0": [
		"Useful network programs",
		" > ",
		"Advanced",
		"Using a Network-Connected Machine",
		"There are several programs available to setup the network settings easily in a network environment. For the network administrator especially, managing several machines on the network is possible. ",
		"Before using the programs below, set the IP address first. ",
		"Some features and optional goods may not be available depending on model or country (see ",
		"Features by model",
		").",
		"Embedded Web Server",
		"The web server embedded on your network machine allows you to do the following tasks (see ",
		"Using ",
		"Check the supplies information and status.",
		"Customize machine settings.",
		"Set the email notification option. When you set this option, the machine status (toner cartridge shortage or machine error) will be sent to a certain person's email automatically.",
		"Configure the network parameters necessary for the machine to connect to various network environments.",
		"SetIP ",
		"wired network setup",
		"This utility program allows you to select a network interface and manually configure the IP addresses for use with the TCP/IP protocol.",
		"If your device does not support a network connection, it will not be able to use this feature (see ",
		"Rear view",
		"TCP/IPv6 is not supported by this program."
	],
	"43_1|49_1|51_1": [
		"Wired network setup",
		" > ",
		"Advanced",
		"Using a Network-Connected Machine",
		"Printing a network configuration report",
		"You can print ",
		"Network Configuration Report",
		" from the machine’s control panel that will show the current machine’s network settings. This will help you to set up a network.",
		"Press the ",
		" (",
		"Menu",
		") button on the control panel and select ",
		"Network",
		"Network Conf.",
		" .",
		"Using this ",
		", you can find your machine’s MAC address and IP address.",
		"For example:",
		"MAC Address: 00:15:99:41:A2:78",
		"IP Address: 169.254.192.192",
		"Setting IP address",
		"First, you have to set up an IP address for network printing and managements. In most cases a new IP address will be automatically assigned by a DHCP (Dynamic Host Configuration Protocol) server located on the network.",
		"IPv4 configuration",
		"You can also set the TCP/IPv4 from ",
		"Embedded Web Server",
		". When the ",
		" window opens, move the mouse cursor over the ",
		"Settings",
		" of the top menu bar and then click ",
		"Network Settings",
		" tab",
		").",
		"If you have a DHCPv4 server on your network, you can set one of the following options for default dynamic host configuration.",
		"Select ",
		")> ",
		"TCP/IP (IPv4)",
		"DHCP",
		" on the control panel.",
		"Press ",
		"OK",
		" to select the required value you want.",
		"IPv6 configuration",
		"IPv6",
		" is supported properly only in Windows Vista or higher.",
		"You can also set the TCP/IPv6 from ",
		"The machine supports the following IPv6 addresses for network printing and managements.",
		"Link-local Address",
		": Self-configured local IPv6 address (Address starts with FE80).",
		"Stateless Address",
		": Automatically configured IPv6 address by a network router.",
		"Stateful Address",
		": IPv6 address configured by a DHCPv6 server.",
		"Manual Address",
		": Manually configured IPv6 address by a user.",
		"In the IPv6 network environment, follow the next procedure to use the IPv6 address.",
		"Activating IPv6",
		") button on the control panel.",
		"TCP/IP (IPv6)",
		"IPv6 Protocol",
		"On",
		" and press ",
		".",
		"Turn the machine off and turn it on again.",
		"When you install the printer driver, do not configure both IPv4 and IPv6. We recommend to configure either IPv4 or IPv6 (see ",
		"Installing driver over the network",
		"DHCPv6 address configuration",
		"If you have a DHCPv6 server on your network, you can set one of the following options for default dynamic host configuration.",
		"DHCPv6 Config"
	],
	"43_1|49_1|52_2": [
		"Installing driver over the network",
		" > ",
		"Advanced",
		"Using a Network-Connected Machine",
		"Some features and optional goods may not be available depending on model or country (see ",
		"Features by model",
		").",
		"The machine that does not support the network interface, it will not be able to use this feature (see ",
		"Rear view",
		"You can install the printer driver and software when you insert the software CD into your CD-ROM drive.For windows, select the printer driver and software in the ",
		"Select Software to Install",
		" window.",
		"Windows",
		"The firewall software might be blocking network communication. Before connecting the device to the network, disable the computer’s firewall.",
		"Make sure that the machine is connected to the network and powered on. Also, your machine’s IP address should have been set (see ",
		"Setting IP address",
		").\t",
		"Insert the supplied software CD into your CD-ROM drive.",
		"If the installation window does not appear, click ",
		"Start",
		"All programs",
		"Accessories",
		"Run",
		".",
		" X:\\",
		"Setup.exe",
		" replacing “X” with the letter, which represents your CD-ROM drive and click ",
		"OK",
		"For Windows 8,",
		"If the installation window does not appear, from ",
		"Charms",
		", select ",
		"Search",
		"Apps ",
		"and search for ",
		". Type in X:\\Setup.exe, replacing “X” with the letter that represents your CD-ROM drive and click ",
		"If “",
		"Tap to choose what happens with this disc",
		".” pop-up window appears, click the window and select ",
		"Run Setup.exe",
		"For Windows 10 / Windows Server 2016",
		"If the installation window does not appear, type in X:\\",
		" in ",
		" input area from task bar, replacing “X” with the letter that represents your CD-ROM drive and press the Enter key.",
		"Review and accept the installation agreements in the installation window. Then, click ",
		"Next",
		"Select ",
		"New Printer",
		" on the ",
		"Printer Setup Type",
		" screen. Then, click ",
		"Network",
		"Printer Connection Type",
		" screen Then,click ",
		"Follow the instructions in the installation window.",
		"From the Windows 8 ",
		" Screen",
		"The V4 driver is automatically downloaded from the Windows Update if your computer is connected to the Internet. If not, you can manually download the V4 driver from ",
		"Lenovo",
		" website, ",
		"www.lenovoimage.com",
		". ",
		"If you install the driver using the supplied software CD, V4 driver is not installed. If you want to use the V4 driver in the ",
		"Desktop",
		" screen, you can download from the ",
		"If you want to install ",
		"’s printer management tools, you need to install them using the supplied software CD.",
		"). ",
		"From ",
		"Settings",
		"Change PC settings",
		"Devices",
		"From task bar, type in ",
		"Devices and Printers",
		" input area. Press the Enter key.",
		"OR",
		"From the ",
		" (",
		") icon, select ",
		"Click ",
		"Add a device",
		"Discovered machines will be shown on the screen. ",
		"Click the model name or host name you wish to use. ",
		"You can print a Network Configuration Report from the machine’s control panel that will show the current machine’s host name (see ",
		"Printing a network configuration report",
		"The driver is automatically installed from the ",
		"Windows Update",
		"Mac",
		"You need to download Mac software packages from the ",
		" website to install the printer software (",
		"Make sure that the machine is connected to your computer and powered on.",
		"Download printer driver software from the ",
		" website then unpack (",
		"Turn on the machine.",
		"Double-click the ",
		"PrinterDriver",
		"Mac_Installer",
		"Mac_Printer",
		"Printer Driver.pkg.",
		"When installation finished, click ",
		"System Preferences",
		"Printer & Scanners",
		" Click ",
		"Add Printer",
		"(",
		"+",
		") button to select your printer and add it to your printer list.",
		"IP",
		" and select ",
		"HP Jetdirect - Socket",
		" in Protocol.",
		"Enter the machine’s IP address in the ",
		"Address",
		" input field.",
		"Enter the queue name in the ",
		"Queue",
		" input field. If you cannot determine the queue name for your machine server, try using the default queue first.",
		"if Auto Select does not work properly, choose ",
		"Select Printer Software",
		" and your machine name in ",
		"Print Using",
		"Add",
		"After the installation is finished, click ",
		"Close",
		"Linux",
		"You need to download Linux software packages from the ",
		"www.lenovoimage.com)",
		"Make sure that the machine is connected to your network and powered on. Also, your machine’s IP address should have been set. ",
		"Copy ",
		"Unified Linux Driver",
		" package to your system.",
		"Open Terminal program and go to the folder that you copied thepackage to.",
		"Extract the package.",
		"Move to ",
		"uld",
		" folder.",
		"Execute ” ",
		"./install.sh",
		"“ command (If you are not logged in as root,execute the command with “",
		"sudo",
		"” as “",
		"sudo ./install.sh",
		"”).",
		"Proceed with installation.",
		"When installation finished, launch ",
		"Printing",
		" utility (Go to ",
		"System",
		"Administration",
		" or execute “",
		"system-config-printer",
		"“ command in Terminal program).",
		" button.",
		"AppSocket/HP JetDirect",
		" and enter your machine’s IP address.",
		"Forward",
		" button and add it to your system.",
		"Add a network printer",
		"Unified Driver Configurator",
		"Add Printer.",
		"The ",
		"Add printer wizard",
		" window opens. Click ",
		"Network printer",
		" and click the ",
		"The printer’s IP address and model name appears on list field.",
		"Select your machine and click ",
		"Enter the printer description and click ",
		"After the machine is added, click ",
		"Finish"
	],
	"43_1|49_1|53_3": [
		"Wireless network setup",
		" > ",
		"Advanced",
		"Using a Network-Connected Machine",
		"Wireless networking may not be available depending on the model (see ",
		"Features by model",
		").",
		"Wireless networks require higher security, so when an access point is first set up, a network name (SSID), the type of security used, and a Network Password are created for the network. Ask your network administrator about this information before proceeding with the machine installation.",
		"Introducing wireless set up methods",
		"You can set wireless settings either from the machine or the computer. Choose the setting method from the below table.",
		"Some wireless network installation types may not be available depending on the model or country.",
		"It is strongly recommended that you set the password on Access Points. If you do not set the password on Access Points, they might be exposed to illegal access from unknown machines including PCs, smart phones and printers. Refer to the Access Point user' guide for password settings.",
		"Set up method",
		"Connecting method",
		"Description & Reference",
		"With Access Point",
		"From the computer",
		"See ",
		"Setting up via USB cable",
		" for Window.",
		"Access point without a USB cable",
		" for Mac.",
		"See",
		"Using a network cable",
		".",
		"From the machine’s control panel",
		"Using the WPS Settings menu ",
		"Using the Wi-Fi Networks",
		"Wi-Fi Direct setup",
		"Setting the Wi-Fi Direct for mobile printing",
		"If your machine and access point (or wireless router) support Wi-Fi Protected Setup™ (WPS), then you can easily configure the wireless network settings through the ",
		"WPS Settings",
		" menu without the need for a computer.",
		"If you want to use the wireless network using the infrastructure mode, make sure that the network cable is disconnected from the machine. Using the ",
		"WPS (PBC)",
		" button or entering the PIN from the computer to connect to the access point (or wireless router) varies depending on the access point (or wireless router) you are using. Refer to the user's guide of the access point (or wireless router) you are using.",
		"When using the WPS button to set the wireless network, security settings may change. To prevent this, lock the WPS option for the current wireless security settings. The option name may differ depending on the access point (or wireless router) you are using.",
		"Items to prepare",
		"Check if the access point (or wireless router) supports Wi-Fi Protected Setup™ (WPS).",
		"Check if your machine supports Wi-Fi Protected Setup™ (WPS).",
		"Networked computer (PIN mode only)",
		"Choosing your type",
		"There are two methods available to connect your machine to a wireless network.",
		"The ",
		"Push Button Configuration (PBC) ",
		"method allows you to connect your machine to a wireless network by pressing both the ",
		" menu on the control panel of your machine and the WPS (PBC) button on a Wi-Fi Protected Setup™ WPS-enabled access point (or wireless router) respectively.",
		"Personal Identification Number (PIN) ",
		"method helps you connect your machine to a wireless network by entering the supplied PIN information on a Wi-Fi Protected Setup™ WPS-enabled access point (or wireless router).",
		"Connecting WPS",
		"Factory default in your machine is ",
		"PBC ",
		"mode, which is recommended for a typical wireless network environment.",
		"Connecting in PBC mode",
		"Press the ",
		" (",
		"Menu",
		") button on the control panel and select ",
		"Network",
		". ",
		"Press ",
		"Wi-Fi",
		"WPS",
		"PBC",
		" button on the access point (or wireless router).",
		"Follow the instruction on the display screen.",
		"The messages are displayed on the display screen.",
		"Connecting in PIN mode",
		"Network.",
		"PIN",
		"The eight-digit PIN appears on the display. ",
		"You need to enter the eight-digit PIN within two minutes on the computer that is connected to the access point (or wireless router).",
		"You need to enter the PIN from the computer to connect to the access point (or wireless router) varies depending on the access point (or wireless router) you are using. Refer to the user's guide of the access point (or wireless router) you are using.",
		"Before starting, you will need to know the network name (SSID) of your wireless network and the network key if it is encrypted. This information was set when the access point (or wireless router) was installed. If you do not know about your wireless environment, please ask the person who set up your network.",
		" from the display screen.",
		"Wi-Fi On/Off",
		" > ON.",
		"The machine will display a list of available networks from which to choose. After a network is chosen then printer will prompt for the corresponding security key.",
		"Select the Wi-Fi network option you want.",
		"Setup using Windows",
		"\tAccess point",
		"\tNetwork-connected computer",
		"\tSoftware CD that was provided with your machine",
		"\tA machine installed with a wireless network interface",
		"\tUSB cable",
		"Creating the infrastructure network",
		"Check whether the USB cable is connected to the machine.",
		"Turn on your computer, access point, and machine.",
		"Insert the supplied software CD into your CD-ROM drive.",
		"If the installation window does not appear, click ",
		"Start",
		"All programs",
		"Accessories",
		"Run",
		" X:\\",
		"Setup.exe",
		" replacing “X” with the letter, which represents your CD-ROM drive and click ",
		"OK",
		"For Windows 8,",
		"If the installation window does not appear, from ",
		"Charms",
		", select ",
		"Search",
		"Apps",
		" and search for ",
		". Type in X:\\Setup.exe, replacing “X” with the letter that represents your CD-ROM drive and click ",
		"If “",
		"Tap to choose what happens with this disc.",
		"” pop-up window appears, click the window and select ",
		"Run Setup.exe",
		"For Windows 10 / Windows Server 2016",
		"If the installation window does not appear, type in X:\\",
		" in ",
		" input area from task bar, replacing “X” with the letter that represents your CD-ROM drive and press the Enter key.",
		"Review and accept the installation agreements in the installation window. Then, click ",
		"Next",
		"Select ",
		"New Printer",
		" on the ",
		"Printer Setup Type",
		" screen. Then, click ",
		"Wireless",
		"Printer Connection Type",
		"On the ",
		"Are you setting up your printer for the first time?",
		" screen, select ",
		"Yes, I will set up my printer's wireless network.",
		" Then, click ",
		"If your printer is already connected on the network, select ",
		"No, my printer is already connected to my network.",
		"Using a USB cable",
		"Select the Wireless Setup Method",
		"After searching, the window shows the wireless network devices. Select the name (SSID) of the access point you want to use and click ",
		"If you cannot find the network name you want to choose, or if you want to set the wireless configuration manually, click ",
		"Advanced Setting",
		"Enter the wireless Network Name",
		": ",
		"Enter the SSID of the access point (SSID is case-sensitive).",
		"Operation Mode",
		"Infrastructure",
		"Authentication",
		"Select an authentication type.",
		"Open System",
		"Authentication is not used, and encryption may or may not be used, depending on the need for data security.",
		"Shared Key",
		"Authentication is used. A device that has a proper WEP key can access the network.",
		"WPA Personal",
		" or ",
		"WPA2 Personal",
		"Select this option to authenticate the print server based on a WPA Pre-Shared Key. This uses a shared secret key (generally called Pre Shared Key pass phrase), which is manually configured on the access point and each of its clients.",
		"Encryption",
		"Select the encryption (None, WEP64, WEP128, TKIP, AES).",
		"Network Password",
		"Enter the encryption network password value.",
		"Confirm Network Password",
		"Confirm the encryption network password value.",
		"WEP Key Index",
		"If you are using WEP Encryption, select the appropriate ",
		"The wireless network security window appears when the access point has security settings.",
		"Enter the Network Password of the access point (or router).",
		"If your printer supports Wi-Fi Direct, the following screen appears.",
		"Click ",
		"Wi-Fi Direct option appears on the screen only if your printer supports this feature.",
		"Can start to build Wi-Fi Direct by using ",
		"Lenovo Easy Printer Manager",
		" (see ",
		"Setting up Wi-Fi Direct",
		"Wi-Fi Direct Name",
		": The default Wi-Fi Direct Name is the model name and the maximum length is 22 characters.",
		"Password setting",
		" is the numeric string, and the size is 8 ~ 64 characters.",
		"When the wireless network set up is completed, disconnect the USB cable between the computer and machine. Click ",
		"Select the components to be installed.",
		"Follow the instructions in the installation window.",
		"WiFi-enabled PC running Windows 7 or higher and an access point (router)",
		"Software CD that was provided with your machine",
		"A machine installed with a wireless network interface",
		"While setting the wireless network, the machine uses PC's wireless LAN. You might not be able to connect to the Internet. ",
		"X:\\",
		"Apps ",
		"and search for ",
		"Tap to choose what happens with this disc",
		".” pop-up window appears, click the window and select ",
		"Wireless ",
		"on the ",
		"Are you setting up your printer for the first time? ",
		"screen, select ",
		"Yes, I will set up my printer's wireless network. ",
		"Then, click ",
		"No, my printer is already connected to my network",
		"Using a direct wireless connection ",
		"Select the Wireless Setup Method ",
		"screen. Then, click ",
		"Even if your computer is running Windows 7 or higher, you cannot use this feature if your PC does not support wireless network. Set the wireless network using a USB cable (see ",
		"If below screen appears, press the ",
		" (WPS) button from the control panel within 2 minutes.",
		"When the wireless network set up is completed, click ",
		"Setup using Mac",
		"You need to download Mac software packages from the ",
		"Lenovo",
		" website to install the printer software (",
		"www.lenovoimage.com",
		"Make sure that the machine is connected to your computer and powered on.",
		"Download printer driver software from the ",
		" website then unpack (",
		"Turn on the machine.",
		"Double-click the ",
		"PrinterDriver",
		"Mac_Installer",
		"Mac_Printer",
		"Printer Driver.pkg.",
		"If the installer asks you to allow access to the keychain, click ",
		"Deny",
		"If you clicked ",
		"Always Allow",
		" in this step, the ",
		"Select a wireless printer ",
		"window appears without asking for access to the keychain. If this occurs, click ",
		"Cancel",
		" in the ",
		"window.",
		", and then click ",
		"If the screen dose not appear, go to step 14.",
		"When you set the wireless configuration manually, click ",
		"Select this option to authenticate the print server based on the WPA Pre-Shared Key. This uses a shared secret key (generally called Pre Shared Key pass phrase) that is manually configured on the access point and each of its clients.",
		"Select the encryption. (None, WEP64, WEP128, TKIP, AES)",
		"Network Key",
		"Enter the encryption network key value.",
		"Confirm Network Key",
		"Confirm the encryption network key value.",
		"The wireless network security window appears when the access point has security enabled.",
		"Enter the Network Key of the access point (or router).",
		"The window showing the wireless network setting appears. Check the settings and click ",
		"You can start Wi-Fi Direct by using the control panel (see ",
		"Wireless Network Setting Complete",
		" window appears. Click ",
		"When the wireless network settings are completed, disconnect the USB cable between the computer and machine. Click ",
		"\tWiFi-enabled Mac running Mac OS 10.7 or higher and an access point (router)",
		"Read the license agreement and check installation agreement button.",
		" screen.",
		"Allow",
		"If the ",
		"Select a wireless printer",
		" window appears, select the printer named DIRECT-xxx.",
		"Press WPS button on your printer ",
		"screen appears, press the ",
		"When the wireless network set up is complete, follow the instructions in the installation window.",
		"See your network administrator, or the person that set up your wireless network, for information about your network configuration.",
		"Your machine is a network compatible machine. To enable your machine to work with your network, you will need to perform some configuration procedures.",
		"\tNetwork cable",
		"Printing a network configuration report",
		"You can identify the network settings of your machine by printing a network configuration report.",
		"IP setting",
		"This program is used to manually set the network IP address of your machine using its MAC address to communicate with the machine. The MAC address is the hardware serial number of the network interface and can be found in the ",
		"Network Configuration Report",
		"Configuring the machine’s wireless network",
		"Before starting you will need to know the network name (SSID) of your wireless network and the network key if it is encrypted. This information was set when the access point (or wireless router) was installed. If you do not know about your wireless environment, please ask the person who set up your network.",
		"To configure wireless parameters, you can use ",
		"Embedded Web Server",
		"Using Embedded Web Server",
		"Before starting wireless parameter configuration, check the cable connection status. ",
		"Check whether or not the network cable is connected to the machine. If not, connect the machine with a standard network cable.",
		"Start a web browser such as Internet Explorer, Safari, or Firefox and enter your machine’s new IP address in the browser window.",
		"For example,",
		"Login",
		" on the upper right of the ",
		" website.",
		"If it’s your first time logging into ",
		" you need to log-in as an administrator. Type in the below default ",
		"ID",
		" and ",
		"Password",
		". We recommend you to change the default password for security reasons.",
		"ID: ",
		"admin",
		"Password: ",
		"00000 ",
		"When the ",
		" window opens, click ",
		"Network Settings",
		"Wizard",
		"Select the one ",
		"Network Name(SSID)",
		" in the list.",
		"If the wireless security setting window appears, enter the registered password (network password) and click ",
		"The confirmation window appears, please check your wireless setup. If the setup is right, click ",
		"Apply",
		"Turning the Wi-Fi network on/off",
		"Check whether the network cable is connected to the machine. If not, connect the machine with a standard network cable.",
		"You can turn the Wi-Fi network on/off.",
		"Wi-Fi Direct is a secure and easy-to-use peer-to-peer connection between a Wi-Fi Direct-enabled printer and mobile device.",
		"With Wi-Fi Direct, you can connect your printer to a Wi-Fi Direct network while concurrently connecting to an access point. You can also use a wired network and a Wi-Fi Direct network simultaneously so multiple users can access and print documents both from Wi-Fi Direct and from a wired network.",
		"You cannot connect your mobile device to the internet through the printer’s Wi-Fi Direct.",
		"The supported protocol list may differ from your model, Wi-Fi Direct networks do NOT support IPv6, network filtering, IPSec, WINS, and SLP services. ",
		"The maximum number of devices that can be connected via Wi-Fi Direct is 4.",
		"You can enable Wi-Fi Direct feature by one of the following methods.",
		"From the machine",
		"Wi-Fi ",
		">",
		" Wi-Fi Direct",
		"Tap ",
		"Wi-Fi Direct",
		"Enable ",
		"From the network-connected computer",
		"If your printer is using a network cable or a wireless access point, you can enable and configure Wi-Fi Direct from ",
		"Access ",
		" and select ",
		"Settings",
		"Wi-Fi Direct™",
		"™ and set other options.",
		"Setting up the mobile device",
		"After setting up Wi-Fi Direct from the printer, refer to the user manual of the mobile device you are using to set its Wi-Fi Direct.",
		"After setting up Wi-Fi Direct, you need to download the mobile printing application (For example: Lenovo Mobile printer) to print from your smartphone.",
		"When you have found the printer you want to connect to from your mobile device, select the printer and the printer's LED will blink. Press the WPS button on the printer and it will be connected to your mobile device. If you don’t have WPS button, press the option you want when the Wi-Fi connection confirmed window appears from the display screen and it will be connected to your mobile device.",
		" If your mobile device does not support Wi-Fi Direct, you need to enter the \"Network Key\" of a printer instead of pushing the WPS button.",
		"Troubleshooting for wireless network",
		"Problems during setup or driver installation",
		"Printers Not Found",
		"Your machine may not be turned on. Turn on your computer and the machine.",
		"USB cable is not connected between your computer and machine. Connect the machine to your computer using the USB cable.",
		"The machine does not support wireless networking. Check the machine's user's guide included on the software CD supplied with your machine and prepare a wireless network machine.",
		"Connecting Failure",
		" - ",
		"SSID Not Found",
		"The machine is unable to find the network name (SSID) you have selected or entered. Check the network name (SSID) on your access point and try connecting again. ",
		"Your access point is not turned on. Turn on your access point.",
		"Invalid Security",
		"Security is not configured correctly. Check the configured security on your access point and machine.",
		"General Connection Error",
		"Your computer is not receiving a signal from your machine. Check the USB cable and your machine’s power.",
		"Connected Wired Network",
		"Your machine is connected with a wired network cable. Remove the wired network cable from your machine.",
		"Assigning the IP address",
		"Cycle the power for the access point (or wireless router) and machine.",
		"PC Connection Error",
		"The configured network address is unable to connect between your computer and machine.",
		"For a DHCP network environment",
		"The receives the IP address automatically (DHCP) when computer is configured to DHCP.",
		"If the printing job is not working in DHCP mode, the problem may be caused by the automatically changed IP address. Compare the IP address between the product's IP address and the printer port's IP address.",
		"How to compare:",
		"Print the network information report of your printer, and then check the IP address (see ",
		"Check the printer port's IP address from your computer.",
		"Click the Windows ",
		" menu. ",
		"For Windows 8, from the ",
		"For Windows XP/Server 2003, select ",
		"Printer and Faxes",
		"For Windows Server 2008/Vista, from the ",
		" menu, select Control Panel > ",
		"Hardware and Sound",
		"Printers",
		"For Windows 7, from the ",
		"Devices and Printers",
		"Control Panel",
		"For Windows Server 2008 R2, select ",
		"Hardware",
		"From task bar, type in ",
		" input area. Press the Enter key.",
		"OR",
		"From the ",
		") icon, select ",
		"Devices",
		"Printers & scanners",
		" >",
		"Right-click the ",
		") icon, you can select ",
		"Right-click your machine.",
		"For Windows XP Service Pack 3/2003/2008/Vista, press ",
		"Properties",
		"For Windows 7/8 , Windows Server 2008 R2, Windows 10, or Windows Sever 2016 from context menus, select the ",
		"Printer properties",
		"If ",
		" item has ",
		"►",
		" mark, you can select other printer drivers connected with selected printer.",
		"Port",
		" tab.",
		"Configure Port..",
		" button.",
		"Check if ",
		"Printer Name",
		"IP Address:",
		" is the IP address on the network configuration Sheet.",
		"Change the printer port's IP address if it is different from the network information report's.",
		"If you want to use the software installation CD to change the port IP, connect to a network printer. Then reconnect the IP address.",
		"For a Static network environment",
		"The machine uses the static address when the computer is configured to static address.",
		"If the computer’s network information is as shown below:",
		"IP address: 169.254.133.42",
		"Subnet Mask: 255.255.0.0",
		"Then the machine’s network information should be as below:",
		"IP address: 169.254.133.",
		"43",
		"Subnet Mask: 255.255.0.0 (Use the computer’s subnet mask.)",
		"Gateway: 169.254.133.",
		"1",
		"Other problems",
		"If problems occur while using the machine on a network, check the following: ",
		"For information on the access point (or wireless router), refer to its own user's guide. ",
		"You cannot enable wired and wireless networks at the same time.",
		"Your computer, access point (or wireless router), or machine may not be turned on.",
		"Check the wireless reception around the machine. If the router is far from the machine or there is an obstacle, you might have difficulty receiving the signal. ",
		"Cycle the power for the access point (or wireless router), machine, and computer. Sometimes cycling the power can recover network communication.",
		"Check whether firewall software (V3 or Norton) is blocking the communication. ",
		"If the computer and the machine are connected on the same network and it cannot be found when searching, firewall software might be blocking the communication. Refer to the user's guide for the software to turn it off and try searching for the machine again.",
		"Check whether the machine's IP address is allocated correctly. You can check the IP address by printing the network configuration report.",
		"Check whether the access point (or wireless router) has a configured security (password). If it has a password, refer to the access point (or wireless router) administrator.",
		"Check the machine's IP address. Reinstall the machine driver and change the settings to connect to the machine on the network. Due to the characteristics of DHCP, the allocated IP address could change if the machine is not used for a long time or if the access point has been reset.",
		"Register the product's MAC address when you confogure the DHCP server on the access point (or wireless router). Then you can always use the IP address that is set with the MAC address. You can identify the Mac address of your machine by printing a network configuration report (see ",
		"Check the wireless environment. You might not be able to connect to the network in the infrastructure environment where you need to type in a user's information before connecting to the access point (or wireless router).",
		"This machine only supports IEEE 802.11 b/g/n and Wi-Fi. Other wireless communication types (e.g., Bluetooth) are not supported.",
		"You cannot use infrastructure mode at the same time for Lenovo wireless network machines.",
		"The machine is within the range of the wireless network.",
		"The machine is located away from obstacles that could block the wireless signal.",
		"Remove any large metal objects between the access point (or wireless router) and the machine.",
		"Make sure the machine and wireless access point (or wireless router) are not separated by poles, walls, or support columns containing metal or concrete.",
		"The machine is located away from other electronic devices that may interfere with the wireless signal.",
		"Many devices can interfere with the wireless signal, including a microwave oven and some Bluetooth devices.",
		"Whenever the configuration of your access point (or wireless router) changes, you must do the product's wireless network setup again.",
		"The maximum number of device that can be connected via ",
		" is 3.",
		" is ",
		"ON",
		", this machine only supports IEEE 802.11 b/g.",
		"If the access point is set to work with the 802.11n standard only, it may not connect to your machine."
	],
	"43_1|54_2": [
		"Useful Setting Menus",
		" > ",
		"Advanced",
		"This chapter explains how to browse the current status of your machine, and the method of setting for advanced machine setup. ",
		"Before you begin reading a chapter",
		"Print",
		"Copy",
		"Scan",
		"System setup",
		"Network setup"
	],
	"43_1|54_2|55_0": [
		"Before you begin reading a chapter",
		" > ",
		"Advanced",
		"Useful Setting Menus",
		"This chapter explains all the features available for this series' models to help users  easily understand the features.You can check the features available for each model in the ",
		"Basic Guide",
		" (see ",
		"Menu overview",
		").The following are tips for using this chapter",
		"The control panel provides access to various menus to set up the machine or use the machine’s functions. These menus can be accessed by pressing ",
		" (",
		"Menu",
		").",
		"Some menus may not appear on the display depending on options or models. If so, it is not applicable to your machine.",
		"For models that do not have the ",
		") on the control panel, this feature is not applicable (see ",
		"Control panel overview",
		"Some menu names may differ from your machine depending on its options or the models."
	],
	"43_1|54_2|56_1": [
		"Print",
		" > ",
		"Advanced",
		"Useful Setting Menus",
		"Some menus may not appear in the display depending on options or models. If so, it is not applicable to your machine (see ",
		"Menu overview",
		").",
		"To change the menu options:",
		"Press ",
		" (",
		"Menu",
		") > ",
		"Print Setup",
		" on the control panel.",
		"Item",
		"Description",
		"Orientation",
		"Selects the direction in which information is printed on a page.",
		"Copies ",
		"You can enter the number of copies using the number keypad.",
		"Resolution",
		"Specifies the number of dots printed per inch (dpi). The higher the setting, the sharper printed characters and graphics.",
		"Trapping",
		"Reduces the white gap caused by misalignment of color channels in color printing mode. Also black text will be overprinted on other colors.",
		"Screen",
		"Affects the resolution and clarity of your color output.",
		"Enhanced",
		": ",
		"This mode will generate printouts with sharp texts and smooth graphic/photo objects in the page.",
		"Detailed",
		"This mode will generate printouts with sharp details over the entire page.",
		"Normal",
		"This mode will generate printouts with smooth tone over the entire page.",
		"Clear Text",
		"Selects this option to print texts clearer than on a normal document.",
		"Auto CR",
		"Allows you to append the required carriage return to each line feed, which is useful for Unix or DOS users.",
		"Emulation",
		"Sets the emulation type and option.",
		"Edge Enhance",
		"Allows user to enhance sharpness of text and graphics for improving readability.",
		"Darkness",
		"You can adjust the degree of darkness. This feature allows dark images to be printed into lighter images, or light images into darker images.",
		"SkipBlankPages",
		"This option allows you to specify not to print blank pagesin the original data."
	],
	"43_1|54_2|57_2": [
		"Copy",
		" > ",
		"Advanced",
		"Useful Setting Menus",
		"Copy feature",
		"Some menus may not appear in the display depending on options or models. If so, it is not applicable to your machine (see ",
		"Menu overview",
		").",
		"To change the menu options:",
		"In copy mode, press ",
		" (",
		"Menu",
		") > ",
		"Copy Feature",
		" on the control panel.",
		"Item",
		"Description",
		"Original Size",
		"Sets the image size.",
		"Reduce/Enlarge",
		"Reduces or enlarges the size of a copied image (see ",
		"Reduced or enlarged copy",
		"If the machine is set to Eco mode, reduce and enlarge features are not available.",
		"Darkness",
		"Adjusts the brightness level to make a copy that is easier to read, when the original contains faint markings and dark images (see ",
		")",
		"Original Type",
		"Improves the copy quality by selecting the document type for the current copy job (see ",
		"Original ",
		"Collation",
		"Set the machine to sort the copy job. For example, if you make 2 copies of a 3 page original, one complete 3 page document will print followed by a second complete document.",
		"Layout",
		"Adjusts the layout format such as Normal, ID copy, 2/4-up.",
		"2-up",
		" or ",
		"4-up",
		"Reduces the size of the original images and prints 2 or 4 pages onto one sheet of paper. ",
		"ID Copy",
		"prints one side of the original on the upper half of the paper and the other side on the lower half without reducing the size of the original. This feature is helpful for copying a small-sized item such as business card.",
		"Adjust Bkgd",
		".",
		"Prints an image without its background. This copy feature removes the background color and can be helpful when copying an original containing color in the background, such as a newspaper or a catalog.",
		"Off",
		": ",
		"Does not use this feature.",
		"Auto",
		"Optimizes the background.",
		"Enhance Lev.1~2",
		"The higher the number is, the more vivid the background is.",
		"Erase Lev.1~4",
		"The higher the number is, the lighter the background is.",
		"Copy Setup",
		"Change Default",
		"Resets the value or setting to the printer’s out-of-box state.",
		"Improves the copy quality by selecting the document size for the current copy job.",
		"Copies ",
		"You can enter the number of copies using the number keypad.",
		"Set the machine to sort the copy job. For example, if you make 2 copies of a 3 page original, one complete 3 page document will print followed by a second complete document. ",
		"On",
		"Prints output in sets to match the sequence of originals.",
		"Prints output sorted into stacks of individual pages.",
		"If the machine is set Eco mode, reduce and enlarge features are not available."
	],
	"43_1|54_2|58_3": [
		"Scan",
		" > ",
		"Advanced",
		"Useful Setting Menus",
		"Scan feature",
		"Some menus may not appear in the display depending on options or models. If so, it is not applicable to your machine (see ",
		"Menu overview",
		").",
		"To change the menu options:",
		"in scan mode, press ",
		" (",
		"Menu",
		") > ",
		"Scan Feature",
		" on the control panel.",
		"Item",
		"Description",
		"USB Feature",
		"Sets scan destination to a USB. You scan the originals and save the scanned image to a USB device.",
		"Original Size",
		"Sets the image size.",
		"Original Type",
		"Sets the original document’s type.",
		"Resolution",
		"Sets the image resolution.",
		"Color Mode",
		"Sets the color mode.",
		" Darkness",
		"Adjusts the brightness level to scan.",
		"File Format",
		"Sets the file format in which the image is to be saved. If you select JPEG, TIFF, PDF, or XPS, you can select to scan multiple pages.",
		"Scan setup",
		"In scan mode, press ",
		"Scan Setup",
		"Change Default",
		"Resets the value or setting to the printer’s out-of-box state.",
		"USB Default",
		"Resets the USB scan setting to the printer’s out-of-box state."
	],
	"43_1|54_2|59_4": [
		"System setup",
		" > ",
		"Advanced",
		"Useful Setting Menus",
		"Machine setup",
		"Some menus may not appear in the display depending on options or models. If so, it is not applicable to your machine (see ",
		"Menu overview",
		").",
		"To change the menu options:",
		"Press ",
		" (",
		"Menu",
		") > ",
		"System Setup",
		"Machine Setup",
		" on the control panel.",
		"Item",
		"Description",
		"Language",
		"Sets the language of the text that appears on the control panel display.",
		"Power Save",
		"Sets how long the machine waits before going to power save mode.",
		"When the machine does not receive data for an extended period of time, power consumption is automatically lowered. ",
		"Auto Power Off",
		"Turns power off automatically when the machine has been in power save mode for the length of time set in ",
		"On",
		"Timeout",
		".",
		"To turn the machine on again, press the ",
		"Power/Wake Up",
		") button on the control panel (make sure the main power switch is on).",
		"If you run the printer driver or ",
		"Lenovo Easy Printer Manager",
		", the time automatically extends.",
		"The ",
		" feature is disabled if the machine is connected to a wireless or wired network or working on a print job.",
		"Wakeup Event",
		"You can set the condition to wake up from power-save mode.",
		": ",
		" The machine wake up from the power save mode on the following cases:",
		"Pressing any button",
		"Opening or closing the paper tray",
		"Off",
		"The machine wakes up from power save mode only when a button on the control panel is pressed. ",
		"System Timeout",
		"Sets the time that the machine remembers previously used copy settings. After the timeout, the machine restores the default copy settings.",
		"Job Timeout",
		"Sets the length of time the printer waits before printing the last page of a print job that does not end with a command to print the page.",
		"Altitude Adj.",
		"Optimize print quality according to the machine’s altitude.",
		"Humidity",
		"Optimizes print quality according to the humidity in the environment.",
		"Auto Continue",
		"Determine whether or not the machine continues printing when it detects the paper does not match the paper settings.",
		"If a paper mismatch occurs, the machine waits until you insert the correct paper. ",
		"After 0 Sec",
		"Even though a paper mismatch occurs, the machine continues printing.",
		"After 30 Sec",
		"If a paper mismatch occurs, an error message will display. The machine waits for about 30 second, then automatically clear the message and continue printing. ",
		"Paper Substit.",
		"Automatically substitutes the printer driver’s paper size to prevent the paper mismatch between Letter and A4. For example, if you have A4 paper in the tray but you set the paper size to Letter in the printer driver, the machine prints on A4 paper and vice versa.",
		"Eco Settings",
		"Allows you to save print resources and enables eco-friendly printing. ",
		"Default Mode",
		"Select whether to turn the Eco mode on or off.",
		"On force",
		"On-Forced",
		"): Sets the Eco mode on with password. If a user wants to turn the Eco mode on/off, the user needs to enter the password.",
		"Select Temp.",
		"Selects the eco template set from the ",
		"Embedded Web Server",
		"Paper setup",
		"Paper Setup",
		"Paper Size",
		"Sets the paper size as A4, Letter, or other paper sizes, according to your requirements.",
		"Paper Type",
		"Chooses the type of the paper for each tray.",
		"Margin",
		"Sets the margins for the document.",
		"Report",
		"Configuration",
		"Prints a report on the machine's overall configuration.",
		"Supplies Info.",
		"Prints supplies’ information page. ",
		"Demo Page",
		"Prints the demo page to check whether your machine is printing properly or not.",
		"PCL Font",
		"Print to see the PCL font list.",
		"PS Font",
		"Print to see the PS font list",
		"Network Conf. ",
		"Prints information on your machine’s network connection and configuration.",
		"Usage Counter",
		"Prints a usage page. The usage page contains the total number of pages printed.",
		"Maintenance",
		" > CLR Empty Msg",
		"When toner cartridge is empty, this option appears. You can clear the empty message.",
		"Supplies Life",
		"Shows the supply life indicators (see ",
		"Monitoring the supplies life",
		".)",
		"Image Mgr.",
		"Allows you to adjust the color setting such as contrast level, color registration, color density, etc.",
		"Custom Color",
		" adjusts contrast, color by color.",
		"Default",
		" optimizes colors automatically.",
		"Print Density",
		" allows you to manually adjust the color contrast for each cartridge. It is recommended to use the Default setting for best color quality.",
		"Serial Number",
		"Shows the machine’s serial number. When you call for service or register as a user on the Lenovo website, you can find this.",
		"TonerLow Alert",
		"Customizes the level to alert toner low or toner empty (see ",
		"Setting the toner low alert",
		"ImgU.Low Alert",
		"Customizes the level to alert imaging unit low."
	],
	"43_1|54_2|60_5": [
		"Network setup",
		" > ",
		"Advanced",
		"Useful Setting Menus",
		"Some menus may not appear in the display depending on options or models. If so, it is not applicable to your machine (see ",
		"Menu overview",
		").",
		" Press ",
		" (",
		"Menu",
		")> ",
		"Network",
		" on the control panel.",
		"Option",
		"Description",
		"TCP/IP (IPv4)",
		"Selects the appropriate protocol and configure parameters to use the network environment.",
		"There are many of parameters to be set. If you are not sure, leave as is, or consult the network administrator.",
		"TCP/IP (IPv6)",
		"Selects this option to use the network environment through IPv6.",
		"Ethernet",
		"Configure the network transmission speed and active port.",
		"Wi-Fi",
		"Selects this option to use the Wi-Fi network.",
		"Clear Setting",
		"s",
		"Reverts the network settings to the default values. (Reboot required.)",
		"Network Conf.",
		"This list shows information on your machine’s network connection and configuration.",
		"Protocol Mgr.",
		"You can activate or deactivate the following protocols.",
		"HTTP",
		": ",
		"You can set whether to use Embedded Web Server or not.",
		"Turn the power off and on after you change this option.",
		"WINS",
		" You can configure the WINS server. WINS (Windows Internet Name Service) is used in the Windows operating system.",
		"SNMPv1/v2",
		"You have to enable this option to use SNMP V1/V2 protocol. Administrator’s can use SNMP to monitor and manage machines on the network.",
		"UPnP(SSDP)",
		"You have to enable this option to use UPnP(SSDP) protocol.",
		"mDNS",
		"You have to enable this option to use MDNS (Multicast Domain Name System) protocol.",
		"SetIP",
		"You have to enable this option to use SetIP protocol.",
		"SLP",
		"You can configure SLP (Service Location Protocol) settings. This protocol allows host applications to find services in a local area network without prior configuration."
	],
	"43_1|61_3": [
		"Special Features",
		" > ",
		"Advanced",
		"This chapter explains special copying, scanning, and printing features.",
		"Altitude adjustment",
		"Printing features",
		"Scan features",
		"The procedures in this chapter are mainly based on Windows 7.",
		"It may be necessary to press ",
		"OK",
		" to navigate to lower-level menus for some models."
	],
	"43_1|61_3|62_0": [
		"Altitude adjustment",
		" > ",
		"Advanced",
		"Special Features",
		"Print quality is affected by atmospheric pressure, which is determined by the height of the machine above sea level. The following information will guide you on how to set your machine for the best print quality.",
		"Before you set the altitude value, determine the altitude where you are.",
		"Normal",
		": ",
		"0 ~ 1,000 m (3,280 ft)",
		"High 1 ",
		"1,000 m (3,280 ft) ~ 2,000 m (6,561 ft)",
		"High 2",
		"2,000 m (6,561 ft) ~ 3,000 m (9,842 ft) ",
		"High 3",
		"3,000 m (9,842 ft) ~ 4,000 m (13,123 ft)",
		"High 4",
		"4,000 m (13,123 ft) ~ 5,000 m (16,404 ft)",
		"You can set the altitude value from ",
		"Device Settings",
		" in ",
		"Lenovo Easy Printer Manager",
		" program.",
		"If your machine is connected to the local, you can set the machine’s setting from ",
		"Advanced Setting",
		" (see ",
		"Using Lenovo Easy Printer Manager ",
		").",
		"If your machine is connected to the network, you can set themachine’s setting from ",
		"Embedded Web Server",
		"Settings",
		" tab > ",
		"Machine Settings",
		"Using ",
		"You can also set the altitude in ",
		"System Setup ",
		"option on the machine’s display (see ",
		"Machine’s basic settings"
	],
	"43_1|61_3|63_1": [
		"Printing features",
		" > ",
		"Advanced",
		"Special Features",
		"For basic printing features, refer to the ",
		"Basic Guide",
		" (see ",
		"Basic printing ",
		").",
		"This feature may not be available depending on model or optional goods (see ",
		"Features by model",
		"Changing the default print settings",
		"For Windows XP Service Pack 3/Server 2003, select ",
		"Printer and Faxes",
		". ",
		"For Windows Server 2008/Vista, from the ",
		"Start",
		" menu, select ",
		"Control Panel",
		"Hardware and Sound",
		"Printers",
		"For Windows 7, from the ",
		"Devices and Printers",
		".",
		"For Windows 8, from the ",
		"Charms",
		", select ",
		"Search",
		"Settings",
		"For Windows Server 2008 R2, select ",
		"Hardware",
		"For Windows 10 / Windows Server 2016",
		"From task bar, type in ",
		" in ",
		" input area. Press the Enter key.",
		"OR",
		"From the ",
		" (",
		") icon, select ",
		"Devices",
		"Printers & scanners",
		" >",
		"Right-click the ",
		") icon, you can select ",
		"Right-click on your machine.",
		"For Windows XP Service Pack 3/Server 2003/Server 2008/Vista, select ",
		"Printing Preferences",
		"For Windows 7/Windows 8/Windows Server 2008 R2/Windows 10/ Windows Server 2016, from context menus, select ",
		"Printing preferences",
		"If ",
		" has a ",
		"►",
		", you can select other printer drivers connected to the selected printer.",
		"Change the settings on each tab. ",
		"Click ",
		"OK",
		"If you want to change the settings for each print job, change it in ",
		"Setting your machine as a default machine",
		"For Windows XP Service Pack 3/Server 2003, from the ",
		",",
		" select ",
		"Select your machine.",
		"Right-click your machine and select ",
		"Set as Default Printer",
		"For Windows 7 or Windows Server 2008 R2, if ",
		"Set as default printer",
		"Using advanced print features",
		"XPS printer driver",
		": used to print XPS file format. ",
		"See ",
		"The XPS printer driver can be installed only on Windows Vista OS or higher.",
		"Printing to a file (PRN)",
		"You will sometimes need to save the print data as a file. ",
		"Check the ",
		"Print to file",
		" box in the ",
		"Print",
		" window.",
		"Type in the destination path and the file name, and then click ",
		"For example, ",
		"c:\\Temp\\file name",
		"If you type in only the file name, the file is automatically saved in ",
		"My Documents",
		", ",
		"Documents and Settings",
		", or ",
		"Users",
		". The saved folder may differ, depending on your operating system or the application you are using.",
		"Understanding special printer features",
		"You can use advanced printing features when using your machine.",
		"To take advantage of the printer features provided by your printer driver, click ",
		"Properties",
		" or ",
		"Preferences",
		" in the application’s ",
		" window to change the print settings. The machine name that appears in the printer properties window may differ depending on the machine in use.",
		"Some menus may not appear on the display depending on options or models. If so, it is not applicable to your machine.",
		"Select the ",
		"Help",
		" menu or click the ",
		" button from the window or press ",
		"F1",
		" on your keyboard and click on any option you want to know about (see ",
		"Using help",
		"Item",
		"Description",
		"Multiple Pages per Side",
		"Selects the number of pages to print on a single sheet of paper. To print more than one page per sheet, the pages will be reduced in size and arranged in the order you specify. You can print up to 16 pages on one sheet. ",
		"Poster Printing",
		"Prints a single-page document onto 4 (Poster 2x2), 9 (Poster 3x3), or 16 (Poster 4x4) sheets of paper, for the purpose of pasting the sheets together to form one poster-size document.",
		"Poster Overlap",
		" value. Specify ",
		" in millimeters or inches by selecting the radio button on the upper right of ",
		"Basic",
		" tab to make it easier to paste the sheets together.",
		"Booklet Printing",
		"[a]",
		"Prints your document on both sides of a sheet of paper and arranges the pages so that the paper can be folded in half after printing to produce a booklet. ",
		"This option is available only when you use the PCL/SPL printer driver. This option is not available when you use XPS driver.",
		"The ",
		" option is not available for all paper sizes. Select the available paper ",
		"Size",
		" option under the ",
		"Paper",
		" tab to see what paper sizes are available.",
		"If you select an unavailable paper size, this option can be automatically canceled. Select only available paper (paper without ",
		" mark).",
		"Double-sided Printing (Manual)",
		"Print on both sides of a sheet of paper (duplex). Before printing, decide how you want your document oriented. ",
		"If your machine does not have a duplex unit, you should complete the printing job manually. The machine prints every other page of the document first. After that, a message appears on your computer.",
		"Skip Blank Pages",
		" feature does not work when you select the duplex option.",
		"None",
		": ",
		"Disables this feature.",
		"Long Edge",
		"This option is the conventional layout used in bookbinding.",
		"Short Edge",
		"This option is the conventional layout used in calendars.",
		"Paper Options",
		"Changes the size of a document to appear larger or smaller on the printed page by entering in a percentage by which to enlarge or decrease the document.",
		"Watermark",
		"The watermark option allows you to print text over an existing document. For example, you use it when you want to have large gray letters reading “",
		"DRAFT",
		"” or “",
		"CONFIDENTIAL",
		"” printed diagonally across the first page or all pages of a document. ",
		"Header",
		"You can add the selected text to the top left, top center, or top right.",
		"Footer",
		"You can add the selected text to the bottom left, bottom center, or bottom right.",
		"(",
		"Creating a watermark",
		")",
		"To change the print settings from your software application, access ",
		"Opening printing preferences",
		" tab, select ",
		"Edit...",
		" from the ",
		" drop-down list. ",
		"Enter a text message in the ",
		"Watermark Message",
		" box. You can enter up to 256 characters. ",
		"When the ",
		"First Page Only",
		" box is checked, the watermark prints on the first page only.",
		"Select watermark options. ",
		"You can select the font name, style, size, and shade from the ",
		"Font Attributes",
		" section, as well as set the angle of the watermark from the ",
		"Watermark Alignment and Angle",
		" section. ",
		"Add",
		" to add a new watermark to the ",
		"Current Watermarks",
		" list.   ",
		"When you finish editing, click ",
		" until you exit the ",
		"Editing a watermark",
		"Click the ",
		" drop-down list.",
		"Select the watermark you want to edit from the ",
		" list and change the watermark message and options. ",
		"Update",
		" to save the changes.",
		" window. ",
		"Deleting a watermark",
		"Select the watermark you want to delete from the ",
		" list and click ",
		"Delete",
		"Overlay",
		"This option is available only when you use the PCL/SPL printer driver (see ",
		"Software",
		"An overlay is text and/or images stored in the computer hard disk drive (HDD) as a special file format that can be printed on any document. Overlays are often used to take the place of letterhead paper. Rather than using preprinted letterhead, you can create an overlay containing exactly the same information that is currently on your letterhead. To print a letter with your company’s letterhead, you do not need to load preprinted letterhead paper in the machine: just print the letterhead overlay on your document.",
		"To use a page overlay, you must create a new page overlay containing your logo or image.",
		"The overlay document size must be the same as the document you print with the overlay. Do not create an overlay with a watermark.",
		"The resolution of the overlay document must be the same as that of the document you will print with the overlay.",
		"Creating a new page overlay",
		"Create or open a document containing text or an image for use in a new page overlay. Position the items exactly as you wish them to appear when printed as an overlay.",
		"To save the document as an overlay, access ",
		" tab, and select ",
		"Create",
		"In the ",
		"Save As",
		" window, type a name up to eight characters in the ",
		"File name",
		" box. Select the destination path, if necessary (The default is C:\\Formover).",
		"Save",
		"When a confirming message window appears, click ",
		"Yes",
		"The file is not printed. Instead, it is stored on your computer hard disk drive.",
		"Using a page overlay",
		"Create or open the document you want to print.",
		" tab. ",
		"Print Overlay",
		"If the overlay file you want does not appear in the ",
		"Overlay File 1",
		"Overlay File 2",
		" drop-down list, select ",
		"Load",
		"Overlay List",
		". Select the overlay file you want to use. ",
		"If you have stored the overlay file you want to use in an external source, you can also load the file when you access the ",
		"After you select the file, click ",
		"Open",
		". The file appears in the ",
		" box and is available for printing. Select the overlay from the ",
		" box. ",
		"If necessary, check ",
		"Confirm Page Overlay When Printing",
		" box. If this box is checked, a message window appears each time you submit a document for printing, asking you to confirm your wish to print an overlay on your document. ",
		"If this box is not checked and an overlay has been selected, the overlay automatically prints with your document. ",
		"The selected overlay prints on your document. ",
		"Deleting a page overlay",
		" window, click the ",
		"Select ",
		"Edit",
		" in the ",
		"Text",
		" drop down list. ",
		"Select the overlay you want to delete from the ",
		" window. You can delete page overlays that you no longer use.",
		"[a] ",
		"This option is not available when you use XPS driver.",
		"Mac printing",
		"Some features may not be available depending on models or options. It means that the features are not supported.",
		"Printing a document",
		"When you print with a Mac, you need to check the printer driver settings in each application you use. Follow the steps below to print from a Mac:",
		"Open the document to print.",
		"Open the ",
		"File ",
		"menu and click ",
		"Page Setup",
		"Document Setup",
		" in some applications).",
		"Choose your paper size, orientation, scaling, other options, and make sure that your machine is selected. Click ",
		"File",
		" menu and click ",
		"Choose the number of copies and indicate which pages to print. ",
		"Changing printer settings",
		"Open an application and select ",
		" menu. The machine name, which appears in the printer properties window, may differ depending on the machine in use. Except for the name, the composition of the printer properties window is similar to the following.",
		"Printing multiple pages on one sheet ",
		"You can print more than one page on a single sheet of paper. This feature provides a cost-effective way to print draft copies.",
		"Open an application, and select ",
		" menu.",
		"Layout",
		" from the drop-down list under ",
		"Orientation",
		". In the ",
		"Pages per Sheet",
		" drop-down list, select the number of pages you want to print on one sheet of paper.",
		"Select the other options to use.",
		"The machine prints the selected number of pages to print on one sheet of paper.",
		"Printing on both sides of the paper",
		"Some features may not be available depending on models or options. It means that the features are not supported (see ",
		"Variety feature",
		"Before printing in the duplex mode, decide on which edge you will be binding your finished document. The binding options are, as follows:",
		"Long-Edge Binding",
		"This option is the conventional layout used in book binding.",
		"Short-Edge[ Binding",
		"This option is the type often used with calendars.",
		"From your Mac application, select ",
		"Select a binding orientation from the ",
		"Two-Sided",
		" option.",
		" and the machine prints on both sides of the paper.",
		"If you print more than 2 copies, the first copy and the second copy might print on the same sheet of paper. Avoid printing on both sides of paper when you are printing more than 1 copy.",
		"Click the question mark on the bottom-left corner of the window and click on the topic you want to know about. A pop-up window appears with information about that option's feature, which is provided from the driver. ",
		"Linux printing",
		"Printing from applications",
		"There are a lot of Linux applications that allow you to print using Common UNIX Printing System (CUPS). You can print on your machine from any such application.",
		"Print Setup",
		" for someapplications).",
		" Choose your paper size, orientation, and makesure that your machine is selected. Click ",
		"Apply",
		" Open the ",
		" Select your machine to print.",
		"Choose the number of copies and indicate which pages to print.",
		"Change other printing options in each tab, if necessary.",
		"Automatic/manual duplex printing may not be available depending on models. You can alternatively use the lpr printing system or other applications for odd-even printing (see ",
		"Printing files",
		"You can print text, image, pdf files on your machine using the standardCUPS directly from the command line interface. The CUPS lp or lpr utility allows you to do that. You can print these files by using below command format.",
		"\"",
		"lp -d ",
		"<printer name>",
		"-o",
		"<option> <file name>",
		"Please refer to lp or lpr man page on your system for more details.",
		"Configuring Printer Properties",
		"You can change the default printing options or connection type with Printing utility supplied by o/s.",
		"Launch Printing utility(Go to ",
		"System",
		"Administration",
		"Printing",
		" menu or execute \"",
		"system-config-printer",
		"\" command in Terminal program).",
		"Select your printer and double-click it.",
		"Change default printing options or connection type.",
		" button."
	],
	"43_1|61_3|64_2": [
		"Scan features",
		" > ",
		"Advanced",
		"Special Features",
		"For basic scanning features, refer to the ",
		"Basic Guide",
		" (see ",
		"Basic scanning",
		").",
		"This feature may not be available depending on model or optional goods (see ",
		"Features by model",
		"The maximum resolution that can be achieved depends upon various factors, including computer speed, available disk space, memory, the size of the image being scanned, and bit depth settings. Thus, depending on your system and what you are scanning, you may not be able to scan at certain resolutions, especially using enhanced dpi.",
		"Basic scanning method",
		"Variety feature",
		"You can scan the originals with your machine via a USB cable or the network. The following methodoloqies can be used for scanning your documents:",
		"Scan to PC",
		": ",
		"Scan the originals from the control panel. Then, the scanned data will be stored in the connected computers ",
		"My Documents",
		" folder (see ",
		"Basic Scanning",
		"Scan to WSD",
		"Scans the originals and saves the scanned data on a connected computer if the computer supports the WSD (Web Service for Device) feature (see ",
		"Scanning to WSD",
		"TWAIN: ",
		"TWAIN is the one of the preset imaging applications. Scanning an image launches the selected application, enabling you to control the scanning process. This feature can be used via the local connection or the network connection (see ",
		"Scanning from image editing program",
		"Lenovo Easy Document Creator",
		"You can use this program to scan images or documents (See ",
		"Using ",
		"WIA: ",
		"WIA stands for Windows Images Acquisition. To use this feature, your computer must be connected directly with the machine via a USB cable (see ",
		"Scanning using the WIA driver",
		"Scan to USB",
		"You can scan a document and save the scanned image onto a USB memory device (see ",
		"Scanning to a USB memory device",
		"Setting the scan settings in the computer",
		"Open ",
		"Lenovo Easy Printer Manager",
		"Using Lenovo Easy Printer Manager ",
		"Select the appropriate machine from the ",
		"Printer List",
		".",
		"Select ",
		"Scan to PC Settings",
		" menu.",
		"Select the option you want.",
		"Scan Activation",
		"Determines whether or not scanning is enabled on the device.",
		"Basic",
		" tab: ",
		" Contains settings related to general scan and device settings.",
		"Image",
		" Contains settings related to image altering.",
		"Press ",
		"Save",
		"OK",
		"Scanning from network connected machine",
		"This feature is not available for the machine that does not support the network interface (see ",
		"Rear view",
		"Make sure the printer driver is installed on your computer using the software CD, since the printer driver includes the scan program (see ",
		"Installing the driver locally",
		"Place a single document face down on the document glass (see ",
		"On the scanner glass",
		"(",
		"Scan",
		") > ",
		"Network PC",
		" on the control panel.",
		"If you see ",
		"Not Available",
		" message, check the port connection.",
		"Select your registered computer ",
		"ID",
		", and enter the ",
		"Password",
		" if necessary.",
		" is the same ID as the registered scan ID for ",
		"Advanced Settings",
		" is the 4 digit number registered password for ",
		" >",
		" Advanced Settings",
		"Select the option you want and press ",
		"Scanning begins.",
		"Scanned image is saved in computer’s ",
		"C:\\",
		"Users",
		"\\users name\\",
		". The saved folder may differ, depending on your operating system or the application you are using.",
		"Scans the originals and saves the scanned data on a connected computer if the computer supports the WSD (Web Service for Device) feature. To use the WSD feature, you need to install the WSD printer driver on your computer. For Windows 7, you can install the WSD driver by ",
		"Control Panel",
		"Devices and Printers",
		"Add a printer",
		". Click ",
		"Add a network printer",
		" from the wizard.",
		"The machine that does not support the network interface, it will not be able to use this feature (see ",
		"The WSD feature works only with Windows Vista® or later version that are the WSD-compliant computer. ",
		"The following installation steps are based on Windows 7 computer. ",
		"Installing a WSD Printer Driver ",
		"Select",
		"Start",
		"Click ",
		"Add a network, wireless or Bluetooth printer",
		"In the printers list, select the one you want to use, and then click ",
		"Next",
		"The IP address for WSD printer is http://IP address/ws/ (example: http://111.111.111.111/ws/).",
		"If no WSD printer is displayed in the list, click ",
		"The printer that I want isn't listed",
		"Add a printer using a TCP/IP address or hostname",
		" and select ",
		"Web Services Device",
		" from ",
		"Device type",
		". Then enter the printer's IP address.",
		"Follow the instructions in the installation window.",
		"Scanning using the WSD feature",
		"Make sure that the machine is connected to your computer and powered on.",
		"(Scan) > ",
		" message, check the port connection. Or check the printer driver for WSD is correctly installed.",
		"Select your computer name from ",
		"WSD PC List",
		"Scanning with ",
		" is an application to help users scan, compile, and save documents in multiple formats, including .epub format.",
		"Availabe for Windows OS and Mac OS users only.",
		"Windows XP Service Pack 3",
		" or higher and Internet Explorer 6.0 or higher is the minimum requirement for ",
		" is installed automatically when you install the machine software (see ",
		"From the ",
		" menu select ",
		"Programs",
		" or ",
		"All Programs",
		"Lenovo Printers",
		"For Mac, open the ",
		"Applications",
		" folder > ",
		"Lenovo",
		" from the home screen.",
		"Select the type of scanning or a favorites and then make adjustments to the image(",
		"Options",
		" to scan a final image or ",
		"Prescan",
		" to get another preview image.",
		"Send",
		"Press the option you want.",
		"Click the ",
		"Help",
		" (",
		") button from the window, and then click on any option you want to know about.",
		"You can scan and import documents in the image editing software such as Adobe Photoshop, if the software is TWAIN-compliant. Follow the steps below to scan with TWAIN-compliant software:",
		"Open an application, such as Adobe Photoshop.",
		"File",
		"Import",
		", and select the scanner device.",
		"Set the scan options.",
		"Scan and save your scanned image.",
		"Your machine supports the Windows Image Acquisition (WIA) driver for scanning images. WIA is one of the standard components provided by Microsoft Windows 7 and works with digital cameras and scanners. Unlike the TWAIN driver, the WIA driver allows you to scan and easily adjust images without using additional software:",
		"The WIA driver works only on Windows OS (not supported Windows 2000) with a USB port.",
		"Hardware and Sound",
		"Right-click on device driver icon in ",
		"Printers and Faxes",
		"Start Scan",
		"New Scan",
		" application appears.",
		"Choose your scanning preferences and click ",
		"Preview",
		" to see how your preferences affect the picture.",
		"MAC scanning",
		"You can scan documents using ",
		"Image Capture",
		" program. MAC OS X offers ",
		" program. ",
		"Scanning with network",
		"Make sure that your machine is connected to a network.",
		"Place the originals face up in the ADF or place a single original face down on the scanner glass and close the ADF (see ",
		"Loading originals",
		"Open the ",
		" folder and run ",
		". ",
		"Select your device below ",
		"SHARED",
		"Set the scan options on this program.",
		"If scanning does not operate in Image Capture, update Mac OS to the latest version. ",
		"For more information, refer to the ",
		"’s help.",
		"You can also scan using TWAIN-compliant software, such as Adobe Photoshop.",
		"You can scan using ",
		" software. Open the ",
		"Lenovo ",
		"folder > ",
		"Linux scanning",
		"Launch a scan application such as xsane or simple-scan(If it's not installed, please install it manually to use scan features. For example, you may use \"yum install xsane\" for rpm package systems and \"apt-get install xsane\" for deb package systems to install xsane). ",
		"Select your device from the list and set the scan options to apply. ",
		" button."
	],
	"43_1|65_4": [
		"Useful Management Tools",
		" > ",
		"Advanced",
		"This chapter introduces management tools provided to help you make full use of your machine. ",
		"Accessing management tools",
		"Using ",
		"Embedded Web Server",
		"Using Lenovo Easy Printer Manager ",
		"Lenovo Easy Document Creator",
		"Lenovo Printer Status"
	],
	"43_1|65_4|66_0": [
		"Accessing management tools",
		" > ",
		"Advanced",
		"Useful Management Tools",
		"Lenovo provides a variety of management tools for Lenovo printers. ",
		"Make sure that the machine is connected to your computer and powered on.",
		"From the ",
		"Start",
		" menu, select ",
		"Programs",
		" or ",
		"All Programs",
		".",
		"For Windows 8, from the ",
		"Charms",
		", select ",
		"Search",
		"Apps",
		"For Windows 10 / Windows Server 2016",
		"From task bar, type in ",
		"Lenovo Printers",
		" in ",
		" input area. Press the enter key.",
		"OR",
		"(",
		") icon, select ",
		"All apps",
		"Find ",
		"Under ",
		", you can see installed management tools.",
		"Click the management tool you want to use.",
		"After installing the driver, for some management tools, you can access them directly from the ",
		" menu > ",
		"For Windows 8, after installing the driver, for some management tools, you can access them directly from the ",
		" screen by clicking on the corresponding tile."
	],
	"43_1|65_4|67_1": [
		"Using Embedded Web Server",
		" > ",
		"Advanced",
		"Useful Management Tools",
		"Using ",
		"Embedded Web Server",
		"Internet Explorer 8.0 or higher is the minimum requirement for ",
		".",
		" explanation in this user’s guide may differ from your machine depending on its options or models.",
		"Accessing ",
		"Access a web browser, such as Internet Explorer, from Windows.",
		"Enter the machine IP address of your printer (http://xxx.xxx.xxx.xxx) in the address field and press the Enter key or click ",
		"Go",
		"Your machine’s embedded website opens.",
		"Logging into ",
		"Before configuring options in ",
		", you need to log-in as an administrator. You can still use ",
		" without logging in but you won’t have access to ",
		"Settings",
		" tab and ",
		"Security",
		" tab. ",
		"Click ",
		"Login",
		" on the upper right of the ",
		" website.",
		"If it’s your first time logging into ",
		" you need to log-in as an administrator. Type in the below default ",
		"ID",
		" and ",
		"Password",
		". We recommend you to change the default password for security reasons.",
		": ",
		"admin",
		"00000",
		" overview",
		"Some tabs may not appear depending on your model.",
		"Information",
		" tab",
		"This tab gives you general information about your machine. You can check things, such as remaining amount of toner. You can also print reports, such as an error report.",
		"Active Alerts",
		"Shows the alerts that have occurred in the machine and their severity.",
		"Supplies",
		"Shows how many pages are printed and amount of toner left in the cartridge.",
		"Usage Counters",
		"Shows the usage count by print types: simplex and duplex.",
		"Current Settings",
		"Shows the machine’s and network’s information. ",
		"Print information",
		"Prints reports such as system related reports, e-mail address, and font reports.",
		"This tab allows you to set configurations provided by your machine and network. You need to log-in as an administrator to view this tab. ",
		"Machine Settings",
		" tab: ",
		"Sets options provided by your machine. ",
		"Network Settings",
		"Shows options for the network environment. Sets options such as TCP/IP and network protocols. ",
		"This tab allows you to set system and network security information. You need to log-in as an administrator to view this tab.",
		"System Security",
		"Sets the system administrator’s information and also enables or disables machine features.",
		"Network Security",
		"Sets settings for IPv4/IPv6 filtering and Authentication servers.",
		"Maintenance",
		"This tab allows you to maintain your machine by upgrading firmware and setting contact information for sending emails. You can also connect to ",
		"Lenovo",
		" website or download drivers by selecting the ",
		"Link",
		" menu.",
		"Firmware Upgrade",
		"Upgrade your machine’s firmware.",
		"Contact Information",
		"Shows the contact information.",
		"Shows links to useful sites where you can download or check information.",
		"Setting the system administrator’s information",
		"This setting is necessary for using the e-mail notification option.",
		"Some menus may not appear in the display depending on options or models. If so, it is not applicable to your machine.",
		"Start a web browser, such as Internet Explorer, from Windows.",
		"Enter the machine IP address (http://xxx.xxx.xxx.xxx) in the address field and press the Enter key or click ",
		"From the ",
		" tab, select ",
		"System Administrator",
		"Enter the name of the administrator, phone number, location, and email address. ",
		"Apply",
		". "
	],
	"43_1|65_4|68_2": [
		"Using Lenovo Easy Printer Manager",
		" > ",
		"Advanced",
		"Useful Management Tools",
		"Using Lenovo Easy Printer Manager ",
		"Available for Windows and Mac OS users only.",
		"For Windows, Internet Explorer 6.0 or higher is the minimum requirement for ",
		"Lenovo Easy Printer Manager",
		".",
		" is an application that combines Lenovo machine settings into one location. ",
		" combines device settings as well as printing environments, settings/actions and launching. All of these features provide a gateway to conveniently use your ",
		"Lenovo",
		" machine. ",
		" provides two different user interfaces for the user to choose from: the basic user interface and the advanced user interface. Switching between the two interfaces is easy: just click a button.",
		"Understanding Lenovo Easy Printer Manager",
		"To open the program: ",
		"For Windows,",
		"Select ",
		"Start",
		"Programs",
		" or ",
		"All Programs",
		"Lenovo Printers",
		"For Windows 8",
		"From the ",
		"Charms",
		", select ",
		"Search",
		"Apps",
		"For Windows 10 / Windows Server 2016",
		"From task bar, type in ",
		" in ",
		" input area. Press the enter key and then select ",
		"OR",
		"(",
		") icon, select ",
		"All apps",
		"For Mac,",
		"Open the ",
		"Applications",
		" folder > ",
		"The ",
		" interface is comprised of various basic sections as described in the table that follows:",
		"The screenshot may differ depending on operating system you are using.",
		"1",
		"Printer list",
		"The Printer list displays printers installed on your computer and network printers added by network discovery (Windows only).",
		"2",
		"Advanced Setting",
		"The advanced user interface is intended to be used by the person responsible for managing the network and machines.",
		"Some menus may not appear in the display depending on options or models. If so, it is not applicable to your machine.",
		"Device Settings",
		": ",
		"You can configure various machine settings such as machine setup, paper, layout, emulation, network, and print information. ",
		"If you connect your machine to a network, the Embedded Web Server icon is enabled.",
		"Scan to PC Settings",
		"This menu includes settings to create or delete scan to PC profiles. ",
		"Scan Activation",
		"Determines whether or not scanning is enabled on the device.",
		"Basic",
		" tab: ",
		" Contains settings related general scan and device settings.",
		"Alert Settings",
		" (Windows only): ",
		"This menu includes settings related to error alerting. ",
		"Printer Alert",
		"Provides settings related to when alerts will be received.",
		"Email Alert",
		"Provides options relating to receiving alerts via email.",
		"Alert History",
		" Provides a history of device and toner related alerts.",
		"3",
		"Application information",
		"Includes links for changing to the refresh, preference setting, help, and about.",
		"4",
		"Printer information",
		"This area gives you general information about your machine. You can check information, such as the machine’s model name, IP address (or Port name), and machine status.",
		"This button opens the ",
		"Troubleshooting Guide",
		" when an error occurs. You can directly open the troubleshooting section in the user’s guide. ",
		"5",
		"Quick links",
		"Displays ",
		" to machine specific functions. This section also includes links to applications in the advanced settings.",
		"6",
		"Contents area",
		"Displays information about the selected machine, remaining toner level, and paper. The information will vary based on the machine selected. Some machines do not have this feature.",
		"7",
		"Order supplies",
		"Click on the ",
		"Order",
		" button from the supply ordering window. You can order replacement toner cartridge(s) from online.",
		"Select the ",
		"Help",
		" menu or click the ",
		" button from the window and click on any option you want to know about. "
	],
	"43_1|65_4|69_3": [
		"Using Lenovo Easy Document Creator",
		" > ",
		"Advanced",
		"Useful Management Tools",
		"Using ",
		"Lenovo Easy Document Creator",
		"Available for Windows and Mac OS users only.",
		"Windows",
		"® XP Service Pack 3 or higher and Internet Explorer 6.0 or higher is the minimum requirement for ",
		".",
		" is an application to help users scan, compile, and save documents in multiple formats, including .epub format. Whether you’re a student needing to organize research from the library or a stay-at-home mom sharing scanned pictures from last year’s birthday party, ",
		" will provide you with the necessary tools.",
		"The ",
		" provides features mentioned below:",
		"Scan: ",
		"Use for scanning pictures or documents.",
		"Text Converting",
		" Scan(Windows only): ",
		" Use for scanning documents that need to be saved in an editable text format.",
		"Document Conversion",
		": ",
		"Provides the ability to convert existing files into multiple formats."
	],
	"43_1|65_4|70_4": [
		"Using Lenovo Printer Status",
		" > ",
		"Advanced",
		"Useful Management Tools",
		"Using ",
		"Lenovo Printer Status",
		"The ",
		" is a program that monitors and informs you of the machine status. ",
		" window and its contents shown in this user’s guide may differ depending on the machine or operating system in use.",
		"Check the operating system(s) that are compatible with your machine (see ",
		"Specifications",
		").",
		"Available for Windows OS users only (see ",
		"Software",
		" overview",
		"If an error occurs while operating, you can check the error from the ",
		". ",
		" is installed automatically when you install the machine software. ",
		"You can also launch ",
		" manually. Go to the ",
		"Printing Preferences",
		" and click the ",
		"Printer Status",
		" button.",
		"These icons appear on the Windows task bar:",
		"Icon",
		"Mean",
		"Description",
		"Normal",
		"The machine is in ready mode and experiencing no errors or warnings.",
		"Warning",
		"The machine is in a state where an error might occur in the future. For example, it might be in toner low status, which may lead to toner empty status.",
		"Error",
		"The machine has at least one error.",
		"1",
		"Device Information",
		"You can view the device information.",
		"2",
		"User’s Guide",
		"You can view the ",
		".",
		"This button opens the ",
		"Troubleshooting Guide",
		" when an error occurs. You can directly open the troubleshooting section in the user’s guide. ",
		"3",
		"Supplies Information",
		"You can view the percentage of toner remaining in each toner cartridge. The machine and the number of toner cartridge(s) shown in the above window may differ depending on the machine in use. Some machines do not have this feature.",
		"4",
		"Option",
		"You can set printing job alert related settings. ",
		"5",
		"Cancel Print ",
		"or ",
		"Close",
		": ",
		"If print job is waiting in the print queue or printer, cancel all user's print jobs in the print queue or the printer.",
		"Close ",
		"Depending on the status of the machine or the supported functions, the ",
		" button may appear to close the status window.",
		"6",
		"Toner/Paper Information",
		"This button area for paper and toner info will be available based on the device."
	],
	"43_1|71_5": [
		"Troubleshooting",
		" > ",
		"Advanced",
		"This chapter gives helpful information for what to do if you encounter an error.",
		"Paper feeding problems",
		"Power and cable connecting problems",
		"Printing problems",
		"Printing quality problems",
		"Copying problems",
		"Scanning problems",
		"Operating system problems",
		"For errors that occur during the wireless software installation and settings, refer to the troubleshotting section in the wireless setting chapter (see ",
		"Troubleshooting for wireless network",
		")."
	],
	"43_1|71_5|72_0": [
		"Paper feeding problems",
		" > ",
		"Advanced",
		"Troubleshooting",
		"Condition",
		"Suggested solutions",
		"Paper jams during printing.",
		"Clear the paper jam.",
		"Paper sticks together.",
		"Check the maximum paper capacity of the tray.",
		"Make sure that you are using the correct type of paper.",
		"Remove paper from the tray and flex or fan the paper.",
		"Humid conditions may cause some paper to stick together.",
		"Multiple sheets of paper do not feed.",
		"Different types of paper may be stacked in the tray. Load paper of only one type, size, and weight.",
		"Paper does not feed into the machine.",
		"Remove any obstructions from inside the machine.",
		"Paper has not been loaded correctly. Remove paper from the tray and reload it correctly.",
		"There is too much paper in the tray. Remove excess paper from the tray.",
		"The paper is too thick. Use only paper that meets the specifications required by the machine.",
		"The paper keeps jamming.",
		"There is too much paper in the tray. Remove excess paper from the tray. If you are printing on special materials, use the manual feeding in tray.",
		"An incorrect type of paper is being used. Use only paper that meets the specifications required by the machine.",
		"There may be debris inside the machine. Open the front cover and remove any debris."
	],
	"43_1|71_5|73_1": [
		"Power and cable connecting problems",
		" > ",
		"Advanced",
		"Troubleshooting",
		"Reboot the power. If the problem persists, please call for service.",
		"Condition",
		"Suggested solutions",
		"The machine is not receiving power, ",
		"or the connection cable between the computer and the machine is not connected properly.",
		"Connect the machine to the electricity supply first. ",
		"Check the USB cable or network cable in the machine’s rear.",
		"Disconnect the USB cable or network cable in the machine’s rear and then, reconnect it."
	],
	"43_1|71_5|74_2": [
		"Printing problems",
		" > ",
		"Advanced",
		"Troubleshooting",
		"Condition",
		"Possible cause",
		"Suggested solutions",
		"The machine does not print.",
		"The machine is not receiving power.",
		"Connect the machine to the electricity supply first. If the machine has a ",
		" (",
		"Power/Wake Up",
		") button on the control, press it. ",
		"The machine is not selected as the default machine.",
		"Select your machine as your default machine in Windows.",
		"Check the machine for the following:",
		"The cover is not closed. Close the cover.",
		"Paper is jammed. Clear the paper jam (see ",
		"Clearing paper jams",
		").",
		"No paper is loaded. Load paper (see ",
		"Loading paper in the tray",
		"The toner cartridge is not installed. Install the toner cartridge (see ",
		"Replacing the toner cartridge",
		"Make sure the protect cover and sheets are removed from the toner cartridge (see ",
		"If a system error occurs, contact your service representative.",
		"The connection cable between the computer and the machine is not connected properly.",
		"Disconnect the machine cable and reconnect it (see ",
		"Rear view",
		"The connection cable between the computer and the machine is defective.",
		"If possible, attach the cable to another computer that is working properly and print a job. You can also try using a different machine cable.",
		"The port setting is incorrect.",
		"Check the Windows printer settings to make sure that the print job is sent to the correct port. If the computer has more than one port, make sure that the machine is attached to the correct one.",
		"The machine may be configured incorrectly. ",
		"Check the ",
		"Printing Preferences",
		" to ensure that all of the print settings are correct.",
		"The printer driver may be incorrectly installed.",
		"Uninstall and reinstall the machine’s driver.",
		"The machine is malfunctioning.",
		"Check the display message on the control panel to see if the machine is indicating a system error. Contact a service representative.",
		"The document size is so big that the hard disk space of the computer is insufficient to access the print job.",
		"Get more hard disk space and print the document again.",
		"The output tray is full.",
		"Once the paper is removed from the output tray, the machine resumes printing.",
		"The machine selects print materials from the wrong paper source.",
		"The paper option that was selected in the ",
		" may be incorrect.",
		"For many software applications, the paper source selection is found under the ",
		"Paper",
		" tab within the ",
		" (see ",
		"Opening printing preferences",
		"). Select the correct paper source. See the printer driver help screen (see ",
		"Using help",
		"A print job is extremely slow.",
		"The job may be very complex.",
		"Reduce the complexity of the page or try adjusting the print quality settings.",
		"Half the page is blank.",
		"The page orientation setting may be incorrect.",
		"Change the page orientation in your application (see ",
		"). See the printer driver help screen (see ",
		"The paper size and the paper size settings do not match.",
		"Ensure that the paper size in the printer driver settings matches the paper in the tray.Or, ensure that the paper size in the printer driver settings matches the paper selection in the software application settings you use (see ",
		"The machine prints, but the text is wrong, garbled, or incomplete.",
		"The machine cable is loose or defective.",
		"Disconnect the machine cable and reconnect. Try a print job that you have already printed successfully. If possible, attach the cable and the machine to another computer that you know works and try a print job. Finally, try a new machine cable.",
		"The wrong printer driver was selected.",
		"Check the application’s printer selection menu to ensure that your machine is selected.",
		"The software application is malfunctioning.",
		"Try printing a job from another application.",
		"The operating system is malfunctioning.",
		"Exit Windows and reboot the computer. Turn the machine off and back on again.",
		"Pages print, but they are blank.",
		"The toner cartridge is defective or out of toner.",
		"Redistribute the toner, if necessary. If necessary, replace the toner cartridge.",
		"See ",
		"Redistributing toner",
		".",
		"The file may have blank pages.",
		"Check the file to ensure that it does not contain blank pages.",
		"Some parts, such as the controller or the board, may be defective.",
		"Contact a service representative.",
		"The machine does not print PDF files correctly. Some parts of graphics, text, or illustrations are missing.",
		"Incompatibility between the PDF file and the Acrobat products.",
		"Printing the PDF file as an image may enable the file to print. Turn on ",
		"Print As Image",
		" from the Acrobat printing options. ",
		"It will take longer to print when you print a PDF file as an image.",
		"The print quality of photos is not good. Images are not clear.",
		"The resolution of the photo is very low. ",
		"Reduce the photo size. If you increase the photo size in the software application, the resolution will be reduced. ",
		"Before printing, the machine emits vapor near the output tray.",
		"Using damp paper can cause vapor during printing.",
		"This is not a problem. Just keep printing.",
		"The machine does not print special-sized paper, such as billing paper.",
		"Paper size and paper size setting do not match.",
		"Set the correct paper size in the ",
		"Custom",
		" in ",
		" tab in ",
		"The printed billing paper is curled.",
		"The paper type setting does not match.",
		"Change the printer option and try again. Go to ",
		", click ",
		" tab, and set type to ",
		"Thick"
	],
	"43_1|71_5|75_3": [
		"Printing quality problems",
		" > ",
		"Advanced",
		"Troubleshooting",
		"If the inside of the machine is dirty or paper has been loaded improperly, there might be a reduction in print quality. See the table below to clear the problem. ",
		"Condition",
		"Suggested solutions",
		"Light or faded print",
		"If a vertical white streak or faded area appears on the page, the toner supply is low. Install a new toner cartridge (see ",
		"Replacing the toner cartridge",
		").",
		"If a vertical white streak or faded area still appears on the page even though the machine has enough toner supply, open and close the front door 3 ~ 4 times (see ",
		"Machine overview",
		"The paper may not meet paper specifications; for example, the paper may be too moist or rough.",
		"If the entire page is light, the print resolution setting is too low or the toner save mode is on. Adjust the print resolution and turn the toner save mode off. See the help screen of the printer driver.",
		"A combination of faded or smeared defects may indicate that the toner cartridge needs cleaning. Clean the inside of your machine (see ",
		"Cleaning the machine",
		"The surface of the LSU part inside the machine may be dirty. Clean the inside of your machine (see ",
		"). If these steps do not correct the problem, contact a service representative.",
		"The top half of the paper is printed lighter than the rest of the paper",
		"The toner might not adhere properly to this type of paper.",
		"Change the printer option and try again. Go to ",
		"Printing Preferences",
		", click the ",
		"Paper",
		" tab, and set the paper type to ",
		"Recycled",
		" (see ",
		"Opening printing preferences",
		"Toner specks",
		"The paper may not meet specifications; for example, the paper may be too moist or rough.",
		"The transfer roller may be dirty. Clean the inside of your machine (see ",
		"The paper path may need cleaning. Contact a service representative (see ",
		"Dropouts",
		"If faded areas, generally rounded, occur randomly on the page:",
		"A single sheet of paper may be defective. Try reprinting the job.",
		"The moisture content of the paper is uneven or the paper has moist spots on its surface. Try a different brand of paper.",
		"The paper lot is bad. The manufacturing processes can cause some areas to reject toner. Try a different kind or brand of paper.",
		" tab, and set type to ",
		"Thick",
		"If these steps do not correct the problem, contact a service representative.",
		"White Spots ",
		"If white spots appear on the page:",
		"The paper is too rough and a lot of dirt from paper falls to the inner components within the machine, so the transfer roller may be dirty. Clean the inside of your machine (see ",
		"The paper path may need cleaning. Clean the inside of your machine (see ",
		"Vertical lines",
		"If black vertical streaks appear on the page:",
		"The surface (drum part) of the imaging unit inside the machine has probably been scratched. Remove the imaging unit and install a new one (see ",
		"Replacing the imaging unit",
		"If white vertical streaks appear on the page:",
		"Black or color background",
		"If the amount of background shading becomes unacceptable:",
		"Change to a lighter weight paper.",
		"Check the environmental conditions: very dry conditions or a high level of humidity (higher than 80% RH) can increase the amount of background shading.",
		"Remove the old imaging unit and install a new one (see ",
		"Thoroughly redistribute the toner (see ",
		"Redistributing toner",
		"Toner smear",
		"Clean the inside of the machine (see ",
		"Check the paper type and quality.",
		"Remove the imaging unit and install a new one (see ",
		"Vertical repetitive defects",
		"If marks repeatedly appear on the printed side of the page at even intervals:",
		"The imaging unit may be damaged. If you still have the same problem, remove the imaging unit and, install a new one (see ",
		"Parts of the machine may have toner on them. If the defects occur on the back of the page, the problem will likely correct itself after a few more pages.",
		"The fusing assembly may be damaged. Contact a service representative.",
		"Background scatter",
		"Background scatter results from bits of toner randomly distributed on the printed page. ",
		"The paper may be too damp. Try printing with a different batch of paper. Do not open packages of paper until necessary so that the paper does not absorb too much moisture.",
		"If background scatter covers the entire surface area of a printed page, adjust the print resolution through your software application or in ",
		"). Ensure the correct paper type is selected. For example: If Thicker Paper is selected, but Plain Paper actually used, an overcharging can occur causing this copy quality problem.",
		"If you are using a new toner cartridge, redistribute the toner first (see ",
		"Toner particles are around bold characters or pictures",
		"Ensure the correct paper type is selected. For example: If Thicker Paper is selected, but Plain Paper actually used, an overcharging can occur causing this copy quality problem.",
		"Misformed characters",
		"If characters are improperly formed and producing hollow images, the paper stock may be too slick. Try different paper.",
		"Page skew",
		"Ensure that the paper is loaded properly.",
		"Ensure that the guides are not too tight or too loose against the paper stack.",
		"Curl or wave",
		"Check the paper type and quality. Both high temperature and humidity can cause paper curl.",
		"Turn the stack of paper over in the tray. Also try rotating the paper 180° in the tray.",
		"Wrinkles or creases",
		"Back of printouts are dirty",
		"Check for leaking toner. Clean the inside of the machine (see ",
		"Solid color or black pages",
		"The imaging unit may not be installed properly. Remove the imaging unit and reinsert it.",
		"The imaging unit may be defective. Remove the imaging unit and install a new one (see ",
		"The machine may require repairing. Contact a service representative.",
		"Loose toner",
		"Remove the imaging unit and then, install a new one (see ",
		"If the problem persists, the machine may require repair. Contact a service representative.",
		"Character voids",
		"Character voids are white areas within parts of characters that should be solid black:",
		"You may be printing on the wrong surface of the paper. Remove the paper and turn it around. ",
		"The paper may not meet paper specifications.",
		"Horizontal stripes",
		"If horizontally aligned black streaks or smears appear:",
		"The imaging unit may be installed improperly. Remove the imaging unit and reinsert it.",
		"If the problem persists, the machine may require repairing. Contact a service representative.",
		"Curl",
		"If the printed paper is curled or paper does not feed into the machine:",
		"Turn the stack of paper over in the tray. Also try rotating the paper 180° in the tray. ",
		"Change the printer’s paper option and try again. Go to ",
		"Thin",
		"An unknown image repetitively appears on a few sheets",
		"Light print or contamination occurs",
		"Your machine is probably being used at an altitude of 1,000 m (3,281 ft) or above.The high altitude may affect the print quality, such as loose toner or light imaging. Change the altitude setting for your machine (see ",
		"Altitude adjustment"
	],
	"43_1|71_5|76_4": [
		"Copying problems",
		" > ",
		"Advanced",
		"Troubleshooting",
		"Condition",
		"Suggested solutions",
		"Copies are too light or too dark.",
		"Adjust the darkness in copy feature to lighten or darken the backgrounds of copies (see ",
		"Changing the settings for each copy",
		").",
		"Smears, lines, marks, or spots appear on copies.",
		"If the defects are on the original, adjust darkness in copy feature to lighten the background of your copies.",
		"Adjust background in copy setup removes the background color (see ",
		"If there are no defects on the original, clean the scan unit (see ",
		"Cleaning the scan unit",
		"Copy image is skewed.",
		"Ensure that the original is aligned with the registration guide.",
		"The transfer roller may be dirty. Clean the inside of your machine (see ",
		"Cleaning the machine",
		"Blank copies print out.",
		"Ensure that the original is face down on the scanner glass.",
		"If these steps do not correct the problem, contact a service representative.",
		"Image rubs off the copy easily.",
		"Replace the paper in the tray with paper from a new package.",
		"In high humidity areas, do not leave paper in the machine for extended periods of time.",
		"Frequent copy paper jams occur.",
		"Fan the paper, then turn it over in the tray. Replace the paper in the tray with a fresh supply. Check/adjust the paper guides, if necessary.",
		"Ensure that the paper is the proper type and weight (see ",
		"Print media specifications ",
		"Check for copy paper or pieces of copy paper remaining in the machine after a paper jam has been cleared.",
		"Toner cartridge produces fewer copies than expected before running out of toner.",
		"Your originals may contain pictures, solids, or heavy lines. For example, your originals may be forms, newsletters, books, or other documents that use more toner.",
		"The scanner lid may be left open while copies are being made.",
		"Turn the machine off and back on."
	],
	"43_1|71_5|77_5": [
		"Scanning problems",
		" > ",
		"Advanced",
		"Troubleshooting",
		"Condition",
		"Suggested solutions",
		"The scanner does not work.",
		"Make sure that you place the original to be scanned face down on the scanner glass (see ",
		"Loading originals",
		").",
		"There may not be enough available memory to hold the document you want to scan. Try the Prescan function to see if that works. Try lowering the scan resolution rate.",
		"Check that the machine printer cable is connected properly.",
		"Make sure that the machine printer cable is not defective. Switch the printer cable with a known good cable. If necessary, replace the printer cable.",
		"Check that the scanner is configured correctly. Check scan setting in the ",
		"Easy Document Creator",
		" or the application you want to use to make certain that the scanner job is being sent to the correct port (for example, USB001).",
		"The unit scans very slowly.",
		"Check if the machine is printing received data. If so, scan the document after the received data has been printed.",
		"Graphics are scanned more slowly than text.",
		"Message appears on your computer screen:",
		"Device can’t be set to the H/W mode you want.",
		"Port is being used by another program.",
		"Port is disabled.",
		"Scanner is busy receiving or printing data. When the current job is completed, try again.",
		"Invalid handle.",
		"Scanning has failed.",
		"There may be a copying or printing job in progress. Try your job again when that job is finished.",
		"The selected port is currently being used. Restart your computer and try again.",
		"The machine printer cable may be improperly connected or the power may be off.",
		"The scanner driver is not installed or the operating environment is not set up properly.",
		"Ensure that the machine is properly connected and the power is on, then restart your computer.",
		"The USB cable may be improperly connected or the power may be off."
	],
	"43_1|71_5|78_6": [
		"Operating system problems",
		" > ",
		"Advanced",
		"Troubleshooting",
		"Common Windows problems",
		"Condition",
		"Suggested solutions",
		"“File in Use” message appears during installation.",
		"Exit all software applications. Remove all software from the startup group, then restart Windows. Reinstall the printer driver.",
		"“General Protection Fault”, “Exception OE”, “Spool 32”, or “Illegal Operation” messages appear.",
		"Close all other applications, reboot Windows and try printing again.",
		"“Fail To Print”, “A printer timeout error occurred” message appear.",
		"These messages may appear during printing. Just keep waiting until the machine finishes printing. If the message appears in ready mode or after printing has completed, check the connection and/or whether an error has occurred.",
		"Machine information is not displayed when you click the device in the ",
		"Devices and Printers",
		".",
		"Check the ",
		"Printer properties",
		". Click the ",
		"Ports",
		" tab.",
		"(",
		"Control Panel",
		" > Right-click on your printer icon and select ",
		")",
		"If the port is set to File or LPT, uncheck them and select TCP/IP, USB, or WSD.",
		"Refer to the Microsoft Windows User’s Guide that came with your computer for further information on Windows error messages.",
		"Common Mac problems",
		"The machine does not print PDF files correctly. Some parts of graphics, text, or illustrations are missing.",
		"Printing the PDF file as an image may enable the file to print. Turn on ",
		"Print As Image",
		" from the Acrobat printing options. ",
		"It will take longer to print when you print a PDF file as an image.",
		"Some letters are not displayed normally during cover page printing.",
		"Mac OS cannot create the font while printing the cover page. The English alphabet and numbers are displayed normally on the cover page.",
		"When printing a document in Mac with Acrobat Reader 6.0 or higher, colors print incorrectly.",
		"Make sure that the resolution setting in your machine driver matches the one in Acrobat Reader.",
		"Refer to the Mac User’s Guide that came with your computer for further information on Mac error messages.",
		"Common Linux problems",
		"There is no xsane nor simple-scan application on my Linux machine.",
		"For some Linux distributions, there might be no default scan application. To use scan features, install one of scan applications using download center supplied by the OS(ex. Ubuntu Software Center for Ubuntu, Install/Remove Software for openSUSE, Software for Fedora).",
		"Scanner can not be found via network.",
		"For some Linux distributions, strong firewall is enabled and it may block our installer from opening the necessary port for searching network devices. In such a case, open the snmp port - 22161 manually or disable the firewall temporarily while using the device.",
		"When printing more than one copy, the second copy does not print. ",
		"The problem occurs on Ubuntu 12.04 due to the problem in standard CUPS filter 'pdftops'. Update 'cups-filters' package to version 1.0.18 to fix the problem ('pdftops' is a part of 'cups-filters' package).",
		"Unchecking the collate option in the Print Dialog does not work.",
		"For some distributions, GNOME Print Dialog has an issue handling the collate option. As workaround, set the default value of collate option to ",
		"False",
		" using the system's printing utility(execute \"system-config-printer\" in the Terminal program).",
		"Printing always works with duplex.",
		"This duplex issue was in Ubuntu 9.10 CUPS package. Update CUPS version to 1.4.1-5ubuntu2.2.",
		"Printer is not added through system's printing utility.",
		"The problem occurs on Debian 7 due to the defect in 'system-config-printer' package of the Debian 7 (",
		"http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=662813",
		" in Debian bug tracking system). Please use another way to add printer (CUPS WebUI for example)",
		"Paper size and orientation are disabled in the Print Dialog when opening text files.",
		"The problem occurs on Fedora 19 and it's related to 'leafpad' text editor on Fedora 19. Please use other text editors like 'gedit'.",
		"Printing produces divided images.",
		" This issue exists in openSUSE 13.2 due to wrong ghostscript provided by the system. Update 'cups-filters-ghostscript' package with the command \"zypper install --force cups-filters-ghostscript\" or with \"Install/Remove Software\" utility.",
		"Refer to the Linux User’s Guide that came with your computer for further information on Linux error messages."
	],
	"79_2": [
		"Glossary",
		" > ",
		"The following glossary helps you get familiar with the product by understanding the terminologies commonly used with printing as well as mentioned in this user’s guide.",
		"802.11",
		"802.11 is a set of standards for wireless local area network (WLAN) communication, developed by the IEEE LAN/MAN Standards Committee (IEEE 802). ",
		"802.11b/g/n",
		"802.11b/g/n can share same hardware and use the 2.4 GHz band. 802.11b supports bandwidth up to 11 Mbps, 802.11n supports bandwidth up to 150 Mbps. 802.11b/g/n devices may occasionally suffer interference from microwave ovens, cordless telephones, and Bluetooth devices.",
		"Access point",
		"Access Point or Wireless Access Point (AP or WAP) is a device that connects wireless communication devices together on wireless local area networks (WLAN), and acts as a central transmitter and receiver of WLAN radio signals. ",
		"ADF",
		"An Automatic Document Feeder (ADF) is a scanning unit that will automatically feed an original sheet of paper so that the machine can scan some amount of the paper at once. ",
		"AppleTalk",
		"AppleTalk is a proprietary suite of protocols developed by Apple, Inc for computer networking. It was included in the original Mac (1984) and is now deprecated by Apple in favor of TCP/IP networking.",
		"BIT Depth",
		"A computer graphics term describing the number of bits used to represent the color of a single pixel in a bitmapped image. Higher color depth gives a broader range of distinct colors. As the number of bits increases, the number of possible colors becomes impractically large for a color map. 1-bit color is commonly called as monochrome or black and white.",
		"BMP",
		"A bitmapped graphics format used internally by the Microsoft Windows graphics subsystem (GDI), and used commonly as a simple graphics file format on that platform.",
		"BOOTP",
		"Bootstrap Protocol. A network protocol used by a network client to obtain its IP address automatically. This is usually done in the bootstrap process of computers or operating systems running on them. The BOOTP servers assign the IP address from a pool of addresses to each client. BOOTP enables 'diskless workstation' computers to obtain an IP address prior to loading any advanced operating system.",
		"CCD",
		"Charge Coupled Device (CCD) is a hardware which enables the scan job. CCD Locking mechanism is also used to hold the CCD module to prevent any damage when you move the machine.",
		"Collation",
		"Collation is a process of printing a multiple-copy job in sets. When collation is selected, the device prints an entire set before printing additional copies.",
		"Control Panel",
		"A control panel is a flat, typically vertical, area where control or monitoring instruments are displayed. They are typically found in front of the machine. ",
		"Coverage",
		"It is the printing term used for a toner usage measurement on printing. For example, 5% coverage means that an A4 sided paper has about 5% image or text on it. So, if the paper or original has complicated images or lots of text on it, the coverage will be higher and at the same time, a toner usage will be as much as the coverage.",
		"CSV",
		"Comma Separated Values (CSV). A type of file format, CSV is used to exchange data between disparate applications. The file format, as it is used in Microsoft Excel, has become a de facto standard throughout the industry, even among non-Microsoft platforms.",
		"DADF",
		"A Duplex Automatic Document Feeder (DADF) is a scanning unit that will automatically feed and turn over an original sheet of paper so that the machine can scan on both sides of the paper.",
		"Default",
		"The value or setting that is in effect when taking a printer out of its box state, reset, or initialized.",
		"DHCP",
		"A Dynamic Host Configuration Protocol (DHCP) is a client-server networking protocol. A DHCP server provides configuration parameters specific to the DHCP client host requesting, generally, information required by the client host to participate on an IP network. DHCP also provides a mechanism for allocation of IP addresses to client hosts.",
		"DIMM",
		"Dual Inline Memory Module (DIMM), a small circuit board that holds memory. DIMM stores all the data within the machine like printing data, received fax data.",
		"DLNA",
		"The Digital Living Network Alliance (DLNA) is a standard that allows devices on a home network to share information with each other across the network.",
		"DNS",
		"The Domain Name Server (DNS) is a system that stores information associated with domain names in a distributed database on networks, such as the Internet.",
		"Dot Matrix Printer",
		"A dot matrix printer refers to a type of computer printer with a print head that runs back and forth on the page and prints by impact, striking an ink-soaked cloth ribbon against the paper, much like a typewriter.",
		"DPI",
		"Dots Per Inch (DPI) is a measurement of resolution that is used for scanning and printing. Generally, higher DPI results in a higher resolution, more visible detail in the image, and a larger file size.",
		"DRPD ",
		"Distinctive Ring Pattern Detection. Distinctive Ring is a telephone company service which enables a user to use a single telephone line to answer several different telephone numbers.",
		"Duplex",
		"A mechanism that will automatically turn over a sheet of paper so that the machine can print (or scan) on both sides of the paper. A printer equipped with a Duplex Unit can print on both sides of paper during one print cycle.",
		"Duty Cycle",
		"Duty cycle is the page quantity which does not affect printer performance for a month. Generally the printer has the lifespan limitation such as pages per year. The lifespan means the average capacity of print-outs, usually within the warranty period. For example, if the duty cycle is 48,000 pages per month assuming 20 working days, a printer limits 2,400 pages a day.",
		"ECM",
		"Error Correction Mode (ECM) is an optional transmission mode built into Class 1 fax machines or fax modems. It automatically detects and corrects errors in the fax transmission process that are sometimes caused by telephone line noise.",
		"Emulation",
		"Emulation is a technique of one machine obtaining the same results as another.",
		"An emulator duplicates the functions of one system with a different system, so that the second system behaves like the first system. Emulation focuses on exact reproduction of external behavior, which is in contrast to simulation, which concerns an abstract model of the system being simulated, often considering its internal state.",
		"Ethernet",
		"Ethernet is a frame-based computer networking technology for local area networks (LANs). It defines wiring and signaling for the physical layer, and frame formats and protocols for the media access control (MAC)/data link layer of the OSI model. Ethernet is mostly standardized as IEEE 802.3. It has become the most widespread LAN technology in use during the 1990s to the present.",
		"EtherTalk",
		"A suite of protocols developed by Apple Computer for computer networking. It was included in the original Mac (1984) and is now deprecated by Apple in favor of TCP/IP networking. ",
		"FDI",
		"Foreign Device Interface (FDI) is a card installed inside the machine to allow a third party device such as a coin operated device or a card reader. Those devices allow the pay-for-print service on your machine.",
		"FTP",
		"A File Transfer Protocol (FTP) is a commonly used protocol for exchanging files over any network that supports the TCP/IP protocol (such as the Internet or an intranet).",
		"Fuser Unit ",
		"The part of a laser printer that fuses the toner onto the print media. It consists of a heat roller and a pressure roller. After toner is transferred onto the paper, the fuser unit applies heat and pressure to ensure that the toner stays on the paper permanently, which is why paper is warm when it comes out of a laser printer.",
		"Gateway",
		"A connection between computer networks, or between a computer network and a telephone line. It is very popular, as it is a computer or a network that allows access to another computer or network.",
		"Grayscale",
		"A shade of gray that represents light and dark portions of an image when color images are converted to grayscale; colors are represented by various shades of gray.",
		"Halftone",
		"An image type that simulates grayscale by varying the number of dots. Highly colored areas consist of a large number of dots, while lighter areas consist of a smaller number of dots.",
		"Mass storage device (HDD)",
		"Mass storage device (HDD), commonly referred to as a hard drive or hard disk, is a non-volatile storage device which stores digitally-encoded data on rapidly rotating platters with magnetic surfaces.",
		"IEEE",
		"The Institute of Electrical and Electronics Engineers (IEEE) is an international non-profit, professional organization for the advancement of technology related to electricity.",
		"IEEE 1284",
		"The 1284 parallel port standard was developed by the Institute of Electrical and Electronics Engineers (IEEE). The term \"1284-B\" refers to a specific connector type on the end of the parallel cable that attaches to the peripheral (for example, a printer). ",
		"Intranet",
		"A private network that uses Internet Protocols, network connectivity, and possibly the public telecommunication system to securely share part of an organization's information or operations with its employees. Sometimes the term refers only to the most visible service, the internal website.",
		"IP address",
		"An Internet Protocol (IP) address is a unique number that devices use in order to identify and communicate with each other on a network utilizing the Internet Protocol standard.",
		"IPM",
		"The Images Per Minute (IPM) is a way of measuring the speed of a printer. An IPM rate indicates the number of single-sided sheets a printer can complete within one minute.",
		"IPP",
		"The Internet Printing Protocol (IPP) defines a standard protocol for printing as well as managing print jobs, media size, resolution, and so forth. IPP can be used locally or over the Internet to hundreds of printers, and also supports access control, authentication, and encryption, making it a much more capable and secure printing solution than older ones.",
		"IPX/SPX",
		"IPX/SPX stands for Internet Packet Exchange/Sequenced Packet Exchange. It is a networking protocol used by the Novell NetWare operating systems. IPX and SPX both provide connection services similar to TCP/IP, with the IPX protocol having similarities to IP, and SPX having similarities to TCP. IPX/SPX was primarily designed for local area networks (LANs), and is a very efficient protocol for this purpose (typically its performance exceeds that of TCP/IP on a LAN).",
		"ISO",
		"The International Organization for Standardization (ISO) is an international standard-setting body composed of representatives from national standards bodies. It produces world-wide industrial and commercial standards.",
		"ITU-T",
		"The International Telecommunication Union is an international organization established to standardize and regulate international radio and telecommunications. Its main tasks include standardization, allocation of the radio spectrum, and organizing interconnection arrangements between different countries to allow international phone calls. A -T out of ITU-T indicates telecommunication.",
		"ITU-T No. 1 chart",
		"Standardized test chart published by ITU-T for document facsimile transmissions.",
		"JBIG",
		"Joint Bi-level Image Experts Group (JBIG) is an image compression standard with no loss of accuracy or quality, which was designed for compression of binary images, particularly for faxes, but can also be used on other images.",
		"JPEG",
		"Joint Photographic Experts Group (JPEG) is a most commonly used standard method of lossy compression for photographic images. It is the format used for storing and transmitting photographs on the World Wide Web.",
		"LDAP",
		"The Lightweight Directory Access Protocol (LDAP) is a networking protocol for querying and modifying directory services running over TCP/IP.",
		"LED",
		"A Light-Emitting Diode (LED) is a semiconductor device that indicates the status of a machine.",
		"MAC address",
		"Media Access Control (MAC) address is a unique identifier associated with a network adapter. MAC address is a unique 48-bit identifier usually written as 12 hexadecimal characters grouped in pairs (e. g., 00-00-0c-34-11-4e). This address is usually hard-coded into a Network Interface Card (NIC) by its manufacturer, and used as an aid for routers trying to locate machines on large networks.",
		"MFP",
		"Multi Function Peripheral (MFP) is an office machine that includes the following functionality in one physical body, so as to have a printer, a copier, a fax, a scanner and etc.",
		"MH",
		"Modified Huffman (MH) is a compression method for decreasing the amount of data that needs to be transmitted between the fax machines to transfer the image recommended by ITU-T T.4. MH is a codebook-based run-length encoding scheme optimized to efficiently compress white space. As most faxes consist mostly of white space, this minimizes the transmission time of most faxes. ",
		"MMR",
		"Modified Modified READ (MMR) is a compression method recommended by ITU-T T.6.",
		"Modem",
		"A device that modulates a carrier signal to encode digital information, and also demodulates such a carrier signal to decode transmitted information.",
		"MR",
		"Modified Read (MR) is a compression method recommended by ITU-T T.4. MR encodes the first scanned line using MH. The next line is compared to the first, the differences determined, and then the differences are encoded and transmitted.",
		"NetWare",
		"A network operating system developed by Novell, Inc. It initially used cooperative multitasking to run various services on a PC, and the network protocols were based on the archetypal Xerox XNS stack. Today NetWare supports TCP/IP as well as IPX/SPX.",
		"OPC",
		"Organic Photo Conductor (OPC) is a mechanism that makes a virtual image for print using a laser beam emitted from a laser printer, and it is usually green or rust colored and has a cylinder shape. ",
		"An imaging unit containing a drum slowly wears the drum surface by its usage in the printer, and it should be replaced appropriately since it gets worn from contact with the cartridge development brush, cleaning mechanism, and paper.",
		"Originals",
		"The first example of something, such as a document, photograph or text, etc, which is copied, reproduced or translated to produce others, but which is not itself copied or derived from something else.",
		"OSI",
		"Open Systems Interconnection (OSI) is a model developed by the International Organization for Standardization (ISO) for communications. OSI offers a standard, modular approach to network design that divides the required set of complex functions into manageable, self-contained, functional layers. The layers are, from top to bottom, Application, Presentation, Session, Transport, Network, Data Link and Physical.",
		"PABX ",
		"A private automatic branch exchange (PABX) is an automatic telephone switching system within a private enterprise.",
		"PCL",
		"Printer Command Language (PCL) is a Page Description Language (PDL) developed by HP as a printer protocol and has become an industry standard. Originally developed for early inkjet printers, PCL has been released in varying levels for thermal, dot matrix printer, and laser printers.",
		"PDF",
		"Portable Document Format (PDF) is a proprietary file format developed by Adobe Systems for representing two dimensional documents in a device independent and resolution independent format.",
		"PostScript",
		"PostScript (PS) is a page description language and programming language used primarily in the electronic and desktop publishing areas. - that is run in an interpreter to generate an image.",
		"Printer Driver",
		"A program used to send commands and transfer data from the computer to the printer.",
		"Print Media",
		"The media like paper, labels, and transparencies which can be used in a printer, a scanner, a fax or, a copier.",
		"PPM",
		"Pages Per Minute (PPM) is a method of measurement for determining how fast a printer works, meaning the number of pages a printer can produce in one minute.",
		"PRN file",
		"An interface for a device driver, this allows software to interact with the device driver using standard input/output system calls, which simplifies many tasks. ",
		"Protocol",
		"A convention or standard that controls or enables the connection, communication, and data transfer between two computing endpoints.",
		"PS",
		"See PostScript.",
		"PSTN",
		"The Public-Switched Telephone Network (PSTN) is the network of the world's public circuit-switched telephone networks which, on industrial premises, is usually routed through the switchboard.",
		"RADIUS",
		"Remote Authentication Dial In User Service (RADIUS) is a protocol for remote user authentication and accounting. RADIUS enables centralized management of authentication data such as usernames and passwords using an AAA (authentication, authorization, and accounting) concept to manage network access.",
		"Resolution",
		"The sharpness of an image, measured in Dots Per Inch (DPI). The higher the dpi, the greater the resolution.",
		"SMB",
		"Server Message Block (SMB) is a network protocol mainly applied to share files, printers, serial ports, and miscellaneous communications between nodes on a network. It also provides an authenticated Inter-process communication mechanism.",
		"SMTP",
		"Simple Mail Transfer Protocol (SMTP) is the standard for e-mail transmissions across the Internet. SMTP is a relatively simple, text-based protocol, where one or more recipients of a message are specified, and then the message text is transferred. It is a client-server protocol, where the client transmits an email message to the server.",
		"SSID",
		"Service Set Identifier (SSID) is a name of a wireless local area network (WLAN). All wireless devices in a WLAN use the same SSID in order to communicate with each other. The SSIDs are case-sensitive and have a maximum length of 32 characters.",
		"Subnet Mask ",
		"The subnet mask is used in conjunction with the network address to determine which part of the address is the network address and which part is the host address.",
		"TCP/IP",
		"The Transmission Control Protocol (TCP) and the Internet Protocol (IP); the set of communications protocols that implement the protocol stack on which the Internet and most commercial networks run.",
		"TCR",
		"Transmission Confirmation Report (TCR) provides details of each transmission such as job status, transmission result and number of pages sent. This report can be set to print after each job or only after failed transmissions.",
		"TIFF",
		"Tagged Image File Format (TIFF) is a variable-resolution bitmapped image format. TIFF describes image data that typically come from scanners. TIFF images make use of tags, keywords defining the characteristics of the image that is included in the file. This flexible and platform-independent format can be used for pictures that have been made by various image processing applications.",
		"Toner Cartridge",
		"A kind of bottle or container used in a machine like a printer which contains toner. Toner is a powder used in laser printers and photocopiers, which forms the text and images on the printed paper. Toner can be fused by a combination of heat/pressure from the fuser, causing it to bind to the fibers in the paper.",
		"TWAIN",
		"An industry standard for scanners and software. By using a TWAIN-compliant scanner with a TWAIN-compliant program, a scan can be initiated from within the program. It is an image capture API for Microsoft Windows and Apple Mac operating systems.",
		"UNC Path",
		"Uniform Naming Convention (UNC) is a standard way to access network shares in Window NT and other Microsoft products. The format of a UNC path is: \\\\<servername>\\<sharename>\\<Additional directory>",
		"URL",
		"Uniform Resource Locator (URL) is the global address of documents and resources on the Internet. The first part of the address indicates what protocol to use, the second part specifies the IP address or the domain name where the resource is located.",
		"USB",
		"Universal Serial Bus (USB) is a standard that was developed by the USB Implementers Forum, Inc., to connect computers and peripherals. Unlike the parallel port, USB is designed to concurrently connect a single computer USB port to multiple peripherals.",
		"Watermark",
		"A watermark is a recognizable image or pattern in paper that appears lighter when viewed by transmitted light. Watermarks were first introduced in Bologna, Italy in 1282; they have been used by papermakers to identify their product, and also on postage stamps, currency, and other government documents to discourage counterfeiting.",
		"WEP",
		"Wired Equivalent Privacy (WEP) is a security protocol specified in IEEE 802.11 to provide the same level of security as that of a wired LAN. WEP provides security by encrypting data over radio so that it is protected as it is transmitted from one end point to another.",
		"WIA",
		"Windows Imaging Architecture (WIA) is an imaging architecture that is originally introduced in Windows Me and Windows XP Service Pack 3. A scan can be initiated from within these operating systems by using a WIA-compliant scanner.",
		"WPA",
		"Wi-Fi Protected Access (WPA) is a class of systems to secure wireless (Wi-Fi) computer networks, which was created to improve upon the security features of WEP.",
		"WPA-PSK",
		"WPA-PSK (WPA Pre-Shared Key) is special mode of WPA for small business or home users. A shared key, or password, is configured in the wireless access point (WAP) and any wireless laptop or desktop devices. WPA-PSK generates a unique key for each session between a wireless client and the associated WAP for more advanced security.",
		"WPS",
		"The Wi-Fi Protected Setup (WPS) is a standard for establishing a wireless home network. If your wireless access point supports WPS, you can configure the wireless network connection easily without a computer.",
		"XPS",
		"XML Paper Specification (XPS) is a specification for a Page Description Language (PDL) and a new document format, which has benefits for portable document and electronic document, developed by Microsoft. It is an XML-based specification, based on a new print path and a vector-based device-independent document format."
	]
}