// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler src1 : register(s0);
sampler src2 : register(s2);
float4 srcSize : register(c0);  // width, height, 1/width, 1/height

float4 main(float2 tex : TEXCOORD0) : COLOR0
{
  int par = round(frac(tex.x * srcSize.x));
  float2 pos = float2((floor(tex.x * srcSize.x) + 0.5) * srcSize.z, tex.y);
  if (par == 0)
    return tex2D(src1, pos);
  else
    return tex2D(src2, pos);
}
