// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  axrar_arcman.cxx
// ----------------------------------------------------------------------------

#ifndef axrar_arcman_cxx__
#define axrar_arcman_cxx__


// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "axrar_callback.cxx"
#include "util.h"


// ----------------------------------------------------------------------------
//  A[JCu
// ----------------------------------------------------------------------------

class rar_arc_manager
{
  rar_archive  m_arc;
  axrar_unrar_callback  m_callback;
  bool  m_skipped;
  int  m_file_num;

  static int is_directory(int flags)
  {
    return (0xe0 == (flags & 0xe0));
  }

  int open_archive(const char *arc_name, int open_mode)
  {
    int  ret = m_arc.open(arc_name, open_mode);
    if (0 == ret)
    {
      m_arc.set_callback(&m_callback);
      m_file_num = 0;
      m_skipped = true;
    }
    return ret;
  }

public:
  rar_arc_manager(void) { }
  ~rar_arc_manager() { close_archive(); }

  int open_archive_list(const char *arc_name)
  {
    return open_archive(arc_name, RAR_OM_LIST);
  }

  int open_archive_extract(const char *arc_name)
  {
    return open_archive(arc_name, RAR_OM_EXTRACT);
  }

  void close_archive(void)
  {
    m_arc.close();
  }

  int get_next_fileinfo(fileInfo *fi)
  {
    if (!m_skipped)
      m_arc.process_file(RAR_SKIP, NULL, NULL);

    int  ret;
    RARHeaderData  hdr;
    while (0 == (ret = m_arc.read_header(&hdr)))
    {
      if (!is_directory(hdr.Flags))
      {
        m_skipped = false;
        break;
      }
      m_arc.process_file(RAR_SKIP, NULL, NULL);
    }

    if (0 == ret)
    {
      if (NULL != fi)
      {
        static const char *METHOD_STR[6] =
          { "store", "fastest", "fast", "normal", "good", "best" };

        if (0x30 <= hdr.Method && hdr.Method <= 0x35)
          strncpy(fi->method, METHOD_STR[hdr.Method - 0x30], 8);
        else
          strncpy(fi->method, "unknown", 8);
        fi->method[7] = '\0';

        fi->position = m_file_num;
        fi->compsize = hdr.PackSize;
        fi->filesize = hdr.UnpSize;
        fi->timestamp = dosdatetime_to_time_t(hdr.FileTime);

        fi->path[0] = fi->filename[0] = '\0';
        split_filepath(hdr.FileName, fi->path, 200, fi->filename, 200);

        fi->crc = hdr.FileCRC;
      }

      m_file_num++;
    }

    return ret;
  }

  int extract(uint8 *buf, size_t buf_size, spi_callback *spicb)
  {
    m_callback.set_buf(buf, buf_size);
    m_callback.set_spi_callback(spicb);

    int  ret = m_arc.process_file(RAR_TEST, NULL, NULL);
    m_skipped = true;

    return ret;
  }

  static int is_rar(const uint8 *data)
  {
    static const uint8  RAR_SIGNATURE[] = { 0x52, 0x61, 0x72, 0x21, 0x1a, 0x07, 0x00 };
    if (NULL == data)
      return 0;
    else
      return !memcmp(data, RAR_SIGNATURE, sizeof(RAR_SIGNATURE));
  }

  static int is_rar_sfx(HANDLE fh)
  {
    if (INVALID_HANDLE_VALUE == fh)
      return 0;

    uint32  sfx_module_size = get_exe_size(fh);
    if (uint32(-1) == sfx_module_size)
      return 0;

    SetFilePointer(fh, sfx_module_size, NULL, FILE_BEGIN);

    DWORD  read_bytes;
    uint8  buf[16];
    ReadFile(fh, buf, 16, &read_bytes, NULL);

    return is_rar(buf);
  }
};


#endif // axrar_arcman_cxx__
