// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  axrar_callback.cxx
// ----------------------------------------------------------------------------

#ifndef axrar_callback_cxx__
#define axrar_callback_cxx__

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "rar_arc.h"
#include "axrar_dialog.cxx"
#include "spi_callback.cxx"


// ----------------------------------------------------------------------------
//  axrar.spi p unrar R[obN
// ----------------------------------------------------------------------------

class axrar_unrar_callback : public unrar_callback
{
  uint8  *m_buf_p;
  size_t  m_buf_remain;

  spi_callback  *m_spi_callback;

  int callback_process_data(const uint8 *data, size_t data_size)
  {
    size_t  copy_size = (data_size > m_buf_remain) ? m_buf_remain : data_size;

    if (NULL != m_buf_p && 0 < m_buf_remain)
    {
      memcpy(m_buf_p, data, copy_size);
      m_buf_p += copy_size;
      m_buf_remain -= copy_size;
    }

    if (NULL != m_spi_callback && m_spi_callback->notify(copy_size))
      return -1;
    else
      return 0;
  }

  int callback_need_password(char *buf, size_t buf_size)
  {
    if (NULL == buf)
      return -1;

    password_dialog  pswd_dlg;
    if (0 == pswd_dlg.show(NULL))
    {
      strncpy(buf, pswd_dlg.get_password(), buf_size);
      if (buf_size)
        buf[buf_size - 1] = '\0';
      return 0;
    }
    else
      return -1;
  }

  int callback_change_volume(char *buf, int call_mode)
  {
    if (RAR_VOL_NOTIFY == call_mode)
      return 0;

    if (NULL == buf)
      return -1;

    change_volume_dialog  chvol_dlg;
    chvol_dlg.set_archive_name(buf);

    if (0 == chvol_dlg.show(NULL))
    {
      strcpy(buf, chvol_dlg.get_archive_name());
      return 0;
    }
    else
      return -1;
  }

public:
  axrar_unrar_callback(void)
       : m_buf_p(NULL), m_buf_remain(0) { }
  ~axrar_unrar_callback() { }

  void set_buf(uint8 *buf, size_t buf_size)
    { m_buf_p = buf; m_buf_remain = buf_size; }
  void set_spi_callback(spi_callback *callback)
    { m_spi_callback = callback; }
};


#endif // axrar_callback_cxx__
