// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  axrar_dialog.cxx
// ----------------------------------------------------------------------------

#ifndef axrar_dialog_cxx__
#define axrar_dialog_cxx__

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "dialog.h"
#include "resource.h"


// ----------------------------------------------------------------------------
//  pX[h̓_CAO
// ----------------------------------------------------------------------------

class password_dialog : public dialog
{
  enum { BUF_SIZE = 1024 };
  char  m_passwd[BUF_SIZE + 1];

  const char *resource_id(void) const
  {
    return MAKEINTRESOURCE(IDD_PASSWORD);
  }

  void apply(HWND wh, WPARAM /*wp*/, LPARAM /*lp*/)
  {
    GetDlgItemText(wh, IDC_PASSWORD_INPUT, m_passwd, BUF_SIZE);
  }

public:
  password_dialog(void) { m_passwd[0] = m_passwd[BUF_SIZE] = '\0'; }
  ~password_dialog() { }

  const char *get_password(void) const { return m_passwd; }
};


// ----------------------------------------------------------------------------
//  }`{[Ɏw_CAO
// ----------------------------------------------------------------------------

class change_volume_dialog : public dialog
{
  enum { BUF_SIZE = 1024 };
  char  m_arc_name[BUF_SIZE + 1];

  const char *resource_id(void) const
  {
    return MAKEINTRESOURCE(IDD_MULTIVOLUME);
  }

  virtual void init(HWND wh)
  {
    SetDlgItemText(wh, IDC_ARC_NAME_INPUT, m_arc_name);
  }

  void apply(HWND wh, WPARAM /*wp*/, LPARAM /*lp*/)
  {
    GetDlgItemText(wh, IDC_ARC_NAME_INPUT, m_arc_name, BUF_SIZE);
  }

public:
  change_volume_dialog(void) { m_arc_name[0] = m_arc_name[BUF_SIZE] = '\0'; }
  ~change_volume_dialog() { }

  const char *get_archive_name(void) const { return m_arc_name; }
  void set_archive_name(const char *arc_name) { strncpy(m_arc_name, arc_name, BUF_SIZE); }
};


#endif // axrar_dialog_cxx__
