// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  dialog.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "dialog.h"


// ----------------------------------------------------------------------------
//  Oϐ
// ----------------------------------------------------------------------------

extern HINSTANCE  g_inst;


// ----------------------------------------------------------------------------
//  _CAOvV[W ()
// ----------------------------------------------------------------------------

BOOL CALLBACK dlg_proc(HWND wh, UINT msg, WPARAM wp, LPARAM lp)
{
  dialog  *dlg;
  if (msg == WM_INITDIALOG)
  {
    dlg = (dialog *)lp;
    dlg->m_orig_long = SetWindowLong(wh, DWL_USER, lp);
  }
  else
    dlg = (dialog *)GetWindowLong(wh, DWL_USER);

  if (NULL != dlg)
    return dlg->proc(wh, msg, wp, lp);
  else
    return FALSE;
}


// ----------------------------------------------------------------------------
//  _CAONX
// ----------------------------------------------------------------------------

// ---
//  ftHg̃_CAOvV[W
// ---

BOOL dialog::proc(HWND wh, UINT msg, WPARAM wp, LPARAM lp)
{
  switch (msg)
  {
  case WM_INITDIALOG:
    init(wh);
    return TRUE;

  case WM_COMMAND:
    switch (LOWORD(wp))
    {
    case IDOK:
      apply(wh, wp, lp);
      // X[
    case IDCANCEL:
      close_dialog(wh, (IDOK == LOWORD(wp)) ? 0 : 1);
      return TRUE;
    }
    return FALSE;

  case WM_SYSCOMMAND:
    if (SC_CLOSE == wp)
    {
      close_dialog(wh, 1);
      return TRUE;
    }
    break;
  }
  return FALSE;
}


// ---
//  _CAO
// ---

void dialog::close_dialog(HWND wh, int ret_val)
{
  SetWindowLong(wh, DWL_USER, m_orig_long);
  EndDialog(wh, ret_val);
}


// ---
//  _CAO\
// ---

int dialog::show(HWND owner)
{
  return DialogBoxParam(g_inst,
                        resource_id(),
                        owner,
                        dlg_proc,
                        (LPARAM)this);
}

