// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  rar_arc.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "rar_arc.h"


// ----------------------------------------------------------------------------
//  rar A[JCuNX
// ----------------------------------------------------------------------------

// ---
//  A[JCuJ
// ---

int rar_archive::open(const char *arc_name, int mode)
{
  close();

  if (NULL == arc_name || '\0' == arc_name[0])
    return ERAR_EOPEN;

  m_arc_name = new char [strlen(arc_name) + 1];
  strcpy(m_arc_name, arc_name);

  m_arc_data.ArcName = m_arc_name;
  m_arc_data.OpenMode = mode;
  m_arc_data.CmtBuf = NULL;
  m_arc_data.CmtBufSize = 0;

  m_arc_h = unrar_dll::open_archive(&m_arc_data);

  if (NULL == m_arc_h)
    return m_arc_data.OpenResult;
  else
    return 0;
}


// ---
//  A[JCu
// ---

void rar_archive::close(void)
{
  if (NULL != m_arc_h)
  {
    unrar_dll::close_archive(m_arc_h);
    m_arc_h = NULL;
  }
  if (NULL != m_arc_name)
  {
    delete [] m_arc_name;
    m_arc_name = NULL;
  }
}


// ---
//  t@Cwb_ǂݍ
// ---

int rar_archive::read_header(RARHeaderData *hdr_data)
{
  return unrar_dll::read_header(m_arc_h, hdr_data);
}


// ---
//  t@C
// ---

int rar_archive::process_file(int operation, char *dest_path, char *dest_name)
{
  return unrar_dll::process_file(m_arc_h, operation, dest_path, dest_name);
}


// ---
//  R[obN֐ݒ肷
// ---

void rar_archive::set_callback(unrar_callback *cb)
{
  if (NULL != cb)
    unrar_dll::set_callback(m_arc_h, unrar_callback::callback_proc, (LONG)cb);
  else
    unrar_dll::set_callback(m_arc_h, NULL, NULL);
}


// ---
//  pX[hݒ肷
// ---

void rar_archive::set_password(const char *password)
{
  unrar_dll::set_password(m_arc_h, password);
}

