// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  rar_arc.h
// ----------------------------------------------------------------------------

#ifndef rar_arc_h__
#define rar_arc_h__

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "conf.h"
#include "unrar_dll.h"


// ----------------------------------------------------------------------------
//  rar A[JCuNX
// ----------------------------------------------------------------------------

class rar_archive
{
  char                *m_arc_name;
  RAROpenArchiveData  m_arc_data;
  HANDLE              m_arc_h;

public:
  rar_archive(void)
       : m_arc_h(NULL),
         m_arc_name(NULL) { }
  ~rar_archive() { close(); }

  int open(const char *arc_name, int mode);
  void close(void);
  int read_header(RARHeaderData *hdr_data);
  int process_file(int operation, char *dest_path, char *dest_name);
  void set_callback(class unrar_callback *cb);
  void set_password(const char *password);
};


// ----------------------------------------------------------------------------
//  unrar.dll ̃R[obNNX (^)
// ----------------------------------------------------------------------------

class unrar_callback
{
protected:
  virtual int callback_process_data(const uint8 *data, size_t data_size)
    { return -1; }
  virtual int callback_need_password(char *buf, size_t buf_size)
    { return -1; }
  virtual int callback_change_volume(char *buf, int call_mode)
    { return -1; }

public:
  unrar_callback(void) { }
  virtual ~unrar_callback() { }

  static int CALLBACK callback_proc(UINT msg, LONG user_data, LONG p1, LONG p2)
  {
    unrar_callback  *uc = (unrar_callback *)user_data;
    switch (msg)
    {
    case UCM_PROCESSDATA:
      return uc->callback_process_data((const uint8 *)p1, (size_t)p2);
    case UCM_CHANGEVOLUME:
      return uc->callback_change_volume((char *)p1, (int)p2);
    case UCM_NEEDPASSWORD:
      return uc->callback_need_password((char *)p1, (size_t)p2);
    default:
      return 0;
    }
  }
};


#endif // rar_arc_h__
