// -*- Mode: C++ -*-

#ifndef spi_h__
#define spi_h__

#include <windows.h>
#include <time.h>

#define SPI_OK  0
#define SPI_ERROR_NOT_IMPLEMENTED  (-1)
#define SPI_ERROR_CANCEL  1
#define SPI_ERROR_UNKNOWN_FORMAT  2
#define SPI_ERROR_BROKEN_DATA  3
#define SPI_ERROR_MEMORY_ALLOCATION  4
#define SPI_ERROR_MEMORY  5
#define SPI_ERROR_FILE_READ  6
#define SPI_ERROR_ERROR  8


typedef struct
{
  unsigned char method[8];
  unsigned long position;
  unsigned long compsize;
  unsigned long filesize;
  time_t timestamp;
  char path[200];
  char filename[200];
  unsigned long crc;
} fileInfo;


typedef int __stdcall (*SPI_CALLBACK)(int, int, long);

#define SPI_API  __stdcall
#define SPI_EXPORT  __declspec(dllexport) SPI_API


#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

int SPI_EXPORT GetPluginInfo(int info_no, LPSTR buf, int buf_len);
int SPI_EXPORT IsSupported(LPSTR filename, DWORD dw);
int SPI_EXPORT GetArchiveInfo(LPSTR buf, long len, unsigned int flag, HLOCAL *info);
int SPI_EXPORT GetFileInfo(LPSTR buf, long len, LPSTR filename, unsigned int flag, fileInfo *info);
int SPI_EXPORT GetFile(LPSTR src, long len, LPSTR dest, unsigned int flag, FARPROC prog_callback, long data);
int SPI_EXPORT ConfigurationDlg(HWND parent, int func);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // spi_h__
