// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  spi_callback.cxx
// ----------------------------------------------------------------------------

#ifndef spi_callback_cxx__
#define spi_callback_cxx__

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "spi.h"


// ----------------------------------------------------------------------------
//  spi ̃R[obN
// ----------------------------------------------------------------------------

class spi_callback
{
  SPI_CALLBACK  m_callback_func;
  long  m_data;
  int  m_num, m_denom;

public:
  spi_callback(SPI_CALLBACK func, long data)
       : m_callback_func(func),
         m_data(data) { }
  ~spi_callback() { }

  void set_demon(int denom)
  {
    m_num = 0;
    m_denom = denom;
  }

  int notify(int d)
  {
    m_num += d;
    return (NULL != m_callback_func) ?
      m_callback_func(m_num, m_denom, m_data) : 0;
  }
};


#endif // spi_callback_cxx__
