// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  axrar.spi - RAR extract plug-in
//  (C) 2004 mij4x
//
//  This software is provided 'as-is', without any express or implied
//  warranty.  In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//     claim that you wrote the original software. If you use this software
//     in a product, an acknowledgment in the product documentation would be
//     appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and must not be
//     misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source distribution.
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  spi_main.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "axrar_arcman.cxx"
#include "spi_util.h"


// ----------------------------------------------------------------------------
//  萔
// ----------------------------------------------------------------------------

#define PLUGIN_VERSION  "1.0.1"

const char *PLUGIN_INFO[] =
{
  "00AM",
  "RAR extract plug-in ver." PLUGIN_VERSION " (C) 2001-2004 mij4x",
  "*.rar",
  "WinRAR Archive",
};


// ----------------------------------------------------------------------------
//  O[oϐ
// ----------------------------------------------------------------------------

HINSTANCE  g_inst = NULL;


// ----------------------------------------------------------------------------
//  Gg|Cg
// ----------------------------------------------------------------------------

BOOL WINAPI DllMain(HINSTANCE inst, DWORD reason, LPVOID)
{
  switch (reason)
  {
  case DLL_PROCESS_ATTACH:
    if (false == unrar_dll::initialize())
      return FALSE;
    g_inst = inst;
    break;

  case DLL_PROCESS_DETACH:
    unrar_dll::finalize();
    break;
  }
  return TRUE;
}


// ----------------------------------------------------------------------------
//  Plug-in Ɋւ𓾂
// ----------------------------------------------------------------------------

int SPI_EXPORT GetPluginInfo(int info_no, LPSTR buf, int buf_len)
{
  int  copy_len = 0;

  if (0 <= info_no && info_no < countof(PLUGIN_INFO))
  {
    const char  *src = PLUGIN_INFO[info_no];
    char  *dst = buf;

    while (copy_len < buf_len)
    {
      copy_len++;
      if ('\0' == (*dst++ = *src++))
        break;
    }
  }

  return copy_len;
}


// ----------------------------------------------------------------------------
//  WJ\ (ΉĂ) t@C`ׂ
// ----------------------------------------------------------------------------

int SPI_EXPORT IsSupported(LPSTR filename, DWORD dw)
{
  bool  file_handle;
  {
    const uint8  *p;
    const size_t  BUF_SIZE = 16;
    uint8  buf[BUF_SIZE];

    if (dw & 0xffff0000)
    {
      p = (const uint8 *)dw;
      file_handle = false;
    }
    else
    {
      DWORD  read_bytes;
      ReadFile((HANDLE)dw, buf, BUF_SIZE, &read_bytes, NULL);
      p = buf;
      file_handle = true;
    }

    if (rar_arc_manager::is_rar(p))
      return 1;
  }

  {
    HANDLE  fh;
    if (file_handle)
      fh = (HANDLE)dw;
    else
    {
      if (NULL == filename || '\0' == filename[0])
        return 0;

      fh = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL,
                      OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

      if (INVALID_HANDLE_VALUE == fh)
        return 0;
    }

    int  ret = rar_arc_manager::is_rar_sfx(fh);

    if (!file_handle)
      CloseHandle(fh);

    return ret;
  }
}


// ----------------------------------------------------------------------------
//  A[JCûׂẴt@C̏擾
// ----------------------------------------------------------------------------

int SPI_EXPORT GetArchiveInfo(LPSTR buf, long len, unsigned int flag, HLOCAL *info)
{
  if (!is_file_in(flag))
    return SPI_ERROR_NOT_IMPLEMENTED;

  uint  count = 0;
  {
    rar_arc_manager  arc_man;
    if (arc_man.open_archive_list(buf))
      return SPI_ERROR_UNKNOWN_FORMAT;

    while (0 == arc_man.get_next_fileinfo(NULL))
      count++;

    arc_man.close_archive();
  }

  fileInfo  *fi = (fileInfo *)LocalAlloc(LMEM_FIXED, sizeof(fileInfo) * (count + 1));
  if (NULL == fi)
    return SPI_ERROR_MEMORY_ALLOCATION;

  {
    rar_arc_manager  arc_man;
    if (arc_man.open_archive_list(buf))
    {
      LocalFree(fi);
      return SPI_ERROR_UNKNOWN_FORMAT;
    }

    uint  i;
    for (i = 0; i < count; i++)
      if (0 != arc_man.get_next_fileinfo(&fi[i]))
        break;
    fi[i].method[0] = '\0';
//    fi[count].method[0] = '\0';

    *info = (HLOCAL)fi;

    arc_man.close_archive();
  }

  return SPI_OK;
}


// ----------------------------------------------------------------------------
//  A[JCu̎w肵t@C̏擾
// ----------------------------------------------------------------------------

int SPI_EXPORT GetFileInfo(LPSTR buf, long len, LPSTR filename, unsigned int flag, fileInfo *info)
{
  if (!is_file_in(flag))
    return SPI_ERROR_NOT_IMPLEMENTED;

  rar_arc_manager  arc_man;
  if (arc_man.open_archive_list(buf))
    return SPI_ERROR_UNKNOWN_FORMAT;

  char  target_filename[200];
  char  target_path[200];
  split_filepath(filename, target_path, 200, target_filename, 200);

  int (__cdecl *str_compare)(const char *, const char *);
  str_compare = (is_ignore_case(flag)) ? std::stricmp : std::strcmp;

  fileInfo  fi;
  while (0 == arc_man.get_next_fileinfo(&fi))
  {
    if (0 == str_compare(target_path, fi.path) &&
        0 == str_compare(target_filename, fi.filename))
    {
      if (NULL != info)
        *info = fi;
      return SPI_OK;
    }
  }

  return SPI_ERROR_UNKNOWN_FORMAT;
}


// ----------------------------------------------------------------------------
//  A[JCũt@C擾
// ----------------------------------------------------------------------------

int unrar_errcode_to_spi_errcode(int unrar_errcode)
{
  switch (unrar_errcode)
  {
  case 0: return SPI_OK;

  case ERAR_NO_MEMORY: return SPI_ERROR_MEMORY_ALLOCATION;

  case ERAR_BAD_DATA:
  case ERAR_BAD_ARCHIVE: return SPI_ERROR_BROKEN_DATA;

  case ERAR_UNKNOWN_FORMAT: return SPI_ERROR_UNKNOWN_FORMAT;

  case ERAR_EOPEN:
  case ERAR_EREAD: return SPI_ERROR_FILE_READ;

  case ERAR_ECREATE:
  case ERAR_EWRITE: //return spi_error_FILE_WRITE;
  case ERAR_ECLOSE:
  case ERAR_END_ARCHIVE:
  case ERAR_SMALL_BUF:
  default: return SPI_ERROR_ERROR;

  case ERAR_UNKNOWN: return SPI_ERROR_CANCEL;
  }
}

int SPI_EXPORT GetFile(LPSTR src, long len, LPSTR dest, unsigned int flag, FARPROC prog_callback, long data)
{
  if (!is_file_in(flag))// || is_file_out(flag))
    return SPI_ERROR_NOT_IMPLEMENTED;

  spi_callback  spicb((SPI_CALLBACK)prog_callback, data);

  rar_arc_manager  arc_man;
  if (arc_man.open_archive_extract(src))
    return SPI_ERROR_UNKNOWN_FORMAT;

  for (uint i = len; i-- > 0; )
    arc_man.get_next_fileinfo(NULL);

  fileInfo  fi;
  arc_man.get_next_fileinfo(&fi);

  int  ret;
  uint8  *img = NULL;
  if (fi.filesize)
  {
    img = (uint8 *)LocalAlloc(LMEM_FIXED, fi.filesize);
    if (NULL == img)
      return SPI_ERROR_MEMORY_ALLOCATION;

    ret = arc_man.extract(img, fi.filesize, &spicb);
    if (ret)
    {
      LocalFree(img);
      img = NULL;
      ret = unrar_errcode_to_spi_errcode(ret);
    }
  }

  if (!is_file_out(flag))  // o
  {
    *(HLOCAL *)dest = (HLOCAL)img;
  }
  else if (NULL != img)  // t@Co
  {
    const size_t  BUF_SIZE = 1024;
    char  fn_buf[BUF_SIZE];

    if (0 != make_filepath(fn_buf, BUF_SIZE, dest, fi.filename))
      ret = SPI_ERROR_NOT_IMPLEMENTED;
    else
    {
      HANDLE  fh = CreateFile(fn_buf, GENERIC_WRITE, 0, NULL,
                              CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL);
      if (INVALID_HANDLE_VALUE == fh)
        ret = SPI_ERROR_NOT_IMPLEMENTED;
      else
      {
        DWORD  write_bytes;
        WriteFile(fh, img, fi.filesize, &write_bytes, NULL);
        CloseHandle(fh);
      }
    }
    LocalFree(img);
  }

  return ret;
}


// ----------------------------------------------------------------------------
//  Plug-in ݒ_CAO\
// ----------------------------------------------------------------------------

int SPI_EXPORT ConfigurationDlg(HWND parent, int func)
{
  enum { FUNC_ABOUT = 0, FUNC_CONFIG = 1 };
  switch (func)
  {
  case FUNC_ABOUT:
#if 1
    {
      int  dll_ver = unrar_dll::get_dll_version();
      char  buf[256];
      wsprintf(buf, "%s\nunrar.dll version: %d",
               PLUGIN_INFO[1], dll_ver);
      MessageBox(parent, buf, "axrar.spi", MB_OK);
    }
#else
    MessageBox(parent, PLUGIN_INFO[1], "axrar.spi", MB_OK);
#endif
    return SPI_OK;

  default:
    return SPI_ERROR_NOT_IMPLEMENTED;
  }
}

