// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  unrar_dll.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "unrar_dll.h"


// ----------------------------------------------------------------------------
//  萔
// ----------------------------------------------------------------------------

#ifdef UNRAR_DYNAMIC_LINK
# define UNRAR_DLL_NAME  "unrar.dll"
#endif


// ----------------------------------------------------------------------------
//  unrar.dll bp[NX
// ----------------------------------------------------------------------------

HMODULE unrar_dll::s_dll = NULL;

RAROPENARCHIVE    unrar_dll::s_open_archive = NULL;
RARCLOSEARCHIVE   unrar_dll::s_close_archive = NULL;
RARREADHEADER     unrar_dll::s_read_header = NULL;
RARPROCESSFILE    unrar_dll::s_process_file = NULL;
RARSETCALLBACK    unrar_dll::s_set_callback = NULL;
RARSETPASSWORD    unrar_dll::s_set_password = NULL;
RARGETDLLVERSION  unrar_dll::s_get_dll_version = NULL;
//RAROPENARCHIVEEX  unrar_dll::s_open_archive_ex = NULL;
//RARREADHEADEREX   unrar_dll::s_read_header_ex = NULL;
//RARPROCESSFILEW   unrar_dll::s_process_file_w = NULL;

// ---
//  s
// ---

bool unrar_dll::initialize(void)
{
#ifdef UNRAR_DYNAMIC_LINK

  finalize();

  s_dll = LoadLibrary(UNRAR_DLL_NAME);
  if (NULL == s_dll)
    return false;

  s_open_archive = (RAROPENARCHIVE)GetProcAddress(s_dll, "RAROpenArchive");
  s_close_archive = (RARCLOSEARCHIVE)GetProcAddress(s_dll, "RARCloseArchive");
  s_read_header = (RARREADHEADER)GetProcAddress(s_dll, "RARReadHeader");
  s_process_file = (RARPROCESSFILE)GetProcAddress(s_dll, "RARProcessFile");
  s_set_callback = (RARSETCALLBACK)GetProcAddress(s_dll, "RARSetCallback");
  s_set_password = (RARSETPASSWORD)GetProcAddress(s_dll, "RARSetPassword");
  s_get_dll_version = (RARGETDLLVERSION)GetProcAddress(s_dll, "RARGetDllVersion");
//  s_open_archive_ex = (RAROPENARCHIVEEX)GetProcAddress(s_dll, "RAROpenArchiveEx");
//  s_read_header_ex = (RARREADHEADEREX)GetProcAddress(s_dll, "RARReadHeaderEx");
//  s_process_file_w = (RARPROCESSFILEW)GetProcAddress(s_dll, "RARProcessFileW");

  if (NULL == s_open_archive ||
      NULL == s_close_archive ||
      NULL == s_read_header ||
      NULL == s_process_file ||
      NULL == s_set_callback ||
      NULL == s_set_password ||
      NULL == s_get_dll_version)
//      NULL == s_open_archive_ex ||
//      NULL == s_read_header_ex ||
//      NULL == s_process_file_w)
  {
    finalize();
    return false;
  }

#else

  s_open_archive = RAROpenArchive;
  s_close_archive = RARCloseArchive;
  s_read_header = RARReadHeader;
  s_process_file = RARProcessFile;
  s_set_callback = RARSetCallback;
  s_set_password = RARSetPassword;
  s_get_dll_version = RARGetDllVersion;
//  s_open_archive_ex = RAROpenArchiveEx;
//  s_read_header_ex = RARReadHeaderEx;
//  s_process_file_w = RARProcessFileW;

#endif // UNRAR_DYNAMIC_LINK

  return true;
}


// ---
//  Is
// ---

void unrar_dll::finalize(void)
{
  if (NULL != s_dll)
  {
    FreeLibrary(s_dll);
    s_dll = NULL;
  }
}

