// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  unrar_dll.h
// ----------------------------------------------------------------------------

#ifndef unrar_dll_h__
#define unrar_dll_h__

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include <windows.h>

#ifdef UNRAR_DYNAMIC_LINK
#include "unrar/unrar.h"
#else
#include "unrar/dll.hpp"
#endif


// ----------------------------------------------------------------------------
//  ^`
// ----------------------------------------------------------------------------

typedef HANDLE PASCAL (*RAROPENARCHIVE)(struct RAROpenArchiveData *);
typedef int    PASCAL (*RARCLOSEARCHIVE)(HANDLE);
typedef int    PASCAL (*RARREADHEADER)(HANDLE, struct RARHeaderData *);
typedef int    PASCAL (*RARPROCESSFILE)(HANDLE, int, char *, char *);
typedef void   PASCAL (*RARSETCALLBACK)(HANDLE, UNRARCALLBACK, LONG);
typedef void   PASCAL (*RARSETPASSWORD)(HANDLE, char *);
typedef int    PASCAL (*RARGETDLLVERSION)(void);
//typedef HANDLE PASCAL (*RAROPENARCHIVEEX)(struct RAROpenArchiveDataEx *);
//typedef int    PASCAL (*RARREADHEADEREX)(HANDLE, struct RARHeaderDataEx *);
//typedef int    PASCAL (*RARPROCESSFILEW)(HANDLE, int, wchar_t *, wchar_t *);


// ----------------------------------------------------------------------------
//  unrar.dll bp[NX
// ----------------------------------------------------------------------------

class unrar_dll
{
  static HMODULE  s_dll;

  static RAROPENARCHIVE    s_open_archive;
  static RARCLOSEARCHIVE   s_close_archive;
  static RARREADHEADER     s_read_header;
  static RARPROCESSFILE    s_process_file;
  static RARSETCALLBACK    s_set_callback;
  static RARSETPASSWORD    s_set_password;
  static RARGETDLLVERSION  s_get_dll_version;
//  static RAROPENARCHIVEEX  s_open_archive_ex;
//  static RARREADHEADEREX   s_read_header_ex;
//  static RARPROCESSFILEW   s_process_file_w

  unrar_dll(void) { }
  ~unrar_dll() { }

public:
  static bool initialize(void);
  static void finalize(void);

  static HANDLE open_archive(RAROpenArchiveData *arc_data)
    { return s_open_archive(arc_data); }
  static int close_archive(HANDLE arc_h)
    { return s_close_archive(arc_h); }
  static int read_header(HANDLE arc_h, RARHeaderData *hdr_data)
    { return s_read_header(arc_h, hdr_data); }
  static int process_file(HANDLE arc_h, int op, char *dest_path, char *dest_name)
    { return s_process_file(arc_h, op, dest_path, dest_name); }
  static void set_callback(HANDLE arc_h, UNRARCALLBACK callback, LONG user_data)
    { s_set_callback(arc_h, callback, user_data); }
  static void set_password(HANDLE arc_h, const char *password)
    { s_set_password(arc_h, (char *)password); }
  static int get_dll_version(void)
    { return s_get_dll_version(); }
//  static HANDLE open_archive_ex(RAROpenArchiveDataEx *arc_data)
//    { return s_open_archive_ex(arc_data); }
//  static int read_header_ex(HANDLE arc_h, RARHeaderDataEx *hdr_data)
//    { return s_read_header_ex(arc_h, hdr_data); }
//  static int process_file_w(HANDLE arc_h, int op, wchar_t *dest_path, char *dest_name)
//    { return s_process_file_w(arc_h, op, dest_path, dest_name); }
};


#endif // unrar_dll_h__
