// -*- Mode: C++ -*-

// ----------------------------------------------------------------------------
//  util.cpp
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  CN[h
// ----------------------------------------------------------------------------

#include "util.h"
#include <string.h>


// ----------------------------------------------------------------------------
//  st@C̃TCY擾
// ----------------------------------------------------------------------------

uint32 get_exe_size(HANDLE fh)
{
  DWORD  read_bytes;

  SetFilePointer(fh, 0, NULL, FILE_BEGIN);

  IMAGE_DOS_HEADER  img_dos_hdr;
  ReadFile(fh, &img_dos_hdr, sizeof(IMAGE_DOS_HEADER), &read_bytes, NULL);

  static const uint  SIGNATURE_MZ = 0x5a4d;
  if (SIGNATURE_MZ != img_dos_hdr.e_magic)
    return -1;

  uint32  pe_offset = img_dos_hdr.e_lfanew;
  SetFilePointer(fh, pe_offset, NULL, FILE_BEGIN);

  IMAGE_NT_HEADERS  img_nt_hdrs;
  ReadFile(fh, &img_nt_hdrs, sizeof(IMAGE_NT_HEADERS), &read_bytes, NULL);

  if (IMAGE_NT_SIGNATURE != img_nt_hdrs.Signature)
    return -1;

  uint  num_secs = img_nt_hdrs.FileHeader.NumberOfSections;
  if (0 == num_secs)
    return -1;

  SetFilePointer(fh, sizeof(IMAGE_SECTION_HEADER) * (num_secs - 1),
                 NULL, FILE_CURRENT);

  IMAGE_SECTION_HEADER  img_sec_hdr;
  ReadFile(fh, &img_sec_hdr, sizeof(IMAGE_SECTION_HEADER), &read_bytes, NULL);

  return img_sec_hdr.SizeOfRawData + img_sec_hdr.PointerToRawData;
}


// ----------------------------------------------------------------------------
//  fBNgƃt@Cɕ
// ----------------------------------------------------------------------------

int split_filepath(const char *filepath,
                   char *dir_buf, size_t dir_size,
                   char *fn_buf, size_t fn_size)
{
  if (0 == dir_size || NULL == dir_buf)
    dir_buf = NULL, dir_size = 0;
  else
    dir_buf[0] = '\0';

  if (0 == fn_size || NULL == fn_buf)
    fn_buf = NULL, fn_size = 0;
  else
    fn_buf[0] = '\0';

  if (NULL == filepath || '\0' == filepath[0] ||
      (NULL == dir_buf) && (NULL == fn_buf))
    return 1;

  const char  *fn_begin = NULL;
  for (const char *p = filepath + strlen(filepath) - 1; filepath + 1 < p; p--)
  {
    if ('\\' == *p && !IsDBCSLeadByte(*(p - 1)))
    {
      fn_begin = p + 1;
      break;
    }
  }

  size_t  src_len, copy_len;

  if (NULL != fn_begin && NULL != dir_buf)
  {
    src_len = fn_begin - filepath + 1;
    copy_len = MIN(dir_size, src_len);
    memcpy(dir_buf, filepath, copy_len);
    dir_buf[copy_len - 1] = '\0';
  }
  else
    fn_begin = filepath;

  src_len = strlen(fn_begin) + 1;
  if (NULL != fn_buf && 0 < src_len)
  {
    copy_len = MIN(fn_size, src_len);
    memcpy(fn_buf, fn_begin, copy_len);
    fn_buf[copy_len - 1] = '\0';
  }

  return 0;
}


int make_filepath(char *buf, size_t buf_size, const char *dir, const char *fn)
{
  if (NULL == buf || 0 == buf_size || NULL == fn)
    return 1;

  if (NULL == dir)
    dir = "";

  size_t  dir_len = strlen(dir);
  size_t  fn_len = strlen(fn);

  bool  add_backslash;
  if (0 < dir_len)
  {
    add_backslash = true;

    if ('\\' == dir[dir_len - 1])
    {
      if (1 == dir_len || !IsDBCSLeadByte(dir[dir_len - 2]))
        add_backslash = false;
    }
  }
  else
    add_backslash = false;

  size_t  require_buf_size = dir_len + fn_len + 1 + (add_backslash ? 1 : 0);
  if (buf_size < require_buf_size)
    return 1;

  memcpy(buf, dir, dir_len);
  if (add_backslash)
    buf[dir_len++] = '\\';
  memcpy(buf + dir_len, fn, fn_len + 1);

  return 0;
}


// ----------------------------------------------------------------------------
//  MS-DOS `̓tE time_t ɕϊ
// ----------------------------------------------------------------------------

time_t dosdatetime_to_time_t(uint datetime)
{
  static const uint  YEAR_SEC      = 31536000L;
  static const uint  DAY_SEC       = 86400L;
  static const uint  HOUR_SEC      = 3600L;
  static const uint  MINUTE_SEC    = 60L;
  static const uint  SEVENTIES_SEC = 315532800L;
  static const uint  TOTAL_DAYS[12] =
    { 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 };

  static bool  flag_tzset = false;

  if (false == flag_tzset)
  {
    _tzset();
    flag_tzset = true;
  }

  int  year = datetime >> 25;
  int  month = (datetime >> 21) & 0x0f;
  int  day = (datetime >> 16) & 0x1f;

  day += (year + 3) >> 2;
  if (3 <= month && 0 == (year & 0x03))
    day++;

  int  hour = (datetime >> 11) & 0x1f;
  int  min = (datetime >> 5) & 0x3f;
  int  sec = (datetime & 0x1f) << 1;

  return  year * YEAR_SEC + (TOTAL_DAYS[month - 1] + day) * DAY_SEC
    + hour * HOUR_SEC + min * MINUTE_SEC + sec + SEVENTIES_SEC + _timezone;
}

