// MAX+plus II Verilog Example
// Efficient Counter Inference
// Copyright (c) 1997 Altera Corporation

module counters (d, clk, clear, ld, enable, up_down,
    	        qa, qb, qc, qd, qe, qf, qg,
 		qh, qi, qj, qk, ql, qm, qn);

   input   [7:0] d;
   input   clk, clear, ld, enable, up_down;
   output  [7:0] qa, qb, qc, qd, qe, qf, qg;
   output  [7:0] qh, qi, qj, qk, ql, qm, qn;

   reg     [7:0] qa, qb, qc, qd, qe, qf, qg;
   reg     [7:0] qh, qi, qj, qk, ql, qm, qn;


   integer direction;

   // An enable counter
   always @(posedge clk) 
   begin
	if (enable)
		qa = qa + 1;
   end


   // A synchronous load counter
   always @(posedge clk) 
   begin
	if (!ld)
		qb = d;
	else
		qb = qb + 1;
   end


   // A synchronous clear counter
   always @(posedge clk)
   begin
	if (!clear)
		qc = 0;
	else
		qc = qc + 1;
   end


   // An up/down counter
   always @(posedge clk) 
   begin
	if (up_down)
		direction = 1;
	else
		direction = -1;
		qd = qd + direction;
   end


   // A synchronous load enable counter
   always @ (posedge clk) 
   begin
	if (!ld)
		qe = d;
	else if (enable)
		qe = qe + 1;
   end


   // An enable up/down counter
   always @(posedge clk) 
   begin
	if (up_down)
		direction = 1;
	else
		direction = -1;
		if (enable)
			qf = qf + direction;
   end


   // A synchronous clear enable counter
   always @(posedge clk) 
   begin
	if (!clear)
		qg = 0;
	else if (enable)
		qg = qg + 1;
   end


   // A synchronous load clear counter
   always @(posedge clk) 
   begin
	if (!clear)
		qh = 0;
	else if (!ld)
		qh = d;
	else
		qh = qh + 1;
   end


   // A synchronous load up/down counter
   always @(posedge clk) 
   begin
	if (up_down)
		direction = 1;
	else
		direction = -1;

	if (!ld)
		qi = d;
	else
		qi = qi + direction;
   end


   // A synchronous load enable up/down counter
   always @(posedge clk) 
   begin
	if (up_down)
		direction = 1;
	else
		direction = -1;

	if (!ld)
		qj = d;
	else if (enable)
		qj = qj + direction;
   end


   // A synchronous clear load enable counter
   always @(posedge clk) 
   begin
	if (!clear)
		qk = 0;
	else if (!ld)
		qk = d;
	else if (enable)
		qk = qk + 1;
   end


   // A synchronous clear up/down counter
   always @(posedge clk) 
   begin
	if (up_down)
		direction = 1;
	else
		direction = -1;

	if (!clear)
		ql = 0;
	else if (enable)
		ql = ql + direction;
   end


   // A synchronous clear enable up/down counter
   always @(posedge clk) 
   begin
	if (up_down)
		direction = 1;
	else
		direction = -1;

	if (!clear)
		qm = 0;
	else if (enable)
		qm = qm + direction;
   end


   // A modulus 200 up counter
   always @(posedge clk) 
   begin
	if (qn == 200)
		qn = 0;
	else
		qn = qn + 1; 
   end

endmodule

