// MAX+plus II Verilog Example
// Register Inference
// Copyright (c) 1997 Altera Corporation

module reginf(d, clk, clr, pre, load, data,
			  q1, q2, q3, q4, q5, q6, q7);

	input d, clk, clr, pre, load, data;
	output q1, q2, q3, q4, q5, q6, q7;
	reg q1, q2, q3, q4, q5, q6, q7;

    // Register with active-high Clock
	always @(posedge clk)
		q1 = d;

    // Register with active-low Clock
	always @(negedge clk)
		q2 = d;

    // Register with active-high Clock & asynchronous Clear
	always @(posedge clk or posedge clr) begin
		if (clr)
			q3 = 0;
		else
			q3 = d;
	end

    // Register with active-low Clock & asynchronous Clear
	always @(negedge clk or negedge clr) begin
		if (!clr)
			q4 = 0;
		else
			q4 = d;
	end

    // Register with active-high Clock & asynchronous Preset
	always @(posedge clk or posedge pre) begin
		if (pre)
			q5 = 1;
		else
			q5 = d;
	end

    // Register with active-high Clock & asynchronous Load
	always @(posedge clk or posedge load) begin
		if (load)
			q6 = data;
		else
			q6 = d;
	end

    // Register with active-high Clock & asynchronous Clear & Preset
	always @(posedge clk or posedge clr or posedge pre) begin
		if (clr)
			q7 = 0;
		else if (pre)
			q7 = 1;
		else
			q7 = d;
	end

endmodule
