// MAX+plus II Verilog Example
// State Machine
// Copyright (c) 1997 Altera Corporation

module statmach(clk, in, reset, out);
   input clk, in, reset;
   output out;

   reg out;
   reg state;

   parameter s0 = 0, s1 = 1;

   always @(state) 
   begin
	case (state)
		s0:
			out = 0;
		s1:
			out = 1;
		default:
			out = 0;
	endcase
   end

   always @(posedge clk or posedge reset)
   begin
	if (reset)
		state = s0;
	else
		case (state)
			s0:
				state = s1;
			s1:
				if (in)
					state = s0;
				else
					state = s1;
		endcase
   end

endmodule
