@echo off
set ADD_DC_VER=1.3.5
rem
rem  Version 1.3.5.01
rem
rem  Usage:  add_dc design_name [-force] [path_of_exe]
rem          add_dc [-force] design_name [path_of_exe]
rem          add_dc [-h[elp]]
rem
rem  Example:  add_dc mydesign
rem
rem  Description
rem      This script affects all DFFs and DFFEs, and only these modules.
rem
rem      If CLRN pin is not used:
rem          Add CLRN pin and connect it with device_clear signal.
rem      If CLRN pin is connected to vcc:
rem          Connect device clear signal to the CLRN pin instead.
rem      If CLRN pin is used:
rem          Insert AND2 to and the clrn signal with device_clear,
rem          then connect the output of AND2 to the CLRN pin.
rem      For DFF1 and DFFE1, PRN pin will be modified instead of CLRN pin.
rem

if %1x==x goto :usage
if %1==-h goto :usage
if %1==/h goto :usage
if %1==-help goto :usage
if %1==/help goto :usage

set FORCE=0
if %1==-f     set FORCE=1
if %1==/f     set FORCE=1
if %1==-force set FORCE=1
if %1==/force set FORCE=1
if %2x==x goto :prepare_filenames
if %2==-f     set FORCE=2
if %2==/f     set FORCE=2
if %2==-force set FORCE=2
if %2==/force set FORCE=2

:prepare_filenames
set SRC_FILE=
set AWK_FILE=
if %FORCE%==1 goto :get_params_1
if %FORCE%==2 goto :get_params_2

:get_params_0
set SRC_FILE=%1
set AWK_FILE=%2
goto :check_awk

:get_params_1
set SRC_FILE=%2
set AWK_FILE=%3
goto :check_awk

:get_params_2
set SRC_FILE=%1
set AWK_FILE=%3
goto :check_awk

:check_awk
if not %AWK_FILE%x==x set AWK_FILE=%AWK_FILE%\add_dclr.exe
if %AWK_FILE%x==x set AWK_FILE=add_dclr.exe

:check_lang
set VO_FILE=0
set VHO_FILE=0
if exist %SRC_FILE%.vo set VO_FILE=1
if exist %SRC_FILE%.vho set VHO_FILE=1
if %FORCE%==2 set FORCE=1
if %VO_FILE%%VHO_FILE%==10 goto :lang_verilog
if %VO_FILE%%VHO_FILE%==01 goto :lang_vhdl
if %VO_FILE%%VHO_FILE%==11 goto :two_source
goto :no_source

:lang_verilog
set FILE_EXT=.vo
set LANG=VERILOG
goto :check_force

:lang_vhdl
set FILE_EXT=.vho
set LANG=VHDL
goto :check_force

:check_force
if not %FORCE%==0 goto :no_backup

:verify_awk_script_version
%AWK_FILE% PASS=0 %SRC_FILE%%FILE_EXT%
if errorlevel 1000 goto :no_awk
if errorlevel 14 goto :wrong_awk_ver
if errorlevel 13 goto :check_dc
goto :wrong_awk_ver

:check_dc
%AWK_FILE%  PASS=1 %SRC_FILE%%FILE_EXT%
if errorlevel 2 goto :dc_exist
if errorlevel 1 goto :not_mp2

:check_backup
if not exist %SRC_FILE%.ori goto :no_backup

:has_backup
rem cmp -s %SRC_FILE%%FILE_EXT% %SRC_FILE%.ori
rem if errorlevel 1 goto :backup_mismatch
goto :backup_mismatch
goto :add_dc

:no_backup
echo Making backup copy of %SRC_FILE%%FILE_EXT% to %SRC_FILE%.ori.
rem cp %SRC_FILE%%FILE_EXT% %SRC_FILE%.ori
copy %SRC_FILE%%FILE_EXT% %SRC_FILE%.ori
goto :add_dc

:add_dc
rem borrow FORCE for DC_ERROR
set FORCE=0
%AWK_FILE% PASS=2 SIGNAL_FILE="signal.tm_" DESIGN=%SRC_FILE% LANG=%LANG% %SRC_FILE%%FILE_EXT% > %SRC_FILE%.tmp
if errorlevel 2 goto :add_dc_error
if errorlevel 1 set FORCE=1
if exist signal.tm_ goto :add_more_signals

:no_more_signals
%AWK_FILE% PASS=3 SIGNAL_FILE="NUL" DESIGN=%SRC_FILE% LANG=%LANG% %SRC_FILE%.tmp > %SRC_FILE%%FILE_EXT%
goto :del_tmp_files

:add_more_signals
%AWK_FILE% PASS=3 SIGNAL_FILE="signal.tm_" DESIGN=%SRC_FILE% LANG=%LANG% %SRC_FILE%.tmp > %SRC_FILE%%FILE_EXT%

:del_tmp_files
if exist %SRC_FILE%.tmp del %SRC_FILE%.tmp
if exist signal.tm_ del signal.tm_

if %FORCE%==1 goto :dc_not_added

:dc_added
echo The device_clear pin is added to %SRC_FILE%%FILE_EXT%.
goto :end

:dc_not_added
echo The device_clear pin is NOT added to %SRC_FILE%%FILE_EXT%.
echo Please make sure the design name is %SRC_FILE%.
goto :end

:usage
echo ADD_DC Script version %ADD_DC_VER%
echo.
echo This script is used for post-processing .vo or .vho netlist generated by
echo MAX+plus II.  It inserts a device_clear signal that is used for power up
echo initialization of all DFFs and DFFEs in the design.  The device_clear
echo signal should be driven low to reset all DFFs and DFFEs, and driven high
echo for normal simulation.
echo.
echo Syntax:  add_dc design_name [-force] [path_of_exe]
echo          add_dc [-force] design_name [path_of_exe]
echo          add_dc [-h[elp]]
echo.
echo [design_name] is the name of the design; the netlist filename is assumed
echo     to be design_name.vo or design_name.vho.
echo [path_of_exe] is the path of add_dclr.exe.
echo.
echo Example:  add_dc mydesign
goto :end

:no_source
echo ERROR:  %SRC_FILE%.vo or %SRC_FILE%.vho does not exist.
echo Please make sure the source file is in the current directory.
goto :end

:two_source
echo ERROR:  Both %SRC_FILE%.vo and %SRC_FILE%.vho exist!
echo Only one file can be modified at a time.  Please rename or remove
echo   one of the source files.
goto :end

:no_awk
echo ERROR:  %AWK_FILE% not found.
echo Please specify the location of add_dclr.exe as the last parameter
echo   if it is not in the current directory.
goto :end

:wrong_awk_ver
echo ERROR:  Incorrect version of %AWK_FILE%
echo Please contact Altera to obtain the latest script files.
goto :end

:dc_exist
echo ERROR:  %SRC_FILE%%FILE_EXT% already contains device_clear signal.
echo You may try using -force option to add a device_clear signal.
goto :end

:not_mp2
echo ERROR:  %SRC_FILE%%FILE_EXT% is not written by MAX+plus II.
echo You may try using -force option to add a device_clear signal.
goto :end

:backup_mismatch
rem echo Backup %SRC_FILE%.ori exists, but it is different from the original %SRC_FILE%%FILE_EXT%.
rem echo If %SRC_FILE%%FILE_EXT% is correct, please remove %SRC_FILE%.ori and re-run add_dc.
echo Backup %SRC_FILE%.ori exists.  Please remove it and re-run add_dc.
goto :end

:dc_exist
echo ERROR:  The device_clear pin already exists!
goto :end

:add_dc_error
echo ERROR:  Unable to finish adding device_clear pin to source file %SRC_FILE%%FILE_EXT%.
echo Please check the syntax of the source file.
goto :end

:end
if not %FORCE%x==x set FORCE=
if not %SRC_FILE%x==x set SRC_FILE=
if not %AWK_FILE%x==x set AWK_FILE=
if not %VO_FILE%x==x set VO_FILE=
if not %VHO_FILE%x==x set VHO_FILE=
if not %FILE_EXT%x==x set FILE_EXT=
if not %LANG%x==x set LANG=
set ADD_DC_VER=
