-- memmodes.inc

-- the constant definitions in this file should be consistent 
-- with those from DBCOMMON.H

-- single port memory
CONSTANT	MEM_READONLY				= H"00000002";
CONSTANT	MEM_INITIALIZED				= H"00000004";
CONSTANT	MEM_REG_DATAIN				= H"00000010";
CONSTANT	MEM_REG_ADDR  				= H"00000020";
CONSTANT	MEM_REG_CTRL  				= H"00000040";
CONSTANT	MEM_REG_DATAOUT				= H"00000080";

-- dual port memory
CONSTANT	MEM_FIFO					= H"00000008";
CONSTANT	MEM_REG_DATAIN_CLK0			= H"00000010"; --Same as MEM_REG_DATAIN
CONSTANT	MEM_REG_WADDR_CLK0			= H"00000020"; --Same as MEM_REG_ADDR
CONSTANT	MEM_REG_WCTRL_CLK0			= H"00000040"; --Same as MEM_REG_CTRL
CONSTANT	MEM_REG_DATAOUT_CLK0		= H"00000100"; 
CONSTANT	MEM_REG_DATAOUT_CLK1		= H"00000080"; --Same as MEM_REG_DATAOUT
CONSTANT	MEM_REG_RADDR_CLK0			= H"00000200";
CONSTANT	MEM_REG_RADDR_CLK1			= H"00000400";
CONSTANT	MEM_REG_RCTRL_CLK0			= H"00000800";
CONSTANT	MEM_REG_RCTRL_CLK1			= H"00001000";

-- extra modes
CONSTANT	MEM_REG_DATAIN_USE_CLRN0	= H"00002000";
CONSTANT	MEM_REG_WADDR_USE_CLRN0		= H"00004000";
CONSTANT	MEM_REG_WCTRL_USE_CLRN0		= H"00008000";
CONSTANT	MEM_REG_DATAOUT_USE_CLRN0	= H"00200000";
CONSTANT	MEM_REG_RADDR_USE_CLRN0		= H"00400000";
CONSTANT	MEM_REG_RCTRL_USE_CLRN0		= H"00800000";


-- the same with RAM prefix

-- single port memory
CONSTANT	RAM_READONLY				= H"00000002";
CONSTANT	RAM_INITIALIZED				= H"00000004";
CONSTANT	RAM_REG_DATAIN				= H"00000010";
CONSTANT	RAM_REG_ADDR  				= H"00000020";
CONSTANT	RAM_REG_CTRL  				= H"00000040";
CONSTANT	RAM_REG_DATAOUT				= H"00000080";

-- dual port memory
CONSTANT	RAM_FIFO					= H"00000008";
CONSTANT	RAM_REG_DATAIN_CLK0			= H"00000010"; --Same as RAM_REG_DATAIN
CONSTANT	RAM_REG_WADDR_CLK0			= H"00000020"; --Same as RAM_REG_ADDR
CONSTANT	RAM_REG_WCTRL_CLK0			= H"00000040"; --Same as RAM_REG_CTRL
CONSTANT	RAM_REG_DATAOUT_CLK0		= H"00000100"; 
CONSTANT	RAM_REG_DATAOUT_CLK1		= H"00000080"; --Same as RAM_REG_DATAOUT
CONSTANT	RAM_REG_RADDR_CLK0			= H"00000200";
CONSTANT	RAM_REG_RADDR_CLK1			= H"00000400";
CONSTANT	RAM_REG_RCTRL_CLK0			= H"00000800";
CONSTANT	RAM_REG_RCTRL_CLK1			= H"00001000";

-- extra modes
CONSTANT	RAM_REG_DATAIN_USE_CLRN0	= H"00002000";
CONSTANT	RAM_REG_WADDR_USE_CLRN0		= H"00004000";
CONSTANT	RAM_REG_WCTRL_USE_CLRN0		= H"00008000";
CONSTANT	RAM_REG_DATAOUT_USE_CLRN0	= H"00200000";
CONSTANT	RAM_REG_RADDR_USE_CLRN0		= H"00400000";
CONSTANT	RAM_REG_RCTRL_USE_CLRN0		= H"00800000";


-- the same with ROM prefix

-- single port memory
CONSTANT	ROM_READONLY				= H"00000002";
CONSTANT	ROM_INITIALIZED				= H"00000004";
CONSTANT	ROM_REG_DATAIN				= H"00000010";
CONSTANT	ROM_REG_ADDR  				= H"00000020";
CONSTANT	ROM_REG_CTRL  				= H"00000040";
CONSTANT	ROM_REG_DATAOUT				= H"00000080";

-- dual port memory
CONSTANT	ROM_FIFO					= H"00000008";
CONSTANT	ROM_REG_DATAIN_CLK0			= H"00000010"; --Same as ROM_REG_DATAIN
CONSTANT	ROM_REG_WADDR_CLK0			= H"00000020"; --Same as ROM_REG_ADDR
CONSTANT	ROM_REG_WCTRL_CLK0			= H"00000040"; --Same as ROM_REG_CTRL
CONSTANT	ROM_REG_DATAOUT_CLK0		= H"00000100"; 
CONSTANT	ROM_REG_DATAOUT_CLK1		= H"00000080"; --Same as ROM_REG_DATAOUT
CONSTANT	ROM_REG_RADDR_CLK0			= H"00000200";
CONSTANT	ROM_REG_RADDR_CLK1			= H"00000400";
CONSTANT	ROM_REG_RCTRL_CLK0			= H"00000800";
CONSTANT	ROM_REG_RCTRL_CLK1			= H"00001000";

-- extra modes
CONSTANT	ROM_REG_DATAIN_USE_CLRN0	= H"00002000";
CONSTANT	ROM_REG_WADDR_USE_CLRN0		= H"00004000";
CONSTANT	ROM_REG_WCTRL_USE_CLRN0		= H"00008000";
CONSTANT	ROM_REG_DATAOUT_USE_CLRN0	= H"00200000";
CONSTANT	ROM_REG_RADDR_USE_CLRN0		= H"00400000";
CONSTANT	ROM_REG_RCTRL_USE_CLRN0		= H"00800000";

