#! /bin/sh
#
PORT_DEF_ERROR='Error!  $PORT must be defined as WINDOWS or UNIX'
#
# delete existing design files
#
rm -f *.gdf *.sym *.tdf *.inc *.idx
#
# Extract copyright notice from ../h/syver.h, and create legal sed commands
#
echo '/[$]Header:/d' > ../lpmlib/copyrght.sed
echo '/^--[ 	][ 	]*[(][cC][)]/{' >> ../lpmlib/copyrght.sed
sed -n 's/^[#]define[ 	][ 	]*MAXC_COPYRIGHT_ASCII[^"]*["]\([^"]*\)["].*$/a\\\
--	\1/p' ../h/syver.h >> ../lpmlib/copyrght.sed
sed -n '/[*]ge_legal_msg_array[[][]]/,/[}][;]/s/^.*["]\([^"]*\)["].*$/a\\\
--	\1/p' ../genlib/gelegal.c >> ../lpmlib/copyrght.sed
echo 'd' >> ../lpmlib/copyrght.sed
echo '}' >> ../lpmlib/copyrght.sed

#
# Create new TDF files
#
(
  cd ../lpmlib
  for i in *.tdf
  do
	sed -f copyrght.sed $i > ../lpmlibr/$i
  done
)
#
# Copy all other design files
#
cp -prf ../lpmlib/*.gdf .
cp -prf ../lpmlib/*.sym .
cp -prf ../lpmlib/*.inc .
cp -prf ../lpmlib/wizard.lst .
rm -f ../lpmlib/copyrght.sed

#
# Encrypt OpenCores
#
ENCRYPT1="a16450 a6402 a6850 a8237 a8251 a8255"

#for tdf in $ENCRYPT1
#do
#	mv $tdf.tdf $tdf.tmp
#	# Encrypting $tdf.tdf
#	../exew/altcrypt -e -p0001 -i$tdf.tmp -o$tdf.tdf
#done

#
# Encrypt Caleb's FFT megafunction
#
BUTTERFLY="butterfly"
COUNTER_SELF_TIMED="counter_self_timed"
DFT2_ENGINE="dft2_engine"
DFT2_ENGINE_1PORT="dft2_engine_1port"
FFT_CONTROLLER="fft_controller"
FFT_DELAY="fft_delay"
FFT_ON_CHIP="fft_on_chip"
FFT_SHIFT="fft_shift"
MULT_COMPLEX="mult_complex"
TW_COUNTER="tw_counter"

FFT1="$BUTTERFLY $COUNTER_SELF_TIMED $DFT2_ENGINE $DFT2_ENGINE_1PORT"
#FFT2="$FFT_CONTROLLER $FFT_DELAY $FFT_ON_CHIP $FFT_SHIFT $MULT_COMPLEX"
FFT2="$FFT_CONTROLLER $FFT_DELAY $FFT_SHIFT $MULT_COMPLEX"
FFT3="$TW_COUNTER fft fft_max fft_over fmult"

#for tdf in $FFT1 $FFT2 $FFT3
#do
#	mv $tdf.tdf $tdf.tmp
#	# Encrypting $tdf.tdf
#	../exew/altcrypt -e -p0002 -i$tdf.tmp -o$tdf.tdf
#done

#
# Encrypt Caleb's color space converters
#
RGB2YCRCB=rgb2ycrcb
YCRCB2RGB=ycrcb2rgb

ENCRYPT3="$RGB2YCRCB $YCRCB2RGB"

#for tdf in $ENCRYPT3
#do
#	mv $tdf.tdf $tdf.tmp
#	# Encrypting $tdf.tdf
#	../exew/altcrypt -e -p0003 -i$tdf.tmp -o$tdf.tdf
#done

rm -f *.tmp
