<?php 

require_once 'class-fliphtml5-list-table.php';

class FlipHtml5_View {

	private $controller;
	private $list_table;
	
	function __construct($controller) {
		$this->controller = $controller;
	}
	
	function print_add_new(){
		if ( !empty($_POST) && isset($_POST['fliphtml5-upload']) && wp_verify_nonce($_POST['fliphtml5-nonce'],'fliphtml5-add-new-add-new') ){
			if ( !isset($_FILES['fliphtml5-zip']) || ($_FILES["fliphtml5-zip"]["error"] > 0) ){
				echo '<div class="error"><p>' . __('Please select a ZIP file created with Flip Html5', 'fliphtml5')  . '</p></div>';
			}else{
				$uploadfile = wp_handle_upload($_FILES['fliphtml5-zip'], array(
						'test_form' => false,
						'mimes' => array('zip' => 'application/zip')
				));
				
				if ( isset($uploadfile['error']) ){
					echo '<div class="error"><p>' . esc_attr($uploadfile['error'])  . '</p></div>';
				}else{
					$id = ( isset($_POST['fliphtml5-replace']) && ($_POST['fliphtml5-replace'] == 'yes') && isset($_POST['fliphtml5-replace-id']) ) ? ($_POST['fliphtml5-replace-id']) : -1;
					$ret = $this->controller->install_book($uploadfile['file'], $id);
					if ( is_wp_error($ret) ){
						echo '<div class="error"><p>' . $ret->get_error_message()  . '</p></div>';
					}else{		
						if ( $ret["new"] )
							echo '<div class="error"><p>This is a new version fliphtml5 WordPress Plugin. In addition to adding the book here, you also need to update the Plugin itself. Fore more inforamtion, visit <a href="http://fliphtml5.com/how-to-update-flip-builder-wordpress-plugin/" target="_blank">How to update fliphtml5 WordPress Plugin</a>.</p></div>';
						echo '<div class="updated"><p>The book is successfully installed. &nbsp;&nbsp;<a href="?page=fliphtml5_view_book&bookid=' . $ret["id"] . '">View The Book</a></p></div>';
						echo '<div class="updated"><p> To embed the book into your page, use shortcode <strong>[fliphtml5 id="' . $ret["id"] . '"]</strong></p></div>';
						echo '<div class="updated"><p> To embed the book into your template, use php code <strong>' . esc_attr('<?php echo do_shortcode(\'[fliphtml5 id="' . $ret["id"] . '"]\'); ?>') . '</strong></p></div>';						
					}
				}
			}
		}
		?>
		<div class="wrap">
			<div id="icon-fliphtml5" class="icon32"><br /></div>
			<h2><?php _e( 'Add New Book', 'fliphtml5' ); ?> <a href="<?php echo admin_url('admin.php?page=fliphtml5_show_books'); ?>" class="add-new-h2">Show All Books</a></h2>
			<h4><?php _e( 'Upload the ZIP file created with <a href="http://fliphtml5.com" target="_blank">Flip Html5</a>', 'fliphtml5' ); ?></h4>
			<form id="form-fliphtml5-add-new" method="post" enctype="multipart/form-data"> 
				<ul>
					<li>
						<input type="file" id="fliphtml5-zip" name="fliphtml5-zip" />
						<input id="fliphtml5-upload" name="fliphtml5-upload" type="submit" class="button" value="<?php esc_attr_e('Upload', 'fliphtml5') ?>" />
					</li> 
					<li>
						<input type="checkbox" name="fliphtml5-replace" value="yes"><?php esc_attr_e('Replace an existing book', 'fliphtml5') ?>:&nbsp;
						<select name="fliphtml5-replace-id">
							<?php 
							global $wpdb;
							$table_name = $wpdb->prefix . "fliphtml5";
							$book_rows = $wpdb->get_results( "SELECT * FROM $table_name", ARRAY_A);						
							if ( $book_rows ){
								foreach ( $book_rows as $row )
									echo '<option value="' . $row['id'] . '">' . $row['id'] . ' : ' . $row['name'] . '</option>';
							}
							?>
						</select>
					</li>
	  			</ul>
	  			<?php wp_nonce_field('fliphtml5-add-new-add-new','fliphtml5-nonce'); ?>
	  		</form>              
		</div>
		<?php
	}

	function print_books() {
		?>
		<div class="wrap">
		<div id="icon-fliphtml5" class="icon32"><br /></div>
		<h2><?php _e( 'Installed Books', 'fliphtml5' ); ?> <a href="<?php echo admin_url('admin.php?page=fliphtml5_add_new'); ?>" class="add-new-h2">Add New</a> </h2>
		<?php $this->process_delete_action(); ?>
		<form id="book-list-table" method="post">
		<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
		<?php 
		if ( !is_object($this->list_table) )
			$this->list_table = new FlipHtml5_List_Table($this);
		$this->list_table->list_data = $this->controller->get_list_data();
		$this->list_table->prepare_items();
		$this->list_table->display();		
		?>								
        </form>
		</div>
		<?php
	}
	
	function process_delete_action(){
		$deleted = 0;
		if ( isset($_REQUEST['action']) && ($_REQUEST['action'] == 'delete') && isset( $_REQUEST['bookid'] ) ){
			if ( is_array( $_REQUEST['bookid'] ) ){
				foreach( $_REQUEST['bookid'] as $id){
					$ret = $this->controller->delete_book($id);
					if ($ret > 0)
						$deleted += $ret;
				}
			}else{
				$deleted = $this->controller->delete_book( $_REQUEST['bookid'] );
			}
		}
	
		if ($deleted > 0){
			echo '<div class="updated"><p>';
			printf( _n('%d book deleted.', '%d books deleted.', $deleted), $deleted );
			echo '</p></div>';
		}
		
	}
	
	function view_book(){
		if ( !isset( $_REQUEST['bookid'] ) )
			return;
		?>
		<div class="wrap">
		<div id="icon-fliphtml5" class="icon32"><br /></div>
		<h2><?php _e( 'View Book', 'fliphtml5' ); ?> <a href="<?php echo admin_url('admin.php?page=fliphtml5_show_books'); ?>" class="add-new-h2">Show All Books</a> <a href="<?php echo admin_url('admin.php?page=fliphtml5_add_new'); ?>" class="add-new-h2">Add New</a> </h2>
		<div class="updated"><p style="text-align:center;"> To embed the book into your page, use shortcode <strong><?php echo esc_attr('[fliphtml5 id="' . $_REQUEST['bookid'] . '"]'); ?></strong></p></div>
		<div class="updated"><p style="text-align:center;"> To embed the book into your template, use php code <strong><?php echo esc_attr('<?php echo do_shortcode(\'[fliphtml5 id="' . $_REQUEST['bookid'] . '"]\'); ?>'); ?></strong></p></div>
		<?php
		echo $this->controller->generate_body_code( $_REQUEST['bookid'] ); 
		?>	 
		</div>
		<?php
	}
}