<?php
/*
Plugin Name: Flip Html5
Plugin URI: http://fliphtml5.com
Description: Flip Html5 WordPress Plugin
Version: 1.0
Author: fliphtml5.com
Author URI: http://fliphtml5.com
License: Copyright 2013 fliphtml5.com, All Rights Reserved
*/

define('FLIPHTML5_VERSION', '1.0');

define('FLIPHTML5_URL', plugin_dir_url( __FILE__ ));

define('FLIPHTML5_PATH', plugin_dir_path( __FILE__ ));

require_once 'app/class-fliphtml5-controller.php';

class FlipHtml5_Plugin{
	public $fliphtml5_controller;
	
	function __construct() {
		$this->init();
	}
	
	public function init(){
		$this->fliphtml5_controller = new FlipHtml5_Controller();
		register_activation_hook( __FILE__, array($this, 'activation_handler') );
		add_action( 'admin_menu', array($this, 'register_menu') );
		add_shortcode( 'fliphtml5', array($this, 'shortcode_handler') );
		add_action( 'init', array($this, 'register_script') );
		//add_action( 'wp_enqueue_scripts', array($this, 'enqueue_script') );
		//add_action( 'admin_enqueue_scripts', array($this, 'enqueue_admin_script') );
	}
	
	function activation_handler(){
		$this->fliphtml5_controller->activation_handler();
	}
	
//	function enqueue_admin_script($hook){
		/*if ($hook == 'admin_page_fliphtml5r_view_slider'){
			wp_enqueue_script('fliphtml5-script');
			wp_enqueue_script('fliphtml5-script1');
		}*/
//	}
	
//	function enqueue_script(){
		/*wp_enqueue_script('fliphtml5-script');
		wp_enqueue_script('fliphtml5-script1');*/
//	}
	
	function register_script(){
		/*$script_url = FLIPBUILDER_URL . 'data/js/jquery.js';
		//$script_url1 = HISLIDER_URL . 'data/js/jquery.hislider.js';
		wp_register_script('flipbuilder-script', $script_url);
		//wp_register_script('hislider-script1', $script_url1);*/
		if ( is_admin() ){
			wp_register_style('fliphtml5-style', FLIPHTML5_URL . 'fliphtml5.css');
			wp_enqueue_style('fliphtml5-style');
		}
	}
	
	function shortcode_handler($atts){
		if ( !isset($atts['id']) )
			return __('Please specify a book id', 'fliphtml5');
		$id = $atts['id'];
		return $this->fliphtml5_controller->generate_body_code($id);
	}
	
	function register_menu(){
		add_menu_page(
				__('Flip Html5', 'fliphtml5'),
				__('Flip Html5', 'fliphtml5'),
				'manage_options', 
				'fliphtml5_show_books', 
				array($this, 'show_books'),
				FLIPHTML5_URL . 'images/logo-16.png' );
				
		add_submenu_page(
				'fliphtml5_show_books', 
				__('Installed Books', 'fliphtml5'), 
				__('Installed Books', 'fliphtml5'), 
				'manage_options',
				'fliphtml5_show_books',
				array($this, 'show_books' ) );
		
		add_submenu_page(
				'fliphtml5_show_books',
				__('Add New book', 'fliphtml5'),
				__('Add New', 'fliphtml5'),
				'manage_options',
				'fliphtml5_add_new',
				array($this, 'add_new' ) );
		add_submenu_page(
				null,
				__('View Book', 'fliphtml5'),
				__('View Book', 'fliphtml5'),
				'manage_options',
				'fliphtml5_view_book',
				array($this, 'view_book' ) );
	}
	
	public function show_books(){
		$this->fliphtml5_controller->show_books();
	}
	
	public function add_new(){
		$this->fliphtml5_controller->add_new();
	}
	
	public function view_book(){
		$this->fliphtml5_controller->view_book();
	}
}

$fliphtml5_plugin = new FlipHtml5_Plugin();

/**
 * Global php function
 * @param unknown_type $id
 */
function fliphtml5($id) {
	echo $fliphtml5_plugin->fliphtml5_controller->generate_body_code($id);
}

/**
 * Uninstallation
 */
function fliphtml5_uninstall() {
	global $wpdb;
	$table_name = $wpdb->prefix . "fliphtml5";
	$wpdb->query("DROP TABLE IF EXISTS $table_name");
}

if ( function_exists('register_uninstall_hook') )
	register_uninstall_hook( __FILE__, 'fliphtml5_uninstall' );

