/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PixelmonMethods {
    public static ArrayList<EntityPixelmon> getAllActivePokemon(EntityPlayer player) {
        ArrayList<EntityPixelmon> list = new ArrayList<EntityPixelmon>();
        try {
            PlayerStorage storage = PixelmonStorage.PokeballManager.getPlayerStorage((EntityPlayerMP)player);
            for (NBTTagCompound nbt : storage.getList()) {
                int[] id;
                if (nbt == null || !storage.EntityAlreadyExists(id = PixelmonMethods.getID(nbt), player.field_70170_p)) continue;
                list.add(storage.getAlreadyExists(id, player.field_70170_p));
            }
        }
        catch (PlayerNotLoadedException playerNotLoadedException) {
            // empty catch block
        }
        return list;
    }

    public static int[] getID(NBTTagCompound nbt) {
        return new int[]{nbt.func_74762_e("pixelmonID1"), nbt.func_74762_e("pixelmonID2")};
    }

    public static boolean isIDSame(NBTTagCompound nbt, EntityPixelmon entity) {
        return PixelmonMethods.isIDSame(PixelmonMethods.getID(nbt), entity.getPokemonId());
    }

    public static boolean isIDSame(int[] id1, int[] id2) {
        if (id1.length != 2 && id1.length != id2.length) {
            return false;
        }
        return id1[0] == id2[0] && id1[1] == id2[1];
    }

    public static boolean isIDSame(NBTTagCompound nbt, int[] id) {
        return PixelmonMethods.isIDSame(PixelmonMethods.getID(nbt), id);
    }

    public static boolean isIDSame(EntityPixelmon e, int[] id) {
        return PixelmonMethods.isIDSame(e.getPokemonId(), id);
    }

    public static boolean isIDSame(int[] id, EntityPixelmon e) {
        return PixelmonMethods.isIDSame(e.getPokemonId(), id);
    }

    public static boolean isIDSame(EntityPixelmon e1, EntityPixelmon e2) {
        return PixelmonMethods.isIDSame(e1.getPokemonId(), e2.getPokemonId());
    }
}

