/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Iterable2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldHelper {
    public static final ForgeDirection[] NWSE = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.EAST};
    public static final ForgeDirection[] ESWN = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH};
    public static final AbstractList2D<ForgeDirection> COMPASS = new EntryList2D<ForgeDirection>();

    public static boolean isHorizontal(ForgeDirection dir) {
        return dir.offsetX != 0;
    }

    public static boolean isNegative(ForgeDirection dir) {
        return dir.offsetX < 0 || dir.offsetY < 0 || dir.offsetZ < 0;
    }

    public static ForgeDirection[] getOpposites(ForgeDirection ... dirs) {
        ForgeDirection[] result = new ForgeDirection[dirs.length];
        for (int i = 0; i < dirs.length; ++i) {
            result[i] = dirs[i].getOpposite();
        }
        return result;
    }

    public static ForgeDirection ccw(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return ForgeDirection.DOWN;
            }
            case EAST: {
                return ForgeDirection.NORTH;
            }
            case NORTH: {
                return ForgeDirection.WEST;
            }
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case UNKNOWN: {
                return ForgeDirection.UNKNOWN;
            }
            case UP: {
                return ForgeDirection.UP;
            }
            case WEST: {
                return ForgeDirection.SOUTH;
            }
        }
        return null;
    }

    public static BiomeGenBase demandBiome(String name) {
        BiomeGenBase result = WorldHelper.parseBiome(name);
        if (result == null) {
            throw new IllegalArgumentException("No such Biome named \"" + name + "\"");
        }
        return result;
    }

    public static BiomeGenBase parseBiome(String name) {
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || !biome.field_76791_y.equalsIgnoreCase(name)) continue;
            return biome;
        }
        return null;
    }

    public static char abbreviate(ForgeDirection dir) {
        return dir.toString().charAt(0);
    }

    public static ForgeDirection toDirection(char c) {
        switch (Character.toUpperCase(c)) {
            case 'N': {
                return ForgeDirection.NORTH;
            }
            case 'W': {
                return ForgeDirection.WEST;
            }
            case 'S': {
                return ForgeDirection.SOUTH;
            }
            case 'E': {
                return ForgeDirection.EAST;
            }
            case 'U': {
                return ForgeDirection.UP;
            }
            case 'D': {
                return ForgeDirection.DOWN;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection[] dirsFromOffsets(float x, float z) {
        ArrayList resultList = new ArrayList();
        int angle = (int)(Math.toDegrees(Math.atan2(z, x)) / 45.0);
        switch (angle) {
            case -3: {
                return new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST};
            }
            case -2: {
                return new ForgeDirection[]{ForgeDirection.NORTH};
            }
            case -1: {
                return new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST};
            }
            case 0: {
                return new ForgeDirection[]{ForgeDirection.EAST};
            }
            case 1: {
                return new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.EAST};
            }
            case 2: {
                return new ForgeDirection[]{ForgeDirection.SOUTH};
            }
            case 3: {
                return new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST};
            }
            case 4: {
                return new ForgeDirection[]{ForgeDirection.WEST};
            }
        }
        return new ForgeDirection[]{ForgeDirection.UNKNOWN};
    }

    public static ArrayList<ForgeDirection> getDirectionsTowards(int distX, int distZ) {
        ForgeDirection leftRight;
        ForgeDirection forgeDirection = distX == 0 ? null : (leftRight = distX < 0 ? ForgeDirection.WEST : ForgeDirection.EAST);
        ForgeDirection upDown = distZ == 0 ? null : (distZ < 0 ? ForgeDirection.NORTH : ForgeDirection.SOUTH);
        ArrayList<ForgeDirection> result = new ArrayList<ForgeDirection>();
        if (leftRight != null) {
            result.add(leftRight);
        }
        if (upDown != null) {
            result.add(upDown);
        }
        return result;
    }

    public static ForgeDirection randomAdjacent(ForgeDirection dir, Random random) {
        int i = RandomHelper.useRandomForNumberBetween(random, -1, 1);
        return i == 0 ? dir : COMPASS.get(dir.offsetZ * i, dir.offsetX * i);
    }

    public static int firstUncoveredUpwardsFromY(World world, int x, int y, int z, boolean countNonSolid) {
        Block block = null;
        while ((block = world.func_147439_a(x, y, z)) != null && (countNonSolid || block.func_149655_b((IBlockAccess)world, x, y, z))) {
            ++y;
        }
        return y;
    }

    public static int firstBlockDownwardsFromY(World world, int x, int y, int z, boolean countNonSolid) {
        Block block = null;
        while ((block = world.func_147439_a(x, y, z)) == null || !countNonSolid && !block.func_149655_b((IBlockAccess)world, x, y, z)) {
            --y;
        }
        return y;
    }

    public static int getWaterDepth(int posX, int posY, int posZ, World worldObj) {
        int count = 0;
        while (worldObj.func_147439_a(posX, posY, posZ) == Blocks.field_150355_j) {
            ++posY;
            ++count;
        }
        return count;
    }

    public static int getLavaDepth(int posX, int posY, int posZ, World worldObj) {
        int count = 0;
        while (worldObj.func_147439_a(posX, posY, posZ) == Blocks.field_150353_l) {
            ++posY;
            ++count;
        }
        return count;
    }

    public static int getWaterDepthAt(int posX, int posZ, World worldObj) {
        if (!WorldHelper.isWaterOrIce(worldObj, posX, 62, posZ)) {
            return 0;
        }
        int depth = 0;
        depth = 1;
        while (WorldHelper.isWaterOrIce(worldObj, posX, 63 - depth, posZ)) {
            ++depth;
        }
        return depth;
    }

    public static boolean isWaterOrIce(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == Blocks.field_150355_j || block == Blocks.field_150432_aD;
    }

    public static boolean isWateryBiome(BiomeGenBase biome) {
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
    }

    public static boolean isChunkFloodedOrFrozen(int chunkX, int chunkZ, World worldObj, int jump) {
        if (jump >= 16) {
            throw new IllegalArgumentException("Cannot check a whether a chunk is flooded or not if the initial jump value overshoots the chunk's bounds right after the first iteration!");
        }
        int i = 0;
        while (i + jump <= 16) {
            int j = 0;
            while (j + jump <= 16) {
                if (!WorldHelper.isWaterOrIce(worldObj, chunkX * 16 + i, 62, chunkZ * 16 + j)) {
                    return false;
                }
                j += jump;
            }
            i += jump;
        }
        System.out.println("Chunk is flooded");
        return true;
    }

    public static int[] block2ChunkCoords(int x, int z) {
        return new int[]{x >> 4, z >> 4};
    }

    public static int[] forgeDirectionToLocalChunkCoords(ForgeDirection dir) {
        int x = (int)(dir.offsetX == 0 ? 0.0f : 8.5f * (float)dir.offsetX + 7.5f);
        int z = (int)(dir.offsetZ == 0 ? 0.0f : 8.5f * (float)dir.offsetZ + 7.5f);
        return new int[]{x, z};
    }

    public static int[] forgeDirectionAndOffsetToLocalChunkCoords(ForgeDirection dir, int offset) {
        int x = (int)(dir.offsetX == 0 ? (float)offset : 8.5f * (float)dir.offsetX + 7.5f);
        int z = (int)(dir.offsetZ == 0 ? (float)offset : 8.5f * (float)dir.offsetZ + 7.5f);
        return new int[]{x, z};
    }

    protected static boolean canFitWithinBiomeScaled(World world, BiomeGenBase biome, BiomeGenBase[] alsoAllowedBiomes, int startX, int startZ, int coordBaseMode, int skip, AbstractList2D<?> points, int tolerance, float scale) {
        int violations = 0;
        int index = 0;
        for (Link2D link2D : points) {
            int zi;
            if (index % skip != 0) {
                ++index;
                continue;
            }
            int xi = coordBaseMode % 2 == 0 ? startX + (int)(scale * (float)link2D.x) : startX + (int)(scale * (float)link2D.z);
            BiomeGenBase otherBiome = world.getBiomeGenForCoordsBody(xi, zi = coordBaseMode % 2 == 0 ? startZ + (int)(scale * (float)link2D.z) : startZ + (int)(scale * (float)link2D.x));
            if (biome != otherBiome && !CommonHelper.contains(alsoAllowedBiomes, otherBiome)) {
                ++violations;
            }
            if (violations > tolerance) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean canFitWithinBiomeScaled(World world, BiomeGenBase biome, int startX, int startZ, int coordBaseMode, int skip, AbstractList2D<?> points, int tolerance, float scale) {
        int violations = 0;
        int index = 0;
        for (Link2D link2D : points) {
            int zi;
            if (index % skip != 0) {
                ++index;
                continue;
            }
            int xi = coordBaseMode % 2 == 0 ? startX + (int)(scale * (float)link2D.x) : startX + (int)(scale * (float)link2D.z);
            int n = zi = coordBaseMode % 2 == 0 ? startZ + (int)(scale * (float)link2D.z) : startZ + (int)(scale * (float)link2D.x);
            if (biome != world.getBiomeGenForCoordsBody(xi, zi)) {
                ++violations;
            }
            if (violations > tolerance) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean canFitWithinBiome(World world, BiomeGenBase biome, int startX, int startZ, int coordBaseMode, int skip, AbstractList2D<?> points, int tolerance) {
        return WorldHelper.canFitWithinBiomeScaled(world, biome, startX, startZ, coordBaseMode, skip, points, tolerance, 1.0f);
    }

    public static boolean canFitWithinBiome(World world, BiomeGenBase biome, BiomeGenBase[] alsoAllowed, int startX, int startZ, int coordBaseMode, int skip, AbstractList2D<?> points, int tolerance) {
        return WorldHelper.canFitWithinBiomeScaled(world, biome, alsoAllowed, startX, startZ, coordBaseMode, skip, points, tolerance, 1.0f);
    }

    public static boolean canChunksFitWithinBiome(World world, BiomeGenBase biome, int startX, int startZ, int coordBaseMode, int skip, AbstractList2D<?> points, int tolerance) {
        return WorldHelper.canFitWithinBiomeScaled(world, biome, startX, startZ, coordBaseMode, skip, points, tolerance, 16.0f);
    }

    public static boolean canFitWithinBiome(World world, BiomeGenBase biome, int x, int z, int width, int length, int tolerance) {
        int violations = 0;
        x >>= 4;
        z >>= 4;
        for (int i = 0; i <= width >> 4; ++i) {
            for (int j = 0; j <= length >> 4; ++j) {
                int x0 = (x + i) * 16;
                int z0 = (z + j) * 16;
                BiomeGenBase currentBiome = world.func_72807_a((x + i) * 16, (z + j) * 16);
                if (biome != currentBiome) {
                    ++violations;
                }
                if (violations <= tolerance) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canFitWithinBiome(World world, BiomeGenBase biome, BiomeGenBase[] alsoAllowed, int x, int z, int width, int length, int tolerance) {
        int violations = 0;
        x >>= 4;
        z >>= 4;
        for (int i = 0; i <= width >> 4; ++i) {
            for (int j = 0; j <= length >> 4; ++j) {
                int x0 = (x + i) * 16;
                int z0 = (z + j) * 16;
                BiomeGenBase currentBiome = world.getBiomeGenForCoordsBody((x + i) * 16, (z + j) * 16);
                if (biome != currentBiome && !CommonHelper.contains(alsoAllowed, currentBiome)) {
                    ++violations;
                }
                if (violations <= tolerance) continue;
                return false;
            }
        }
        return true;
    }

    public static int getFitting(World world, BiomeGenBase biome, int x, int z, AbstractList2D<Float> points, int skip, int tolerance) {
        if (WorldHelper.canFitWithinBiome(world, biome, x, z, 0, skip, points, tolerance)) {
            return 0;
        }
        if (WorldHelper.canFitWithinBiome(world, biome, x, z, 1, skip, points, tolerance)) {
            return 1;
        }
        return -1;
    }

    public static AbstractList2D<Integer> getNearbyBiomesFromChunkCoords(World world, int chunkX, int chunkZ, int radius) {
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                if (i == 0 && j == 0) continue;
                int biomeID = world.func_72807_a((int)((chunkX + i) * 16), (int)((chunkZ + j) * 16)).field_76756_M;
                result.addValue(i, j, biomeID);
            }
        }
        return result;
    }

    public static AbstractList2D<Integer> getNearbyBiomes(World world, int blockX, int blockZ, int radius) {
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                if (i == 0 && j == 0) continue;
                int biomeID = world.func_72807_a((int)(blockX + i * 16), (int)(blockZ + j * 16)).field_76756_M;
                result.addValue(i, j, biomeID);
            }
        }
        return result;
    }

    public static AbstractList2D<Float> getNearbyMatchingBiomes(BiomeGenBase biome, World world, int x, int z, int radius) {
        EntryList2D<Float> result = new EntryList2D<Float>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                if (world.func_72807_a(x + i * 16, z + j * 16) != biome) continue;
                result.addValue(i, j, Float.valueOf(1.0f));
            }
        }
        return result;
    }

    public static AbstractList2D<Float> getContinuousBiomeFromChunkCoords(BiomeGenBase biome, World world, int chunkX, int chunkZ) {
        EntryList2D<Float> result = new EntryList2D<Float>();
        WorldHelper.fillMapWithContinuousBiome(biome, world, result, chunkX, chunkZ);
        return result;
    }

    public static void fillMapWithContinuousBiome(BiomeGenBase biome, World world, AbstractList2D<Float> map, int chunkX, int chunkZ) {
        for (ForgeDirection dir : NWSE) {
            int trueX = chunkX + dir.offsetX;
            int trueZ = chunkZ + dir.offsetZ;
            if (map.contains(trueX, trueZ) || world.func_72807_a(trueX * 16, trueZ * 16) != biome) continue;
            map.addValue(trueX, trueZ, Float.valueOf(1.0f));
            WorldHelper.fillMapWithContinuousBiome(biome, world, map, trueX, trueZ);
        }
    }

    public static int getHighestPointInLayout(World world, int x, int z, Iterable2D<?> l2d) {
        int y = 0;
        for (Link2D link2D : l2d) {
            int i = x + link2D.x;
            int j = z + link2D.z;
            int heightVal = world.func_72825_h(i, j);
            if (heightVal <= y) continue;
            y = heightVal;
        }
        return y;
    }

    public static int getLowestTopPointInLayout(World world, int x, int z, Iterable2D<?> l2d) {
        int y = -1;
        for (Link2D link2D : l2d) {
            int i = x + link2D.x;
            int j = z + link2D.z;
            int heightVal = world.func_72825_h(i, j);
            if (y != -1 && heightVal >= y) continue;
            y = heightVal;
        }
        return y;
    }

    public static void fixLighting(World world, StructureBoundingBox bb) {
        for (int i = bb.field_78897_a >> 4; i <= bb.field_78893_d >> 4; ++i) {
            for (int j = bb.field_78896_c >> 4; j <= bb.field_78892_f >> 4; ++j) {
                Chunk chunk = world.func_72964_e(i, j);
                chunk.func_76603_b();
                chunk.func_76613_n();
            }
        }
    }

    @Deprecated
    private static ForgeDirection newDirection(String name, int offsetX, int offsetY, int offsetZ) {
        Class[][] DIRECTION_PARAMS = new Class[][]{{ForgeDirection.class, Integer.TYPE, Integer.TYPE, Integer.TYPE}};
        return (ForgeDirection)EnumHelper.addEnum((Class[][])DIRECTION_PARAMS, ForgeDirection.class, (String)name, (Object[])new Object[]{offsetX, offsetY, offsetZ});
    }

    static {
        for (ForgeDirection dir : NWSE) {
            COMPASS.addValue(dir.offsetX, dir.offsetZ, dir);
        }
    }
}

