/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.achievement;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PixelmonAchievementEvent;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsApricorns;
import com.pixelmonmod.pixelmon.config.PixelmonItemsBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.items.ItemApricornCooked;
import com.pixelmonmod.pixelmon.items.ItemItemFinder;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.items.ItemPokedex;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerNotLoadedException;
import com.pixelmonmod.pixelmon.storage.PokeballManager;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;

public class PixelmonAchievements {
    private static boolean called = false;
    public static final String[] lengendaries = new String[]{"Mew", "Mewtwo", "Zapdos", "Articuno", "Moltres", "Suicune", "Entei", "Raikou", "Lugia", "Ho-Oh", "Celebi", "Regice", "Registeel", "Regirock", "Latias", "Latios", "Groudon", "Kyogre", "Rayquaza", "Jirachi", "Deoxys", "Azelf", "Mesprit", "Uxie", "Dialga", "Palkia", "Giratina", "Cresselia", "Darkrai", "Manaphy", "Phione", "Heatran", "Regigigas", "Shaymin", "Arceus"};
    public static final Achievement itemFinderChieve = new Achievement("achievement.itemFinder", "ItemFinderChieve", 0, -2, PixelmonItems.itemFinder, null).func_75971_g();
    public static final Achievement hiddenLootChieve = new Achievement("achievement.itemhiddenloot", "HiddenPokeLootChieve", 2, -2, Blocks.field_150410_aZ, itemFinderChieve).func_75971_g();
    public static final Achievement normalLootChieve = new Achievement("achievement.normalloot", "NormalPokeLootChieve", -2, -2, PixelmonBlocks.pokeChest, null).func_75971_g();
    public static final Achievement masterBallChieve = new Achievement("achievement.lootmasterball", "LootMasterBallChieve", 4, -2, PixelmonItemsPokeballs.masterBall, null).func_75971_g().func_75987_b();
    public static final Achievement grottoChieve = new Achievement("achievement.grotto", "GrottoChieve", 1, -1, Blocks.field_150345_g, null).func_75971_g();
    public static final Achievement pokedexChieve = new Achievement("achievement.pokedex", "PokedexChieve", -2, 0, PixelmonItems.pokeDex, null).func_75971_g();
    public static final Achievement apricornChieve = new Achievement("achievement.apricorn", "ApricornChieve", 0, 0, PixelmonItemsApricorns.apricornRedCooked, null).func_75971_g();
    public static final Achievement pokeballChieve = new Achievement("achievement.pokeball", "PokeballChieve", 2, 0, PixelmonItemsPokeballs.pokeBall, apricornChieve).func_75971_g();
    public static final Achievement legendaryChieve = new Achievement("achievement.catchlegendary", "LegendaryChieve", 2, 2, PixelmonItemsPokeballs.masterBall, pokeballChieve).func_75971_g().func_75987_b();
    public static final Achievement shinyChieve = new Achievement("achievement.catchshiny", "ShinyChieve", 4, 2, PixelmonItemsPokeballs.masterBall, pokeballChieve).func_75971_g().func_75987_b();
    public static final Achievement firstcatchChieve = new Achievement("achievement.firstcatch", "FirstCatchChieve", 4, 0, PixelmonItemsPokeballs.pokeBall, pokeballChieve).func_75971_g();
    public static final Achievement trainerChieve = new Achievement("achievement.beattrainer", "TrainerChieve", -2, 2, PixelmonItemsPokeballs.greatBall, null).func_75971_g();
    public static final Achievement pvpChieve = new Achievement("achievement.winpvp", "PvPChieve", 0, 2, PixelmonItemsPokeballs.ultraBall, null).func_75971_g();
    public static final Achievement dex1Chieve = new Achievement("achievement.completedex1", "dex1Chieve", -4, -2, PixelmonItemsPokeballs.pokeBall, null).func_75971_g();
    public static final Achievement dex10Chieve = new Achievement("achievement.completedex10", "dex10Chieve", -4, -1, PixelmonItemsPokeballs.pokeBall, dex1Chieve).func_75971_g();
    public static final Achievement dex20Chieve = new Achievement("achievement.completedex20", "dex20Chieve", -4, 0, PixelmonItemsPokeballs.pokeBall, dex10Chieve).func_75971_g();
    public static final Achievement dex30Chieve = new Achievement("achievement.completedex30", "dex30Chieve", -4, 1, PixelmonItemsPokeballs.pokeBall, dex20Chieve).func_75971_g();
    public static final Achievement dex40Chieve = new Achievement("achievement.completedex40", "dex40Chieve", -4, 2, PixelmonItemsPokeballs.greatBall, dex30Chieve).func_75971_g();
    public static final Achievement dex50Chieve = new Achievement("achievement.completedex50", "dex50Chieve", -4, 3, PixelmonItemsPokeballs.greatBall, dex40Chieve).func_75971_g().func_75987_b();
    public static final Achievement dex60Chieve = new Achievement("achievement.completedex60", "dex60Chieve", -4, 4, PixelmonItemsPokeballs.greatBall, dex50Chieve).func_75971_g();
    public static final Achievement dex70Chieve = new Achievement("achievement.completedex70", "dex70Chieve", -4, 5, PixelmonItemsPokeballs.ultraBall, dex60Chieve).func_75971_g();
    public static final Achievement dex80Chieve = new Achievement("achievement.completedex80", "dex80Chieve", -4, 6, PixelmonItemsPokeballs.ultraBall, dex70Chieve).func_75971_g();
    public static final Achievement dex90Chieve = new Achievement("achievement.completedex90", "dex90Chieve", -4, 7, PixelmonItemsPokeballs.ultraBall, dex80Chieve).func_75971_g();
    public static final Achievement dex100Chieve = new Achievement("achievement.completedex100", "dex100Chieve", -4, 8, PixelmonItemsPokeballs.masterBall, dex90Chieve).func_75971_g().func_75987_b();
    public static AchievementPage pixelmonPage = new AchievementPage("Pixelmon", new Achievement[]{itemFinderChieve, hiddenLootChieve, normalLootChieve, masterBallChieve, grottoChieve, pokedexChieve, pokeballChieve, legendaryChieve, shinyChieve, firstcatchChieve, trainerChieve, pvpChieve, apricornChieve, dex1Chieve, dex10Chieve, dex20Chieve, dex30Chieve, dex40Chieve, dex50Chieve, dex60Chieve, dex70Chieve, dex80Chieve, dex90Chieve, dex100Chieve});

    public static void SetupAchievements() {
        if (called) {
            return;
        }
        AchievementPage.registerAchievementPage((AchievementPage)pixelmonPage);
        called = true;
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        int num;
        ItemStack item = event.crafting;
        EntityPlayer player = event.player;
        if (item.func_77973_b() instanceof ItemItemFinder) {
            player.func_71064_a((StatBase)itemFinderChieve, 1);
        } else if (item.func_77973_b() instanceof ItemPokedex) {
            player.func_71064_a((StatBase)pokedexChieve, 1);
        } else if (item.func_77973_b() instanceof ItemPokeball) {
            player.func_71064_a((StatBase)pokeballChieve, 1);
        }
        if (item.func_77973_b() == PixelmonItemsBlocks.pcItem && (num = RandomHelper.getRandomNumberBetween(1, 100)) == 45 && !player.field_70170_p.field_72995_K) {
            EntityPixelmon pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumPokemon.Porygon.name, player.field_70170_p);
            pixelmonEntity.func_70107_b(player.field_70165_t, player.field_70163_u + 5.0, player.field_70161_v);
            player.field_70170_p.func_72838_d((Entity)pixelmonEntity);
        }
    }

    @SubscribeEvent
    public void onSmelting(PlayerEvent.ItemSmeltedEvent event) {
        ItemStack itemStack = event.smelting;
        EntityPlayer player = event.player;
        if (itemStack.func_77973_b() instanceof ItemApricornCooked) {
            Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "apricornChieve"));
            player.func_71064_a((StatBase)apricornChieve, 1);
        }
    }

    public static void captureChieves(EntityPlayer player, EntityPixelmon pokemon) {
        String name = pokemon.getName();
        Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "firstcatchChieve"));
        player.func_71064_a((StatBase)firstcatchChieve, 1);
        for (String p : lengendaries) {
            if (!name.equalsIgnoreCase(p)) continue;
            Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "legendaryChieve"));
            player.func_71064_a((StatBase)legendaryChieve, 1);
        }
        if (pokemon.getIsShiny()) {
            Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "shinyChieve"));
            player.func_71064_a((StatBase)shinyChieve, 1);
        }
        PixelmonAchievements.pokedexChieves(player);
    }

    public static void battleChieves(EntityPlayer player, BattleParticipant opponent, boolean win) {
        if (win) {
            if (opponent instanceof PlayerParticipant) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "pvpChieve"));
                player.func_71064_a((StatBase)pvpChieve, 1);
            } else if (opponent instanceof TrainerParticipant) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "trainerChieve"));
                player.func_71064_a((StatBase)trainerChieve, 1);
            }
        }
    }

    public static void pokedexChieves(EntityPlayer player) {
        try {
            PokeballManager pm = PixelmonStorage.PokeballManager;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            int caught = pm.getPlayerStorage((EntityPlayerMP)playerMP).pokedex.countCaught();
            int percent = (int)((double)caught / (double)EnumPokemon.values().length * 100.0);
            if (percent >= 1) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex1Chieve"));
                player.func_71064_a((StatBase)dex1Chieve, 1);
            }
            if (percent >= 10) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex10Chieve"));
                player.func_71064_a((StatBase)dex10Chieve, 1);
            }
            if (percent >= 20) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex20Chieve"));
                player.func_71064_a((StatBase)dex20Chieve, 1);
            }
            if (percent >= 30) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex30Chieve"));
                player.func_71064_a((StatBase)dex30Chieve, 1);
            }
            if (percent >= 40) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex40Chieve"));
                player.func_71064_a((StatBase)dex40Chieve, 1);
            }
            if (percent >= 50) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex50Chieve"));
                player.func_71064_a((StatBase)dex50Chieve, 1);
            }
            if (percent >= 60) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex60Chieve"));
                player.func_71064_a((StatBase)dex60Chieve, 1);
            }
            if (percent >= 70) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex70Chieve"));
                player.func_71064_a((StatBase)dex70Chieve, 1);
            }
            if (percent >= 80) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex80Chieve"));
                player.func_71064_a((StatBase)dex80Chieve, 1);
            }
            if (percent >= 90) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex90Chieve"));
                player.func_71064_a((StatBase)dex90Chieve, 1);
            }
            if (percent >= 100) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonAchievementEvent(player, "dex100Chieve"));
                player.func_71064_a((StatBase)dex100Chieve, 1);
            }
        }
        catch (PlayerNotLoadedException e) {
            e.printStackTrace();
        }
    }
}

