/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api;

import com.pixelmonmod.pixelmon.api.ReflectionUtil;
import com.pixelmonmod.pixelmon.api.interactions.IInteraction;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballBase;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumApricorns;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.item.Item;

public class PixelmonApi {
    private static ArrayList<EnumPokeballs> pokeballs = new ArrayList();
    private static ArrayList<Item> pokeballItems = new ArrayList();
    private static Class arrayOfAppricorns = null;

    public static void addInteraction(IInteraction interaction) {
        EntityPixelmon.interactionList.add(interaction);
    }

    public static void addModelLibrary(String location) {
        ClientProxy.modelPaths.add(0, location);
    }

    public static void addStatus(String statusNameValue, int index) {
        try {
            StatusType newStatus;
            StatusType[] newValues;
            StatusType[] oldValues = (StatusType[])ReflectionUtil.getStaticFieldValue(StatusType.class, "ENUM$VALUES");
            if (index >= oldValues.length) {
                newValues = new StatusType[index + 1];
                for (int i = oldValues.length; i < index; ++i) {
                    newValues[i] = StatusType.Wait;
                }
            } else {
                newValues = new StatusType[oldValues.length];
            }
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            Class[] fields = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
            newValues[index] = newStatus = (StatusType)((Object)ReflectionUtil.invokeEnumConstructor(StatusType.class, fields, new Object[]{statusNameValue, index, index}));
            ReflectionUtil.setStaticFieldValue(StatusType.class, "ENUM$VALUES", newValues);
            Logger.getLogger("pixelmon").info("successfully added the status " + statusNameValue);
        }
        catch (Exception e) {
            Logger.getLogger("pixelmon").log(Level.WARNING, "failed to register the status with the index " + index, e);
        }
    }

    public static void registerPokeball(String ballNameValue, int index, double ballBonus, String textureDirectory, String filenamePrefix, EnumApricorns[] recipe, int quantityMade, int chanceBreak) {
        PixelmonApi.registerPokeball(ballNameValue, index, ballBonus, textureDirectory, filenamePrefix, recipe, quantityMade, chanceBreak, null);
    }

    private static boolean addPokeballToList(EnumPokeballs ball, Item item) {
        for (EnumPokeballs b : pokeballs) {
            if (b.getIndex() != ball.getIndex()) continue;
            int index = pokeballs.indexOf(b);
            pokeballs.set(index, ball);
            pokeballItems.set(index, item);
            return true;
        }
        return false;
    }

    public static void registerPokeball(String ballNameValue, int index, double ballBonus, String textureDirectory, String filenamePrefix, EnumApricorns[] recipe, int quantityMade, int chanceBreak, Class<? extends ModelPokeballBase> modelClass) {
        try {
            EnumPokeballs[] newValues;
            EnumPokeballs[] oldValues;
            if (arrayOfAppricorns == null) {
                block2: for (Constructor<?> field : EnumPokeballs.class.getDeclaredConstructors()) {
                    for (Class<?> paramClass : field.getParameterTypes()) {
                        if (!paramClass.getName().equals("[Lpixelmon.enums.EnumApricorns;")) continue;
                        arrayOfAppricorns = paramClass;
                        continue block2;
                    }
                }
            }
            if (index >= (oldValues = (EnumPokeballs[])ReflectionUtil.getStaticFieldValue(EnumPokeballs.class, "ENUM$VALUES")).length) {
                newValues = new EnumPokeballs[index + 1];
                for (int i = oldValues.length; i < index; ++i) {
                    newValues[i] = EnumPokeballs.PokeBall;
                }
            } else {
                newValues = new EnumPokeballs[oldValues.length];
            }
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            Class[] fields = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Double.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, arrayOfAppricorns, Integer.TYPE, Integer.TYPE};
            EnumPokeballs newBall = (EnumPokeballs)ReflectionUtil.invokeEnumConstructor(EnumPokeballs.class, fields, new Object[]{ballNameValue, index, index, ballBonus, filenamePrefix, 0, 0, 0, 0, 0, 0, recipe, quantityMade, chanceBreak});
            newBall.setTextureDirectory(textureDirectory);
            newValues[index] = newBall;
            ReflectionUtil.setStaticFieldValue(EnumPokeballs.class, "ENUM$VALUES", newValues);
            if (PixelmonApi.addPokeballToList(newBall, PixelmonItemsPokeballs.pokeBall)) {
                Logger.getLogger("pixelmon").info("a pokeball with the index of " + index + " was overriden!");
            }
            Logger.getLogger("pixelmon").info("successfully added the Pokeball " + ballNameValue);
        }
        catch (Exception e) {
            Logger.getLogger("pixelmon").log(Level.WARNING, "failed to register the Pokeball with the index " + index, e);
        }
    }

    public static void setPokeballItem(EnumPokeballs ball, Item item) {
        PixelmonApi.addPokeballToList(ball, item);
    }

    public static Item getPokeball(EnumPokeballs ball) {
        if (pokeballs.contains(ball)) {
            return pokeballItems.get(pokeballs.indexOf(ball));
        }
        return null;
    }
}

