/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

public class ReflectionUtil {
    public static Field getField(Class beanClass, String fieldName) throws NoSuchFieldException {
        Field field = null;
        Class tempClass = beanClass;
        while (field == null && tempClass != null) {
            try {
                field = tempClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                tempClass = tempClass.getSuperclass();
            }
        }
        if (field == null) {
            throw new NoSuchFieldException(fieldName + " in class " + beanClass);
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldValue(Object bean, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = ReflectionUtil.getField(bean.getClass(), fieldName);
        boolean accessible = field.isAccessible();
        Object value = null;
        field.setAccessible(true);
        try {
            value = field.get(bean);
        }
        finally {
            field.setAccessible(accessible);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object bean, String fieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = ReflectionUtil.getField(bean.getClass(), fieldName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(bean, newValue);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getStaticFieldValue(Class beanClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = ReflectionUtil.getField(beanClass, fieldName);
        boolean accessible = field.isAccessible();
        Object value = null;
        field.setAccessible(true);
        try {
            value = field.get(beanClass);
        }
        finally {
            field.setAccessible(accessible);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStaticFieldValue(Class beanClass, String fieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Field field = ReflectionUtil.getField(beanClass, fieldName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            FieldAccessor fieldAccessor = (FieldAccessor)ReflectionUtil.invokeMethod(field, "getFieldAccessor", new Class[]{Object.class}, new Object[]{beanClass});
            Object isReadOnly = ReflectionUtil.getFieldValue(fieldAccessor, "isReadOnly");
            try {
                ReflectionUtil.setFieldValue(fieldAccessor, "isReadOnly", false);
                fieldAccessor.set((Object)beanClass, newValue);
            }
            finally {
                ReflectionUtil.setFieldValue(fieldAccessor, "isReadOnly", isReadOnly);
            }
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStaticFieldValue2(Class beanClass, String fieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = ReflectionUtil.getField(beanClass, fieldName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            int modifiers = field.getModifiers();
            ReflectionUtil.setFieldValue(field, "modifiers", modifiers & 0xFFFFFFEF);
            try {
                FieldAccessor fieldAccessor = ReflectionFactory.getReflectionFactory().newFieldAccessor(field, false);
                fieldAccessor.set(null, newValue);
            }
            finally {
                ReflectionUtil.setFieldValue(field, "modifiers", modifiers);
            }
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static Method getMethod(Class beanClass, String methodName, Class ... parameterTypes) throws NoSuchMethodException {
        Method method = null;
        Class tempClass = beanClass;
        while (method == null && tempClass != null) {
            try {
                method = tempClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                tempClass = tempClass.getSuperclass();
                e.printStackTrace();
            }
        }
        if (method == null) {
            throw new NoSuchMethodException();
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeMethod(Object bean, String methodName, Class[] parameterTypes, Object[] values) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = ReflectionUtil.getMethod(bean.getClass(), methodName, parameterTypes);
        boolean accessible = method.isAccessible();
        Object value = null;
        method.setAccessible(true);
        try {
            value = method.invoke(bean, values);
        }
        finally {
            method.setAccessible(accessible);
        }
        return value;
    }

    public static Constructor getConstructor(Class beanClass, Class ... parameterTypes) throws NoSuchMethodException {
        return beanClass.getDeclaredConstructor(parameterTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeConstructor(Class beanClass, Class[] parameterTypes, Object[] values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor constructor = ReflectionUtil.getConstructor(beanClass, parameterTypes);
        boolean accessible = constructor.isAccessible();
        Object value = null;
        constructor.setAccessible(true);
        try {
            value = constructor.newInstance(values);
        }
        finally {
            constructor.setAccessible(accessible);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeEnumConstructor(Class beanClass, Class[] parameterTypes, Object[] values) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        Constructor constructor = ReflectionUtil.getConstructor(beanClass, parameterTypes);
        boolean accessible = constructor.isAccessible();
        Object value = null;
        constructor.setAccessible(true);
        try {
            ConstructorAccessor constructorAccessor = (ConstructorAccessor)ReflectionUtil.getFieldValue(constructor, "constructorAccessor");
            if (constructorAccessor == null) {
                ReflectionUtil.invokeMethod(constructor, "acquireConstructorAccessor", new Class[0], new Object[0]);
                constructorAccessor = (ConstructorAccessor)ReflectionUtil.getFieldValue(constructor, "constructorAccessor");
            }
            value = constructorAccessor.newInstance(values);
        }
        finally {
            constructor.setAccessible(accessible);
        }
        return value;
    }
}

