/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles;

import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;

public class BattleRegistry {
    private static final int baseDim = 64;
    private static int battleIndex = 0;
    private static ArrayList<BattleControllerBase> battleList = new ArrayList();
    private static ChunkCoordinates[][] arenaPositions = new ChunkCoordinates[64][64];

    public static ArrayList<BattleControllerBase> getBattleList() {
        return battleList;
    }

    public static void registerBattle(BattleControllerBase bc) {
        bc.battleIndex = battleIndex++;
        battleList.add(bc);
    }

    public static int getIndex(BattleControllerBase bc) {
        for (int i = 0; i < battleList.size(); ++i) {
            if (battleList.get(i) != bc) continue;
            return BattleRegistry.battleList.get((int)i).battleIndex;
        }
        return -1;
    }

    public static BattleControllerBase getBattle(int index) {
        for (int i = 0; i < battleList.size(); ++i) {
            if (BattleRegistry.battleList.get((int)i).battleIndex != index) continue;
            return battleList.get(i);
        }
        return null;
    }

    public static BattleControllerBase getBattle(EntityPlayer player) {
        for (int i = 0; i < battleList.size(); ++i) {
            for (BattleParticipant p : BattleRegistry.battleList.get((int)i).participants) {
                if (!(p instanceof PlayerParticipant) || ((PlayerParticipant)p).player != player) continue;
                return battleList.get(i);
            }
        }
        return null;
    }

    public static void deRegisterBattle(BattleControllerBase bc) {
        for (int i = 0; i < battleList.size(); ++i) {
            if (battleList.get(i) != bc) continue;
            if (bc.arenaManager != null) {
                BattleRegistry.arenaPositions[bc.arenaManager.arenaLocation.field_71574_a][bc.arenaManager.arenaLocation.field_71573_c] = null;
            }
            battleList.remove(i);
            return;
        }
    }

    public static void updateBattles() {
        for (int i = 0; i < battleList.size(); ++i) {
            battleList.get(i).update();
        }
    }

    public static void registerArenaLocation(ChunkCoordinates pos) {
        BattleRegistry.arenaPositions[pos.field_71574_a][pos.field_71573_c] = pos;
    }

    public static ChunkCoordinates getArenaLocation() throws Exception {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                if (arenaPositions[i][j] != null) continue;
                return new ChunkCoordinates(i, 0, j);
            }
        }
        throw new Exception("Run out of arena locations!");
    }
}

