/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.IAttackAnimation;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.RemoveEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.AttackModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.CriticalHit;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.multiTurn.MultiTurnSpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.statusAppliers.StatusApplierBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Add;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.database.AttackCategory;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Sniper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilitiesUnfinished.AngerPoint;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ChoiceItem;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.StatCollector;

public class Attack {
    public static final float EFFECTIVE_NORMAL = 1.0f;
    public static final float EFFECTIVE_SUPER = 2.0f;
    public static final float EFFECTIVE_MAX = 4.0f;
    public static final float EFFECTIVE_NOT = 0.5f;
    public static final float EFFECTIVE_BARELY = 0.25f;
    public static final float EFFECTIVE_NONE = 0.0f;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_FIRE = 1;
    public static final int TYPE_WATER = 2;
    public static final int TYPE_ELECTRIC = 3;
    public static final int TYPE_GRASS = 4;
    public static final int TYPE_ICE = 5;
    public static final int TYPE_FIGHT = 6;
    public static final int TYPE_POISON = 7;
    public static final int TYPE_GROUND = 8;
    public static final int TYPE_FLYING = 9;
    public static final int TYPE_PSYCHIC = 10;
    public static final int TYPE_BUG = 11;
    public static final int TYPE_ROCK = 12;
    public static final int TYPE_GHOST = 13;
    public static final int TYPE_DRAGON = 14;
    public static final int TYPE_DARK = 15;
    public static final int TYPE_STEEL = 16;
    public static final int ATTACK_PHYSICAL = 0;
    public static final int ATTACK_SPECIAL = 1;
    public static final int ATTACK_STATUS = 2;
    public static AttackBase[] fullAttackList = new AttackBase[600];
    private boolean disabled = false;
    public AttackBase baseAttack;
    public int pp;
    public int ppBase;
    public int movePower;
    public int moveAccuracy;
    public boolean willFail;
    public static boolean hasItem = false;
    static AttackCategory[] categories;

    public Attack(int attackIndex, String moveName, ResultSet rs) throws SQLException {
        if (fullAttackList[attackIndex] == null) {
            AttackBase a;
            Attack.fullAttackList[attackIndex] = a = new AttackBase(attackIndex, moveName, rs);
            this.baseAttack = a;
        } else {
            this.baseAttack = fullAttackList[attackIndex];
        }
        this.ppBase = this.pp = rs.getInt("PP");
    }

    public boolean use(PixelmonWrapper user, PixelmonWrapper target) {
        EffectBase e;
        int i;
        if (this.willFail) {
            user.bc.sendToAll("pixelmon.battletext.movefailed", new Object[0]);
            return true;
        }
        EntityPixelmon userPokemon = user.pokemon;
        EntityPixelmon targetPokemon = target.pokemon;
        if (user == target) {
            userPokemon.func_70671_ap().func_75651_a((Entity)userPokemon, 0.0f, 0.0f);
            userPokemon.lastMoveUsed = DatabaseMoves.getAttack(this.baseAttack.getUnLocalizedName());
            for (int j = 0; j < this.baseAttack.effects.size(); ++j) {
                EffectBase e2 = this.baseAttack.effects.get(j);
                if (e2 instanceof StatsEffect) {
                    try {
                        e2.ApplyEffect(Attack.calcCriticalHit(null, user, target), user, target);
                    }
                    catch (Exception exc) {
                        if (!PixelmonConfig.printErrors) continue;
                        System.out.println("Error in applyEffect for " + e2.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                        System.out.println(exc.getStackTrace());
                    }
                    continue;
                }
                if (e2 instanceof SpecialAttackBase) {
                    try {
                        if (e2.applyStage != EffectBase.ApplyStage.During) continue;
                        ((SpecialAttackBase)e2).ApplyEffect(user, target, Attack.calcCriticalHit(null, user, target));
                    }
                    catch (Exception exc2) {
                        if (!PixelmonConfig.printErrors) continue;
                        System.out.println("Error in applyEffect for " + e2.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                        System.out.println(exc2.getStackTrace());
                    }
                    continue;
                }
                if (!(e2 instanceof StatusApplierBase)) continue;
                try {
                    e2.ApplyEffect(Attack.calcCriticalHit(null, user, target), user, target);
                    continue;
                }
                catch (Exception exc3) {
                    if (!PixelmonConfig.printErrors) continue;
                    System.out.println("Error in applyEffect for " + e2.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                    System.out.println(exc3.getStackTrace());
                }
            }
            if (userPokemon.func_70902_q() != null) {
                userPokemon.update(EnumUpdateType.HP, EnumUpdateType.Moveset);
            }
            if (targetPokemon.func_70902_q() != null) {
                targetPokemon.update(EnumUpdateType.HP, EnumUpdateType.Moveset);
            }
            if (userPokemon.getTrainer() != null) {
                userPokemon.getTrainer().getPokemonStorage().updateAndSendToClient(userPokemon, new EnumUpdateType[]{EnumUpdateType.Moveset, EnumUpdateType.HP});
            }
            if (targetPokemon.getTrainer() != null) {
                targetPokemon.getTrainer().getPokemonStorage().updateAndSendToClient(targetPokemon, new EnumUpdateType[]{EnumUpdateType.Moveset, EnumUpdateType.HP});
            }
            user.attackList.add(this.baseAttack.getUnLocalizedName());
            return true;
        }
        int[] modifiedMoveStats = userPokemon.getAbility().modifyPowerAndAccuracy(this.baseAttack.basePower, this.baseAttack.accuracy, userPokemon, targetPokemon, this);
        this.movePower = this.baseAttack.basePower;
        this.moveAccuracy = this.baseAttack.accuracy;
        boolean attackHandled = false;
        boolean cantMiss = false;
        userPokemon.func_70671_ap().func_75651_a((Entity)targetPokemon, 0.0f, 0.0f);
        double accuracy = (double)this.moveAccuracy * (double)userPokemon.battleStats.getAccuracy() / (double)targetPokemon.battleStats.getEvasion();
        double crit = Attack.calcCriticalHit(null, user, target);
        for (int i2 = 0; i2 < targetPokemon.getStatusSize(); ++i2) {
            StatusBase e3 = targetPokemon.getStatus(i2);
            try {
                if (!e3.stopsIncomingAttack(user)) continue;
                if (userPokemon.heldItem != null && userPokemon.heldItem.func_77973_b() != null && userPokemon.heldItem.func_77973_b() instanceof ItemHeld) {
                    ((ItemHeld)userPokemon.heldItem.func_77973_b()).onMiss(userPokemon, targetPokemon);
                }
                return true;
            }
            catch (Exception exc) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println("Error calculating stopsIncomingAttack for " + e3.type.toString() + " for attack " + this.baseAttack.getLocalizedName());
                System.out.println(exc.getStackTrace());
            }
        }
        if (!targetPokemon.getAbility().allowsIncomingAttack(targetPokemon, userPokemon, this)) {
            return false;
        }
        boolean shouldNotLosePP = false;
        for (i = 0; i < this.baseAttack.effects.size(); ++i) {
            e = this.baseAttack.effects.get(i);
            if (!(e instanceof MultiTurnSpecialAttackBase) || ((MultiTurnSpecialAttackBase)e).getTurnCount(userPokemon) != -1) continue;
            shouldNotLosePP = true;
        }
        if (this.baseAttack.accuracy == -1 || this.cantMiss(user)) {
            cantMiss = true;
        }
        for (i = 0; i < this.baseAttack.effects.size(); ++i) {
            e = this.baseAttack.effects.get(i);
            try {
                if (!e.hasSpecialAccuracyEffect()) continue;
                accuracy = e.getAccuracy(userPokemon, targetPokemon);
                continue;
            }
            catch (Exception exc) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println("Error calculating hasSpecialAccuracyEffect for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                System.out.println(exc.getStackTrace());
            }
        }
        if (cantMiss || (double)RandomHelper.getRandomNumberBetween(0, 100) <= accuracy) {
            int i3;
            EffectBase e4;
            boolean ignoresImmunities = false;
            for (int o = 0; o < this.baseAttack.effects.size(); ++o) {
                if (!(this.baseAttack.effects.get(o) instanceof MultiTurnSpecialAttackBase) || !((MultiTurnSpecialAttackBase)this.baseAttack.effects.get(o)).ignoresType(userPokemon)) continue;
                ignoresImmunities = true;
            }
            if (EnumType.getTotalEffectiveness(targetPokemon.getEffectiveTypes(target.pokemon), this.baseAttack.attackType) != 0.0f || this.baseAttack.getUnLocalizedName().equals("Sand-Attack") || this.baseAttack.getUnLocalizedName().equals("Spikes") || this.baseAttack.getUnLocalizedName().equals("Toxic Spikes") || this.baseAttack.getUnLocalizedName().equals("Stealth Rock") || ignoresImmunities) {
                for (int j = 0; j < this.baseAttack.effects.size(); ++j) {
                    e4 = this.baseAttack.effects.get(j);
                    if (!(e4 instanceof StatusApplierBase)) continue;
                    if (targetPokemon.getStatusSize() > 0) {
                        boolean shouldApply = true;
                        try {
                            for (int i4 = 0; i4 < targetPokemon.getStatusSize(); ++i4) {
                                StatusBase et = targetPokemon.getStatus(i4);
                                if (!et.stopsStatusChange()) continue;
                                shouldApply = false;
                                break;
                            }
                            if (!shouldApply) continue;
                            e4.ApplyEffect(crit, user, target);
                        }
                        catch (Exception exc) {
                            if (!PixelmonConfig.printErrors) continue;
                            System.out.println("Error in applyEffect for " + e4.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                            System.out.println(exc.getStackTrace());
                        }
                        continue;
                    }
                    try {
                        e4.ApplyEffect(crit, user, target);
                        continue;
                    }
                    catch (Exception exc) {
                        if (!PixelmonConfig.printErrors) continue;
                        System.out.println("Error in applyEffect for " + e4.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                        System.out.println(exc.getStackTrace());
                    }
                }
            } else {
                user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                for (int l = 0; l < this.baseAttack.effects.size(); ++l) {
                    if (!(this.baseAttack.effects.get(l) instanceof MultiTurnSpecialAttackBase)) continue;
                    ((MultiTurnSpecialAttackBase)this.baseAttack.effects.get(l)).removeEffect(userPokemon, targetPokemon);
                }
                return true;
            }
            for (i3 = 0; i3 < this.baseAttack.effects.size(); ++i3) {
                e4 = this.baseAttack.effects.get(i3);
                try {
                    if (e4.applyStage != EffectBase.ApplyStage.During) continue;
                    if (e4 instanceof AttackModifierBase) {
                        if (e4 instanceof CriticalHit) {
                            crit = Attack.calcCriticalHit(e4, user, target);
                            continue;
                        }
                        attackHandled = ((AttackModifierBase)e4).ApplyEffect(user, target);
                        continue;
                    }
                    if (e4 instanceof SpecialAttackBase) {
                        attackHandled = ((SpecialAttackBase)e4).ApplyEffect(user, target, crit);
                        continue;
                    }
                    if (!(e4 instanceof MultiTurnSpecialAttackBase)) continue;
                    attackHandled = ((MultiTurnSpecialAttackBase)e4).ApplyEffect(user, target, crit);
                    continue;
                }
                catch (Exception exc) {
                    System.out.println("Error in applyEffect for " + e4.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                    System.out.println(exc.getStackTrace());
                }
            }
            if (userPokemon.battleController != null) {
                for (i3 = 0; i3 < userPokemon.battleController.globalStatusController.getGlobalStatusSize(); ++i3) {
                    userPokemon.battleController.globalStatusController.getGlobalStatus(i3).applyInMoveEffect(userPokemon, targetPokemon, this);
                }
            }
            if (!attackHandled) {
                int power = this.doDamageCalc(user, target, crit);
                if (this.baseAttack.attackCategory == 2) {
                    if (targetPokemon.hasStatus(StatusType.Substitute)) {
                        user.bc.sendToAll("pixelmon.battletext.movefailed", new Object[0]);
                    } else {
                        for (int j = 0; j < this.baseAttack.effects.size(); ++j) {
                            EffectBase e5 = this.baseAttack.effects.get(j);
                            if (!(e5 instanceof StatsEffect)) continue;
                            try {
                                if (!targetPokemon.getAbility().allowsStatChange(targetPokemon, userPokemon, (StatsEffect)e5)) continue;
                                e5.ApplyEffect(crit, user, target);
                                continue;
                            }
                            catch (Exception exc) {
                                if (!PixelmonConfig.printErrors) continue;
                                System.out.println("Error in applyEffect for " + e5.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                                System.out.println(exc.getStackTrace());
                            }
                        }
                    }
                    power = 0;
                } else {
                    targetPokemon.doBattleDamage(user, power);
                    target.damageTakenThisTurn += power;
                    for (int j = 0; j < this.baseAttack.effects.size(); ++j) {
                        EffectBase e6 = this.baseAttack.effects.get(j);
                        if (!(e6 instanceof StatsEffect)) continue;
                        try {
                            e6.ApplyEffect(crit, user, target);
                            continue;
                        }
                        catch (Exception exc) {
                            if (!PixelmonConfig.printErrors) continue;
                            System.out.println("Error in applyEffect for " + e6.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                            System.out.println(exc.getStackTrace());
                        }
                    }
                }
                this.doMove(user, target);
                Object s = null;
                this.sendEffectiveChat(user, target, crit);
                if (targetPokemon.heldItem != null && targetPokemon.heldItem.func_77973_b() != null && targetPokemon.heldItem.func_77973_b() instanceof ItemHeld) {
                    ((ItemHeld)targetPokemon.heldItem.func_77973_b()).postProcessAttack(user, target, this, power);
                }
                if (userPokemon.heldItem != null && userPokemon.heldItem.func_77973_b() != null && userPokemon.heldItem.func_77973_b() instanceof ItemHeld) {
                    ((ItemHeld)userPokemon.heldItem.func_77973_b()).postProcessAttack(user, user, this, power);
                }
            }
            for (i3 = 0; i3 < this.baseAttack.effects.size(); ++i3) {
                e4 = this.baseAttack.effects.get(i3);
                try {
                    if (e4.applyStage != EffectBase.ApplyStage.End || !(e4 instanceof RemoveEffect)) continue;
                    e4.ApplyEffect(crit, user, target);
                    continue;
                }
                catch (Exception exc) {
                    if (!PixelmonConfig.printErrors) continue;
                    System.out.println("Error in applyEffect for " + e4.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                    System.out.println(exc.getStackTrace());
                }
            }
        } else {
            if (userPokemon.heldItem != null && userPokemon.heldItem.func_77973_b() != null && userPokemon.heldItem.func_77973_b() instanceof ItemHeld) {
                ((ItemHeld)userPokemon.heldItem.func_77973_b()).onMiss(userPokemon, targetPokemon);
            }
            user.bc.sendToAll("pixelmon.battletext.missedattack", userPokemon.getNickname(), this.baseAttack.getLocalizedName());
            user.attackList.set(user.attackList.size() - 1, null);
            for (i = 0; i < this.baseAttack.effects.size(); ++i) {
                e = this.baseAttack.effects.get(i);
                try {
                    e.ApplyMissEffect(user, target);
                    continue;
                }
                catch (Exception exc) {
                    if (!PixelmonConfig.printErrors) continue;
                    System.out.println("Error in applyMissEffect for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                    System.out.println(exc.getStackTrace());
                }
            }
        }
        if (userPokemon.func_70902_q() != null) {
            userPokemon.update(EnumUpdateType.HP, EnumUpdateType.Moveset);
        }
        if (targetPokemon.func_70902_q() != null) {
            targetPokemon.update(EnumUpdateType.HP, EnumUpdateType.Moveset);
        }
        if (userPokemon.getTrainer() != null) {
            userPokemon.getTrainer().getPokemonStorage().updateAndSendToClient(userPokemon, new EnumUpdateType[]{EnumUpdateType.Moveset, EnumUpdateType.HP});
        }
        if (targetPokemon.getTrainer() != null) {
            targetPokemon.getTrainer().getPokemonStorage().updateAndSendToClient(targetPokemon, new EnumUpdateType[]{EnumUpdateType.Moveset, EnumUpdateType.HP});
        }
        if (this.baseAttack.makesContact) {
            userPokemon.getAbility().applyEffectOnContact(userPokemon, targetPokemon, true);
            targetPokemon.getAbility().applyEffectOnContact(targetPokemon, userPokemon, false);
        }
        userPokemon.lastMoveUsed = DatabaseMoves.getAttack(this.baseAttack.getUnLocalizedName());
        if (targetPokemon.func_110143_aJ() <= 0.0f) {
            shouldNotLosePP = false;
        }
        return !shouldNotLosePP;
    }

    public void doMove(PixelmonWrapper user, PixelmonWrapper target) {
        for (IAttackAnimation anim : this.baseAttack.animations) {
            anim.doMove((EntityLiving)user.pokemon, (EntityLiving)target.pokemon);
        }
    }

    public int doDamageCalc(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, double crit) {
        StatusBase e;
        int i;
        EntityPixelmon user = userWrapper.pokemon;
        EntityPixelmon target = targetWrapper.pokemon;
        if (user.getAbility() instanceof Sniper && crit == 2.0) {
            crit = 3.0;
        }
        double stab = 1.0;
        if (this.hasSTAB(user)) {
            stab = 1.5;
        }
        stab = user.getAbility().modifyStab(targetWrapper, userWrapper, stab);
        double type = EnumType.getTotalEffectiveness(target.type, this.baseAttack.attackType);
        double critical = crit;
        double rand = ((double)RandomHelper.getRandomNumberBetween(1, 128) % 16.0 + 85.0) * 0.01;
        double modifier = stab * type * critical;
        double attack = 0.0;
        double defense = 0.0;
        double Level2 = user.getLvl().getLevel();
        if (this.baseAttack.attackCategory == 0) {
            double userAttack = user.battleStats.attackStat;
            if (ItemHeld.isItemOfType(user.func_70694_bm(), EnumHeldItems.choiceItem)) {
                userAttack = ((ChoiceItem)user.func_70694_bm().func_77973_b()).affectAttack(userAttack);
            }
            attack = userAttack * user.battleStats.getAttackModifier() * 0.01;
            defense = (double)target.battleStats.defenceStat * (double)target.battleStats.getDefenceModifier() * 0.01;
        } else if (this.baseAttack.attackCategory == 1) {
            double userSpAttack = user.battleStats.specialAttackStat;
            if (ItemHeld.isItemOfType(user.func_70694_bm(), EnumHeldItems.choiceItem)) {
                userSpAttack = ((ChoiceItem)user.func_70694_bm().func_77973_b()).affectSpecialAttack(userSpAttack);
            }
            attack = userSpAttack * user.battleStats.getSpecialAttackModifier() * 0.01;
            defense = (double)target.battleStats.specialDefenceStat * (double)target.battleStats.getSpecialDefenceModifier() * 0.01;
        }
        double DmgRand = (15.0 * rand + 85.0) * 0.01;
        double DamageBase = (2.0 * Level2 / 5.0 + 2.0) * attack * (double)this.movePower * 0.02 / defense + 2.0;
        double Damage2 = DamageBase * modifier * DmgRand * 0.85;
        for (i = 0; i < target.getStatusSize(); ++i) {
            e = target.getStatus(i);
            try {
                Damage2 = e.adjustRecievedDamage(this, Damage2, user, target, crit);
                continue;
            }
            catch (Exception exc) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println("Error in adjustRecievedDamage for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                System.out.println(exc.getStackTrace());
            }
        }
        for (i = 0; i < user.getStatusSize(); ++i) {
            e = user.getStatus(i);
            try {
                Damage2 = e.adjustDealtDamage(this, Damage2, user, target, crit);
                continue;
            }
            catch (Exception exc) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println("Error in adjustDealtDamage for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                System.out.println(exc.getStackTrace());
            }
        }
        if (user.heldItem != null && user.heldItem.func_77973_b() != null && user.heldItem.func_77973_b() instanceof ItemHeld) {
            Damage2 = ((ItemHeld)user.heldItem.func_77973_b()).preProcessAttack(user, target, this, Damage2, false);
        }
        if (user.heldItem != null && user.heldItem.func_77973_b() != null && user.heldItem.func_77973_b() instanceof ItemHeld && this.baseAttack.attackCategory == 0) {
            Damage2 = ((ItemHeld)user.heldItem.func_77973_b()).preProcessAttackPhysical(user, target, this, Damage2, false);
        }
        if (target != null && target.heldItem != null && target.heldItem.func_77973_b() != null && target.heldItem.func_77973_b() instanceof ItemHeld) {
            Damage2 = ((ItemHeld)target.heldItem.func_77973_b()).preProcessAttack(user, target, this, Damage2, true);
        }
        return (int)Damage2;
    }

    public boolean hasSTAB(EntityPixelmon user) {
        return user.baseStats.type1 == this.baseAttack.attackType || user.baseStats.type2 == this.baseAttack.attackType;
    }

    public void setDisabled(boolean value, EntityPixelmon pixelmon) {
        this.disabled = value;
        if (pixelmon.battleController != null && pixelmon.func_70902_q() != null) {
            Add p = new Add(new PixelmonData(pixelmon));
            Pixelmon.network.sendTo((IMessage)p, (EntityPlayerMP)pixelmon.func_70902_q());
        }
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public static double calcCriticalHit(EffectBase e, PixelmonWrapper user, PixelmonWrapper target) {
        if (target.pokemon.getAbility().preventsCriticalHits()) {
            return 1.0;
        }
        int critStage = 1;
        if (user.pokemon.heldItem != null && user.pokemon.heldItem.func_77973_b() != null && user.pokemon.heldItem.func_77973_b() instanceof ItemHeld) {
            critStage += ((ItemHeld)user.pokemon.heldItem.func_77973_b()).adjustCritStage(user.pokemon, target.pokemon);
        }
        int percent = 6;
        if (e != null) {
            if (e instanceof CriticalHit) {
                critStage += e.value;
            }
            if (critStage == 1) {
                percent = 6;
            } else if (critStage == 2) {
                percent = 13;
            } else if (critStage == 3) {
                percent = 25;
            } else if (critStage == 4) {
                percent = 33;
            } else if (critStage == 5) {
                percent = 50;
            }
        }
        if (RandomHelper.getRandomNumberBetween(0, 100) < percent) {
            if (target.pokemon.getAbility() instanceof AngerPoint) {
                ((AngerPoint)target.pokemon.getAbility()).wasCrit = true;
            }
            if (user.pokemon.getAbility() instanceof Sniper) {
                return 3.0;
            }
            return 2.0;
        }
        return 1.0;
    }

    public boolean canHit(EntityPixelmon pixelmon1, EntityPixelmon pixelmon2) {
        if (pixelmon2 == null) {
            return false;
        }
        return !pixelmon1.field_70128_L && !pixelmon1.isFainted && !pixelmon2.field_70128_L && !pixelmon2.isFainted;
    }

    public static boolean canMovesHit(EntityPixelmon entity, EntityPixelmon target) {
        boolean[] b = new boolean[4];
        int i1 = 0;
        b[3] = true;
        b[2] = true;
        b[1] = true;
        b[0] = true;
        for (int i = 0; i < entity.getMoveset().size(); ++i) {
            Attack a = entity.getMoveset().get(i);
            if (!a.canHit(entity, target)) {
                b[i1] = false;
            }
            ++i1;
        }
        return b[0] && b[1] && b[2] && b[3];
    }

    public static Attack getWhichMoveIsBest(PixelmonWrapper pw) {
        PixelmonWrapper target = pw.bc.getOppositePokemon(pw);
        Moveset moves = pw.pokemon.getMoveset();
        ArrayList<Attack> usableMoves = new ArrayList<Attack>();
        for (Attack a : moves) {
            if (a.getDisabled() || a.pp <= 0) continue;
            usableMoves.add(a);
        }
        if (usableMoves.size() == 0) {
            return DatabaseMoves.getAttack("Struggle");
        }
        int[] weightings = new int[usableMoves.size()];
        for (int i = 0; i < weightings.length; ++i) {
            Attack a = (Attack)usableMoves.get(i);
            float effectiveness = EnumType.getTotalEffectiveness(target.pokemon.getEffectiveTypes(target.pokemon), a.baseAttack.attackType);
            if (effectiveness > 1.0f) {
                weightings[i] = 20;
                continue;
            }
            if (effectiveness == 1.0f) {
                weightings[i] = 10;
                continue;
            }
            if (!(effectiveness < 1.0f)) continue;
            weightings[i] = 5;
        }
        if (pw.attackList.size() > 0) {
            String lastAttack = pw.attackList.get(pw.attackList.size() - 1);
            for (int i = 0; i < weightings.length; ++i) {
                Attack a = (Attack)usableMoves.get(i);
                if (!a.baseAttack.getUnLocalizedName().equals(lastAttack)) continue;
                int n = i;
                weightings[n] = weightings[n] / 3;
            }
        }
        return Attack.getRandomAttack(usableMoves, weightings);
    }

    public static Attack getRandomAttack(List<Attack> attacks, int[] weightings) {
        int totalRarity = 0;
        for (int i = 0; i < weightings.length; ++i) {
            totalRarity += weightings[i];
        }
        if (totalRarity > 0) {
            int num = RandomHelper.getRandomNumberBetween(0, totalRarity - 1);
            int sum = 0;
            for (int i = 0; i < weightings.length; ++i) {
                int rarity = 0;
                if (num < sum + (rarity += weightings[i])) {
                    return attacks.get(i);
                }
                sum += rarity;
            }
        }
        return null;
    }

    public static int getAttackCategory(int categoryID) {
        if (categories == null) {
            categories = DatabaseMoves.getAttackCategories();
        }
        String categoryString = "";
        for (int i = 0; i < categories.length; ++i) {
            if (Attack.categories[i].index != categoryID) continue;
            categoryString = Attack.categories[i].category;
        }
        if (categoryString.equalsIgnoreCase("Special")) {
            return 1;
        }
        if (categoryString.equalsIgnoreCase("Physical")) {
            return 0;
        }
        if (categoryString.equalsIgnoreCase("Status")) {
            return 2;
        }
        if (PixelmonConfig.printErrors) {
            System.out.println("Unknown Attack Category: " + categoryString);
        }
        return -1;
    }

    public boolean doesPersist(EntityPixelmon entityPixelmon) {
        if (this.baseAttack.getUnLocalizedName().equalsIgnoreCase("Fly") || this.baseAttack.getUnLocalizedName().equalsIgnoreCase("Bounce")) {
            for (int i = 0; i < entityPixelmon.getStatusSize(); ++i) {
                StatusBase s = entityPixelmon.getStatus(i);
                if (s.type != StatusType.Flying) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.baseAttack.effects.size(); ++i) {
            EffectBase e = this.baseAttack.effects.get(i);
            try {
                if (!e.doesPersist(entityPixelmon)) continue;
                return true;
            }
            catch (Exception exc) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println("Error in doesPersist for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                System.out.println(exc.getStackTrace());
            }
        }
        return false;
    }

    public boolean cantMiss(PixelmonWrapper user) {
        if (user.pokemon.getAbility().cantMiss(user, this)) {
            return true;
        }
        for (int i = 0; i < this.baseAttack.effects.size(); ++i) {
            EffectBase e = this.baseAttack.effects.get(i);
            try {
                if (!e.cantMiss(user)) continue;
                return true;
            }
            catch (Exception exc) {
                if (!PixelmonConfig.printErrors) continue;
                System.out.println("Error in cantMiss for " + e.getClass().toString() + " for attack " + this.baseAttack.getLocalizedName());
                System.out.println(exc.getStackTrace());
            }
        }
        return false;
    }

    public static String getCategoryString(int category) {
        if (category == 0) {
            return StatCollector.func_74838_a((String)"attack.category.physical");
        }
        if (category == 1) {
            return StatCollector.func_74838_a((String)"attack.category.special");
        }
        if (category == 2) {
            return StatCollector.func_74838_a((String)"attack.category.status");
        }
        return null;
    }

    public void sendEffectiveChat(PixelmonWrapper user, PixelmonWrapper target, double crit) {
        String s = null;
        if (this.baseAttack.attackCategory != 2) {
            float effectiveness;
            if (crit > 1.0) {
                user.bc.sendToAll("pixelmon.battletext.criticalhit", new Object[0]);
            }
            if ((effectiveness = EnumType.getTotalEffectiveness(target.pokemon.getEffectiveTypes(target.pokemon), this.baseAttack.attackType)) == 0.0f) {
                s = "pixelmon.battletext.noeffect";
            }
            if (effectiveness == 0.5f || effectiveness == 0.25f) {
                s = "pixelmon.battletext.wasnoteffective";
            }
            if (effectiveness == 2.0f || effectiveness == 4.0f) {
                s = "pixelmon.battletext.supereffective";
            }
            if (s != null) {
                user.bc.sendToAll(s, new Object[0]);
            }
        }
    }
}

