/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.TargettingInfo;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationLeapForward;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationParser;
import com.pixelmonmod.pixelmon.battles.attacks.animations.IAttackAnimation;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.minecraft.util.StatCollector;

public class AttackBase {
    public int attackIndex;
    private String attackName;
    private String description;
    public EnumType attackType;
    public int attackCategory;
    public int basePower;
    public int ppMax;
    public int accuracy;
    boolean makesContact;
    boolean isHM;
    public ArrayList<EffectBase> effects = new ArrayList();
    public ArrayList<IAttackAnimation> animations = new ArrayList();
    public TargettingInfo targettingInfo;

    public AttackBase(int attackIndex, String moveName, ResultSet rs) throws SQLException {
        String[] splits;
        this.attackIndex = attackIndex;
        this.attackName = moveName;
        this.ppMax = rs.getInt("PPMAX");
        this.attackType = EnumType.parseTypeFromDBID(rs.getInt("TYPEID"));
        if (this.attackName.equals("Struggle")) {
            this.attackType = EnumType.Mystery;
        }
        this.attackCategory = Attack.getAttackCategory(rs.getInt("MOVECATEGORYID"));
        this.basePower = rs.getInt("POWER");
        this.accuracy = rs.getInt("ACCURACY");
        if (rs.wasNull()) {
            this.accuracy = -1;
        }
        this.isHM = rs.getInt("HMID") != -1;
        this.makesContact = rs.getBoolean("MAKESCONTACT");
        this.description = rs.getString("DESCRIPTION");
        for (String e : splits = rs.getString("EFFECT").split(";")) {
            EffectBase etmp = EffectBase.getEffect(e);
            if (etmp == null) continue;
            this.effects.add(etmp);
        }
        String animationString = rs.getString("ATTACKANIMATIONS");
        if (animationString == null) {
            this.animations = new ArrayList();
            this.animations.add(new AttackAnimationLeapForward());
        } else {
            this.animations = AttackAnimationParser.GetAnimation(animationString);
        }
        this.targettingInfo = new TargettingInfo(rs);
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("attack." + this.attackName.toLowerCase() + ".name"));
    }

    public String getUnLocalizedName() {
        return this.attackName;
    }

    public String getLocalizedDescription() {
        return StatCollector.func_74838_a((String)("attack." + this.attackName.toLowerCase() + ".description"));
    }

    public boolean getMakesContact() {
        return this.makesContact;
    }
}

