/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectParser;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ChanceModifier;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.ArrayList;

public abstract class EffectBase {
    public ApplyStage applyStage;
    public ArrayList<ModifierBase> modifiers = new ArrayList();
    private boolean persists;
    public int value = -1;
    public int value2 = -1;
    public Attack parent;

    public EffectBase(ApplyStage applyStage, boolean persists, int ... values) {
        this.applyStage = applyStage;
        this.persists = persists;
    }

    public void AddModifier(ModifierBase modifier) {
        this.modifiers.add(modifier);
    }

    protected abstract void ApplyEffect(double var1, PixelmonWrapper var3, PixelmonWrapper var4) throws Exception;

    public boolean checkChance() throws Exception {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return ((ChanceModifier)m).RollChance();
        }
        return true;
    }

    public abstract boolean cantMiss(PixelmonWrapper var1) throws Exception;

    public static EffectBase getEffect(String e) {
        EffectParser p = new EffectParser();
        return p.ParseEffect(e);
    }

    public boolean doesPersist(EntityPixelmon user) throws Exception {
        return this.persists;
    }

    public boolean hasSpecialAccuracyEffect() throws Exception {
        return false;
    }

    public double getAccuracy(EntityPixelmon user, EntityPixelmon target) throws Exception {
        return 100.0;
    }

    public void ApplyMissEffect(PixelmonWrapper user, PixelmonWrapper target) throws Exception {
    }

    public void ApplyEarlyEffect(PixelmonWrapper user, PixelmonWrapper[] array) {
    }

    public static enum ApplyStage {
        Start,
        During,
        End,
        Priority;

    }
}

