/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks;

import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;

public class StatsEffect
extends EffectBase {
    private StatsType type;
    private boolean isUser = false;

    public StatsEffect(StatsType type, int value, boolean isUser) {
        super(EffectBase.ApplyStage.End, false, new int[0]);
        this.type = type;
        this.value = value;
        this.isUser = isUser;
    }

    @Override
    protected void ApplyEffect(double crit, PixelmonWrapper user, PixelmonWrapper target) throws Exception {
        EntityPixelmon effected = target.pokemon;
        if (this.isUser) {
            effected = user.pokemon;
        }
        if (this.checkChance()) {
            if (this.type == StatsType.Accuracy) {
                if (this.value > 0) {
                    if (effected.battleStats.IncreaseAccuracy(this.value)) {
                        user.bc.sendToAll("pixelmon.effect.accuracyincreased", effected.getNickname());
                    }
                } else if (effected.battleStats.DecreaseAccuracy(Math.abs(this.value))) {
                    user.bc.sendToAll("pixelmon.effect.accuracydecreased", effected.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                }
            } else if (this.type == StatsType.Evasion) {
                if (this.value > 0) {
                    if (effected.battleStats.IncreaseEvasion(this.value)) {
                        user.bc.sendToAll("pixelmon.effect.evasionincreased", effected.getNickname());
                    }
                } else if (effected.battleStats.DecreaseEvasion(Math.abs(this.value))) {
                    user.bc.sendToAll("pixelmon.effect.evasiondecreased", effected.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                }
            } else if (this.type == StatsType.Attack) {
                if (this.value > 0) {
                    if (effected.battleStats.IncreaseAttack(this.value)) {
                        user.bc.sendToAll("pixelmon.effect.attackincreased", effected.getNickname());
                    }
                } else if (effected.battleStats.DecreaseAttack(Math.abs(this.value))) {
                    user.bc.sendToAll("pixelmon.effect.attackdecreased", effected.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                }
            } else if (this.type == StatsType.Defence) {
                if (this.value > 0) {
                    if (effected.battleStats.IncreaseDefence(this.value)) {
                        user.bc.sendToAll("pixelmon.effect.defenseincreased", effected.getNickname());
                    }
                } else if (effected.battleStats.DecreaseDefence(Math.abs(this.value))) {
                    user.bc.sendToAll("pixelmon.effect.defensedecreased", effected.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                }
            } else if (this.type == StatsType.SpecialAttack) {
                if (this.value > 0) {
                    if (effected.battleStats.IncreaseSpecialAttack(this.value)) {
                        user.bc.sendToAll("pixelmon.effect.specatkincreased", effected.getNickname());
                    }
                } else if (effected.battleStats.DecreaseSpecialAttack(Math.abs(this.value))) {
                    user.bc.sendToAll("pixelmon.effect.specatkdecreased", effected.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                }
            } else if (this.type == StatsType.SpecialDefence) {
                if (this.value > 0) {
                    if (effected.battleStats.IncreaseSpecialDefence(this.value)) {
                        user.bc.sendToAll("pixelmon.effect.specdefincreased", effected.getNickname());
                    }
                } else if (effected.battleStats.DecreaseSpecialDefence(Math.abs(this.value))) {
                    user.bc.sendToAll("pixelmon.effect.specdefdecreased", effected.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                }
            } else if (this.type == StatsType.Speed) {
                if (this.value > 0) {
                    if (effected.battleStats.IncreaseSpeed(this.value)) {
                        user.bc.sendToAll("pixelmon.effect.speedincreased", effected.getNickname());
                    }
                } else if (effected.battleStats.DecreaseSpeed(Math.abs(this.value))) {
                    user.bc.sendToAll("pixelmon.effect.speeddecreased", effected.getNickname());
                } else {
                    user.bc.sendToAll("pixelmon.battletext.noeffect", new Object[0]);
                }
            }
        }
    }

    @Override
    public boolean cantMiss(PixelmonWrapper user) {
        return this.isUser;
    }

    public StatsType getStatsType() {
        return this.type;
    }
}

